/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.searchTask;

import com.intellij.find.FindManager;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.largeFilesEditor.search.searchTask.FrameSearcher;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;

public abstract class SearchTaskBase
implements Runnable {
    protected final FileDataProviderForSearch fileDataProviderForSearch;
    protected final SearchTaskOptions options;
    protected final Project project;
    private volatile boolean shouldStop = false;
    private boolean isFinished = false;

    public SearchTaskBase(SearchTaskOptions options2, Project project, FileDataProviderForSearch fileDataProviderForSearch) {
        this.project = project;
        this.options = options2;
        this.fileDataProviderForSearch = fileDataProviderForSearch;
    }

    public SearchTaskOptions getOptions() {
        return this.options;
    }

    @Override
    public final void run() {
        this.doRun();
        this.isFinished = true;
    }

    public final void shouldStop() {
        this.shouldStop = true;
    }

    public final boolean isShouldStop() {
        return this.shouldStop;
    }

    public final boolean isFinished() {
        return this.isFinished;
    }

    protected abstract void doRun();

    static long getPageNumberForBeginning(long pagesAmount, SearchTaskOptions options2) {
        if (options2.searchForwardDirection) {
            if (options2.leftBoundPageNumber == -1L) {
                return 0L;
            }
            return options2.leftBoundPageNumber;
        }
        if (options2.rightBoundPageNumber == -1L) {
            return pagesAmount - 1L;
        }
        return options2.rightBoundPageNumber;
    }

    static boolean isTheEndOfSearchingCycle(long curPageNumber, long pagesAmount, SearchTaskOptions options2) {
        return curPageNumber < 0L || curPageNumber >= pagesAmount || options2.rightBoundPageNumber != -1L && curPageNumber > options2.rightBoundPageNumber || options2.leftBoundPageNumber != -1L && curPageNumber < options2.leftBoundPageNumber;
    }

    static int getTailLength(SearchTaskOptions options2) {
        return options2.regularExpression ? Integer.MAX_VALUE : options2.stringToFind.length() - 1;
    }

    static String getTailFromPage(String nextPageText, int tailLength) {
        return tailLength < nextPageText.length() ? nextPageText.substring(0, tailLength) : nextPageText;
    }

    static char getPostfixSymbol(String nextPageText, int tailLength) {
        return tailLength < nextPageText.length() ? nextPageText.charAt(tailLength) : FrameSearcher.NOT_EXISTING_BORDERING_SYMBOL;
    }

    static char getPrefixSymbol(String prevPageText) {
        if (!StringUtil.isEmpty((String)prevPageText)) {
            return prevPageText.charAt(prevPageText.length() - 1);
        }
        return FrameSearcher.NOT_EXISTING_BORDERING_SYMBOL;
    }

    static long getPreviousPageNumber(long curPageNumber, SearchTaskOptions options2) {
        if (options2.searchForwardDirection) {
            return curPageNumber - 1L;
        }
        return curPageNumber + 1L;
    }

    protected FrameSearcher createFrameSearcher(SearchTaskOptions options2, Project project) {
        return new FrameSearcher(options2, (frameText, offset, ijFindModel) -> FindManager.getInstance((Project)project).findString((CharSequence)frameText, offset, ijFindModel));
    }
}

