/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.google.common.collect.EvictingQueue;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.largeFilesEditor.editor.AbsoluteEditorPosition;
import com.intellij.largeFilesEditor.editor.AbsoluteSymbolPosition;
import com.intellij.largeFilesEditor.editor.DocumentOfPagesModel;
import com.intellij.largeFilesEditor.editor.GlobalScrollBar;
import com.intellij.largeFilesEditor.editor.LocalInvisibleScrollBar;
import com.intellij.largeFilesEditor.editor.Page;
import com.intellij.largeFilesEditor.editor.SelectionState;
import com.intellij.largeFilesEditor.file.ReadingPageResultHandler;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.impl.status.PositionPanel;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class EditorModel {
    private static final Logger LOG = Logger.getInstance(EditorModel.class);
    private static final int EDITOR_LINE_BEGINNING_INDENT = 5;
    private static final int PAGES_CASH_CAPACITY = 10;
    private static final int MAX_AVAILABLE_LINE_LENGTH = 1000;
    private final DataProvider dataProvider;
    private final Editor editor;
    private final DocumentOfPagesModel documentOfPagesModel;
    private final Collection<RangeHighlighter> pageRangeHighlighters;
    private final EvictingQueue<Page> pagesCash = EvictingQueue.create((int)10);
    private final List<Long> numbersOfRequestedForReadingPages = new LinkedList<Long>();
    private final AtomicBoolean isUpdateRequested = new AtomicBoolean(false);
    private boolean isBrokenMode = false;
    private final AbsoluteEditorPosition targetVisiblePosition = new AbsoluteEditorPosition(0L, 0);
    private boolean isLocalScrollBarStabilized = false;
    private final AbsoluteSymbolPosition targetCaretPosition = new AbsoluteSymbolPosition(0L, 0);
    private boolean isRealCaretAndSelectionCanAffectOnTarget = true;
    private boolean isNeedToShowCaret = false;
    private final SelectionState targetSelectionState = new SelectionState();
    private boolean wasViewPortInTheEndOfFileLastTime = false;
    private boolean isAllowedToFollowTheEndOfFile = false;
    private boolean isNeedToHighlightCloseSearchResults = false;
    private boolean isHighlightedSearchResultsAreStabilized = false;
    private JComponent myRootComponent;
    private final ExecutorService myPageReaderExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Large File Editor Page Reader Executor", (int)1);
    private final GlobalScrollBar myGlobalScrollBar;
    private final LocalInvisibleScrollBar myLocalInvisibleScrollBar;

    EditorModel(Document document, Project project, DataProvider dataProvider) {
        this.dataProvider = dataProvider;
        this.pageRangeHighlighters = new ArrayList<RangeHighlighter>();
        this.documentOfPagesModel = new DocumentOfPagesModel(document);
        this.documentOfPagesModel.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                EditorModel.this.fireHighlightedSearchResultsAreOutdated();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/largeFilesEditor/editor/EditorModel$1", "documentChanged"));
            }
        });
        this.editor = EditorModel.createSpecialEditor(document, project);
        this.editor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                EditorModel.this.fireRealCaretPositionChanged(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/largeFilesEditor/editor/EditorModel$2", "caretPositionChanged"));
            }
        });
        this.editor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                EditorModel.this.fireRealSelectionChanged(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/largeFilesEditor/editor/EditorModel$3", "selectionChanged"));
            }
        });
        this.myGlobalScrollBar = new GlobalScrollBar(this);
        this.myLocalInvisibleScrollBar = new LocalInvisibleScrollBar(this);
        JScrollPane scrollPaneInEditor = ((EditorEx)this.editor).getScrollPane();
        scrollPaneInEditor.setVerticalScrollBar((JScrollBar)((Object)this.myLocalInvisibleScrollBar));
        scrollPaneInEditor.getVerticalScrollBar().setOpaque(true);
        this.myRootComponent = this.editor.getComponent();
        this.insertGlobalScrollBarIntoEditorComponent();
    }

    private void insertGlobalScrollBarIntoEditorComponent() {
        JComponent mainPanelInEditor = this.editor.getComponent();
        LayoutManager layout = mainPanelInEditor.getLayout();
        if (layout instanceof BorderLayout) {
            BorderLayout borderLayout = (BorderLayout)layout;
            final Component originalCentralComponent = borderLayout.getLayoutComponent("Center");
            JBLayeredPane intermediatePane = new JBLayeredPane(){

                public void doLayout() {
                    Component[] components = this.getComponents();
                    Rectangle bounds2 = this.getBounds();
                    for (Component component2 : components) {
                        if (component2 == EditorModel.this.myGlobalScrollBar) {
                            int scrollBarWidth = EditorModel.this.myGlobalScrollBar.getPreferredSize().width;
                            component2.setBounds(bounds2.width - scrollBarWidth, 0, scrollBarWidth, bounds2.height);
                            continue;
                        }
                        component2.setBounds(0, 0, bounds2.width, bounds2.height);
                    }
                }

                public Dimension getPreferredSize() {
                    return originalCentralComponent.getPreferredSize();
                }
            };
            intermediatePane.add(originalCentralComponent, (Object)JLayeredPane.DEFAULT_LAYER);
            intermediatePane.add((Component)((Object)this.myGlobalScrollBar), (Object)JLayeredPane.PALETTE_LAYER);
            mainPanelInEditor.add((Component)intermediatePane, "Center");
        } else {
            LOG.info("[Large File Editor Subsystem] EditorModel.insertGlobalScrollBarIntoEditorComponent(): can't insert GlobalScrollBar in normal way.");
            this.myRootComponent = new JPanel();
            this.myRootComponent.setLayout(new BorderLayout());
            this.myRootComponent.add((Component)this.editor.getComponent(), "Center");
            this.myRootComponent.add((Component)((Object)this.myGlobalScrollBar), "East");
        }
    }

    long getCaretPageNumber() {
        return this.targetCaretPosition.pageNumber;
    }

    int getCaretPageOffset() {
        return this.targetCaretPosition.symbolOffsetInPage;
    }

    Editor getEditor() {
        return this.editor;
    }

    JComponent getComponent() {
        return this.myRootComponent;
    }

    void setBrokenMode() {
        this.isBrokenMode = true;
        this.requestUpdate();
    }

    void addCaretListener(CaretListener caretListener2) {
        this.editor.getCaretModel().addCaretListener(caretListener2);
    }

    <T> void putUserDataToEditor(@NotNull Key<T> key, T value2) {
        if (key == null) {
            EditorModel.$$$reportNull$$$0(0);
        }
        this.editor.putUserData(key, value2);
    }

    private void fireRealCaretPositionChanged(@NotNull CaretEvent event) {
        if (event == null) {
            EditorModel.$$$reportNull$$$0(1);
        }
        if (this.isRealCaretAndSelectionCanAffectOnTarget) {
            IdeDocumentHistory docHistory;
            this.reflectRealToTargetCaretPosition();
            this.isNeedToShowCaret = true;
            if (this.editor.getSelectionModel().getSelectionEnd() == this.editor.getSelectionModel().getSelectionStart()) {
                this.targetSelectionState.isExists = false;
            }
            if (event.getOldPosition().line != event.getNewPosition().line && (docHistory = IdeDocumentHistory.getInstance(this.dataProvider.getProject())) != null) {
                docHistory.includeCurrentCommandAsNavigation();
                docHistory.setCurrentCommandHasMoves();
            }
            this.requestUpdate();
        }
    }

    private void reflectRealToTargetCaretPosition() {
        int caretOffset = this.editor.getCaretModel().getPrimaryCaret().getOffset();
        AbsoluteSymbolPosition absoluteSymbolPosition = this.documentOfPagesModel.offsetToAbsoluteSymbolPosition(caretOffset);
        this.targetCaretPosition.set(absoluteSymbolPosition);
    }

    private void fireRealSelectionChanged(SelectionEvent selectionEvent) {
        if (this.isRealCaretAndSelectionCanAffectOnTarget) {
            this.reflectRealToTargetSelection(selectionEvent);
        }
    }

    private void reflectRealToTargetSelection(SelectionEvent selectionEvent) {
        TextRange newSelectionRange = selectionEvent.getNewRange();
        if (newSelectionRange == null || newSelectionRange.isEmpty()) {
            this.targetSelectionState.isExists = false;
        } else {
            int startOffset = newSelectionRange.getStartOffset();
            int endOffset = newSelectionRange.getEndOffset();
            AbsoluteSymbolPosition startAbsolutePosition = this.documentOfPagesModel.offsetToAbsoluteSymbolPosition(startOffset);
            AbsoluteSymbolPosition endAbsolutePosition = this.documentOfPagesModel.offsetToAbsoluteSymbolPosition(endOffset);
            this.targetSelectionState.set(startAbsolutePosition, endAbsolutePosition);
            this.targetSelectionState.isExists = true;
        }
    }

    private void fireHighlightedSearchResultsAreOutdated() {
        this.isHighlightedSearchResultsAreStabilized = false;
        this.requestUpdate();
    }

    public void fireGlobalScrollBarValueChangedFromOutside(long pageNumber) {
        long pagesAmount;
        try {
            pagesAmount = this.dataProvider.getPagesAmount();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return;
        }
        if (pageNumber < 0L || pageNumber > pagesAmount) {
            LOG.warn("[Large File Editor Subsystem] EditorModel.fireGlobalScrollBarValueChangedFromOutside(pageNumber): Illegal argument pageNumber. Expected: 0 < pageNumber <= pagesAmount. Actual: pageNumber=" + pageNumber + " pagesAmount=" + pagesAmount);
            return;
        }
        this.targetVisiblePosition.set(pageNumber, 0);
        this.update();
    }

    private void requestUpdate() {
        if (this.isUpdateRequested.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.isUpdateRequested.set(false);
                this.update();
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresEdt
    private void update() {
        long pagesAmountInFile;
        if (this.isBrokenMode) {
            this.documentOfPagesModel.removeAllPages(this.dataProvider.getProject());
            return;
        }
        try {
            pagesAmountInFile = this.dataProvider.getPagesAmount();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)EditorBundle.message((String)"large.file.editor.message.error.while.working.with.file.try.to.reopen.it", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (this.isNeedToShowCaret) {
            this.ensureTargetCaretPositionIsInFileBounds(pagesAmountInFile);
            this.targetVisiblePosition.set(this.targetCaretPosition.pageNumber, this.targetVisiblePosition.verticalScrollOffset);
        }
        this.normalizePagesInDocumentListBeginning();
        if (pagesAmountInFile == 0L) {
            return;
        }
        if (this.documentOfPagesModel.getPagesAmount() == 0) {
            long pageNumber = this.targetVisiblePosition.pageNumber == 0L ? 0L : (this.targetVisiblePosition.pageNumber == pagesAmountInFile ? this.targetVisiblePosition.pageNumber - 2L : this.targetVisiblePosition.pageNumber - 1L);
            Page page = this.tryGetPageFromCash(pageNumber);
            if (page == null) {
                this.requestReadPage(pageNumber);
                return;
            }
            this.setNextPageIntoDocument(page);
        }
        if (this.isNeedToTurnOnSoftWrapping()) {
            this.editor.getSettings().setUseSoftWraps(true);
        }
        this.normalizePagesInDocumentListEnding();
        this.ensureDocumentLastPageIsValid(pagesAmountInFile);
        if (this.wasViewPortInTheEndOfFileLastTime && this.isAllowedToFollowTheEndOfFile) {
            this.targetVisiblePosition.set(Long.MAX_VALUE, 0);
            this.isNeedToShowCaret = false;
            this.isAllowedToFollowTheEndOfFile = false;
        }
        this.tryReflectTargetCaretPositionToReal();
        this.tryReflectTargetSelectionToReal();
        this.tryNormalizeTargetVisiblePosition();
        if (!this.isLocalScrollBarStabilized) {
            this.tryScrollToTargetVisiblePosition();
        }
        this.updateGlobalStrollBarView();
        long nextPageNumberToAdd = this.tryGetNextPageNumberToAdd(pagesAmountInFile);
        if (nextPageNumberToAdd != -1L) {
            Page nextPageToAdd = this.tryGetPageFromCash(nextPageNumberToAdd);
            if (nextPageToAdd != null) {
                this.setNextPageIntoDocument(nextPageToAdd);
                this.requestUpdate();
                return;
            }
            this.requestReadPage(nextPageNumberToAdd);
            return;
        }
        this.pagesCash.clear();
        if (this.isNeedToShowCaret) {
            if (!this.isLocalScrollBarStabilized) {
                this.requestUpdate();
                return;
            }
            this.showCaretThatIsNeededToShow();
        } else if (!this.isRealCaretMatchesTarget()) {
            this.setCaretToConvenientPosition();
        }
        this.wasViewPortInTheEndOfFileLastTime = false;
        if (this.documentOfPagesModel.getLastPage().getPageNumber() == pagesAmountInFile - 1L && this.myLocalInvisibleScrollBar.getValue() + this.myLocalInvisibleScrollBar.getHeight() == this.myLocalInvisibleScrollBar.getMaximum()) {
            this.wasViewPortInTheEndOfFileLastTime = true;
        }
        this.tryHighlightSearchResultsIfNeed();
    }

    private void ensureDocumentLastPageIsValid(long pagesAmountInFile) {
        Page lastPageInDocument = this.documentOfPagesModel.getLastPage();
        if (lastPageInDocument.isLastInFile() != (lastPageInDocument.getPageNumber() == pagesAmountInFile - 1L)) {
            this.removeLastPageFromDocument();
            this.pagesCash.removeIf(page -> lastPageInDocument.getPageNumber() == page.getPageNumber());
        }
    }

    private boolean isNeedToTurnOnSoftWrapping() {
        return !this.editor.getSettings().isUseSoftWraps() && this.isExistLineWithTooLargeLength();
    }

    private boolean isExistLineWithTooLargeLength() {
        Document document = this.documentOfPagesModel.getDocument();
        int lineCount = document.getLineCount();
        for (int i2 = 0; i2 < lineCount; ++i2) {
            int lineWidth = document.getLineEndOffset(i2) - document.getLineStartOffset(i2);
            if (lineWidth <= 1000) continue;
            return true;
        }
        return false;
    }

    private void tryHighlightSearchResultsIfNeed() {
        if (this.isNeedToHighlightCloseSearchResults) {
            if (!this.isHighlightedSearchResultsAreStabilized) {
                this.updateSearchResultsHighlighting();
                this.isHighlightedSearchResultsAreStabilized = true;
            }
        } else {
            this.clearHighlightedSearchResults();
        }
    }

    private void updateSearchResultsHighlighting() {
        this.clearHighlightedSearchResults();
        List<TextRange> highlightRanges = this.getAllSearchResultsRangesInDocument();
        if (!highlightRanges.isEmpty()) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.dataProvider.getProject());
            for (TextRange range2 : highlightRanges) {
                highlightManager.addRangeHighlight(this.editor, range2.getStartOffset(), range2.getEndOffset(), EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES, true, this.pageRangeHighlighters);
            }
        }
    }

    private List<TextRange> getAllSearchResultsRangesInDocument() {
        ArrayList<TextRange> searchResultsRanges = new ArrayList<TextRange>();
        for (int i2 = 0; i2 < this.documentOfPagesModel.getPagesList().size(); ++i2) {
            Page page = this.documentOfPagesModel.getPagesList().get(i2);
            List<SearchResult> searchResults = this.dataProvider.getSearchResultsInPage(page);
            if (searchResults == null) continue;
            for (SearchResult result2 : searchResults) {
                int from2 = this.documentOfPagesModel.getSymbolOffsetToStartOfPage(this.documentOfPagesModel.getIndexOfPageByPageNumber(result2.startPosition.pageNumber)) + result2.startPosition.symbolOffsetInPage;
                int to = this.documentOfPagesModel.getSymbolOffsetToStartOfPage(this.documentOfPagesModel.getIndexOfPageByPageNumber(result2.endPostion.pageNumber)) + result2.endPostion.symbolOffsetInPage;
                if (from2 < 0) {
                    from2 = 0;
                }
                if (to > this.documentOfPagesModel.getDocument().getTextLength()) {
                    to = this.documentOfPagesModel.getDocument().getTextLength();
                }
                if (from2 >= to) continue;
                searchResultsRanges.add(new TextRange(from2, to));
            }
        }
        return searchResultsRanges;
    }

    private void clearHighlightedSearchResults() {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.dataProvider.getProject());
        for (RangeHighlighter pageRangeHighlighter : this.pageRangeHighlighters) {
            highlightManager.removeSegmentHighlighter(this.editor, pageRangeHighlighter);
        }
        this.pageRangeHighlighters.clear();
    }

    private void showCaretThatIsNeededToShow() {
        int targetCaretOffsetInDocument = this.tryGetTargetCaretOffsetInDocumentWithMargin();
        if (targetCaretOffsetInDocument != -1) {
            if (!this.isRealCaretInsideTargetVisibleArea()) {
                this.editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        } else {
            LOG.warn("[Large File Editor Subsystem] EditorMode.update(): can't show caret.  targetCaretPosition.pageNumber=" + this.targetCaretPosition.pageNumber + " targetCaretPosition.symbolOffsetInPage=" + this.targetCaretPosition.symbolOffsetInPage + " targetVisiblePosition.pageNumber=" + this.targetVisiblePosition.pageNumber + " targetVisiblePosition.verticalScrollOffset=" + this.targetVisiblePosition.verticalScrollOffset);
        }
        this.isNeedToShowCaret = false;
    }

    private boolean isRealCaretInsideTargetVisibleArea() {
        Point pointOfCaret = this.editor.offsetToXY(this.editor.getCaretModel().getOffset());
        Rectangle area = this.editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        return area.contains(pointOfCaret);
    }

    private void setCaretToConvenientPosition() {
        int offset = this.tryGetConvenientOffsetForCaret();
        if (offset != -1) {
            this.runCaretAndSelectionListeningTransparentCommand(() -> this.editor.getCaretModel().moveToOffset(offset));
            this.reflectRealToTargetCaretPosition();
        } else {
            LOG.info("[Large File Editor Subsystem] EditorModel.setCaretToConvenientPosition(): Can't set caret to convenient position.");
        }
    }

    private boolean isRealCaretMatchesTarget() {
        int targetCaretOffsetInDocument = this.tryGetTargetCaretOffsetInDocumentWithMargin();
        return targetCaretOffsetInDocument == this.editor.getCaretModel().getOffset();
    }

    private void tryReflectTargetCaretPositionToReal() {
        int targetCaretOffsetInDocument = this.tryGetTargetCaretOffsetInDocumentWithMargin();
        if (targetCaretOffsetInDocument != -1) {
            this.runCaretAndSelectionListeningTransparentCommand(() -> this.editor.getCaretModel().moveToOffset(targetCaretOffsetInDocument));
        }
    }

    private void tryReflectTargetSelectionToReal() {
        if (this.targetSelectionState.isExists && this.documentOfPagesModel.getPagesAmount() != 0) {
            int docLength = this.documentOfPagesModel.getDocument().getTextLength();
            int startOffset = Math.min(this.documentOfPagesModel.absoluteSymbolPositionToOffset(this.targetSelectionState.start), docLength);
            int endOffset = Math.min(this.documentOfPagesModel.absoluteSymbolPositionToOffset(this.targetSelectionState.end), docLength);
            this.runCaretAndSelectionListeningTransparentCommand(() -> {
                if (startOffset == endOffset) {
                    this.editor.getSelectionModel().removeSelection();
                } else {
                    this.editor.getSelectionModel().setSelection(startOffset, endOffset);
                }
            });
        }
    }

    private int tryGetConvenientOffsetForCaret() {
        Rectangle visibleArea = this.editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        return this.editor.logicalPositionToOffset(this.editor.xyToLogicalPosition(new Point(0, visibleArea.y + this.editor.getLineHeight())));
    }

    private int tryGetTargetCaretOffsetInDocumentWithMargin() {
        if (this.documentOfPagesModel.getPagesAmount() == 0) {
            return 0;
        }
        int offset = this.tryGetTargetCaretOffsetInDocument();
        if (offset == -1) {
            return -1;
        }
        int startOfAllowedRange = this.tryGetStartMarginForTargetCaretInDocument();
        int endOfAllowedRange = this.getSymbolOffsetToStartOfPage(this.documentOfPagesModel.getPagesAmount());
        try {
            if (this.documentOfPagesModel.getLastPage().getPageNumber() != this.dataProvider.getPagesAmount() - 1L) {
                endOfAllowedRange -= this.documentOfPagesModel.getLastPage().getText().length() / 2;
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        if (offset >= startOfAllowedRange && offset <= endOfAllowedRange) {
            return offset;
        }
        return -1;
    }

    private int tryGetStartMarginForTargetCaretInDocument() {
        if (this.documentOfPagesModel.getPagesAmount() > 0) {
            if (this.documentOfPagesModel.getFirstPage().getPageNumber() == 0L) {
                return 0;
            }
            return this.documentOfPagesModel.getFirstPage().getText().length() / 2;
        }
        return 0;
    }

    private int tryGetTargetCaretOffsetInDocument() {
        int targetCaretOffsetInDocument;
        int indexOfPage = this.documentOfPagesModel.tryGetIndexOfNeededPageInList(this.targetCaretPosition.pageNumber);
        if (indexOfPage != -1) {
            targetCaretOffsetInDocument = this.getSymbolOffsetToStartOfPage(indexOfPage) + this.targetCaretPosition.symbolOffsetInPage;
        } else if (this.targetCaretPosition.symbolOffsetInPage == 0 && this.targetCaretPosition.pageNumber == this.documentOfPagesModel.getLastPage().getPageNumber() + 1L) {
            targetCaretOffsetInDocument = this.getSymbolOffsetToStartOfPage(this.documentOfPagesModel.getPagesAmount());
        } else {
            return -1;
        }
        int docLength = this.documentOfPagesModel.getDocument().getTextLength();
        if (targetCaretOffsetInDocument >= 0) {
            return Math.min(targetCaretOffsetInDocument, docLength);
        }
        LOG.warn("[Large File Editor Subsystem] EditorModel.tryGetTargetCaretOffsetInDocument(): Invalid targetCaretPosition state. targetCaretPosition.pageNumber=" + this.targetCaretPosition.pageNumber + " targetCaretPosition.symbolOffsetInPage=" + this.targetCaretPosition.symbolOffsetInPage + " targetCaretOffsetInDocument=" + targetCaretOffsetInDocument + " document.getTextLength()=" + docLength);
        return -1;
    }

    private void updateGlobalStrollBarView() {
        long pagesAmount;
        try {
            pagesAmount = this.dataProvider.getPagesAmount();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return;
        }
        if (pagesAmount >= Integer.MAX_VALUE) {
            LOG.warn("[Large File Editor Subsystem] EditorModel.updateGlobalStrollBarView():pagesAmount > Integer.MAX_VALUE. pagesAmount=" + pagesAmount);
        }
        int extent = 1;
        this.myGlobalScrollBar.setValues((int)this.targetVisiblePosition.pageNumber, extent, 0, (int)pagesAmount + 1);
    }

    private long tryGetNextPageNumberToAdd(long pagesAmountInFile) {
        if (this.documentOfPagesModel.getPagesAmount() == 0) {
            return this.targetVisiblePosition.pageNumber == 0L ? this.targetVisiblePosition.pageNumber : this.targetVisiblePosition.pageNumber - 1L;
        }
        int visibleTargetPageIndex = this.documentOfPagesModel.tryGetIndexOfNeededPageInList(this.targetVisiblePosition.pageNumber);
        if (visibleTargetPageIndex == -1) {
            return this.tryGetNumberOfNextToDocumentPage(pagesAmountInFile);
        }
        int offsetToFirstVisibleSymbolOfTargetVisiblePage = this.getSymbolOffsetToStartOfPage(visibleTargetPageIndex);
        int topOfTargetVisiblePage = this.offsetToY(offsetToFirstVisibleSymbolOfTargetVisiblePage);
        int topOfTargetVisibleArea = topOfTargetVisiblePage + this.targetVisiblePosition.verticalScrollOffset;
        Rectangle visibleArea = this.editor.getScrollingModel().getVisibleArea();
        int bottomOfTargetVisibleArea = topOfTargetVisibleArea + visibleArea.height;
        int lastVisiblePageIndex = visibleTargetPageIndex;
        int offsetToEndOfLastVisiblePage = this.getSymbolOffsetToStartOfPage(lastVisiblePageIndex + 1);
        while (lastVisiblePageIndex + 1 < this.documentOfPagesModel.getPagesAmount() && this.offsetToY(offsetToEndOfLastVisiblePage) <= bottomOfTargetVisibleArea) {
            offsetToEndOfLastVisiblePage = this.getSymbolOffsetToStartOfPage(++lastVisiblePageIndex + 1);
        }
        if (this.documentOfPagesModel.getPagesAmount() - 1 == lastVisiblePageIndex) {
            return this.tryGetNumberOfNextToDocumentPage(pagesAmountInFile);
        }
        return -1L;
    }

    private long tryGetNumberOfNextToDocumentPage(long pagesAmountInFile) {
        if (this.documentOfPagesModel.getPagesAmount() > 0) {
            long nextPageNumber = this.documentOfPagesModel.getLastPage().getPageNumber() + 1L;
            return nextPageNumber < pagesAmountInFile ? nextPageNumber : -1L;
        }
        return -1L;
    }

    private void tryNormalizeTargetVisiblePosition() {
        try {
            boolean needToRepeat;
            while (needToRepeat = this.tryNormalizeTargetEditorViewPosition_iteration()) {
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private boolean tryNormalizeTargetEditorViewPosition_iteration() throws IOException {
        long pagesAmountInFile = this.dataProvider.getPagesAmount();
        if (pagesAmountInFile == 0L) {
            this.targetVisiblePosition.set(0L, 0);
            return false;
        }
        if (this.targetVisiblePosition.pageNumber >= pagesAmountInFile) {
            this.targetVisiblePosition.set(pagesAmountInFile, -1);
        }
        if (this.targetVisiblePosition.verticalScrollOffset < 0) {
            if (this.targetVisiblePosition.pageNumber == 0L) {
                this.targetVisiblePosition.set(0L, 0);
                return false;
            }
            int prevPageIndex = this.documentOfPagesModel.tryGetIndexOfNeededPageInList(this.targetVisiblePosition.pageNumber - 1L);
            if (prevPageIndex == -1) {
                return false;
            }
            int symbolOffsetToBeginningOfPrevPage = this.getSymbolOffsetToStartOfPage(prevPageIndex);
            int symbolOffsetToBeginningOfTargetPage = this.getSymbolOffsetToStartOfPage(prevPageIndex + 1);
            int verticalOffsetToBeginningOfPrevPage = this.offsetToY(symbolOffsetToBeginningOfPrevPage);
            int verticalOffsetToBeginningOfTargetPage = this.offsetToY(symbolOffsetToBeginningOfTargetPage);
            this.targetVisiblePosition.set(this.targetVisiblePosition.pageNumber - 1L, this.targetVisiblePosition.verticalScrollOffset + verticalOffsetToBeginningOfTargetPage - verticalOffsetToBeginningOfPrevPage);
            return true;
        }
        int visibleTargetPageIndex = this.documentOfPagesModel.tryGetIndexOfNeededPageInList(this.targetVisiblePosition.pageNumber);
        if (visibleTargetPageIndex == -1) {
            return false;
        }
        int symbolOffsetToBeginningOfTargetVisiblePage = this.getSymbolOffsetToStartOfPage(visibleTargetPageIndex);
        int symbolOffsetToEndOfTargetVisiblePage = this.getSymbolOffsetToStartOfPage(visibleTargetPageIndex + 1);
        int topOfTargetVisiblePage = this.offsetToY(symbolOffsetToBeginningOfTargetVisiblePage);
        int bottomOfExpectedVisibleArea = topOfTargetVisiblePage + this.targetVisiblePosition.verticalScrollOffset + this.editor.getScrollingModel().getVisibleArea().height;
        if (bottomOfExpectedVisibleArea > this.editor.getContentComponent().getHeight()) {
            int indexOfLastLastPage = this.documentOfPagesModel.tryGetIndexOfNeededPageInList(pagesAmountInFile - 1L);
            if (indexOfLastLastPage == -1) {
                return false;
            }
            int extraDifference = bottomOfExpectedVisibleArea - this.editor.getContentComponent().getHeight();
            this.targetVisiblePosition.set(this.targetVisiblePosition.pageNumber, this.targetVisiblePosition.verticalScrollOffset - extraDifference);
            return true;
        }
        int bottomOfTargetVisiblePage = this.offsetToY(symbolOffsetToEndOfTargetVisiblePage);
        if (topOfTargetVisiblePage + this.targetVisiblePosition.verticalScrollOffset >= bottomOfTargetVisiblePage) {
            this.targetVisiblePosition.set(this.targetVisiblePosition.pageNumber + 1L, this.targetVisiblePosition.verticalScrollOffset - bottomOfTargetVisiblePage + topOfTargetVisiblePage);
            return true;
        }
        return false;
    }

    private void ensureTargetCaretPositionIsInFileBounds(long pagesAmount) {
        if (this.targetCaretPosition.pageNumber < 0L) {
            this.targetCaretPosition.set(0L, 0);
        } else if (this.targetCaretPosition.pageNumber >= pagesAmount) {
            this.targetCaretPosition.set(pagesAmount, 0);
        }
    }

    private void normalizePagesInDocumentListEnding() {
        int visibleTargetPageIndex = this.documentOfPagesModel.tryGetIndexOfNeededPageInList(this.targetVisiblePosition.pageNumber);
        if (visibleTargetPageIndex == -1) {
            return;
        }
        int offsetToFirstVisibleSymbolOfTargetVisiblePage = this.getSymbolOffsetToStartOfPage(visibleTargetPageIndex);
        int topOfTargetVisiblePage = this.offsetToY(offsetToFirstVisibleSymbolOfTargetVisiblePage);
        int topOfTargetVisibleArea = topOfTargetVisiblePage + this.targetVisiblePosition.verticalScrollOffset;
        Rectangle visibleArea = this.editor.getScrollingModel().getVisibleArea();
        int bottomOfTargetVisibleArea = topOfTargetVisibleArea + visibleArea.height;
        int lastVisiblePageIndex = visibleTargetPageIndex;
        int offsetToEndOfLastVisiblePage = this.getSymbolOffsetToStartOfPage(lastVisiblePageIndex + 1);
        while (lastVisiblePageIndex + 1 < this.documentOfPagesModel.getPagesAmount() && this.offsetToY(offsetToEndOfLastVisiblePage) <= bottomOfTargetVisibleArea) {
            offsetToEndOfLastVisiblePage = this.getSymbolOffsetToStartOfPage(++lastVisiblePageIndex + 1);
        }
        int maxAllowedAmountOfPagesInDocumentHere = lastVisiblePageIndex + 2 + 1;
        while (this.documentOfPagesModel.getPagesAmount() > maxAllowedAmountOfPagesInDocumentHere) {
            this.removeLastPageFromDocument();
        }
    }

    private void tryScrollToTargetVisiblePosition() {
        int visibleTargetPageIndex = this.documentOfPagesModel.tryGetIndexOfNeededPageInList(this.targetVisiblePosition.pageNumber);
        if (visibleTargetPageIndex == -1) {
            return;
        }
        int symbolOffsetToBeginningOfTargetVisiblePage = this.getSymbolOffsetToStartOfPage(visibleTargetPageIndex);
        int topOfTargetVisiblePage = this.offsetToY(symbolOffsetToBeginningOfTargetVisiblePage);
        int targetTopOfVisibleArea = topOfTargetVisiblePage + this.targetVisiblePosition.verticalScrollOffset;
        if (this.editor.getScrollingModel().getVisibleAreaOnScrollingFinished().y != targetTopOfVisibleArea) {
            this.editor.getScrollingModel().disableAnimation();
            this.editor.getScrollingModel().scrollVertically(targetTopOfVisibleArea);
            this.editor.getScrollingModel().enableAnimation();
        }
        if (this.editor.getScrollingModel().getVisibleAreaOnScrollingFinished().y == targetTopOfVisibleArea) {
            this.isLocalScrollBarStabilized = true;
        }
    }

    public void setCaretToFileEndAndShow() {
        long pagesAmount;
        try {
            pagesAmount = this.dataProvider.getPagesAmount();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return;
        }
        this.setCaretAndShow(pagesAmount, 0);
    }

    public void setCaretToFileStartAndShow() {
        this.setCaretAndShow(0L, 0);
    }

    public void setCaretAndShow(long pageNumber, int symbolOffsetInPage) {
        this.targetCaretPosition.set(pageNumber, symbolOffsetInPage);
        this.isNeedToShowCaret = true;
        this.requestUpdate();
    }

    private int offsetToY(int offset) {
        return this.editor.offsetToXY((int)offset).y;
    }

    private int getSymbolOffsetToStartOfPage(int indexOfPage) {
        return this.documentOfPagesModel.getSymbolOffsetToStartOfPage(indexOfPage);
    }

    private void requestReadPage(long pageNumber) {
        if (!this.numbersOfRequestedForReadingPages.contains(pageNumber)) {
            this.dataProvider.requestReadPage(pageNumber, page -> this.tellPageWasRead(pageNumber, page));
            this.numbersOfRequestedForReadingPages.add(pageNumber);
        }
    }

    private void tellPageWasRead(long pageNumber, Page page) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (page == null) {
                LOG.warn("page with number " + pageNumber + " is null.");
                return;
            }
            this.pagesCash.add((Object)page);
            this.numbersOfRequestedForReadingPages.remove(pageNumber);
            this.requestUpdate();
        });
    }

    private void setNextPageIntoDocument(Page page) {
        this.runCaretAndSelectionListeningTransparentCommand(() -> this.documentOfPagesModel.addPageIntoEnd(page, this.dataProvider.getProject()));
    }

    private void removeLastPageFromDocument() {
        if (this.documentOfPagesModel.getPagesAmount() > 0) {
            this.pagesCash.add((Object)this.documentOfPagesModel.getLastPage());
            this.runCaretAndSelectionListeningTransparentCommand(() -> this.documentOfPagesModel.removeLastPage(this.dataProvider.getProject()));
        }
    }

    private void deleteAllPagesFromDocument() {
        this.pagesCash.addAll(this.documentOfPagesModel.getPagesList());
        this.runCaretAndSelectionListeningTransparentCommand(() -> this.documentOfPagesModel.removeAllPages(this.dataProvider.getProject()));
    }

    private void runCaretAndSelectionListeningTransparentCommand(Runnable command) {
        this.isRealCaretAndSelectionCanAffectOnTarget = false;
        command.run();
        this.isRealCaretAndSelectionCanAffectOnTarget = true;
    }

    private Page tryGetPageFromCash(long pageNumber) {
        for (Page page : this.pagesCash) {
            if (page.getPageNumber() != pageNumber) continue;
            return page;
        }
        return null;
    }

    private void normalizePagesInDocumentListBeginning() {
        if (!this.isOkBeginningOfPagesInDocumentList()) {
            this.isLocalScrollBarStabilized = false;
            this.deleteAllPagesFromDocument();
        }
    }

    private boolean isOkBeginningOfPagesInDocumentList() {
        int listSize = this.documentOfPagesModel.getPagesAmount();
        if (listSize < 1) {
            return true;
        }
        long numberOfPage0 = this.documentOfPagesModel.getPageByIndex(0).getPageNumber();
        if (numberOfPage0 != this.targetVisiblePosition.pageNumber - 2L && numberOfPage0 != this.targetVisiblePosition.pageNumber - 1L) {
            return numberOfPage0 == this.targetVisiblePosition.pageNumber && this.targetVisiblePosition.pageNumber == 0L;
        }
        if (listSize < 2) {
            return true;
        }
        long numberOfPage1 = this.documentOfPagesModel.getPageByIndex(1).getPageNumber();
        if (numberOfPage1 == this.targetVisiblePosition.pageNumber) {
            return true;
        }
        if (numberOfPage1 != this.targetVisiblePosition.pageNumber - 1L) {
            return false;
        }
        if (listSize < 3) {
            return true;
        }
        long numberOfPage2 = this.documentOfPagesModel.getPageByIndex(2).getPageNumber();
        return numberOfPage2 == this.targetVisiblePosition.pageNumber;
    }

    void dispose() {
        if (this.editor != null) {
            EditorFactory.getInstance().releaseEditor(this.editor);
        }
        this.myPageReaderExecutor.shutdown();
    }

    private static Editor createSpecialEditor(Document document, Project project) {
        Editor editor = EditorFactory.getInstance().createViewer(document, project, EditorKind.MAIN_EDITOR);
        editor.getSettings().setLineMarkerAreaShown(false);
        editor.getSettings().setLineNumbersShown(false);
        editor.getSettings().setFoldingOutlineShown(false);
        editor.getContentComponent().setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).setContextMenuGroupId("EditorPopupMenu");
        } else {
            LOG.warn("[Large File Editor Subsystem] com.intellij.largeFilesEditor.editor.EditorModel.createSpecialEditor: 'editor' is not instance of EditorEx. Can't set proper context menu group id.");
        }
        editor.putUserData(PositionPanel.DISABLE_FOR_EDITOR, new Object());
        return editor;
    }

    public void fireLocalScrollBarValueChanged() {
        if (this.editor.isDisposed()) {
            return;
        }
        if (this.isLocalScrollBarStabilized) {
            this.reflectLocalScrollBarStateToTargetPosition();
        }
        this.requestUpdate();
    }

    private void reflectLocalScrollBarStateToTargetPosition() {
        int indexOfPage;
        if (this.documentOfPagesModel.getPagesAmount() == 0) {
            return;
        }
        int localScrollBarValue = this.myLocalInvisibleScrollBar.getValue();
        int topOfPage = 0;
        int bottomOfPage = 0;
        for (indexOfPage = 0; indexOfPage < this.documentOfPagesModel.getPagesAmount(); ++indexOfPage) {
            topOfPage = bottomOfPage;
            bottomOfPage = this.offsetToY(this.getSymbolOffsetToStartOfPage(indexOfPage + 1));
            if (localScrollBarValue >= bottomOfPage) continue;
            this.targetVisiblePosition.set(this.documentOfPagesModel.getPageByIndex(indexOfPage).getPageNumber(), localScrollBarValue - topOfPage);
            return;
        }
        if (indexOfPage >= 1 && localScrollBarValue == bottomOfPage) {
            this.targetVisiblePosition.set(this.documentOfPagesModel.getPageByIndex(indexOfPage - 1).getPageNumber(), localScrollBarValue - topOfPage);
            return;
        }
        LOG.warn("[Large File Editor Subsystem] EditorModel.reflectLocalScrollBarStateToTargetPosition(): can't reflect state. indexOfPage=" + indexOfPage + " localScrollBarValue=" + localScrollBarValue + " topOfPage=" + topOfPage + " bottomOfPage=" + bottomOfPage + " pagesInDocument.size()=" + this.documentOfPagesModel.getPagesAmount());
    }

    @RequiresEdt
    public void showSearchResult(SearchResult searchResult) {
        this.targetSelectionState.set(searchResult.startPosition.pageNumber, searchResult.startPosition.symbolOffsetInPage, searchResult.endPostion.pageNumber, searchResult.endPostion.symbolOffsetInPage);
        this.targetSelectionState.isExists = true;
        this.targetCaretPosition.pageNumber = searchResult.endPostion.pageNumber;
        this.targetCaretPosition.symbolOffsetInPage = searchResult.endPostion.symbolOffsetInPage;
        this.isNeedToShowCaret = true;
        this.requestUpdate();
    }

    @RequiresEdt
    public void setHighlightingCloseSearchResultsEnabled(boolean enabled) {
        if (this.isNeedToHighlightCloseSearchResults != enabled) {
            this.isNeedToHighlightCloseSearchResults = enabled;
            this.fireHighlightedSearchResultsAreOutdated();
            this.requestUpdate();
        }
    }

    @RequiresEdt
    public void onFileChanged(Page lastPage, boolean isLengthIncreased) {
        this.isLocalScrollBarStabilized = false;
        this.pagesCash.clear();
        if (isLengthIncreased) {
            this.runCaretAndSelectionListeningTransparentCommand(() -> this.documentOfPagesModel.removeLastPage(this.dataProvider.getProject()));
            this.isAllowedToFollowTheEndOfFile = true;
        } else {
            this.runCaretAndSelectionListeningTransparentCommand(() -> this.documentOfPagesModel.removeAllPages(this.dataProvider.getProject()));
        }
        if (lastPage != null) {
            this.pagesCash.add((Object)lastPage);
        }
        this.update();
    }

    @RequiresEdt
    public void onEncodingChanged() {
        this.isLocalScrollBarStabilized = false;
        this.pagesCash.clear();
        this.runCaretAndSelectionListeningTransparentCommand(() -> this.documentOfPagesModel.removeAllPages(this.dataProvider.getProject()));
        this.requestUpdate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/largeFilesEditor/editor/EditorModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "putUserDataToEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fireRealCaretPositionChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface DataProvider {
        public Page getPage(long var1) throws IOException;

        public long getPagesAmount() throws IOException;

        public Project getProject();

        public void requestReadPage(long var1, ReadingPageResultHandler var3);

        public List<SearchResult> getSearchResultsInPage(Page var1);
    }
}

