/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.impl;

import com.intellij.jps.impl.JpsPluginBean;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.UnknownSourceRootType;
import org.jetbrains.jps.model.module.UnknownSourceRootTypeProperties;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.UnknownSourceRootPropertiesSerializer;
import org.jetbrains.jps.plugin.JpsPluginManager;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.service.impl.JpsServiceManagerImpl;

public final class JpsIdePluginManagerImpl
extends JpsPluginManager {
    private final List<PluginDescriptor> myExternalBuildPlugins = new CopyOnWriteArrayList<PluginDescriptor>();
    private final AtomicInteger myModificationStamp = new AtomicInteger(0);
    private final boolean myFullyLoaded;

    public JpsIdePluginManagerImpl() {
        Application application = ApplicationManager.getApplication();
        boolean bl = this.myFullyLoaded = application != null;
        if (!this.myFullyLoaded) {
            return;
        }
        ExtensionsArea rootArea = application.getExtensionArea();
        if (rootArea.hasExtensionPoint(JpsPluginBean.EP_NAME)) {
            final Ref initial = new Ref((Object)Boolean.TRUE);
            JpsPluginBean.EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<JpsPluginBean>(){

                public void extensionAdded(@NotNull JpsPluginBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)initial.get()).booleanValue()) {
                        JpsIdePluginManagerImpl.this.myExternalBuildPlugins.add(pluginDescriptor);
                    } else {
                        JpsIdePluginManagerImpl.this.handlePluginAdded(pluginDescriptor);
                    }
                }

                public void extensionRemoved(@NotNull JpsPluginBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    JpsIdePluginManagerImpl.this.handlePluginRemoved(pluginDescriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "extension";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/jps/impl/JpsIdePluginManagerImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true, null);
            initial.set((Object)Boolean.FALSE);
        }
        if (rootArea.hasExtensionPoint("com.intellij.compileServer.plugin")) {
            ExtensionPoint extensionPoint = rootArea.getExtensionPoint("com.intellij.compileServer.plugin");
            final Ref initial = new Ref((Object)Boolean.TRUE);
            extensionPoint.addExtensionPointListener(new ExtensionPointListener(){

                public void extensionAdded(@NotNull Object extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)initial.get()).booleanValue()) {
                        JpsIdePluginManagerImpl.this.myExternalBuildPlugins.add(pluginDescriptor);
                    } else {
                        JpsIdePluginManagerImpl.this.handlePluginAdded(pluginDescriptor);
                    }
                }

                public void extensionRemoved(@NotNull Object extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension2 == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (pluginDescriptor == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    JpsIdePluginManagerImpl.this.handlePluginRemoved(pluginDescriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "extension";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/jps/impl/JpsIdePluginManagerImpl$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true, null);
            initial.set((Object)Boolean.FALSE);
        }
    }

    public boolean isFullyLoaded() {
        return this.myFullyLoaded;
    }

    private void handlePluginRemoved(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(0);
        }
        if (!this.myExternalBuildPlugins.contains(pluginDescriptor)) {
            return;
        }
        HashMap<JpsModuleSourceRootType, JpsModuleSourceRootPropertiesSerializer> removed = new HashMap<JpsModuleSourceRootType, JpsModuleSourceRootPropertiesSerializer>();
        for (JpsModelSerializerExtension extension2 : this.loadExtensions(JpsModelSerializerExtension.class)) {
            for (JpsModuleSourceRootPropertiesSerializer serializer2 : extension2.getModuleSourceRootPropertiesSerializers()) {
                removed.put((JpsModuleSourceRootType)serializer2.getType(), serializer2);
            }
        }
        for (JpsModelSerializerExtension extension2 : this.loadExtensions(JpsModelSerializerExtension.class, descriptor2 -> !descriptor2.equals(pluginDescriptor))) {
            for (JpsModuleSourceRootPropertiesSerializer serializer2 : extension2.getModuleSourceRootPropertiesSerializers()) {
                removed.remove(serializer2.getType());
            }
        }
        if (!removed.isEmpty()) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                JpsIdePluginManagerImpl.replaceWithUnknownRootType(project, removed.values());
            }
        }
        this.myExternalBuildPlugins.remove(pluginDescriptor);
        this.myModificationStamp.incrementAndGet();
        JpsServiceManager jpsServiceManager = JpsServiceManager.getInstance();
        if (jpsServiceManager instanceof JpsServiceManagerImpl) {
            ((JpsServiceManagerImpl)jpsServiceManager).cleanupExtensionCache();
        }
    }

    private void handlePluginAdded(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.myExternalBuildPlugins.contains(pluginDescriptor)) {
            return;
        }
        HashSet<String> before = new HashSet<String>();
        for (JpsModelSerializerExtension extension2 : this.loadExtensions(JpsModelSerializerExtension.class)) {
            for (JpsModuleSourceRootPropertiesSerializer serializer2 : extension2.getModuleSourceRootPropertiesSerializers()) {
                before.add(serializer2.getTypeId());
            }
        }
        this.myExternalBuildPlugins.add(pluginDescriptor);
        this.myModificationStamp.incrementAndGet();
        HashMap<String, JpsModuleSourceRootPropertiesSerializer> added2 = new HashMap<String, JpsModuleSourceRootPropertiesSerializer>();
        for (JpsModelSerializerExtension extension3 : this.loadExtensions(JpsModelSerializerExtension.class)) {
            for (JpsModuleSourceRootPropertiesSerializer serializer3 : extension3.getModuleSourceRootPropertiesSerializers()) {
                added2.put(serializer3.getTypeId(), serializer3);
            }
        }
        added2.keySet().removeAll(before);
        if (!added2.isEmpty()) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                JpsIdePluginManagerImpl.updateCustomRootTypes(project, added2.values());
            }
        }
    }

    private static void replaceWithUnknownRootType(Project project, Collection<JpsModuleSourceRootPropertiesSerializer<?>> unregisteredSerializers) {
        if (unregisteredSerializers.isEmpty()) {
            return;
        }
        HashMap serializers = new HashMap();
        for (JpsModuleSourceRootPropertiesSerializer<?> serializer2 : unregisteredSerializers) {
            serializers.put((JpsModuleSourceRootType)serializer2.getType(), serializer2);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootModificationUtil.modifyModel((Module)module, model2 -> {
                boolean shouldCommit = false;
                for (ContentEntry contentEntry : model2.getContentEntries()) {
                    for (SourceFolder folder : contentEntry.getSourceFolders()) {
                        JpsModuleSourceRootPropertiesSerializer removedSerializer = (JpsModuleSourceRootPropertiesSerializer)serializers.get(folder.getRootType());
                        if (removedSerializer == null) continue;
                        JpsIdePluginManagerImpl.changeType(folder, UnknownSourceRootPropertiesSerializer.forType((String)removedSerializer.getTypeId()), JpsIdePluginManagerImpl.serializeProperties(folder, removedSerializer));
                        shouldCommit = true;
                    }
                }
                return shouldCommit;
            });
        }
    }

    private static void updateCustomRootTypes(Project project, Collection<JpsModuleSourceRootPropertiesSerializer<?>> registeredSerializers) {
        if (registeredSerializers.isEmpty()) {
            return;
        }
        HashMap serializers = new HashMap();
        for (JpsModuleSourceRootPropertiesSerializer<?> ser : registeredSerializers) {
            serializers.put(ser.getTypeId(), ser);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            HashMap<SourceFolder, Pair> foldersToUpdate = new HashMap<SourceFolder, Pair>();
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                for (SourceFolder folder : contentEntry.getSourceFolders()) {
                    UnknownSourceRootType type;
                    JpsModuleSourceRootPropertiesSerializer serializer2;
                    if (!(folder.getRootType() instanceof UnknownSourceRootType) || (serializer2 = (JpsModuleSourceRootPropertiesSerializer)serializers.get((type = (UnknownSourceRootType)folder.getRootType()).getUnknownTypeId())) == null) continue;
                    UnknownSourceRootTypeProperties properties = (UnknownSourceRootTypeProperties)folder.getJpsElement().getProperties((JpsModuleSourceRootType)type);
                    Object data2 = properties != null ? properties.getPropertiesData() : null;
                    foldersToUpdate.put(folder, new Pair((Object)serializer2, (Object)(data2 instanceof Element ? (Element)data2 : null)));
                }
            }
            if (foldersToUpdate.isEmpty()) continue;
            ModuleRootModificationUtil.updateModel((Module)module, model2 -> {
                for (ContentEntry contentEntry : model2.getContentEntries()) {
                    for (SourceFolder folder : contentEntry.getSourceFolders()) {
                        Pair pair = (Pair)foldersToUpdate.get(folder);
                        if (pair == null) continue;
                        JpsIdePluginManagerImpl.changeType(folder, (JpsModuleSourceRootPropertiesSerializer)pair.first, (Element)pair.second);
                    }
                }
            });
        }
    }

    @Nullable
    private static <P extends JpsElement> Element serializeProperties(SourceFolder root, @NotNull JpsModuleSourceRootPropertiesSerializer<P> serializer2) {
        JpsElement properties;
        if (serializer2 == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(2);
        }
        if ((properties = root.getJpsElement().getProperties((JpsModuleSourceRootType)serializer2.getType())) != null) {
            Element sourceElement = new Element("sourceFolder");
            serializer2.saveProperties(properties, sourceElement);
            return sourceElement;
        }
        return null;
    }

    private static <P extends JpsElement> void changeType(SourceFolder root, @NotNull JpsModuleSourceRootPropertiesSerializer<P> serializer2, @Nullable Element serializedProps) {
        if (serializer2 == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(3);
        }
        root.changeType((JpsModuleSourceRootType)serializer2.getType(), serializedProps != null ? serializer2.loadProperties(serializedProps) : (JpsElement)((JpsModuleSourceRootType)serializer2.getType()).createDefaultProperties());
    }

    public int getModificationStamp() {
        if (!this.myFullyLoaded && this.myModificationStamp.get() == 0 && ApplicationManager.getApplication() != null) {
            this.myModificationStamp.compareAndSet(0, 1);
        }
        return this.myModificationStamp.get();
    }

    @NotNull
    public <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(4);
        }
        return this.loadExtensions(extensionClass, null);
    }

    @NotNull
    private <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass, @Nullable Predicate<? super PluginDescriptor> filter) {
        if (extensionClass == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(5);
        }
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        for (PluginDescriptor plugin2 : this.myExternalBuildPlugins) {
            if (filter != null && !filter.test((PluginDescriptor)plugin2)) continue;
            ContainerUtil.addIfNotNull(loaders, (Object)plugin2.getPluginClassLoader());
        }
        if (loaders.isEmpty()) {
            loaders.add(((Object)((Object)this)).getClass().getClassLoader());
        }
        return JpsIdePluginManagerImpl.loadExtensionsFrom(loaders, extensionClass);
    }

    @NotNull
    private static <T> Collection<T> loadExtensionsFrom(@NotNull Collection<ClassLoader> loaders, @NotNull Class<T> extensionClass) {
        if (loaders == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(6);
        }
        if (extensionClass == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(7);
        }
        if (loaders.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                JpsIdePluginManagerImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }
        @NonNls String resourceName = "META-INF/services/" + extensionClass.getName();
        LinkedHashSet classes = new LinkedHashSet();
        HashSet<String> loadedUrls = new HashSet<String>();
        for (ClassLoader loader2 : loaders) {
            try {
                Enumeration<URL> resources = loader2.getResources(resourceName);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    if (!loadedUrls.add(url.toExternalForm())) continue;
                    JpsIdePluginManagerImpl.loadImplementations(url, loader2, classes);
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationError("Cannot load configuration files for " + extensionClass.getName(), e);
            }
        }
        ArrayList<T> extensions2 = new ArrayList<T>();
        for (Class aClass : classes) {
            try {
                extensions2.add(extensionClass.cast(aClass.newInstance()));
            }
            catch (Exception e) {
                throw new ServiceConfigurationError("Class " + aClass.getName() + " cannot be instantiated", e);
            }
        }
        ArrayList<T> arrayList = extensions2;
        if (arrayList == null) {
            JpsIdePluginManagerImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static <T> void loadImplementations(URL url, ClassLoader loader2, Set<? super Class<T>> result2) throws IOException {
        for (String name : JpsIdePluginManagerImpl.loadClassNames(url)) {
            try {
                result2.add(Class.forName(name, false, loader2));
            }
            catch (ClassNotFoundException e) {
                throw new ServiceConfigurationError("Cannot find class " + name, e);
            }
        }
    }

    private static List<String> loadClassNames(URL url) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                int i2 = line.indexOf(35);
                if (i2 >= 0) {
                    line = line.substring(0, i2);
                }
                if ((line = line.trim()).isEmpty()) continue;
                result2.add(line);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaders";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jps/impl/JpsIdePluginManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jps/impl/JpsIdePluginManagerImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadExtensionsFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handlePluginRemoved";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handlePluginAdded";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serializeProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changeType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadExtensions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadExtensionsFrom";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

