/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jdkEx;

import com.intellij.jdkEx.DefDisplayModeEx;
import com.intellij.jdkEx.DefInputEventEx;
import com.intellij.jdkEx.DisplayModeEx;
import com.intellij.jdkEx.InputEventEx;
import com.intellij.jdkEx.JBDisplayModeEx;
import com.intellij.jdkEx.JBInputEventEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.MethodInvocator;
import io.netty.util.internal.SystemPropertyUtil;
import java.awt.FileDialog;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@ApiStatus.Experimental
public final class JdkEx {
    private static MethodInvocator mySetTabbingMode;
    private static MethodInvocator ourSetFileDialogLocalizationStringsMethod;
    private static MethodInvocator ourSetFolderPickerModeMethod;
    private static MethodInvocator ourSetFileExclusivePickerModeMethod;

    @NotNull
    public static InputEventEx getInputEventEx() {
        if (SystemInfo.isJetBrainsJvm) {
            return new JBInputEventEx();
        }
        return new DefInputEventEx();
    }

    public static DisplayModeEx getDisplayModeEx() {
        if (SystemInfo.isJetBrainsJvm) {
            return new JBDisplayModeEx();
        }
        return new DefDisplayModeEx();
    }

    public static boolean isCustomDecorationSupported() {
        if (SystemInfo.isJetBrainsJvm && SystemInfo.isWin10OrNewer) {
            return MyCustomDecorMethods.SET_HAS_CUSTOM_DECORATION.isAvailable();
        }
        return false;
    }

    public static void setHasCustomDecoration(@NotNull Window window) {
        if (window == null) {
            JdkEx.$$$reportNull$$$0(0);
        }
        if (!JdkEx.isCustomDecorationSupported()) {
            return;
        }
        MyCustomDecorMethods.SET_HAS_CUSTOM_DECORATION.invoke(window, new Object[0]);
    }

    public static void setCustomDecorationHitTestSpots(@NotNull Window window, @NotNull List<Rectangle> spots) {
        if (window == null) {
            JdkEx.$$$reportNull$$$0(1);
        }
        if (spots == null) {
            JdkEx.$$$reportNull$$$0(2);
        }
        if (!JdkEx.isCustomDecorationSupported()) {
            return;
        }
        MyCustomDecorMethods.SET_CUSTOM_DECORATION_HITTEST_SPOTS.invoke(AWTAccessor.getComponentAccessor().getPeer(window), spots);
    }

    public static void setCustomDecorationTitleBarHeight(@NotNull Window window, int height) {
        if (window == null) {
            JdkEx.$$$reportNull$$$0(3);
        }
        if (!JdkEx.isCustomDecorationSupported()) {
            return;
        }
        MyCustomDecorMethods.SET_CUSTOM_DECORATION_TITLEBAR_HEIGHT.invoke(AWTAccessor.getComponentAccessor().getPeer(window), height);
    }

    public static void setIgnoreMouseEvents(@NotNull Window window, boolean ignoreMouseEvents) {
        if (window == null) {
            JdkEx.$$$reportNull$$$0(4);
        }
        if (SystemInfo.isJetBrainsJvm && (SystemInfo.isMac || SystemInfo.isWindows)) {
            window.setEnabled(false);
            try {
                MethodInvocator invocator = new MethodInvocator(false, Class.forName("java.awt.Window"), "setIgnoreMouseEvents", new Class[]{Boolean.TYPE});
                if (invocator.isAvailable()) {
                    invocator.invoke((Object)window, new Object[]{ignoreMouseEvents});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Nullable
    private static MethodInvocator getTabbingModeInvocator() {
        if (!(SystemInfo.isJetBrainsJvm && SystemInfo.isMacOSBigSur && Registry.is((String)"ide.mac.bigsur.window.with.tabs.enabled", (boolean)true))) {
            return null;
        }
        if (mySetTabbingMode == null) {
            try {
                mySetTabbingMode = new MethodInvocator(false, Class.forName("java.awt.Window"), "setTabbingMode", new Class[0]);
                if (mySetTabbingMode.isAvailable()) {
                    return mySetTabbingMode;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }
        return mySetTabbingMode.isAvailable() ? mySetTabbingMode : null;
    }

    public static boolean isTabbingModeAvailable() {
        return JdkEx.getTabbingModeInvocator() != null;
    }

    public static boolean setTabbingMode(@NotNull Window window, @Nullable Runnable moveTabToNewWindowCallback) {
        MethodInvocator invocator;
        if (window == null) {
            JdkEx.$$$reportNull$$$0(5);
        }
        if ((invocator = JdkEx.getTabbingModeInvocator()) != null) {
            invocator.invoke((Object)window, new Object[0]);
            if (moveTabToNewWindowCallback != null) {
                try {
                    new MethodInvocator(false, Class.forName("java.awt.Window"), "setMoveTabToNewWindowCallback", new Class[]{Runnable.class}).invoke((Object)window, new Object[]{moveTabToNewWindowCallback});
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static MethodInvocator getFileDialogLocalizationStringsMethod() {
        if (!(SystemInfo.isJetBrainsJvm && SystemInfo.isWindows && Registry.is((String)"ide.win.file.chooser.native", (boolean)false) && SystemPropertyUtil.getBoolean((String)"sun.awt.windows.useCommonItemDialog", (boolean)false))) {
            return null;
        }
        if (ourSetFileDialogLocalizationStringsMethod == null) {
            ourSetFileDialogLocalizationStringsMethod = new MethodInvocator(false, FileDialog.class, "setLocalizationStrings", new Class[]{String.class, String.class});
            if (ourSetFileDialogLocalizationStringsMethod.isAvailable()) {
                return ourSetFileDialogLocalizationStringsMethod;
            }
            return null;
        }
        return ourSetFileDialogLocalizationStringsMethod.isAvailable() ? ourSetFileDialogLocalizationStringsMethod : null;
    }

    public static boolean trySetCommonFileDialogLocalization(@NotNull FileDialog fileDialog, @Nullable @Nls String openButtonText, @Nullable @Nls String selectFolderButtonText) {
        MethodInvocator setLocalizationStrings;
        if (fileDialog == null) {
            JdkEx.$$$reportNull$$$0(6);
        }
        if ((setLocalizationStrings = JdkEx.getFileDialogLocalizationStringsMethod()) == null) {
            return false;
        }
        try {
            setLocalizationStrings.invoke((Object)fileDialog, new Object[]{openButtonText, selectFolderButtonText});
            return true;
        }
        catch (Throwable t) {
            Logger.getInstance(JdkEx.class).error(t);
            return false;
        }
    }

    @Nullable
    private static MethodInvocator getSetFolderPickerModeMethod() {
        if (!(SystemInfo.isJetBrainsJvm && SystemInfo.isWindows && Registry.is((String)"ide.win.file.chooser.native", (boolean)false) && SystemPropertyUtil.getBoolean((String)"sun.awt.windows.useCommonItemDialog", (boolean)false))) {
            return null;
        }
        if (ourSetFolderPickerModeMethod == null) {
            ourSetFolderPickerModeMethod = new MethodInvocator(false, FileDialog.class, "setFolderPickerMode", new Class[]{Boolean.TYPE});
            if (ourSetFolderPickerModeMethod.isAvailable()) {
                return ourSetFolderPickerModeMethod;
            }
            return null;
        }
        return ourSetFolderPickerModeMethod.isAvailable() ? ourSetFolderPickerModeMethod : null;
    }

    public static boolean trySetFolderPickerMode(@NotNull FileDialog fileDialog, boolean folderPickerMode) {
        MethodInvocator setFolderPickerMode;
        if (fileDialog == null) {
            JdkEx.$$$reportNull$$$0(7);
        }
        if ((setFolderPickerMode = JdkEx.getSetFolderPickerModeMethod()) == null) {
            return false;
        }
        try {
            setFolderPickerMode.invoke((Object)fileDialog, new Object[]{folderPickerMode});
            return true;
        }
        catch (Throwable t) {
            Logger.getInstance(JdkEx.class).error(t);
            return false;
        }
    }

    @Nullable
    private static MethodInvocator getSetFileExclusivePickerModeMethod() {
        if (!(SystemInfo.isJetBrainsJvm && SystemInfo.isWindows && Registry.is((String)"ide.win.file.chooser.native", (boolean)false) && SystemPropertyUtil.getBoolean((String)"sun.awt.windows.useCommonItemDialog", (boolean)false))) {
            return null;
        }
        if (ourSetFileExclusivePickerModeMethod == null) {
            ourSetFileExclusivePickerModeMethod = new MethodInvocator(false, FileDialog.class, "setFileExclusivePickerMode", new Class[]{Boolean.TYPE});
            if (ourSetFileExclusivePickerModeMethod.isAvailable()) {
                return ourSetFileExclusivePickerModeMethod;
            }
            return null;
        }
        return ourSetFileExclusivePickerModeMethod.isAvailable() ? ourSetFileExclusivePickerModeMethod : null;
    }

    public static boolean trySetFileExclusivePickerMode(@NotNull FileDialog fileDialog, boolean fileExclusivePickerMode) {
        MethodInvocator setFileExclusivePickerMode;
        if (fileDialog == null) {
            JdkEx.$$$reportNull$$$0(8);
        }
        if ((setFileExclusivePickerMode = JdkEx.getSetFileExclusivePickerModeMethod()) == null) {
            return false;
        }
        try {
            setFileExclusivePickerMode.invoke((Object)fileDialog, new Object[]{fileExclusivePickerMode});
            return true;
        }
        catch (Throwable t) {
            Logger.getInstance(JdkEx.class).error(t);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spots";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDialog";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jdkEx/JdkEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setHasCustomDecoration";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setCustomDecorationHitTestSpots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setCustomDecorationTitleBarHeight";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setIgnoreMouseEvents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setTabbingMode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "trySetCommonFileDialogLocalization";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "trySetFolderPickerMode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "trySetFileExclusivePickerMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyMethod {
        private static final MyMethod EMPTY_INSTANCE = new MyMethod(null);
        @Nullable
        MethodInvocator myInvocator;

        public static MyMethod create(@NotNull String className, @NotNull String methodName, Class<?> ... parameterTypes) {
            if (className == null) {
                MyMethod.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                MyMethod.$$$reportNull$$$0(1);
            }
            try {
                return MyMethod.create(Class.forName(className), methodName, parameterTypes);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return EMPTY_INSTANCE;
            }
        }

        public static MyMethod create(@NotNull Class<?> cls, @NotNull String methodName, Class<?> ... parameterTypes) {
            if (cls == null) {
                MyMethod.$$$reportNull$$$0(2);
            }
            if (methodName == null) {
                MyMethod.$$$reportNull$$$0(3);
            }
            return new MyMethod(new MethodInvocator(false, cls, methodName, (Class[])parameterTypes));
        }

        private MyMethod(@Nullable MethodInvocator invocator) {
            this.myInvocator = invocator;
        }

        public boolean isAvailable() {
            return this.myInvocator != null && this.myInvocator.isAvailable();
        }

        @Nullable
        public Object invoke(Object object, Object ... arguments) {
            if (this.isAvailable()) {
                return this.myInvocator.invoke(object, arguments);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cls";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jdkEx/JdkEx$MyMethod";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyCustomDecorMethods {
        public static final MyMethod SET_HAS_CUSTOM_DECORATION = MyMethod.create(Window.class, "setHasCustomDecoration", new Class[0]);
        public static final MyMethod SET_CUSTOM_DECORATION_HITTEST_SPOTS = MyMethod.create("sun.awt.windows.WWindowPeer", "setCustomDecorationHitTestSpots", List.class);
        public static final MyMethod SET_CUSTOM_DECORATION_TITLEBAR_HEIGHT = MyMethod.create("sun.awt.windows.WWindowPeer", "setCustomDecorationTitleBarHeight", Integer.TYPE);

        private MyCustomDecorMethods() {
        }
    }
}

