/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.plugins;

import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.ProjectPluginTracker;
import com.intellij.ide.plugins.ProjectPluginTrackerManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class PluginsUsagesCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("plugins", 4);
    private static final EventId1<PluginInfo> DISABLED_PLUGIN = GROUP.registerEvent("disabled.plugin", (EventField)EventFields.PluginInfo);
    private static final EventId1<PluginInfo> ENABLED_NOT_BUNDLED_PLUGIN = GROUP.registerEvent("enabled.not.bundled.plugin", (EventField)EventFields.PluginInfo);
    private static final EventId1<Integer> PER_PROJECT_ENABLED = GROUP.registerEvent("per.project.enabled", (EventField)EventFields.Count);
    private static final EventId1<Integer> PER_PROJECT_DISABLED = GROUP.registerEvent("per.project.disabled", (EventField)EventFields.Count);

    PluginsUsagesCollector() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        result2.addAll(PluginsUsagesCollector.getDisabledPlugins());
        result2.addAll(PluginsUsagesCollector.getEnabledNonBundledPlugins());
        result2.addAll(PluginsUsagesCollector.getPerProjectPlugins(PER_PROJECT_ENABLED, ProjectPluginTracker::getEnabledPluginsIds));
        result2.addAll(PluginsUsagesCollector.getPerProjectPlugins(PER_PROJECT_DISABLED, ProjectPluginTracker::getDisabledPluginsIds));
        HashSet<MetricEvent> hashSet = result2;
        if (hashSet == null) {
            PluginsUsagesCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    private static Set<MetricEvent> getDisabledPlugins() {
        Set<MetricEvent> set2 = DisabledPluginsState.disabledPlugins().stream().map(PluginInfoDetectorKt::getPluginInfoById).map(arg_0 -> DISABLED_PLUGIN.metric(arg_0)).collect(Collectors.toUnmodifiableSet());
        if (set2 == null) {
            PluginsUsagesCollector.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @NotNull
    private static Set<MetricEvent> getEnabledNonBundledPlugins() {
        Set<MetricEvent> set2 = PluginManagerCore.getLoadedPlugins().stream().filter(PluginDescriptor::isEnabled).filter(descriptor2 -> !descriptor2.isBundled()).map(PluginInfoDetectorKt::getPluginInfoByDescriptor).map(arg_0 -> ENABLED_NOT_BUNDLED_PLUGIN.metric(arg_0)).collect(Collectors.toUnmodifiableSet());
        if (set2 == null) {
            PluginsUsagesCollector.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @NotNull
    private static Set<MetricEvent> getPerProjectPlugins(@NotNull EventId1<Integer> eventId, @NotNull @NotNull Function<@NotNull ProjectPluginTracker, @NotNull Set<PluginId>> countProducer) {
        if (eventId == null) {
            PluginsUsagesCollector.$$$reportNull$$$0(3);
        }
        if (countProducer == null) {
            PluginsUsagesCollector.$$$reportNull$$$0(4);
        }
        Set<MetricEvent> set3 = ProjectPluginTrackerManager.getInstance().getTrackers().values().stream().map(countProducer).filter(set2 -> !set2.isEmpty()).mapToInt(Set::size).mapToObj(arg_0 -> eventId.metric(arg_0)).collect(Collectors.toUnmodifiableSet());
        if (set3 == null) {
            PluginsUsagesCollector.$$$reportNull$$$0(5);
        }
        return set3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/plugins/PluginsUsagesCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "countProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledPlugins";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledNonBundledPlugins";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/plugins/PluginsUsagesCollector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerProjectPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPerProjectPlugins";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

