/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JpsElementPropertiesSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;

final class ProjectStructureUsageCollector
extends ProjectUsagesCollector {
    private final EventLogGroup GROUP = new EventLogGroup("project.structure", 5);
    private final EventId1<Integer> MODULES_TOTAL = this.GROUP.registerEvent("modules.total", (EventField)EventFields.Count);
    private final EventId1<Integer> CONTENT_ROOTS_TOTAL = this.GROUP.registerEvent("content.roots.total", (EventField)EventFields.Count);
    private final EventId1<Integer> SOURCE_ROOTS_TOTAL = this.GROUP.registerEvent("source.roots.total", (EventField)EventFields.Count);
    private final EventId1<Integer> EXCLUDED_ROOTS_TOTAL = this.GROUP.registerEvent("excluded.roots.total", (EventField)EventFields.Count);
    private final EventId2<Integer, String> SOURCE_ROOT = this.GROUP.registerEvent("source.root", (EventField)EventFields.Count, (EventField)EventFields.String((String)"type", Arrays.asList("cookbooks-root", "java-resource", "java-source", "java-test-resource", "java-test", "kotlin-resource", "kotlin-source", "kotlin-test-resource", "kotlin-test")));
    private final EventId1<Integer> PACKAGE_PREFIX = this.GROUP.registerEvent("package.prefix", (EventField)EventFields.Count);
    private final EventId1<Integer> NAMED_SCOPES_TOTAL_LOCAL = this.GROUP.registerEvent("named.scopes.total.local", (EventField)EventFields.Count);
    private final EventId1<Integer> NAMED_SCOPES_TOTAL_SHARED = this.GROUP.registerEvent("named.scopes.total.shared", (EventField)EventFields.Count);
    private final EventId PROJECT_IN_WSL = this.GROUP.registerEvent("project.in.wsl");

    ProjectStructureUsageCollector() {
    }

    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        Module[] modules2;
        if (project == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(0);
        }
        Map typeNames = JBIterable.from((Iterable)JpsModelSerializerExtension.getExtensions()).filter(o -> PluginInfoDetectorKt.getPluginInfo(o.getClass()).isDevelopedByJetBrains()).flatMap(JpsModelSerializerExtension::getModuleSourceRootPropertiesSerializers).toMap(JpsElementPropertiesSerializer::getType, JpsElementPropertiesSerializer::getTypeId);
        int contentRoots = 0;
        int sourceRoots2 = 0;
        int excludedRoots = 0;
        int packagePrefix = 0;
        Object2IntOpenHashMap types = new Object2IntOpenHashMap();
        for (Module module : modules2 = ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            contentRoots += rootManager.getContentEntries().length;
            sourceRoots2 += rootManager.getSourceRoots(true).length;
            excludedRoots += rootManager.getExcludeRoots().length;
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder source : entry.getSourceFolders()) {
                    String key;
                    if (StringUtil.isNotEmpty((String)source.getPackagePrefix())) {
                        ++packagePrefix;
                    }
                    if ((key = (String)typeNames.get(source.getRootType())) == null) continue;
                    types.mergeInt((Object)key, 1, Math::addExact);
                }
            }
        }
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        result2.add(this.MODULES_TOTAL.metric((Object)modules2.length));
        result2.add(this.CONTENT_ROOTS_TOTAL.metric((Object)contentRoots));
        result2.add(this.SOURCE_ROOTS_TOTAL.metric((Object)sourceRoots2));
        result2.add(this.EXCLUDED_ROOTS_TOTAL.metric((Object)excludedRoots));
        for (Object2IntMap.Entry entry : types.object2IntEntrySet()) {
            result2.add(this.SOURCE_ROOT.metric((Object)entry.getIntValue(), (Object)((String)entry.getKey())));
        }
        if (PlatformUtils.isIntelliJ()) {
            result2.add(this.PACKAGE_PREFIX.metric((Object)packagePrefix));
        }
        NamedScope[] localScopes = NamedScopeManager.getInstance((Project)project).getEditableScopes();
        result2.add(this.NAMED_SCOPES_TOTAL_LOCAL.metric((Object)localScopes.length));
        NamedScope[] sharedScopes = DependencyValidationManager.getInstance((Project)project).getEditableScopes();
        result2.add(this.NAMED_SCOPES_TOTAL_SHARED.metric((Object)sharedScopes.length));
        String basePath = project.getBasePath();
        if (basePath != null && FileUtil.toSystemDependentName((String)basePath).startsWith("\\\\wsl$\\")) {
            result2.add(this.PROJECT_IN_WSL.metric());
        }
        HashSet<MetricEvent> hashSet = result2;
        if (hashSet == null) {
            ProjectStructureUsageCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/ProjectStructureUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/ProjectStructureUsageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

