/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.ide.actions.ToolWindowMoveAction;
import com.intellij.ide.actions.ToolWindowViewModeAction;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ToolWindowEventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAllowlistEP;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowCollector {
    private static final ExtensionPointName<ToolWindowAllowlistEP> EP_NAME = new ExtensionPointName("com.intellij.toolWindowAllowlist");
    private static final ToolWindowInfo UNKNOWN = new ToolWindowInfo("unknown", PluginInfoDetectorKt.getUnknownPlugin());
    private static final Map<String, ToolWindowInfo> ourToolwindowWhitelist = new HashMap<String, ToolWindowInfo>();

    public static ToolWindowCollector getInstance() {
        return Holder.INSTANCE;
    }

    private ToolWindowCollector() {
        EP_NAME.processWithPluginDescriptor(ToolWindowCollector::addToolwindowToWhitelist);
        EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ToolWindowAllowlistEP>(){

            public void extensionAdded(@NotNull ToolWindowAllowlistEP extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ToolWindowCollector.addToolwindowToWhitelist(extension2, pluginDescriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private static void addToolwindowToWhitelist(@NotNull ToolWindowAllowlistEP extension2, @NotNull PluginDescriptor pluginDescriptor) {
        PluginInfo info;
        if (extension2 == null) {
            ToolWindowCollector.$$$reportNull$$$0(0);
        }
        if (pluginDescriptor == null) {
            ToolWindowCollector.$$$reportNull$$$0(1);
        }
        if ((info = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor)).isDevelopedByJetBrains()) {
            ourToolwindowWhitelist.put(extension2.id, new ToolWindowInfo(extension2.id, info));
        }
    }

    public void recordActivation(@NotNull Project project, @Nullable String toolWindowId, @Nullable WindowInfoImpl info, @Nullable ToolWindowEventSource source) {
        if (project == null) {
            ToolWindowCollector.$$$reportNull$$$0(2);
        }
        ToolWindowCollector.record(project, toolWindowId, ToolWindowEventLogGroup.ACTIVATED, info, source);
    }

    public void recordHidden(@NotNull Project project, @NotNull WindowInfoImpl info, @Nullable ToolWindowEventSource source) {
        if (project == null) {
            ToolWindowCollector.$$$reportNull$$$0(3);
        }
        if (info == null) {
            ToolWindowCollector.$$$reportNull$$$0(4);
        }
        ToolWindowCollector.record(project, info.getId(), ToolWindowEventLogGroup.HIDDEN, info, source);
    }

    public void recordShown(@NotNull Project project, @Nullable ToolWindowEventSource source, @NotNull WindowInfoImpl info) {
        if (project == null) {
            ToolWindowCollector.$$$reportNull$$$0(5);
        }
        if (info == null) {
            ToolWindowCollector.$$$reportNull$$$0(6);
        }
        ToolWindowCollector.record(project, info.getId(), ToolWindowEventLogGroup.SHOWN, info, source);
    }

    public void recordClick(String toolWindowId, @Nullable WindowInfoImpl info) {
    }

    private static void record(@NotNull Project project, @Nullable String toolWindowId, @NotNull VarargEventId event, @Nullable WindowInfoImpl windowInfo, @Nullable ToolWindowEventSource source) {
        if (project == null) {
            ToolWindowCollector.$$$reportNull$$$0(7);
        }
        if (event == null) {
            ToolWindowCollector.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)toolWindowId)) {
            return;
        }
        ToolWindowInfo info = ToolWindowCollector.getToolWindowInfo(toolWindowId);
        ArrayList<EventPair> data2 = new ArrayList<EventPair>();
        data2.add(ToolWindowEventLogGroup.TOOLWINDOW_ID.with((Object)info.myRecordedId));
        data2.add(EventFields.PluginInfo.with((Object)info.myPluginInfo));
        if (windowInfo != null) {
            data2.add(ToolWindowEventLogGroup.VIEW_MODE.with((Object)ToolWindowViewModeAction.ViewMode.fromWindowInfo(windowInfo)));
            data2.add(ToolWindowEventLogGroup.LOCATION.with((Object)ToolWindowMoveAction.Anchor.fromWindowInfo(windowInfo)));
        }
        if (source != null) {
            data2.add(ToolWindowEventLogGroup.SOURCE.with((Object)source));
        }
        event.log(data2.toArray(new EventPair[0]));
    }

    @NotNull
    private static ToolWindowInfo getToolWindowInfo(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(9);
        }
        if (ourToolwindowWhitelist.containsKey(toolWindowId)) {
            ToolWindowInfo toolWindowInfo = ourToolwindowWhitelist.get(toolWindowId);
            if (toolWindowInfo == null) {
                ToolWindowCollector.$$$reportNull$$$0(10);
            }
            return toolWindowInfo;
        }
        ToolWindowInfo info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])ToolWindowEP.EP_NAME.getExtensions());
        if (info == null) {
            info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        if (info == null) {
            info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        ToolWindowInfo toolWindowInfo = info != null ? info : UNKNOWN;
        if (toolWindowInfo == null) {
            ToolWindowCollector.$$$reportNull$$$0(11);
        }
        return toolWindowInfo;
    }

    @Nullable
    public static ToolWindowInfo getToolWindowInfo(@NotNull String toolWindowId, ToolWindowEP @NotNull [] toolWindows2) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(12);
        }
        if (toolWindows2 == null) {
            ToolWindowCollector.$$$reportNull$$$0(13);
        }
        for (ToolWindowEP ep2 : toolWindows2) {
            if (!StringUtil.equals((CharSequence)toolWindowId, (CharSequence)ep2.id)) continue;
            PluginDescriptor pluginDescriptor = ep2.getPluginDescriptor();
            return new ToolWindowInfo(ep2.id, PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor));
        }
        return null;
    }

    static {
        ourToolwindowWhitelist.put("Messages", new ToolWindowInfo("Messages"));
        ourToolwindowWhitelist.put("Debug", new ToolWindowInfo("Debug"));
        ourToolwindowWhitelist.put("Run", new ToolWindowInfo("Run"));
        ourToolwindowWhitelist.put("Build", new ToolWindowInfo("Build"));
        ourToolwindowWhitelist.put("Find", new ToolWindowInfo("Find"));
        ourToolwindowWhitelist.put("CVS", new ToolWindowInfo("CVS"));
        ourToolwindowWhitelist.put("Hierarchy", new ToolWindowInfo("Hierarchy"));
        ourToolwindowWhitelist.put("Dependency Viewer", new ToolWindowInfo("Dependency_Viewer"));
        ourToolwindowWhitelist.put("Module Dependencies", new ToolWindowInfo("Module_Dependencies"));
        ourToolwindowWhitelist.put("Duplicates", new ToolWindowInfo("Duplicates"));
        ourToolwindowWhitelist.put("Extract Method", new ToolWindowInfo("Extract_Method"));
        ourToolwindowWhitelist.put("Documentation", new ToolWindowInfo("Documentation"));
        ourToolwindowWhitelist.put("Preview", new ToolWindowInfo("Preview"));
        ourToolwindowWhitelist.put("Run Dashboard", new ToolWindowInfo("Run_Dashboard"));
        ourToolwindowWhitelist.put("Services", new ToolWindowInfo("Services"));
        ourToolwindowWhitelist.put("Endpoints", new ToolWindowInfo("Endpoints"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addToolwindowToWhitelist";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recordActivation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recordHidden";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "recordShown";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowInfo";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ToolWindowInfo {
        private final String myRecordedId;
        private final PluginInfo myPluginInfo;

        private ToolWindowInfo(@NotNull String recordedId) {
            if (recordedId == null) {
                ToolWindowInfo.$$$reportNull$$$0(0);
            }
            this(recordedId, PluginInfoDetectorKt.getPlatformPlugin());
        }

        private ToolWindowInfo(@NotNull String recordedId, @NotNull PluginInfo info) {
            if (recordedId == null) {
                ToolWindowInfo.$$$reportNull$$$0(1);
            }
            if (info == null) {
                ToolWindowInfo.$$$reportNull$$$0(2);
            }
            this.myRecordedId = recordedId;
            this.myPluginInfo = info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "recordedId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToolWindowUtilValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "toolwindow".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(1);
            }
            if ("unknown".equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    ToolWindowUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            if (ToolWindowUtilValidator.hasPluginField((EventContext)context)) {
                ValidationResultType validationResultType = ToolWindowUtilValidator.acceptWhenReportedByJetBrainsPlugin((EventContext)context);
                if (validationResultType == null) {
                    ToolWindowUtilValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ToolWindowInfo info = ToolWindowCollector.getToolWindowInfo(data2);
            ValidationResultType validationResultType = info.myPluginInfo.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                ToolWindowUtilValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$ToolWindowUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Holder {
        private static final ToolWindowCollector INSTANCE = new ToolWindowCollector();

        private Holder() {
        }
    }
}

