/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsBuiltInWhitelist;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FusInputEvent;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionsCollectorImpl
extends ActionsCollector {
    public static final String DEFAULT_ID = "third.party";
    private static final ActionsBuiltInWhitelist ourWhitelist = ActionsBuiltInWhitelist.getInstance();

    public void record(@Nullable String actionId, @Nullable InputEvent event, @NotNull Class context) {
        if (context == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(0);
        }
        ActionsCollectorImpl.recordCustomActionInvoked(null, actionId, event, context);
    }

    public static void recordCustomActionInvoked(@Nullable Project project, @Nullable String actionId, @Nullable InputEvent event, @NotNull Class context) {
        if (context == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(1);
        }
        String recorded = StringUtil.isNotEmpty((String)actionId) && ourWhitelist.isCustomAllowedAction(actionId) ? actionId : DEFAULT_ID;
        ActionsEventLogGroup.CUSTOM_ACTION_INVOKED.log(project, (Object)recorded, (Object)new FusInputEvent(event, null));
    }

    public void record(@Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable Language lang) {
        ActionsCollectorImpl.recordActionInvoked(project, action2, event, Collections.singletonList(EventFields.CurrentFile.with((Object)lang)));
    }

    public static void recordActionInvoked(@Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @NotNull List<EventPair<?>> customData) {
        if (customData == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(2);
        }
        ActionsCollectorImpl.record(ActionsEventLogGroup.ACTION_INVOKED, project, action2, event, customData);
    }

    public static void record(VarargEventId eventId, @Nullable Project project, @Nullable AnAction action2, @Nullable AnActionEvent event, @Nullable List<EventPair<?>> customData) {
        if (action2 == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action2.getClass());
        ArrayList data2 = new ArrayList();
        data2.add(EventFields.PluginInfoFromInstance.with((Object)action2));
        if (event != null) {
            if (action2 instanceof ToggleAction) {
                data2.add(ActionsEventLogGroup.TOGGLE_ACTION.with((Object)(!((ToggleAction)action2).isSelected(event) ? 1 : 0)));
            }
            data2.addAll(ActionsCollectorImpl.actionEventData(event));
        }
        if (project != null) {
            data2.add(ActionsEventLogGroup.DUMB.with((Object)DumbService.isDumb((Project)project)));
        }
        if (customData != null) {
            data2.addAll(customData);
        }
        ActionsCollectorImpl.addActionClass(data2, action2, info);
        eventId.log(project, data2);
    }

    @NotNull
    public static @NotNull List<@NotNull EventPair<?>> actionEventData(@NotNull AnActionEvent event) {
        if (event == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(3);
        }
        ArrayList data2 = new ArrayList();
        data2.add(EventFields.InputEvent.with((Object)FusInputEvent.from((AnActionEvent)event)));
        data2.add(EventFields.ActionPlace.with((Object)event.getPlace()));
        data2.add(ActionsEventLogGroup.CONTEXT_MENU.with((Object)event.isFromContextMenu()));
        ArrayList arrayList = data2;
        if (arrayList == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static String addActionClass(@NotNull List<EventPair<?>> data2, @NotNull AnAction action2, @NotNull PluginInfo info) {
        if (data2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(5);
        }
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(6);
        }
        if (info == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(7);
        }
        String actionClassName = info.isSafeToReport() ? action2.getClass().getName() : DEFAULT_ID;
        String actionId = ActionsCollectorImpl.getActionId(info, action2);
        if (action2 instanceof ActionWithDelegate) {
            Object delegate2 = ((ActionWithDelegate)action2).getDelegate();
            PluginInfo delegateInfo = PluginInfoDetectorKt.getPluginInfo(delegate2.getClass());
            if (delegate2 instanceof AnAction) {
                AnAction delegateAction = (AnAction)delegate2;
                actionId = ActionsCollectorImpl.getActionId(delegateInfo, delegateAction);
            } else {
                actionId = delegateInfo.isSafeToReport() ? delegate2.getClass().getName() : DEFAULT_ID;
            }
            data2.add(ActionsEventLogGroup.ACTION_CLASS.with((Object)actionId));
            data2.add(ActionsEventLogGroup.ACTION_PARENT.with((Object)actionClassName));
        } else {
            data2.add(ActionsEventLogGroup.ACTION_CLASS.with((Object)actionClassName));
        }
        data2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
        String string = actionId;
        if (string == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void addActionClass(@NotNull FeatureUsageData data2, @NotNull AnAction action2, @NotNull PluginInfo info) {
        if (data2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(9);
        }
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(10);
        }
        if (info == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(11);
        }
        ArrayList list2 = new ArrayList();
        ActionsCollectorImpl.addActionClass(list2, action2, info);
        for (EventPair eventPair : list2) {
            data2.addData(eventPair.component1().getName(), eventPair.component2().toString());
        }
    }

    @NotNull
    private static String getActionId(@NotNull PluginInfo pluginInfo, @NotNull AnAction action2) {
        if (pluginInfo == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(12);
        }
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(13);
        }
        if (!pluginInfo.isSafeToReport()) {
            return DEFAULT_ID;
        }
        String actionId = ActionManager.getInstance().getId(action2);
        if (actionId == null && action2 instanceof ActionIdProvider) {
            actionId = ((ActionIdProvider)action2).getId();
        }
        if (actionId != null && !ActionsCollectorImpl.canReportActionId(actionId)) {
            String string = action2.getClass().getName();
            if (string == null) {
                ActionsCollectorImpl.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (actionId == null) {
            actionId = ourWhitelist.getDynamicActionId(action2);
        }
        String string = actionId != null ? actionId : action2.getClass().getName();
        if (string == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static boolean canReportActionId(@NotNull String actionId) {
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(16);
        }
        return ourWhitelist.isWhitelistedActionId(actionId);
    }

    public void onActionConfiguredByActionId(@NotNull AnAction action2, @NotNull String actionId) {
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(17);
        }
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(18);
        }
        ourWhitelist.registerDynamicActionId(action2, actionId);
    }

    public static void onActionLoadedFromXml(@NotNull AnAction action2, @NotNull String actionId, @Nullable IdeaPluginDescriptor plugin2) {
        if (action2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(19);
        }
        if (actionId == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(20);
        }
        ourWhitelist.addActionLoadedFromXml(actionId, plugin2);
    }

    public static void onActionsLoadedFromKeymapXml(@NotNull Keymap keymap2, @NotNull Set<String> actionIds) {
        if (keymap2 == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(21);
        }
        if (actionIds == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(22);
        }
        ourWhitelist.addActionsLoadedFromKeymapXml(keymap2, actionIds);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ActionsCollectorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "actionEventData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addActionClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recordCustomActionInvoked";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recordActionInvoked";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionEventData";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addActionClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getActionId";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canReportActionId";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onActionConfiguredByActionId";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onActionLoadedFromXml";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "onActionsLoadedFromKeymapXml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

