/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.ngram;

import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import com.intellij.completion.ngram.slp.translating.Vocabulary;
import com.intellij.internal.ml.ngram.NGramRecentTokens;
import com.intellij.internal.ml.ngram.NGramRecentTokensSequence;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010!J\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0018\u0010#\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0002J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010$\u001a\u00020%J$\u0010'\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001b0)j\b\u0012\u0004\u0012\u00020\u001b`*\u0012\u0004\u0012\u00020\u00040(H\u0002J\u0016\u0010+\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00060"}, d2={"Lcom/intellij/internal/ml/ngram/VocabularyWithLimit;", "Lcom/intellij/completion/ngram/slp/translating/Vocabulary;", "Ljava/io/Externalizable;", "maxVocabularySize", "", "nGramOrder", "maxSequenceSize", "sequenceInitialSize", "(IIII)V", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getMaxVocabularySize", "()I", "setMaxVocabularySize", "(I)V", "recent", "Lcom/intellij/internal/ml/ngram/NGramRecentTokens;", "getRecent", "()Lcom/intellij/internal/ml/ngram/NGramRecentTokens;", "recentSequence", "Lcom/intellij/internal/ml/ngram/NGramRecentTokensSequence;", "getRecentSequence", "()Lcom/intellij/internal/ml/ngram/NGramRecentTokensSequence;", "assertUpdateIsIncremental", "", "tokens", "", "", "readExternal", "ins", "Ljava/io/ObjectInput;", "toExistingIndex", "token", "(Ljava/lang/String;)Ljava/lang/Integer;", "toExistingIndices", "toIndexWithLimit", "model", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel;", "toIndicesWithLimit", "trimRecentTokensSize", "Lkotlin/Pair;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "updateRecentTokens", "writeExternal", "out", "Ljava/io/ObjectOutput;", "Companion", "intellij.platform.ml.impl"})
public final class VocabularyWithLimit
extends Vocabulary
implements Externalizable {
    private final AtomicInteger counter;
    @NotNull
    private final NGramRecentTokens recent;
    @NotNull
    private final NGramRecentTokensSequence recentSequence;
    private int maxVocabularySize;
    @NotNull
    private static final Logger LOG;
    private static final int SEQUENCE_INITIAL_SIZE = 100;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final NGramRecentTokens getRecent() {
        return this.recent;
    }

    @NotNull
    public final NGramRecentTokensSequence getRecentSequence() {
        return this.recentSequence;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> toExistingIndices(@NotNull List<String> token2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(token2, (String)"token");
        Iterable $this$mapNotNull$iv = token2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer n;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.toExistingIndex(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Integer it$iv$iv = n;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Integer toExistingIndex(String token2) {
        Integer n = (Integer)this.getWordIndices().get(token2);
        if (n == null) {
            n = (Integer)this.getWordIndices().get("<unknownCharacter>");
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> toIndicesWithLimit(@NotNull List<String> token2, @NotNull NGramModel model2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(token2, (String)"token");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Iterable $this$map$iv = token2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = this.toIndexWithLimit((String)it, model2);
            collection.add(n);
        }
        List indices = (List)destination$iv$iv;
        this.recentSequence.addWithLimit$intellij_platform_ml_impl(model2, ((Number)CollectionsKt.last((List)indices)).intValue());
        this.updateRecentTokens(token2);
        return indices;
    }

    /*
     * WARNING - void declaration
     */
    private final int toIndexWithLimit(String token2, NGramModel model2) {
        Integer index2 = (Integer)this.getWordIndices().get(token2);
        if (index2 == null) {
            index2 = this.counter.getAndIncrement();
            this.getWordIndices().put(token2, index2);
            if (this.recent.size() >= this.maxVocabularySize) {
                void toRemove2;
                Pair<ArrayList<String>, Integer> pair = this.trimRecentTokensSize();
                ArrayList arrayList = (ArrayList)pair.component1();
                int latestAppearance = ((Number)pair.component2()).intValue();
                this.recentSequence.forgetUntil$intellij_platform_ml_impl(model2, this.recent.size() > 0 ? this.recent.lastIndex() - latestAppearance : 0);
                for (String tokenToRemove : toRemove2) {
                    this.getWordIndices().remove(tokenToRemove);
                }
            }
        }
        return index2;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ArrayList<String>, Integer> trimRecentTokensSize() {
        boolean bl = false;
        ArrayList<void> toRemove2 = new ArrayList<void>();
        int latestAppearance = 0;
        while (this.recent.size() >= this.maxVocabularySize) {
            void token2;
            Pair<String, Integer> pair = this.recent.removeEldest();
            String string = (String)pair.component1();
            int idx = ((Number)pair.component2()).intValue();
            boolean bl2 = false;
            latestAppearance = Math.max(latestAppearance, idx);
            toRemove2.add(token2);
        }
        return TuplesKt.to(toRemove2, (Object)latestAppearance);
    }

    private final void updateRecentTokens(List<String> tokens) {
        if (LOG.isDebugEnabled()) {
            this.assertUpdateIsIncremental(tokens);
        }
        Collection collection = tokens;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.recent.update((String)CollectionsKt.last(tokens));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertUpdateIsIncremental(List<String> tokens) {
        int n = 0;
        int n2 = tokens.size() - 2;
        if (n <= n2) {
            while (true) {
                void i2;
                boolean bl = this.recent.contains(tokens.get((int)i2));
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Cannot find previous token in recent: " + tokens.get((int)i2) + " in " + tokens;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeExternal(@NotNull ObjectOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.maxVocabularySize);
        out.writeInt(this.counter.get());
        this.recent.writeExternal(out);
        this.recentSequence.writeExternal(out);
        out.writeInt(this.getWordIndices().size());
        Object object = this.getWordIndices();
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void token2;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            int code = ((Number)entry2.getValue()).intValue();
            out.writeObject(token2);
            out.writeInt(code);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readExternal(@NotNull ObjectInput ins) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ins, (String)"ins");
        this.maxVocabularySize = ins.readInt();
        this.counter.set(ins.readInt());
        this.recent.readExternal(ins);
        this.recentSequence.readExternal(ins);
        int wordsSize = ins.readInt();
        int n = 0;
        int n2 = wordsSize;
        while (n < n2) {
            void i2;
            Object object = ins.readObject();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String token2 = (String)object;
            int code = ins.readInt();
            this.getWordIndices().put(token2, code);
            ++i2;
        }
    }

    public final int getMaxVocabularySize() {
        return this.maxVocabularySize;
    }

    public final void setMaxVocabularySize(int n) {
        this.maxVocabularySize = n;
    }

    public VocabularyWithLimit(int maxVocabularySize, int nGramOrder, int maxSequenceSize, int sequenceInitialSize) {
        this.maxVocabularySize = maxVocabularySize;
        this.counter = new AtomicInteger(1);
        this.recent = new NGramRecentTokens(maxSequenceSize);
        this.recentSequence = new NGramRecentTokensSequence(maxSequenceSize, nGramOrder, sequenceInitialSize);
    }

    public /* synthetic */ VocabularyWithLimit(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 100;
        }
        this(n, n2, n3, n4);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(VocabularyWithLimit.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Vocab\u2026aryWithLimit::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/ml/ngram/VocabularyWithLimit$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_platform_ml_impl", "()Lcom/intellij/openapi/diagnostic/Logger;", "SEQUENCE_INITIAL_SIZE", "", "intellij.platform.ml.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG$intellij_platform_ml_impl() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

