/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.intellij.internal.ml.Feature;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.UndefinedMapper;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0019\u001a\u001bB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/ml/CategoricalFeature;", "Lcom/intellij/internal/ml/Feature;", "name", "", "categories", "", "(Ljava/lang/String;Ljava/util/Set;)V", "getCategories", "()Ljava/util/Set;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "createMapper", "Lcom/intellij/internal/ml/FeatureMapper;", "suffix", "equals", "", "other", "", "hashCode", "", "otherCategoryMapper", "toString", "CategoryMapper", "Companion", "OtherCategoryMapper", "intellij.platform.ide.impl"})
public final class CategoricalFeature
extends Feature {
    @NotNull
    private final String name;
    @NotNull
    private final Set<String> categories;
    @NotNull
    public static final String OTHER = "OTHER";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public FeatureMapper createMapper(@Nullable String suffix) {
        block6: {
            block5: {
                v0 = suffix;
                if (v0 == null) break block5;
                var2_2 = v0;
                switch (var2_2.hashCode()) {
                    case 75532016: {
                        if (!var2_2.equals("OTHER")) ** break;
                        break;
                    }
                    case 1748463920: {
                        if (!var2_2.equals("UNDEFINED")) ** break;
                        v1 = UndefinedMapper.Companion.checkAndCreate(this.getName(), this.categories.contains("UNDEFINED"));
                        break block6;
                    }
                }
                v1 = this.otherCategoryMapper();
                break block6;
            }
            throw (Throwable)new InconsistentMetadataException("Categorical feature usage must have suffix");
            if (!this.categories.contains(suffix)) {
                throw (Throwable)new InconsistentMetadataException("Unknown category '" + suffix + "' of categorical feature '" + this.getName() + '\'');
            }
            v1 = new CategoryMapper(suffix);
        }
        return v1;
    }

    private final FeatureMapper otherCategoryMapper() {
        if (!this.categories.contains(OTHER)) {
            throw (Throwable)new InconsistentMetadataException("Feature " + this.getName() + " does not allow other category");
        }
        return new OtherCategoryMapper(this.getName(), SetsKt.minus(this.categories, (Iterable)CollectionsKt.listOf((Object[])new String[]{"UNDEFINED", OTHER})));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Set<String> getCategories() {
        return this.categories;
    }

    public CategoricalFeature(@NotNull String name, @NotNull Set<String> categories) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        super(null);
        this.name = name;
        this.categories = categories;
    }

    @NotNull
    public final String component1() {
        return this.getName();
    }

    @NotNull
    public final Set<String> component2() {
        return this.categories;
    }

    @NotNull
    public final CategoricalFeature copy(@NotNull String name, @NotNull Set<String> categories) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        return new CategoricalFeature(name, categories);
    }

    public static /* synthetic */ CategoricalFeature copy$default(CategoricalFeature categoricalFeature, String string, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            string = categoricalFeature.getName();
        }
        if ((n & 2) != 0) {
            set2 = categoricalFeature.categories;
        }
        return categoricalFeature.copy(string, set2);
    }

    @NotNull
    public String toString() {
        return "CategoricalFeature(name=" + this.getName() + ", categories=" + this.categories + ")";
    }

    public int hashCode() {
        String string = this.getName();
        Set<String> set2 = this.categories;
        return (string != null ? string.hashCode() : 0) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CategoricalFeature)) break block3;
                CategoricalFeature categoricalFeature = (CategoricalFeature)object;
                if (!Intrinsics.areEqual((Object)this.getName(), (Object)categoricalFeature.getName()) || !Intrinsics.areEqual(this.categories, categoricalFeature.categories)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/ml/CategoricalFeature$OtherCategoryMapper;", "Lcom/intellij/internal/ml/FeatureMapper;", "name", "", "knownCategories", "", "(Ljava/lang/String;Ljava/util/Set;)V", "asArrayValue", "", "value", "", "getFeatureName", "intellij.platform.ide.impl"})
    private static final class OtherCategoryMapper
    implements FeatureMapper {
        private final String name;
        private final Set<String> knownCategories;

        @Override
        @NotNull
        public String getFeatureName() {
            return this.name;
        }

        @Override
        public double asArrayValue(@Nullable Object value2) {
            return value2 == null || this.knownCategories.contains(value2.toString()) ? 0.0 : 1.0;
        }

        public OtherCategoryMapper(@NotNull String name, @NotNull Set<String> knownCategories) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(knownCategories, (String)"knownCategories");
            this.name = name;
            this.knownCategories = knownCategories;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/internal/ml/CategoricalFeature$CategoryMapper;", "Lcom/intellij/internal/ml/FeatureMapper;", "category", "", "(Lcom/intellij/internal/ml/CategoricalFeature;Ljava/lang/String;)V", "asArrayValue", "", "value", "", "getFeatureName", "intellij.platform.ide.impl"})
    private final class CategoryMapper
    implements FeatureMapper {
        private final String category;

        @Override
        @NotNull
        public String getFeatureName() {
            return CategoricalFeature.this.getName();
        }

        @Override
        public double asArrayValue(@Nullable Object value2) {
            if (value2 == null) {
                return 0.0;
            }
            return Intrinsics.areEqual((Object)value2.toString(), (Object)this.category) ? 1.0 : 0.0;
        }

        public CategoryMapper(String category) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            this.category = category;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/internal/ml/CategoricalFeature$Companion;", "", "()V", "OTHER", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

