/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.intellij.internal.ml.Feature;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.UndefinedMapper;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001%BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u00c6\u0003J\u0019\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003J[\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00072\u0018\b\u0002\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00072\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0016J\u0013\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006&"}, d2={"Lcom/intellij/internal/ml/BinaryFeature;", "Lcom/intellij/internal/ml/Feature;", "name", "", "firstValueMapping", "Lkotlin/Pair;", "", "Lcom/intellij/internal/ml/ValueMapping;", "secondValueMapping", "defaultValue", "allowUndefined", "", "(Ljava/lang/String;Lkotlin/Pair;Lkotlin/Pair;DZ)V", "getAllowUndefined", "()Z", "getDefaultValue", "()D", "getFirstValueMapping", "()Lkotlin/Pair;", "getName", "()Ljava/lang/String;", "getSecondValueMapping", "component1", "component2", "component3", "component4", "component5", "copy", "createMapper", "Lcom/intellij/internal/ml/FeatureMapper;", "suffix", "equals", "other", "", "hashCode", "", "toString", "BinaryMapper", "intellij.platform.ide.impl"})
public final class BinaryFeature
extends Feature {
    @NotNull
    private final String name;
    @NotNull
    private final Pair<String, Double> firstValueMapping;
    @NotNull
    private final Pair<String, Double> secondValueMapping;
    private final double defaultValue;
    private final boolean allowUndefined;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public FeatureMapper createMapper(@Nullable String suffix) {
        FeatureMapper featureMapper;
        String string = suffix;
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case 1748463920: {
                    if (!string2.equals("UNDEFINED")) throw (Throwable)new InconsistentMetadataException("Unexpected binary feature suffix: " + suffix + " (feature '" + this.getName() + "')");
                    featureMapper = UndefinedMapper.Companion.checkAndCreate(this.getName(), this.allowUndefined);
                    return featureMapper;
                }
                default: {
                    throw (Throwable)new InconsistentMetadataException("Unexpected binary feature suffix: " + suffix + " (feature '" + this.getName() + "')");
                }
            }
        }
        featureMapper = new BinaryMapper();
        return featureMapper;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Pair<String, Double> getFirstValueMapping() {
        return this.firstValueMapping;
    }

    @NotNull
    public final Pair<String, Double> getSecondValueMapping() {
        return this.secondValueMapping;
    }

    public final double getDefaultValue() {
        return this.defaultValue;
    }

    public final boolean getAllowUndefined() {
        return this.allowUndefined;
    }

    public BinaryFeature(@NotNull String name, @NotNull Pair<String, Double> firstValueMapping, @NotNull Pair<String, Double> secondValueMapping, double defaultValue, boolean allowUndefined) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(firstValueMapping, (String)"firstValueMapping");
        Intrinsics.checkNotNullParameter(secondValueMapping, (String)"secondValueMapping");
        super(null);
        this.name = name;
        this.firstValueMapping = firstValueMapping;
        this.secondValueMapping = secondValueMapping;
        this.defaultValue = defaultValue;
        this.allowUndefined = allowUndefined;
    }

    @NotNull
    public final String component1() {
        return this.getName();
    }

    @NotNull
    public final Pair<String, Double> component2() {
        return this.firstValueMapping;
    }

    @NotNull
    public final Pair<String, Double> component3() {
        return this.secondValueMapping;
    }

    public final double component4() {
        return this.defaultValue;
    }

    public final boolean component5() {
        return this.allowUndefined;
    }

    @NotNull
    public final BinaryFeature copy(@NotNull String name, @NotNull Pair<String, Double> firstValueMapping, @NotNull Pair<String, Double> secondValueMapping, double defaultValue, boolean allowUndefined) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(firstValueMapping, (String)"firstValueMapping");
        Intrinsics.checkNotNullParameter(secondValueMapping, (String)"secondValueMapping");
        return new BinaryFeature(name, firstValueMapping, secondValueMapping, defaultValue, allowUndefined);
    }

    public static /* synthetic */ BinaryFeature copy$default(BinaryFeature binaryFeature, String string, Pair pair, Pair pair2, double d, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = binaryFeature.getName();
        }
        if ((n & 2) != 0) {
            pair = binaryFeature.firstValueMapping;
        }
        if ((n & 4) != 0) {
            pair2 = binaryFeature.secondValueMapping;
        }
        if ((n & 8) != 0) {
            d = binaryFeature.defaultValue;
        }
        if ((n & 0x10) != 0) {
            bl = binaryFeature.allowUndefined;
        }
        return binaryFeature.copy(string, pair, pair2, d, bl);
    }

    @NotNull
    public String toString() {
        return "BinaryFeature(name=" + this.getName() + ", firstValueMapping=" + this.firstValueMapping + ", secondValueMapping=" + this.secondValueMapping + ", defaultValue=" + this.defaultValue + ", allowUndefined=" + this.allowUndefined + ")";
    }

    public int hashCode() {
        String string = this.getName();
        Pair<String, Double> pair = this.firstValueMapping;
        Pair<String, Double> pair2 = this.secondValueMapping;
        int n = ((((string != null ? string.hashCode() : 0) * 31 + (pair != null ? pair.hashCode() : 0)) * 31 + (pair2 != null ? pair2.hashCode() : 0)) * 31 + Double.hashCode(this.defaultValue)) * 31;
        int n2 = this.allowUndefined ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof BinaryFeature)) break block3;
                BinaryFeature binaryFeature = (BinaryFeature)object;
                if (!Intrinsics.areEqual((Object)this.getName(), (Object)binaryFeature.getName()) || !Intrinsics.areEqual(this.firstValueMapping, binaryFeature.firstValueMapping) || !Intrinsics.areEqual(this.secondValueMapping, binaryFeature.secondValueMapping) || Double.compare(this.defaultValue, binaryFeature.defaultValue) != 0 || this.allowUndefined != binaryFeature.allowUndefined) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/ml/BinaryFeature$BinaryMapper;", "Lcom/intellij/internal/ml/FeatureMapper;", "(Lcom/intellij/internal/ml/BinaryFeature;)V", "asArrayValue", "", "value", "", "getFeatureName", "", "intellij.platform.ide.impl"})
    private final class BinaryMapper
    implements FeatureMapper {
        @Override
        @NotNull
        public String getFeatureName() {
            return BinaryFeature.this.getName();
        }

        @Override
        public double asArrayValue(@Nullable Object value2) {
            String string = String.valueOf(value2);
            return Intrinsics.areEqual((Object)string, (Object)((String)BinaryFeature.this.getFirstValueMapping().getFirst())) ? ((Number)BinaryFeature.this.getFirstValueMapping().getSecond()).doubleValue() : (Intrinsics.areEqual((Object)string, (Object)((String)BinaryFeature.this.getSecondValueMapping().getFirst())) ? ((Number)BinaryFeature.this.getSecondValueMapping().getSecond()).doubleValue() : BinaryFeature.this.getDefaultValue());
        }
    }
}

