/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef;

import com.intellij.internal.jcef.CookieManagerDialog;
import com.intellij.internal.jcef.MyOkCancelDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;

public class WebBrowser
extends AnAction
implements DumbAware {
    private static final String URL = "https://maps.google.com";
    private static final String myTitle = "Web Browser - JCEF";
    private static final String myCookieManagerText = "Cookie Manager";

    public void actionPerformed(@NotNull AnActionEvent e) {
        Window activeFrame;
        if (e == null) {
            WebBrowser.$$$reportNull$$$0(0);
        }
        if ((activeFrame = IdeFrameImpl.getActiveFrame()) == null) {
            return;
        }
        if (!JBCefApp.isSupported()) {
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)new JTextArea("Set the reg key to enable JCEF:\n\"ide.browser.jcef.enabled=true\""), null).setTitle("JCEF Web Browser Is not Supported").createPopup().showInCenterOf((Component)activeFrame);
            return;
        }
        Rectangle bounds2 = activeFrame.getGraphicsConfiguration().getBounds();
        final IdeFrameImpl frame = new IdeFrameImpl();
        ((Frame)frame).setTitle(myTitle);
        frame.setDefaultCloseOperation(2);
        frame.setBounds(bounds2.width / 4, bounds2.height / 4, bounds2.width / 2, bounds2.height / 2);
        frame.setLayout(new BorderLayout());
        final JBCefBrowser myJBCefBrowser = new JBCefBrowser(URL);
        myJBCefBrowser.setErrorPage(JBCefBrowserBase.ErrorPage.DEFAULT);
        myJBCefBrowser.setProperty("JBCefBrowser.focusOnShow", (Object)Boolean.TRUE);
        final CookieManagerDialog myCookieManagerDialog = new CookieManagerDialog((Frame)frame, myJBCefBrowser);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Disposer.dispose((Disposable)myJBCefBrowser);
            }
        });
        myJBCefBrowser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadStart(CefBrowser browser2, CefFrame frame, CefRequest.TransitionType transitionType) {
                myCookieManagerDialog.setVisible(false);
            }
        }, myJBCefBrowser.getCefBrowser());
        frame.add((Component)myJBCefBrowser.getComponent(), "Center");
        final JTextField myUrlBar = new JTextField(URL);
        myUrlBar.addActionListener(event -> myJBCefBrowser.loadURL(myUrlBar.getText()));
        frame.add((Component)myUrlBar, "North");
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JButton myShowCookieManagerButton = new JButton(myCookieManagerText);
        myShowCookieManagerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                myCookieManagerDialog.setVisible(true);
                List cookies = myJBCefBrowser.getJBCefCookieManager().getCookies();
                if (cookies != null) {
                    myCookieManagerDialog.update(cookies);
                }
            }
        });
        controlPanel.add(myShowCookieManagerButton);
        frame.add((Component)controlPanel, "South");
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu menu = new JMenu("Tools");
        menu.setMnemonic('t');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Load HTML with URL", 104);
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyOkCancelDialog<JPanel> dialog2 = new MyOkCancelDialog<JPanel>(frame, "Load HTML with URL");
                JPanel panel2 = new JPanel();
                panel2.setLayout(new BorderLayout());
                JTextField url = new JTextField("file://foo/bar");
                JTextArea html = new JTextArea("<html>\n<body>\n\u0421\u044a\u0435\u0448\u044c \u0415\u0449\u0435 \u042d\u0442\u0438\u0445 \u041c\u044f\u0433\u043a\u0438\u0445 \u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0445 \u0411\u0443\u043b\u043e\u043a &#129366;&#129366;\n</body>\n</html>");
                panel2.add((Component)url, "North");
                panel2.add((Component)html, "Center");
                dialog2.setComponent(panel2);
                dialog2.setOkAction(() -> {
                    myUrlBar.setText(url.getText());
                    SwingUtilities.invokeLater(() -> myJBCefBrowser.loadHTML(html.getText(), url.getText()));
                }, "Load");
                dialog2.show();
            }
        });
        menuItem = new JMenuItem("Set background color", 99);
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyOkCancelDialog<JTextField> dialog2 = new MyOkCancelDialog<JTextField>(frame, "Background Color");
                JTextField color = dialog2.setComponent(new JTextField("lightgreen"));
                dialog2.setOkAction(() -> myJBCefBrowser.setPageBackgroundColor(color.getText()), "Apply");
                dialog2.show();
            }
        });
        final JMenuItem menuItemFocus = new JMenuItem("Set focus on navigation", 102);
        menu.add(menuItemFocus);
        menuItemFocus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean value2 = Boolean.TRUE.equals(myJBCefBrowser.getProperty("JBCefBrowser.focusOnNavigation"));
                myJBCefBrowser.setProperty("JBCefBrowser.focusOnNavigation", (Object)(!value2 ? 1 : 0));
                menuItemFocus.setText(value2 ? "Set focus on navigation" : "Unset focus on navigation");
            }
        });
        frame.setVisible(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/jcef/WebBrowser", "actionPerformed"));
    }
}

