/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentationFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private final TokenSet myTokenSet;

    public IndentationFoldingBuilder(TokenSet tokenSet) {
        this.myTokenSet = tokenSet;
    }

    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode astNode, @NotNull Document document) {
        if (astNode == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(1);
        }
        LinkedList descriptors2 = new LinkedList();
        this.collectDescriptors(astNode, descriptors2);
        FoldingDescriptor[] foldingDescriptorArray = descriptors2.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    private void collectDescriptors(@NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors2) {
        if (node == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (descriptors2 == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(4);
        }
        LinkedList<ASTNode> toProcess = new LinkedList<ASTNode>();
        toProcess.add(node);
        while (!toProcess.isEmpty()) {
            ASTNode current2 = (ASTNode)toProcess.remove();
            if (current2.getTreeParent() != null && current2.getTextLength() > 1 && this.myTokenSet.contains(current2.getElementType())) {
                descriptors2.add((FoldingDescriptor)new FoldingDescriptor(current2, current2.getTextRange()));
            }
            for (ASTNode child2 = current2.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
                toProcess.add(child2);
            }
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(5);
        }
        StringBuilder builder2 = new StringBuilder();
        for (ASTNode child2 = node.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            String text2 = child2.getText();
            if (!text2.contains("\n")) {
                builder2.append(text2);
                continue;
            }
            if (builder2.length() > 0) {
                builder2.append(text2, 0, text2.indexOf(10));
                break;
            }
            builder2.append(IndentationFoldingBuilder.getFirstNonEmptyLine(text2));
            if (builder2.length() > 0) break;
        }
        return builder2.toString();
    }

    @NotNull
    private static String getFirstNonEmptyLine(@NotNull String text2) {
        int end;
        if (text2 == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(6);
        }
        int start2 = 0;
        while ((end = text2.indexOf(10, start2)) != -1 && start2 >= end) {
            start2 = end + 1;
        }
        String string = end == -1 ? text2.substring(start2) : text2.substring(start2, end);
        if (string == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(8);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indentation/IndentationFoldingBuilder";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indentation/IndentationFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstNonEmptyLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNonEmptyLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

