/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.internal.statistic.eventLog.fus.SearchEverywhereLogger;
import com.intellij.internal.statistic.local.ActionGlobalUsageInfo;
import com.intellij.internal.statistic.local.ActionsGlobalSummaryManager;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionOrderStrategy {
    private static final int NUMBER_OF_GROUPS = 8;
    private static final int EXPERIMENT_GROUP = 7;
    private final boolean myExperimentGroup;
    private final ActionManager myActionManager = ActionManager.getInstance();
    private final ActionsGlobalSummaryManager myStatManager = (ActionsGlobalSummaryManager)ApplicationManager.getApplication().getService(ActionsGlobalSummaryManager.class);

    public GotoActionOrderStrategy() {
        this.myExperimentGroup = SearchEverywhereLogger.getBucket() % 8 == 7 && StatisticsUploadAssistant.isSendAllowed() && ApplicationManager.getApplication().isEAP();
    }

    public int compare(@NotNull AnAction first, @NotNull AnAction second) {
        if (first == null) {
            GotoActionOrderStrategy.$$$reportNull$$$0(0);
        }
        if (second == null) {
            GotoActionOrderStrategy.$$$reportNull$$$0(1);
        }
        if (this.shouldOrderByStats()) {
            double myRatio = this.getActionUsagesRatio(this.myActionManager.getId(first));
            double oRatio = this.getActionUsagesRatio(this.myActionManager.getId(second));
            return -Double.compare(myRatio, oRatio);
        }
        return 0;
    }

    private boolean shouldOrderByStats() {
        if (Registry.is((String)"search.everywhere.consider.action.statistics")) {
            return true;
        }
        if (Registry.is((String)"search.everywhere.force.disable.experiment.action.statistics")) {
            return false;
        }
        return this.myExperimentGroup;
    }

    private double getActionUsagesRatio(@Nullable String actionID) {
        if (actionID == null) {
            return 0.0;
        }
        ActionGlobalUsageInfo statistics = this.myStatManager.getActionStatistics(actionID);
        return statistics != null ? statistics.getUsagesPerUserRatio() : 0.0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "first";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "second";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/gotoByName/GotoActionOrderStrategy";
        objectArray[2] = "compare";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

