/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import org.jetbrains.annotations.NotNull;

public class DefaultFileNavigationContributor
implements ChooseByNameContributorEx,
DumbAware {
    private static final Logger LOG = Logger.getInstance(DefaultFileNavigationContributor.class);

    @Override
    public void processNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        if (processor2 == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(1);
        }
        long started = System.currentTimeMillis();
        FilenameIndex.processAllFileNames(processor2, (GlobalSearchScope)scope, (IdFilter)filter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("All names retrieved:" + (System.currentTimeMillis() - started));
        }
    }

    @Override
    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> _processor, @NotNull FindSymbolParameters parameters2) {
        if (name == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(2);
        }
        if (_processor == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(3);
        }
        if (parameters2 == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(4);
        }
        boolean globalSearch = parameters2.getSearchScope().isSearchInLibraries();
        Processor processor2 = item -> {
            if (!globalSearch && ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)item.getVirtualFile())) {
                return true;
            }
            return _processor.process(item);
        };
        boolean directoriesOnly = DefaultFileNavigationContributor.isDirectoryOnlyPattern(parameters2);
        if (!directoriesOnly) {
            FilenameIndex.processFilesByName((String)name, (boolean)false, (Processor)processor2, (GlobalSearchScope)parameters2.getSearchScope(), (Project)parameters2.getProject(), (IdFilter)parameters2.getIdFilter());
        }
        if (directoriesOnly || Registry.is((String)"ide.goto.file.include.directories")) {
            FilenameIndex.processFilesByName((String)name, (boolean)true, (Processor)processor2, (GlobalSearchScope)parameters2.getSearchScope(), (Project)parameters2.getProject(), (IdFilter)parameters2.getIdFilter());
        }
    }

    private static boolean isDirectoryOnlyPattern(@NotNull FindSymbolParameters parameters2) {
        String completePattern;
        if (parameters2 == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(5);
        }
        return (completePattern = parameters2.getCompletePattern()).endsWith("/") || completePattern.endsWith("\\");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_processor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsWithName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectoryOnlyPattern";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

