/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoSymbolModel2;
import com.intellij.ide.util.gotoByName.SelectMostRelevant;
import com.intellij.ide.util.gotoByName.SelectionPolicyKt;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ChooseByNamePopup
extends ChooseByNameBase
implements ChooseByNamePopupComponent,
Disposable {
    public static final Key<ChooseByNamePopup> CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY = new Key("ChooseByNamePopup");
    public static final Key<String> CURRENT_SEARCH_PATTERN = new Key("ChooseByNamePattern");
    private Component myOldFocusOwner;
    private boolean myShowListForEmptyPattern;
    private final boolean myMayRequestCurrentWindow;
    private final ChooseByNamePopup myOldPopup;
    private ActionMap myActionMap;
    private InputMap myInputMap;
    private @NlsContexts.PopupAdvertisement String myAdText;
    private final MergingUpdateQueue myRepaintQueue;
    private static final Pattern patternToDetectLinesAndColumns = Pattern.compile("(.+?)(?::|@|,| |#|#L|\\?l=| on line | at line |:?\\(|:?\\[)(\\d+)?(?:\\W(\\d+)?)?[)\\]]?");
    public static final Pattern patternToDetectAnonymousClasses = Pattern.compile("([.\\w]+)((\\$[\\d]+)*(\\$)?)");
    private static final Pattern patternToDetectMembers = Pattern.compile("(.+)(#)(.*)");
    private static final Pattern patternToDetectSignatures = Pattern.compile("(.+#.*)\\(.*\\)");
    private static final String fullMatchSearchSuffix = " ";

    protected ChooseByNamePopup(@Nullable Project project, @NotNull ChooseByNameModel model2, @NotNull ChooseByNameItemProvider provider2, @Nullable ChooseByNamePopup oldPopup, @Nullable String predefinedText, boolean mayRequestOpenInCurrentWindow, int initialIndex) {
        if (model2 == null) {
            ChooseByNamePopup.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            ChooseByNamePopup.$$$reportNull$$$0(1);
        }
        super(project, model2, provider2, oldPopup != null ? oldPopup.getEnteredText() : predefinedText, initialIndex);
        this.myRepaintQueue = new MergingUpdateQueue("ChooseByNamePopup repaint", 50, true, (JComponent)this.myList, (Disposable)this);
        this.myOldPopup = oldPopup;
        if (oldPopup != null) {
            this.myOldFocusOwner = oldPopup.myPreviouslyFocusedComponent;
        }
        this.myMayRequestCurrentWindow = mayRequestOpenInCurrentWindow;
        this.myAdText = this.myMayRequestCurrentWindow ? LangBundle.message((String)"popup.advertisement.press.to.open.in.current.window", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 1))}) : null;
    }

    public String getEnteredText() {
        return this.myTextField.getText();
    }

    public int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    @Override
    protected void initUI(ChooseByNamePopupComponent.Callback callback2, ModalityState modalityState, boolean allowMultipleSelection) {
        super.initUI(callback2, modalityState, allowMultipleSelection);
        if (this.myOldPopup != null) {
            this.myTextField.setCaretPosition(this.myOldPopup.myTextField.getCaretPosition());
        }
        if (this.myInitialText != null) {
            int selEnd;
            int selStart = this.myOldPopup == null ? 0 : this.myOldPopup.myTextField.getSelectionStart();
            int n = selEnd = this.myOldPopup == null ? this.myInitialText.length() : this.myOldPopup.myTextField.getSelectionEnd();
            if (selEnd > selStart) {
                this.myTextField.select(selStart, selEnd);
            }
            this.rebuildList(SelectionPolicyKt.fromIndex(this.myInitialIndex), 0, ModalityState.current(), null);
        }
        if (this.myOldFocusOwner != null) {
            this.myPreviouslyFocusedComponent = this.myOldFocusOwner;
            this.myOldFocusOwner = null;
        }
        if (this.myInputMap != null && this.myActionMap != null) {
            for (KeyStroke keyStroke : this.myInputMap.keys()) {
                Object key = this.myInputMap.get(keyStroke);
                this.myTextField.getInputMap().put(keyStroke, key);
                this.myTextField.getActionMap().put(key, this.myActionMap.get(key));
            }
        }
    }

    @Override
    public boolean isOpenInCurrentWindowRequested() {
        return super.isOpenInCurrentWindowRequested() && this.myMayRequestCurrentWindow;
    }

    @Override
    protected boolean isCheckboxVisible() {
        return true;
    }

    @Override
    protected boolean isShowListForEmptyPattern() {
        return this.myShowListForEmptyPattern;
    }

    public void setShowListForEmptyPattern(boolean showListForEmptyPattern) {
        this.myShowListForEmptyPattern = showListForEmptyPattern;
    }

    @Override
    protected boolean isCloseByFocusLost() {
        return UISettings.getInstance().getHideNavigationOnFocusLoss();
    }

    @Override
    protected void showList() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ListModel model2 = this.myList.getModel();
        if (model2 == null || model2.getSize() == 0) {
            return;
        }
        JLayeredPane layeredPane = this.myTextField.getRootPane().getLayeredPane();
        Point location = layeredPane.getLocationOnScreen();
        location.y += layeredPane.getHeight();
        Dimension preferredScrollPaneSize = this.myListScrollPane.getPreferredSize();
        preferredScrollPaneSize.width = Math.max(this.myTextFieldPanel.getWidth(), preferredScrollPaneSize.width);
        if (this.myDropdownPopup != null && !this.isCloseByFocusLost()) {
            Dimension currentSize = this.myDropdownPopup.getSize();
            if (preferredScrollPaneSize.width < currentSize.width) {
                preferredScrollPaneSize.width = currentSize.width;
            }
            if (preferredScrollPaneSize.height < currentSize.height) {
                preferredScrollPaneSize.height = currentSize.height;
            }
        }
        Rectangle screen = ScreenUtil.getScreenRectangle((Point)location);
        if (preferredScrollPaneSize.width > screen.width) {
            Dimension size;
            JScrollBar hsb;
            preferredScrollPaneSize.width = screen.width;
            if (model2.getSize() <= this.myList.getVisibleRowCount() && (hsb = this.myListScrollPane.getHorizontalScrollBar()) != null && (!SystemInfo.isMac || hsb.isOpaque()) && (size = hsb.getPreferredSize()) != null) {
                preferredScrollPaneSize.height += size.height;
            }
        }
        if (preferredScrollPaneSize.height > screen.height) {
            preferredScrollPaneSize.height = screen.height;
        }
        location.x = Math.min(location.x, screen.x + screen.width - preferredScrollPaneSize.width);
        location.y = Math.min(location.y, screen.y + screen.height - preferredScrollPaneSize.height);
        String adText = this.getAdText();
        if (this.myDropdownPopup == null) {
            ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myListScrollPane, (JComponent)this.myList);
            builder2.setFocusable(false).setLocateWithinScreenBounds(false).setRequestFocus(false).setCancelKeyEnabled(false).setFocusOwners((Component[])new JComponent[]{this.myTextField}).setBelongsToGlobalPopupStack(false).setModalContext(false).setAdText(adText).setMayBeParent(true);
            builder2.setCancelCallback(() -> Boolean.TRUE);
            this.myDropdownPopup = builder2.createPopup();
            this.myDropdownPopup.setSize(preferredScrollPaneSize);
            this.myDropdownPopup.showInScreenCoordinates((Component)layeredPane, location);
        } else {
            this.myDropdownPopup.setLocation(location);
            this.myDropdownPopup.setSize(preferredScrollPaneSize);
        }
    }

    @Override
    protected void hideList() {
        if (this.myDropdownPopup != null) {
            this.myDropdownPopup.cancel();
            this.myDropdownPopup = null;
        }
    }

    @Override
    public void close(boolean isOk) {
        if (this.checkDisposed()) {
            return;
        }
        this.myModel.saveInitialCheckBoxState(this.myCheckBox.isSelected());
        if (isOk) {
            List<Object> chosenElements = this.getChosenElements();
            if (this.myActionListener instanceof ChooseByNamePopupComponent.MultiElementsCallback) {
                ((ChooseByNamePopupComponent.MultiElementsCallback)this.myActionListener).elementsChosen(chosenElements);
            } else {
                for (Object element2 : chosenElements) {
                    this.myActionListener.elementChosen(element2);
                    String text2 = this.myModel.getFullName(element2);
                    if (text2 == null) continue;
                    StatisticsManager.getInstance().incUseCount(new StatisticsInfo(this.statisticsContext(), text2));
                }
            }
            if (!chosenElements.isEmpty()) {
                String enteredText = this.getTrimmedText();
                if (enteredText.indexOf(42) >= 0) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.wildcards");
                } else {
                    for (Object element3 : chosenElements) {
                        String name = this.myModel.getElementName(element3);
                        if (name == null || StringUtil.startsWithIgnoreCase((String)name, (String)enteredText)) continue;
                        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.camelprefix");
                        break;
                    }
                }
            }
        }
        Disposer.dispose((Disposable)this);
        this.setDisposed(true);
        this.myAlarm.cancelAllRequests();
        this.cleanupUI(isOk);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myActionListener != null) {
            this.myActionListener.onClose();
        }
    }

    private void cleanupUI(boolean ok2) {
        if (this.myTextPopup != null) {
            if (ok2) {
                this.myTextPopup.closeOk(null);
            } else {
                this.myTextPopup.cancel();
            }
            this.myTextPopup = null;
        }
        if (this.myDropdownPopup != null) {
            if (ok2) {
                this.myDropdownPopup.closeOk(null);
            } else {
                this.myDropdownPopup.cancel();
            }
            this.myDropdownPopup = null;
        }
    }

    public static ChooseByNamePopup createPopup(Project project, ChooseByNameModel model2, PsiElement context) {
        return ChooseByNamePopup.createPopup(project, model2, ChooseByNameModelEx.getItemProvider(model2, context), null);
    }

    public static ChooseByNamePopup createPopup(Project project, ChooseByNameModel model2, PsiElement context, @Nullable String predefinedText) {
        return ChooseByNamePopup.createPopup(project, model2, ChooseByNameModelEx.getItemProvider(model2, context), predefinedText, false, 0);
    }

    public static ChooseByNamePopup createPopup(Project project, ChooseByNameModel model2, PsiElement context, @Nullable String predefinedText, boolean mayRequestOpenInCurrentWindow, int initialIndex) {
        return ChooseByNamePopup.createPopup(project, model2, ChooseByNameModelEx.getItemProvider(model2, context), predefinedText, mayRequestOpenInCurrentWindow, initialIndex);
    }

    public static ChooseByNamePopup createPopup(Project project, @NotNull ChooseByNameModel model2, @NotNull ChooseByNameItemProvider provider2) {
        if (model2 == null) {
            ChooseByNamePopup.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            ChooseByNamePopup.$$$reportNull$$$0(3);
        }
        return ChooseByNamePopup.createPopup(project, model2, provider2, null);
    }

    public static ChooseByNamePopup createPopup(Project project, @NotNull ChooseByNameModel model2, @NotNull ChooseByNameItemProvider provider2, @Nullable String predefinedText) {
        if (model2 == null) {
            ChooseByNamePopup.$$$reportNull$$$0(4);
        }
        if (provider2 == null) {
            ChooseByNamePopup.$$$reportNull$$$0(5);
        }
        return ChooseByNamePopup.createPopup(project, model2, provider2, predefinedText, false, 0);
    }

    public static ChooseByNamePopup createPopup(Project project, @NotNull ChooseByNameModel model2, @NotNull ChooseByNameItemProvider provider2, @Nullable String predefinedText, boolean mayRequestOpenInCurrentWindow, int initialIndex) {
        ChooseByNamePopup oldPopup;
        if (model2 == null) {
            ChooseByNamePopup.$$$reportNull$$$0(6);
        }
        if (provider2 == null) {
            ChooseByNamePopup.$$$reportNull$$$0(7);
        }
        ChooseByNamePopup chooseByNamePopup = oldPopup = project == null ? null : (ChooseByNamePopup)project.getUserData(CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            oldPopup.close(false);
        }
        ChooseByNamePopup newPopup = new ChooseByNamePopup(project, model2, provider2, oldPopup, predefinedText, mayRequestOpenInCurrentWindow, initialIndex);
        if (project != null) {
            project.putUserData(CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, (Object)newPopup);
        }
        return newPopup;
    }

    @Override
    @NotNull
    public String transformPattern(@NotNull String pattern) {
        if (pattern == null) {
            ChooseByNamePopup.$$$reportNull$$$0(8);
        }
        ChooseByNameModel model2 = this.getModel();
        return ChooseByNamePopup.getTransformedPattern(pattern, model2);
    }

    @NotNull
    public static String getTransformedPattern(@NotNull String pattern, @NotNull ChooseByNameModel model2) {
        Matcher matcher;
        if (pattern == null) {
            ChooseByNamePopup.$$$reportNull$$$0(9);
        }
        if (model2 == null) {
            ChooseByNamePopup.$$$reportNull$$$0(10);
        }
        String rawPattern = pattern;
        Pattern regex = null;
        if (StringUtil.containsAnyChar((String)pattern, (String)":,;@[( #") || ((String)pattern).contains(" line ") || ((String)pattern).contains("?l=")) {
            regex = patternToDetectLinesAndColumns;
        }
        if (model2 instanceof GotoClassModel2 || model2 instanceof GotoSymbolModel2) {
            if (((String)pattern).indexOf(35) != -1) {
                Pattern pattern2 = regex = model2 instanceof GotoClassModel2 ? patternToDetectMembers : patternToDetectSignatures;
            }
            if (((String)pattern).indexOf(36) != -1) {
                regex = patternToDetectAnonymousClasses;
            }
        }
        if (regex != null && (matcher = regex.matcher((CharSequence)pattern)).matches()) {
            pattern = matcher.group(1);
        }
        if (rawPattern.endsWith(fullMatchSearchSuffix)) {
            pattern = (String)pattern + fullMatchSearchSuffix;
        }
        String string = pattern;
        if (string == null) {
            ChooseByNamePopup.$$$reportNull$$$0(11);
        }
        return string;
    }

    public int getLinePosition() {
        return this.getLineOrColumn(true);
    }

    private int getLineOrColumn(boolean line) {
        Matcher matcher = patternToDetectLinesAndColumns.matcher(this.getTrimmedText());
        if (matcher.matches()) {
            int groupNumber = line ? 2 : 3;
            try {
                String group2;
                if (groupNumber <= matcher.groupCount() && (group2 = matcher.group(groupNumber)) != null) {
                    return Integer.parseInt(group2) - 1;
                }
                if (!line && this.getLineOrColumn(true) != -1) {
                    return 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Nullable
    public String getPathToAnonymous() {
        Matcher matcher = patternToDetectAnonymousClasses.matcher(this.getTrimmedText());
        return ClassSearchEverywhereContributor.pathToAnonymousClass(matcher);
    }

    public int getColumnPosition() {
        return this.getLineOrColumn(false);
    }

    @Nullable
    public String getMemberPattern() {
        String enteredText = this.getTrimmedText();
        int index2 = enteredText.lastIndexOf(35);
        if (index2 == -1) {
            return null;
        }
        String name = enteredText.substring(index2 + 1).trim();
        return StringUtil.isEmpty((String)name) ? null : name;
    }

    public void registerAction(@NonNls String aActionName, KeyStroke keyStroke, Action aAction) {
        if (this.myInputMap == null) {
            this.myInputMap = new InputMap();
        }
        if (this.myActionMap == null) {
            this.myActionMap = new ActionMap();
        }
        this.myInputMap.put(keyStroke, aActionName);
        this.myActionMap.put(aActionName, aAction);
    }

    @NlsContexts.PopupAdvertisement
    public String getAdText() {
        return this.myAdText;
    }

    public void setAdText(@NlsContexts.PopupAdvertisement String adText) {
        this.myAdText = adText;
    }

    public void addMouseClickListener(MouseListener listener2) {
        this.myList.addMouseListener(listener2);
    }

    public Object getSelectionByPoint(Point point) {
        int index2 = this.myList.locationToIndex(point);
        return index2 > -1 ? this.myList.getModel().getElementAt(index2) : null;
    }

    public void repaintList() {
        this.myRepaintQueue.cancelAllUpdates();
        this.myRepaintQueue.queue(new Update(this){

            public void run() {
                ChooseByNamePopup.this.repaintListImmediate();
            }
        });
    }

    public void repaintListImmediate() {
        this.myList.repaint();
    }

    public void dispose() {
        if (this.myProject != null) {
            this.myProject.putUserData(CURRENT_SEARCH_PATTERN, null);
            this.myProject.putUserData(CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, null);
        }
    }

    @NotNull
    @TestOnly
    public List<Object> calcPopupElements(@NotNull String text2, boolean checkboxState) {
        if (text2 == null) {
            ChooseByNamePopup.$$$reportNull$$$0(12);
        }
        ArrayList elements = ContainerUtil.newArrayList((Object[])new Object[]{"empty"});
        Semaphore semaphore = new Semaphore(1);
        this.scheduleCalcElements(text2, checkboxState, ModalityState.NON_MODAL, SelectMostRelevant.INSTANCE, set2 -> {
            elements.clear();
            elements.addAll(set2);
            semaphore.up();
        });
        long start2 = System.currentTimeMillis();
        while (!semaphore.waitFor(10L) && System.currentTimeMillis() - start2 < 20000L) {
            UIUtil.dispatchAllInvocationEvents();
        }
        if (!semaphore.waitFor(10L)) {
            PerformanceWatcher.dumpThreadsToConsole("Thread dump:");
            throw new UncheckedTimeoutException("Too long background calculation");
        }
        ArrayList arrayList = elements;
        if (arrayList == null) {
            ChooseByNamePopup.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/ChooseByNamePopup";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/ChooseByNamePopup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformedPattern";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPopupElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "transformPattern";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTransformedPattern";
                break;
            }
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcPopupElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

