/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementModuleRenderer
extends DefaultListCellRenderer {
    @Nls
    private String myText;

    @Override
    public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
        Component listCellRendererComponent = super.getListCellRendererComponent((JList<?>)list2, (Object)null, index2, isSelected, cellHasFocus);
        this.customizeCellRenderer(value2, isSelected);
        return listCellRendererComponent;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    private void customizeCellRenderer(Object value2, boolean selected2) {
        Pair<String, Icon> elementLocation;
        PsiElement element2;
        this.myText = "";
        if (value2 instanceof PsiElement && (element2 = (PsiElement)value2).isValid() && (elementLocation = this.elementLocation(element2)) != null) {
            this.myText = (String)elementLocation.first;
            this.setIcon((Icon)elementLocation.second);
        }
        this.setText(this.myText);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, UIUtil.getListCellHPadding()));
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(4);
        this.setBackground(selected2 ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListBackground());
        this.setForeground(selected2 ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getInactiveTextColor());
    }

    private @Nullable Pair<@Nls @NotNull String, @NotNull Icon> elementLocation(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(0);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element2.getProject()).getFileIndex();
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
        if (vFile != null && fileIndex.isInLibrary(vFile)) {
            return this.libraryLocation(fileIndex, vFile);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
        if (module != null) {
            return PsiElementModuleRenderer.projectLocation(vFile, module, fileIndex);
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static @NotNull Pair<@Nls @NotNull String, @NotNull Icon> projectLocation(@Nullable VirtualFile vFile, @NotNull Module module, @NotNull ProjectFileIndex fileIndex) {
        String path;
        boolean inTestSource;
        if (module == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(1);
        }
        if (fileIndex == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(2);
        }
        boolean bl = inTestSource = vFile != null && fileIndex.isInTestSourceContent(vFile);
        String text2 = Registry.is((String)"ide.show.folder.name.instead.of.module.name") ? (StringUtil.isEmpty((String)(path = ModuleUtilCore.getModuleDirPath((Module)module))) ? module.getName() : new File(path).getName()) : module.getName();
        Icon icon2 = inTestSource ? AllIcons.Nodes.TestSourceFolder : ModuleType.get((Module)module).getIcon();
        Pair pair = Pair.create((Object)text2, (Object)icon2);
        if (pair == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @ApiStatus.Internal
    @NotNull
    public @NotNull Pair<@Nls @NotNull String, @NotNull Icon> libraryLocation(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        Object text2;
        if (fileIndex == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(4);
        }
        if (vFile == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(text2 = this.orderEntryText(fileIndex, vFile))) && Registry.is((String)"index.run.configuration.jre")) {
            for (Sdk sdk2 : ProjectJdkTable.getInstance().getAllJdks()) {
                Set roots = StreamEx.of((Object[])sdk2.getRootProvider().getFiles(OrderRootType.CLASSES)).append((Object[])sdk2.getRootProvider().getFiles(OrderRootType.SOURCES)).toSet();
                if (!VfsUtilCore.isUnder((VirtualFile)vFile, (Set)roots)) continue;
                text2 = "< " + sdk2.getName() + " >";
                break;
            }
        }
        text2 = ((String)text2).substring(((String)text2).lastIndexOf(File.separatorChar) + 1);
        VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(vFile);
        if (jar != null && !((String)text2).equals(jar.getName())) {
            text2 = (String)text2 + " (" + jar.getName() + ")";
        }
        Pair pair = Pair.create((Object)text2, (Object)AllIcons.Nodes.PpLibFolder);
        if (pair == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @Nls
    @NotNull
    private String orderEntryText(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        if (fileIndex == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(7);
        }
        if (vFile == null) {
            PsiElementModuleRenderer.$$$reportNull$$$0(8);
        }
        for (OrderEntry order : fileIndex.getOrderEntriesForFile(vFile)) {
            if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
            String string = this.getPresentableName(order, vFile);
            if (string == null) {
                PsiElementModuleRenderer.$$$reportNull$$$0(9);
            }
            return string;
        }
        return "";
    }

    @Nls
    protected String getPresentableName(OrderEntry order, VirtualFile vFile) {
        return order.getPresentableName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PsiElementModuleRenderer";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PsiElementModuleRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "projectLocation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "libraryLocation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "orderEntryText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "elementLocation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "projectLocation";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "libraryLocation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "orderEntryText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

