/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import javax.swing.JComponent;

public class MemberChooserBuilder<T extends ClassMember> {
    private final Project myProject;
    private boolean myAllowEmptySelection = false;
    private boolean myAllowMultiSelection = true;
    private boolean myIsInsertOverrideVisible = false;
    private boolean myIsCopyJavadocVisible = false;
    private JComponent myHeaderPanel;
    @NlsContexts.DialogTitle
    private String myTitle;

    public MemberChooserBuilder(Project project) {
        this.myProject = project;
    }

    public MemberChooser<T> createBuilder(T[] elements) {
        MemberChooser chooser2 = new MemberChooser(elements, this.myAllowEmptySelection, this.myAllowMultiSelection, this.myProject, this.myIsInsertOverrideVisible, this.myHeaderPanel);
        if (this.myTitle != null) {
            chooser2.setTitle(this.myTitle);
        }
        chooser2.setCopyJavadocVisible(this.myIsCopyJavadocVisible);
        return chooser2;
    }

    public void allowEmptySelection(boolean allowEmptySelection) {
        this.myAllowEmptySelection = allowEmptySelection;
    }

    public void allowMultiSelection(boolean allowMultiSelection) {
        this.myAllowMultiSelection = allowMultiSelection;
    }

    public void overrideAnnotationVisible(boolean isInsertOverrideVisible) {
        this.myIsInsertOverrideVisible = isInsertOverrideVisible;
    }

    public void setHeaderPanel(JComponent headerPanel) {
        this.myHeaderPanel = headerPanel;
    }

    public void copyJavadocVisible(boolean isCopyJavadocVisible) {
        this.myIsCopyJavadocVisible = isCopyJavadocVisible;
    }

    public void setTitle(@NlsContexts.DialogTitle String title) {
        this.myTitle = title;
    }
}

