/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.MultiStateElementsChooser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementsChooser<T>
extends MultiStateElementsChooser<T, Boolean> {
    private static final BooleanMarkStateDescriptor MARK_STATE_DESCRIPTOR = new BooleanMarkStateDescriptor();
    private final Collection<StatisticsCollector<T>> myStatisticsCollectors = new ArrayList<StatisticsCollector<T>>();

    public void addStatisticsCollector(StatisticsCollector<T> collector) {
        this.myStatisticsCollectors.add(collector);
        this.addElementsMarkListener(collector);
    }

    public void removeStatisticsCollector(StatisticsCollector<T> collector) {
        this.myStatisticsCollectors.remove(collector);
        this.removeElementsMarkListener(collector);
    }

    public ElementsChooser(boolean elementsCanBeMarked) {
        super(elementsCanBeMarked, ElementsChooser.getMarkStateDescriptor());
    }

    public ElementsChooser(List<T> elements, boolean marked) {
        super(elements, marked, ElementsChooser.getMarkStateDescriptor());
    }

    public void addElementsMarkListener(ElementsMarkListener<T> listener2) {
        this.addElementsMarkListener(new ElementsMarkStateListenerAdapter<T>(listener2));
    }

    public void removeElementsMarkListener(ElementsMarkListener<T> listener2) {
        this.removeElementsMarkListener(new ElementsMarkStateListenerAdapter<T>(listener2));
    }

    @Override
    public void addElement(T element2, boolean isMarked) {
        this.addElement(element2, ElementsChooser.getMarkState(isMarked));
    }

    public boolean isElementMarked(T element2) {
        return (Boolean)this.getElementMarkState(element2);
    }

    public void setElementMarked(T element2, boolean marked) {
        this.setElementMarkState(element2, ElementsChooser.getMarkState(marked));
    }

    @Override
    public void addElement(T element2, boolean isMarked, MultiStateElementsChooser.ElementProperties elementProperties) {
        this.addElement(element2, ElementsChooser.getMarkState(isMarked), elementProperties);
    }

    @Override
    public void setElements(List<T> elements, boolean marked) {
        this.setElements(elements, ElementsChooser.getMarkState(marked));
    }

    public void markElements(Collection<T> elements) {
        this.markElements(elements, Boolean.TRUE);
    }

    @NotNull
    public List<T> getMarkedElements() {
        List<T> list2 = this.getElements(true);
        if (list2 == null) {
            ElementsChooser.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public List<T> getElements(boolean isMarked) {
        Map elementMarkStates = this.getElementMarkStates();
        ArrayList elements = new ArrayList();
        for (Map.Entry entry : elementMarkStates.entrySet()) {
            if ((Boolean)entry.getValue() != isMarked) continue;
            elements.add(entry.getKey());
        }
        ArrayList arrayList = elements;
        if (arrayList == null) {
            ElementsChooser.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public boolean hasUnmarkedElements() {
        Map elementMarkStates = this.getElementMarkStates();
        for (Map.Entry entry : elementMarkStates.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void invertSelection() {
        int count = this.getElementCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object type;
            this.setElementMarked(type, !this.isElementMarked(type = this.getElementAt(i2)));
        }
        this.myStatisticsCollectors.forEach(StatisticsCollector::selectionInverted);
    }

    @Override
    public void setAllElementsMarked(boolean marked) {
        this.setAllElementsMarked(ElementsChooser.getMarkState(marked));
        if (marked) {
            this.myStatisticsCollectors.forEach(StatisticsCollector::allSelected);
        } else {
            this.myStatisticsCollectors.forEach(StatisticsCollector::noneSelected);
        }
    }

    private static Boolean getMarkState(boolean marked) {
        return marked;
    }

    private static <T> MultiStateElementsChooser.MarkStateDescriptor<T, Boolean> getMarkStateDescriptor() {
        return MARK_STATE_DESCRIPTOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/ElementsChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkedElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ElementsMarkStateListenerAdapter<T>
    implements MultiStateElementsChooser.ElementsMarkStateListener<T, Boolean> {
        private final ElementsMarkListener<T> myListener;

        ElementsMarkStateListenerAdapter(ElementsMarkListener<T> listener2) {
            this.myListener = listener2;
        }

        @Override
        public void elementMarkChanged(T element2, Boolean markState) {
            this.myListener.elementMarkChanged(element2, markState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsMarkStateListenerAdapter that = (ElementsMarkStateListenerAdapter)o;
            return this.myListener.equals(that.myListener);
        }

        public int hashCode() {
            return this.myListener.hashCode();
        }
    }

    private static class BooleanMarkStateDescriptor<T>
    implements MultiStateElementsChooser.MarkStateDescriptor<T, Boolean> {
        private BooleanMarkStateDescriptor() {
        }

        @Override
        @NotNull
        public Boolean getDefaultState(@NotNull T element2) {
            if (element2 == null) {
                BooleanMarkStateDescriptor.$$$reportNull$$$0(0);
            }
            Boolean bl = Boolean.FALSE;
            if (bl == null) {
                BooleanMarkStateDescriptor.$$$reportNull$$$0(1);
            }
            return bl;
        }

        @Override
        @NotNull
        public Boolean getNextState(@NotNull T element2, @NotNull Boolean state) {
            if (element2 == null) {
                BooleanMarkStateDescriptor.$$$reportNull$$$0(2);
            }
            if (state == null) {
                BooleanMarkStateDescriptor.$$$reportNull$$$0(3);
            }
            Boolean bl = state == false;
            if (bl == null) {
                BooleanMarkStateDescriptor.$$$reportNull$$$0(4);
            }
            return bl;
        }

        @Override
        @Nullable
        public Boolean getNextState(@NotNull Map<T, Boolean> elementsWithStates) {
            Boolean state;
            if (elementsWithStates == null) {
                BooleanMarkStateDescriptor.$$$reportNull$$$0(5);
            }
            boolean currentlyMarked = true;
            Iterator<Boolean> iterator2 = elementsWithStates.values().iterator();
            while (iterator2.hasNext() && (currentlyMarked = (state = iterator2.next()).booleanValue())) {
            }
            return !currentlyMarked;
        }

        @Override
        public boolean isMarked(@NotNull Boolean state) {
            if (state == null) {
                BooleanMarkStateDescriptor.$$$reportNull$$$0(6);
            }
            return state;
        }

        @Override
        @Nullable
        public Boolean getMarkState(@Nullable Object value2) {
            return value2 instanceof Boolean ? (Boolean)value2 : null;
        }

        @Override
        @Nullable
        public TableCellRenderer getMarkRenderer() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/ElementsChooser$BooleanMarkStateDescriptor";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementsWithStates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/ElementsChooser$BooleanMarkStateDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultState";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultState";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getNextState";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isMarked";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface StatisticsCollector<T>
    extends ElementsMarkListener<T> {
        public void selectionInverted();

        public void allSelected();

        public void noneSelected();
    }

    public static interface ElementsMarkListener<T> {
        public void elementMarkChanged(T var1, boolean var2);
    }
}

