/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DirectoryUtil {
    private DirectoryUtil() {
    }

    public static PsiDirectory mkdirs(PsiManager manager2, String path) throws IncorrectOperationException {
        if (File.separatorChar != '/' && path.indexOf(File.separatorChar) != -1) {
            throw new IllegalArgumentException("separators must be '/'; path is " + path);
        }
        PsiDirectory directory = DirectoryUtil.findLongestExistingDirectory(manager2, path);
        if (directory == null) {
            return null;
        }
        String existingPath = directory.getVirtualFile().getPath();
        if (existingPath.equals(path)) {
            return directory;
        }
        String postfix = path.substring(existingPath.length() + 1);
        StringTokenizer tokenizer = new StringTokenizer(postfix, "/");
        while (tokenizer.hasMoreTokens()) {
            directory = directory.createSubdirectory(tokenizer.nextToken());
        }
        return directory;
    }

    @Nullable
    public static PsiDirectory findLongestExistingDirectory(@NotNull PsiManager manager2, @NotNull String path) {
        if (manager2 == null) {
            DirectoryUtil.$$$reportNull$$$0(0);
        }
        if (path == null) {
            DirectoryUtil.$$$reportNull$$$0(1);
        }
        PsiDirectory directory = null;
        while (path.length() > 0) {
            int index2;
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
            if (file2 != null) {
                directory = manager2.findDirectory(file2);
                if (directory != null) break;
                return null;
            }
            if (StringUtil.endsWithChar((CharSequence)path, (char)'/')) {
                path = path.substring(0, path.length() - 1);
                if (SystemInfo.isWindows && path.length() == 2 && path.charAt(1) == ':') {
                    return null;
                }
            }
            if ((index2 = path.lastIndexOf(47)) == -1) {
                return null;
            }
            path = path.substring(0, index2);
        }
        return directory;
    }

    public static PsiDirectory createSubdirectories(String subDirName, PsiDirectory baseDirectory, String delim) throws IncorrectOperationException {
        StringTokenizer tokenizer = new StringTokenizer(subDirName, delim);
        PsiDirectory dir = baseDirectory;
        boolean firstToken = true;
        while (tokenizer.hasMoreTokens()) {
            String dirName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                if (firstToken && "~".equals(dirName)) {
                    VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                    if (userHomeDir == null) {
                        throw new IncorrectOperationException("User home directory not found");
                    }
                    PsiDirectory directory1 = baseDirectory.getManager().findDirectory(userHomeDir);
                    if (directory1 == null) {
                        throw new IncorrectOperationException("User home directory not found");
                    }
                    dir = directory1;
                    continue;
                }
                if ("..".equals(dirName)) {
                    if ((dir = dir.getParentDirectory()) != null) continue;
                    throw new IncorrectOperationException("Not a valid directory");
                }
                if (".".equals(dirName)) continue;
                PsiDirectory existingDir = dir.findSubdirectory(dirName);
                if (existingDir != null) {
                    dir = existingDir;
                    continue;
                }
            }
            dir = dir.createSubdirectory(dirName);
            firstToken = false;
        }
        return dir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/DirectoryUtil";
        objectArray[2] = "findLongestExistingDirectory";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

