/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.DeleteUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.ui.IoErrorText;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeleteHandler {
    private DeleteHandler() {
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, Project project) {
        DeleteHandler.deletePsiElement(elementsToDelete, project, true);
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, final Project project, boolean needConfirmation) {
        if (elementsToDelete == null || elementsToDelete.length == 0) {
            return;
        }
        Object[] elements = PsiTreeUtil.filterAncestors((PsiElement[])elementsToDelete);
        boolean safeDeleteApplicable = ContainerUtil.and((Object[])elements, SafeDeleteProcessor::validElement);
        boolean dumb = DumbService.getInstance((Project)project).isDumb();
        if (safeDeleteApplicable && !dumb) {
            Ref exit = Ref.create((Object)false);
            SafeDeleteDialog dialog2 = new SafeDeleteDialog(project, (PsiElement[])elements, new SafeDeleteDialog.Callback((PsiElement[])elements, exit){
                final /* synthetic */ PsiElement[] val$elements;
                final /* synthetic */ Ref val$exit;
                {
                    this.val$elements = psiElementArray;
                    this.val$exit = ref;
                }

                @Override
                public void run(SafeDeleteDialog dialog2) {
                    if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(this.val$elements), (boolean)true)) {
                        return;
                    }
                    SafeDeleteProcessor processor2 = SafeDeleteProcessor.createInstance(project, () -> {
                        this.val$exit.set((Object)true);
                        dialog2.close(0);
                    }, this.val$elements, dialog2.isSearchInComments(), dialog2.isSearchForTextOccurences(), true);
                    processor2.run();
                }
            }){

                @Override
                protected boolean isDelete() {
                    return true;
                }
            };
            if (needConfirmation) {
                dialog2.setTitle(RefactoringBundle.message((String)"delete.title"));
                if (!dialog2.showAndGet() || ((Boolean)exit.get()).booleanValue()) {
                    return;
                }
            }
        } else {
            int result2;
            Object warningMessage = DeleteUtil.generateWarningMessage("prompt.delete.elements", (PsiElement[])elements);
            boolean anyDirectories = false;
            String directoryName = null;
            for (PsiElement psiElement : elementsToDelete) {
                if (!(psiElement instanceof PsiDirectory) || PsiUtilBase.isSymLink((PsiFileSystemItem)((PsiDirectory)psiElement))) continue;
                anyDirectories = true;
                directoryName = ((PsiDirectory)psiElement).getName();
                break;
            }
            if (anyDirectories) {
                warningMessage = elements.length == 1 ? (String)warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories", (Object[])new Object[]{directoryName}) : (String)warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories.in.the.selected.directory", (Object[])new Object[0]);
            }
            if (safeDeleteApplicable) {
                warningMessage = (String)warningMessage + LangBundle.message((String)"dialog.message.warning.safe.delete.not.available.while.updates.indices.no.usages.will.be.checked", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
            }
            if (needConfirmation && (result2 = Messages.showOkCancelDialog((Project)project, (String)warningMessage, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) != 0) {
                return;
            }
        }
        DeleteHandler.deleteInCommand(project, (PsiElement[])elements);
    }

    private static boolean makeWritable(Project project, PsiElement[] elements) {
        SmartList directories = new SmartList();
        for (PsiElement e : elements) {
            if (!(e instanceof PsiFileSystemItem) || e.getParent() == null) continue;
            directories.add(e.getParent());
        }
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)project, Arrays.asList(elements), (Collection)directories, (boolean)false);
    }

    private static void deleteInCommand(Project project, PsiElement[] elements) {
        CommandProcessor.getInstance().executeCommand(project, () -> NonProjectFileWritingAccessProvider.disableChecksDuring(() -> {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
            List pointers2 = ContainerUtil.map((Object[])elements, arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0));
            if (!DeleteHandler.makeWritable(project, elements)) {
                return;
            }
            DataContext context = DataManager.getInstance().getDataContext();
            if (CommonDataKeys.EDITOR.getData(context) == null) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            }
            if (ContainerUtil.and((Object[])elements, DeleteHandler::isLocalFile)) {
                DeleteHandler.doDeleteFiles(project, elements);
            } else {
                for (SmartPsiElementPointer pointer : pointers2) {
                    PsiElement elementToDelete = pointer.getElement();
                    if (elementToDelete == null) continue;
                    DeleteHandler.doDelete(project, elementToDelete);
                }
            }
        }), RefactoringBundle.message((String)"safe.delete.command", (Object[])new Object[]{RefactoringUIUtil.calculatePsiElementDescriptionList(elements)}), null);
    }

    private static boolean isLocalFile(PsiElement e) {
        VirtualFile file2;
        return e instanceof PsiFileSystemItem && (file2 = ((PsiFileSystemItem)e).getVirtualFile()) != null && file2.isInLocalFileSystem();
    }

    private static boolean clearFileReadOnlyFlags(Project project, PsiElement elementToDelete) {
        VirtualFile virtualFile;
        PsiFile file2;
        if (elementToDelete instanceof PsiDirectory) {
            VirtualFile virtualFile2 = ((PsiDirectory)elementToDelete).getVirtualFile();
            if (virtualFile2.isInLocalFileSystem() && !virtualFile2.is(VFileProperty.SYMLINK)) {
                ArrayList readOnlyFiles = new ArrayList();
                CommonRefactoringUtil.collectReadOnlyFiles((VirtualFile)virtualFile2, readOnlyFiles);
                if (!readOnlyFiles.isEmpty()) {
                    VirtualFile file3;
                    String message2 = IdeBundle.message((String)"prompt.directory.contains.read.only.files", (Object[])new Object[]{virtualFile2.getPresentableUrl()});
                    int _result = Messages.showYesNoDialog((Project)project, (String)message2, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (_result != 0) {
                        return false;
                    }
                    boolean success2 = true;
                    Iterator iterator2 = readOnlyFiles.iterator();
                    while (iterator2.hasNext() && (success2 = DeleteHandler.clearReadOnlyFlag(file3 = (VirtualFile)iterator2.next(), project))) {
                    }
                    if (!success2) {
                        return false;
                    }
                }
            }
        } else if (!(elementToDelete.isWritable() || elementToDelete instanceof PsiFileSystemItem && PsiUtilBase.isSymLink((PsiFileSystemItem)((PsiFileSystemItem)elementToDelete)) || (file2 = elementToDelete.getContainingFile()) == null || !(virtualFile = file2.getVirtualFile()).isInLocalFileSystem())) {
            int _result = ((MessagesEx.MessageInfo)((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly(project, virtualFile).setTitle(IdeBundle.message((String)"title.delete", (Object[])new Object[0]))).appendMessage(" " + IdeBundle.message((String)"prompt.delete.it.anyway", (Object[])new Object[0]))).askYesNo();
            if (_result != 0) {
                return false;
            }
            boolean success3 = DeleteHandler.clearReadOnlyFlag(virtualFile, project);
            if (!success3) {
                return false;
            }
        }
        return true;
    }

    private static void doDelete(Project project, PsiElement element2) {
        if (!DeleteHandler.clearFileReadOnlyFlags(project, element2)) {
            return;
        }
        try {
            element2.checkDelete();
        }
        catch (IncorrectOperationException e) {
            Messages.showMessageDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                element2.delete();
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon()));
            }
        });
    }

    private static void doDeleteFiles(Project project, PsiElement[] fileElements) {
        for (PsiElement file2 : fileElements) {
            if (DeleteHandler.clearFileReadOnlyFlags(project, file2)) continue;
            return;
        }
        LocalFilesDeleteTask task2 = new LocalFilesDeleteTask(project, fileElements);
        ProgressManager.getInstance().run((Task)task2);
        if (task2.error != null) {
            String file3;
            String string = file3 = task2.error instanceof FileSystemException ? ((FileSystemException)task2.error).getFile() : null;
            if (file3 != null) {
                String message2 = IoErrorText.message((Throwable)task2.error);
                String yes = RevealFileAction.getActionName();
                String no = CommonBundle.getCloseButtonText();
                if (Messages.showYesNoDialog((Project)project, (String)message2, (String)CommonBundle.getErrorTitle(), (String)yes, (String)no, (Icon)Messages.getErrorIcon()) == 0) {
                    RevealFileAction.openFile(Paths.get(file3, new String[0]));
                }
            } else {
                Messages.showMessageDialog((Project)project, (String)IoErrorText.message((Throwable)task2.error), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            }
        }
        if (task2.aborted != null) {
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{task2.aborted});
        }
        if (!task2.processed.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (PsiElement fileElement : task2.processed) {
                    try {
                        fileElement.delete();
                    }
                    catch (IncorrectOperationException e) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon()));
                    }
                }
            });
        }
    }

    private static boolean clearReadOnlyFlag(VirtualFile virtualFile, Project project) {
        boolean[] success2 = new boolean[1];
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable action2 = () -> {
                try {
                    ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)virtualFile, (boolean)false);
                    success2[0] = true;
                }
                catch (IOException e1) {
                    Messages.showMessageDialog((Project)project, (String)e1.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                }
            };
            ApplicationManager.getApplication().runWriteAction(action2);
        }, "", null);
        return success2[0];
    }

    public static boolean shouldEnableDeleteAction(PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (PsiElement element2 : elements) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
            if (virtualFile == null || virtualFile instanceof LightVirtualFile) {
                return false;
            }
            if (WritingAccessProvider.isPotentiallyWritable((VirtualFile)virtualFile, (Project)element2.getProject())) continue;
            return false;
        }
        return true;
    }

    private static class LocalFilesDeleteTask
    extends Task.Modal {
        private final PsiElement[] myFileElements;
        List<PsiElement> processed = new ArrayList<PsiElement>();
        VirtualFile aborted = null;
        Throwable error = null;

        LocalFilesDeleteTask(Project project, PsiElement[] fileElements) {
            super(project, IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]), true);
            this.myFileElements = fileElements;
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                LocalFilesDeleteTask.$$$reportNull$$$0(0);
            }
            indicator.setIndeterminate(true);
            try {
                for (PsiElement e : this.myFileElements) {
                    if (!indicator.isCanceled()) {
                        VirtualFile file2;
                        this.aborted = file2 = ((PsiFileSystemItem)e).getVirtualFile();
                        final Path path = file2.toNioPath();
                        indicator.setText(path.toString());
                        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                if (SystemInfo.isWindows && attrs.isOther()) {
                                    this.visitFile(dir, (BasicFileAttributes)null);
                                    return FileVisitResult.SKIP_SUBTREE;
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file2, @Nullable BasicFileAttributes attrs) throws IOException {
                                indicator.setText2(path.relativize(file2).toString());
                                Files.delete(file2);
                                return indicator.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                return this.visitFile(dir, (BasicFileAttributes)null);
                            }
                        });
                        if (indicator.isCanceled()) continue;
                        this.processed.add(e);
                        this.aborted = null;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                Logger.getInstance(((Object)((Object)this)).getClass()).info(t);
                this.error = t;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/DeleteHandler$LocalFilesDeleteTask", "run"));
        }
    }

    public static class DefaultDeleteProvider
    implements DeleteProvider {
        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                DefaultDeleteProvider.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.PROJECT.getData(dataContext) == null) {
                return false;
            }
            PsiElement[] elements = DefaultDeleteProvider.getPsiElements(dataContext);
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        private static PsiElement @Nullable [] getPsiElements(DataContext dataContext) {
            PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
            if (elements == null) {
                PsiElement data2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                if (data2 != null) {
                    elements = new PsiElement[]{data2};
                } else {
                    PsiFile data1 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
                    if (data1 != null) {
                        elements = new PsiElement[]{data1};
                    }
                }
            }
            return elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            PsiElement[] elements;
            if (dataContext == null) {
                DefaultDeleteProvider.$$$reportNull$$$0(1);
            }
            if ((elements = DefaultDeleteProvider.getPsiElements(dataContext)) == null) {
                return;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return;
            }
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, project);
            }
            finally {
                a.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/ide/util/DeleteHandler$DefaultDeleteProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

