/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.TraverseUIHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.EdtInvocationManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TraverseUIStarter
implements ApplicationStarter {
    @NonNls
    private static final String OPTIONS = "options";
    @NonNls
    private static final String CONFIGURABLE = "configurable";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String CONFIGURABLE_NAME = "configurable_name";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String HIT = "hit";
    private static final String ROOT_ACTION_MODULE = "intellij.platform.ide";
    private String OUTPUT_PATH;
    private boolean SPLIT_BY_RESOURCE_PATH;

    public String getCommandName() {
        return "traverseUI";
    }

    public int getRequiredModality() {
        return 3;
    }

    public void premain(@NotNull List<String> args) {
        if (args == null) {
            TraverseUIStarter.$$$reportNull$$$0(0);
        }
        this.OUTPUT_PATH = args.get(1);
        this.SPLIT_BY_RESOURCE_PATH = args.size() > 2 && Boolean.parseBoolean(args.get(2));
    }

    public void main(@NotNull List<String> args) {
        if (args == null) {
            TraverseUIStarter.$$$reportNull$$$0(1);
        }
        System.out.println("Starting searchable options index builder");
        try {
            TraverseUIStarter.startup(Path.of(this.OUTPUT_PATH, new String[0]), this.SPLIT_BY_RESOURCE_PATH);
            ApplicationManagerEx.getApplicationEx().exit(3);
            System.out.println("Searchable options index builder completed");
        }
        catch (Throwable e) {
            System.out.println("Searchable options index builder failed");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(@NotNull Path outputPath, boolean splitByResourcePath) throws IOException {
        if (outputPath == null) {
            TraverseUIStarter.$$$reportNull$$$0(2);
        }
        LinkedHashMap options2 = new LinkedHashMap();
        HashMap<String, Element> roots = new HashMap<String, Element>();
        try {
            EdtInvocationManager.invokeAndWaitIfNeeded(() -> {
                for (TraverseUIHelper extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                    extension2.beforeStart();
                }
                SearchUtil.processConfigurables(ShowSettingsUtilImpl.getConfigurables(ProjectManager.getInstance().getDefaultProject(), true), options2);
                for (TraverseUIHelper extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
                    extension2.afterTraversal(options2);
                }
            });
            System.out.println("Found " + options2.size() + " configurables");
            for (SearchableConfigurable configurable2 : options2.keySet()) {
                Element entryElement;
                Object wrapped;
                Element configurableElement = TraverseUIStarter.createConfigurableElement(configurable2);
                TraverseUIStarter.writeOptions(configurableElement, (Set)options2.get(configurable2));
                if (configurable2 instanceof ConfigurableWrapper && (wrapped = ((ConfigurableWrapper)configurable2).getConfigurable()) instanceof SearchableConfigurable) {
                    configurable2 = (SearchableConfigurable)wrapped;
                }
                if (configurable2 instanceof KeymapPanel) {
                    wrapped = TraverseUIStarter.processKeymap(splitByResourcePath).entrySet().iterator();
                    while (wrapped.hasNext()) {
                        Map.Entry entry = (Map.Entry)wrapped.next();
                        entryElement = TraverseUIStarter.createConfigurableElement(configurable2);
                        TraverseUIStarter.writeOptions(entryElement, (Set)entry.getValue());
                        TraverseUIStarter.addElement(roots, entryElement, (String)entry.getKey());
                    }
                } else if (configurable2 instanceof OptionsContainingConfigurable) {
                    TraverseUIStarter.processOptionsContainingConfigurable((OptionsContainingConfigurable)configurable2, configurableElement);
                } else if (configurable2 instanceof PluginManagerConfigurable) {
                    TreeSet optionDescriptions = new TreeSet();
                    TraverseUIStarter.wordsToOptionDescriptors(Collections.singleton(IdeBundle.message((String)"plugin.manager.repositories", (Object[])new Object[0])), null, optionDescriptions);
                    Iterator iterator2 = optionDescriptions.iterator();
                    while (iterator2.hasNext()) {
                        OptionDescription description = (OptionDescription)iterator2.next();
                        configurableElement.addContent(TraverseUIStarter.createOptionElement(null, IdeBundle.message((String)"plugin.manager.repositories", (Object[])new Object[0]), description.getOption()));
                    }
                } else if (configurable2 instanceof AllFileTemplatesConfigurable) {
                    for (Map.Entry entry : TraverseUIStarter.processFileTemplates(splitByResourcePath).entrySet()) {
                        entryElement = TraverseUIStarter.createConfigurableElement(configurable2);
                        TraverseUIStarter.writeOptions(entryElement, (Set)entry.getValue());
                        TraverseUIStarter.addElement(roots, entryElement, (String)entry.getKey());
                    }
                }
                String module = splitByResourcePath ? TraverseUIStarter.getModuleByClass(configurable2.getOriginalClass()) : "";
                TraverseUIStarter.addElement(roots, configurableElement, module);
            }
        }
        finally {
            EdtInvocationManager.invokeAndWaitIfNeeded(() -> {
                for (SearchableConfigurable configurable2 : options2.keySet()) {
                    configurable2.disposeUIResources();
                }
            });
        }
        TraverseUIStarter.saveResults(outputPath, roots);
    }

    private static void saveResults(@NotNull Path outputPath, Map<String, Element> roots) throws IOException {
        if (outputPath == null) {
            TraverseUIStarter.$$$reportNull$$$0(3);
        }
        for (Map.Entry<String, Element> entry : roots.entrySet()) {
            Path output2;
            String module = entry.getKey();
            if (module.isEmpty()) {
                output2 = outputPath.resolve("searchableOptions.xml");
            } else {
                Path moduleDir = outputPath.resolve(module);
                Files.deleteIfExists(moduleDir.resolve("classpath.index"));
                output2 = moduleDir.resolve("search/" + module + ".searchableOptions.xml");
            }
            JDOMUtil.write((Element)entry.getValue(), (Path)output2);
        }
        for (TraverseUIHelper extension2 : TraverseUIHelper.helperExtensionPoint.getExtensionList()) {
            extension2.afterResultsAreSaved();
        }
    }

    @NotNull
    private static Element createConfigurableElement(@NotNull SearchableConfigurable configurable2) {
        if (configurable2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(4);
        }
        Element configurableElement = new Element(CONFIGURABLE);
        configurableElement.setAttribute(ID, configurable2.getId());
        configurableElement.setAttribute(CONFIGURABLE_NAME, configurable2.getDisplayName());
        Element element2 = configurableElement;
        if (element2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(5);
        }
        return element2;
    }

    private static void addElement(@NotNull Map<String, Element> roots, @NotNull Element element2, @NotNull String module) {
        if (roots == null) {
            TraverseUIStarter.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(7);
        }
        if (module == null) {
            TraverseUIStarter.$$$reportNull$$$0(8);
        }
        roots.computeIfAbsent(module, __ -> new Element(OPTIONS)).addContent(element2);
    }

    @NotNull
    private static Map<String, Set<OptionDescription>> processFileTemplates(boolean splitByResourcePath) {
        SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        HashMap<String, Set<OptionDescription>> options2 = new HashMap<String, Set<OptionDescription>>();
        FileTemplateManager fileTemplateManager = FileTemplateManager.getDefaultInstance();
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllTemplates(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllPatterns(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllCodeTemplates(), splitByResourcePath);
        TraverseUIStarter.processTemplates(optionsRegistrar, options2, fileTemplateManager.getAllJ2eeTemplates(), splitByResourcePath);
        HashMap<String, Set<OptionDescription>> hashMap = options2;
        if (hashMap == null) {
            TraverseUIStarter.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    private static void processTemplates(SearchableOptionsRegistrar registrar, Map<String, Set<OptionDescription>> options2, FileTemplate[] templates, boolean splitByResourcePath) {
        for (FileTemplate template : templates) {
            String module = splitByResourcePath && template instanceof BundledFileTemplate ? TraverseUIStarter.getModuleByTemplate((BundledFileTemplate)template) : "";
            TraverseUIStarter.collectOptions(registrar, options2.computeIfAbsent(module, __ -> new TreeSet()), template.getName(), null);
        }
    }

    @NotNull
    private static String getModuleByTemplate(@NotNull BundledFileTemplate template) {
        if (template == null) {
            TraverseUIStarter.$$$reportNull$$$0(10);
        }
        String url = template.toString();
        String path = StringUtil.substringBefore((String)url, (String)"fileTemplates");
        assert (path != null) : "Template URL doesn't contain 'fileTemplates' directory.";
        if (path.startsWith("jar")) {
            path = StringUtil.trimEnd((String)path, (String)"!/");
        }
        String string = PathUtil.getFileName((String)path);
        if (string == null) {
            TraverseUIStarter.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static void collectOptions(SearchableOptionsRegistrar registrar, Set<? super OptionDescription> options2, @NotNull String text2, String path) {
        if (text2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(12);
        }
        for (String word : registrar.getProcessedWordsWithoutStemming(text2)) {
            options2.add((OptionDescription)new OptionDescription(word, text2, path));
        }
    }

    private static void processOptionsContainingConfigurable(OptionsContainingConfigurable configurable2, Element configurableElement) {
        Set<String> optionsPath = configurable2.processListOptions();
        TreeSet<OptionDescription> result2 = new TreeSet<OptionDescription>();
        TraverseUIStarter.wordsToOptionDescriptors(optionsPath, null, result2);
        Map<String, Set<String>> optionsWithPaths = configurable2.processListOptionsWithPaths();
        for (String path : optionsWithPaths.keySet()) {
            TraverseUIStarter.wordsToOptionDescriptors(optionsWithPaths.get(path), path, result2);
        }
        TraverseUIStarter.writeOptions(configurableElement, result2);
    }

    private static void wordsToOptionDescriptors(@NotNull Set<String> optionsPath, @Nullable String path, @NotNull Set<OptionDescription> result2) {
        if (optionsPath == null) {
            TraverseUIStarter.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(14);
        }
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        for (String opt : optionsPath) {
            for (String word : registrar.getProcessedWordsWithoutStemming(opt)) {
                if (word == null) continue;
                result2.add(new OptionDescription(word, opt, path));
            }
        }
    }

    @NotNull
    private static Map<String, Set<OptionDescription>> processKeymap(boolean splitByResourcePath) {
        HashMap<String, Set<OptionDescription>> map2 = new HashMap<String, Set<OptionDescription>>();
        ActionManagerImpl actionManager = (ActionManagerImpl)ActionManager.getInstance();
        Map<String, Object> actionToPluginId = splitByResourcePath ? TraverseUIStarter.getActionToPluginId() : Collections.emptyMap();
        String componentName = "ActionManager";
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (String id2 : actionManager.getActionIds()) {
            String description;
            AnAction action2 = actionManager.getAction(id2);
            if (action2 == null) {
                throw new IllegalStateException("Cannot find action by id " + id2);
            }
            String module = splitByResourcePath ? TraverseUIStarter.getModuleByAction(action2, actionToPluginId) : "";
            Set options2 = map2.computeIfAbsent(module, __ -> new TreeSet());
            String text2 = action2.getTemplatePresentation().getText();
            if (text2 != null) {
                TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options2, text2, componentName);
            }
            if ((description = action2.getTemplatePresentation().getDescription()) == null) continue;
            TraverseUIStarter.collectOptions(searchableOptionsRegistrar, options2, description, componentName);
        }
        HashMap<String, Set<OptionDescription>> hashMap = map2;
        if (hashMap == null) {
            TraverseUIStarter.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, PluginId> getActionToPluginId() {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        HashMap<String, PluginId> actionToPluginId = new HashMap<String, PluginId>();
        for (PluginId id2 : PluginId.getRegisteredIdList()) {
            for (String action2 : actionManager.getPluginActions(id2)) {
                actionToPluginId.put(action2, id2);
            }
        }
        HashMap<String, PluginId> hashMap = actionToPluginId;
        if (hashMap == null) {
            TraverseUIStarter.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    @NotNull
    private static String getModuleByAction(@NotNull AnAction rootAction, @NotNull Map<String, PluginId> actionToPluginId) {
        IdeaPluginDescriptor plugin2;
        if (rootAction == null) {
            TraverseUIStarter.$$$reportNull$$$0(17);
        }
        if (actionToPluginId == null) {
            TraverseUIStarter.$$$reportNull$$$0(18);
        }
        ArrayDeque<AnAction> actions = new ArrayDeque<AnAction>();
        actions.add(rootAction);
        while (!actions.isEmpty()) {
            AnAction action2 = (AnAction)actions.remove();
            String module = TraverseUIStarter.getModuleByClass(action2.getClass());
            if (!ROOT_ACTION_MODULE.equals(module)) {
                String string = module;
                if (string == null) {
                    TraverseUIStarter.$$$reportNull$$$0(19);
                }
                return string;
            }
            if (!(action2 instanceof ActionGroup)) continue;
            Collections.addAll(actions, ((ActionGroup)action2).getChildren(null));
        }
        ActionManager actionManager = ActionManager.getInstance();
        PluginId id2 = actionToPluginId.get(actionManager.getId(rootAction));
        if (id2 != null && (plugin2 = PluginManagerCore.getPlugin(id2)) != null && !plugin2.getName().equals("IDEA CORE")) {
            String string = PathUtil.getFileName((String)plugin2.getPluginPath().toString());
            if (string == null) {
                TraverseUIStarter.$$$reportNull$$$0(20);
            }
            return string;
        }
        return ROOT_ACTION_MODULE;
    }

    @NotNull
    private static String getModuleByClass(@NotNull Class<?> aClass) {
        if (aClass == null) {
            TraverseUIStarter.$$$reportNull$$$0(21);
        }
        String string = PathUtil.getFileName((String)PathUtil.getJarPathForClass(aClass));
        if (string == null) {
            TraverseUIStarter.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static void writeOptions(@NotNull Element configurableElement, @NotNull Set<? extends OptionDescription> options2) {
        if (configurableElement == null) {
            TraverseUIStarter.$$$reportNull$$$0(23);
        }
        if (options2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(24);
        }
        for (OptionDescription optionDescription : options2) {
            configurableElement.addContent(TraverseUIStarter.createOptionElement(optionDescription.getPath(), optionDescription.getHit(), optionDescription.getOption()));
        }
    }

    @NotNull
    private static Element createOptionElement(String path, String hit, String word) {
        Element optionElement = new Element(OPTION);
        optionElement.setAttribute(NAME, word);
        if (path != null) {
            optionElement.setAttribute(PATH, path);
        }
        optionElement.setAttribute(HIT, hit);
        Element element2 = optionElement;
        if (element2 == null) {
            TraverseUIStarter.$$$reportNull$$$0(25);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = CONFIGURABLE;
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/search/TraverseUIStarter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootAction";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToPluginId";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableElement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = OPTIONS;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/search/TraverseUIStarter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurableElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "processFileTemplates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleByTemplate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processKeymap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionToPluginId";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleByAction";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleByClass";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "premain";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "main";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveResults";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurableElement";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByTemplate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectOptions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wordsToOptionDescriptors";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByAction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByClass";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "writeOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

