/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.ConfigurableHit;
import com.intellij.ide.ui.search.IndexedCharsInterner;
import com.intellij.ide.ui.search.MySearchableOptionProcessor;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.CollectConsumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import kotlin.Pair;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchableOptionsRegistrarImpl
extends SearchableOptionsRegistrar {
    private static final ExtensionPointName<SearchableOptionContributor> EP_NAME = new ExtensionPointName("com.intellij.search.optionContributor");
    private volatile Map<CharSequence, long[]> storage = Collections.emptyMap();
    private final Set<String> stopWords;
    @NotNull
    private volatile Map<Pair<String, String>, Set<String>> highlightOptionToSynonym = Collections.emptyMap();
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private volatile IndexedCharsInterner identifierTable = new IndexedCharsInterner();
    private static final Logger LOG = Logger.getInstance(SearchableOptionsRegistrarImpl.class);
    @NonNls
    private static final Pattern REG_EXP = Pattern.compile("[\\W&&[^-]]+");

    public SearchableOptionsRegistrarImpl() {
        Application app = ApplicationManager.getApplication();
        if (app.isCommandLine() || app.isHeadlessEnvironment()) {
            this.stopWords = Collections.emptySet();
            return;
        }
        this.stopWords = SearchableOptionsRegistrarImpl.loadStopWords();
        app.getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                SearchableOptionsRegistrarImpl.this.dropStorage();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                SearchableOptionsRegistrarImpl.this.dropStorage();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static Set<String> loadStopWords() {
        HashSet<String> hashSet;
        try {
            InputStream stream = ResourceUtil.getResourceAsStream((ClassLoader)SearchableOptionsRegistrarImpl.class.getClassLoader(), (String)"search", (String)"ignore.txt");
            if (stream == null) {
                throw new IOException("Broken installation: IDE does not provide /search/ignore.txt");
            }
            HashSet<String> result2 = new HashSet<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    result2.add(line);
                }
            }
            hashSet = result2;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                SearchableOptionsRegistrarImpl.$$$reportNull$$$0(1);
            }
            return set2;
        }
        if (hashSet == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private synchronized void dropStorage() {
        this.storage = Collections.emptyMap();
        this.isInitialized.set(false);
    }

    public boolean isInitialized() {
        return this.isInitialized.get();
    }

    @ApiStatus.Internal
    public void initialize() {
        if (!this.isInitialized.compareAndSet(false, true)) {
            return;
        }
        MySearchableOptionProcessor processor2 = new MySearchableOptionProcessor(this.stopWords);
        EP_NAME.forEachExtensionSafe(contributor -> contributor.processOptions((SearchableOptionProcessor)processor2));
        this.highlightOptionToSynonym = processor2.computeHighlightOptionToSynonym();
        this.storage = processor2.getStorage();
        this.identifierTable = processor2.getIdentifierTable();
    }

    static void processSearchableOptions(@NotNull Predicate<? super String> fileNameFilter2, @NotNull BiConsumer<? super String, ? super Element> consumer2) {
        if (fileNameFilter2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(3);
        }
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        MethodType methodType = MethodType.methodType(Void.TYPE, String.class, Predicate.class, BiConsumer.class);
        MethodHandles.Lookup lookup2 = MethodHandles.lookup();
        HashMap<Class, MethodHandle> handleCache = new HashMap<Class, MethodHandle>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : PluginManagerCore.getLoadedPlugins()) {
            MethodHandle methodHandle;
            ClassLoader classLoader = ideaPluginDescriptor.getPluginClassLoader();
            if (!visited.add(classLoader)) continue;
            Class<?> loaderClass = classLoader.getClass();
            if (loaderClass.isAnonymousClass() || loaderClass.isMemberClass()) {
                loaderClass = loaderClass.getSuperclass();
            }
            try {
                methodHandle = handleCache.computeIfAbsent(loaderClass, aClass -> {
                    try {
                        return lookup2.findVirtual((Class<?>)aClass, "processResources", methodType);
                    }
                    catch (IllegalAccessException | NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    LOG.error(loaderClass + " is not supported", (Throwable)e);
                    continue;
                }
                LOG.error((Throwable)e);
                continue;
            }
            try {
                methodHandle.invoke(classLoader, "search", fileNameFilter2, (name, stream) -> {
                    try {
                        consumer2.accept((String)name, (Element)JDOMUtil.load((InputStream)stream));
                    }
                    catch (IOException | JDOMException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Throwable throwable) {
                ExceptionUtil.rethrow((Throwable)throwable);
            }
        }
    }

    static long pack(@NotNull String id2, @Nullable String hit, @Nullable String path, @Nullable String groupName, @NotNull IndexedCharsInterner identifierTable) {
        long _groupName;
        if (id2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(4);
        }
        if (identifierTable == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(5);
        }
        long _id = identifierTable.toId(id2.trim());
        long _hit = hit == null ? 32767L : (long)identifierTable.toId(hit.trim());
        long _path = path == null ? 32767L : (long)identifierTable.toId(path.trim());
        long l = _groupName = groupName == null ? 32767L : (long)identifierTable.toId(groupName.trim());
        assert (_id >= 0L && _id < 32767L);
        assert (_hit >= 0L && _hit <= 32767L);
        assert (_path >= 0L && _path <= 32767L);
        assert (_groupName >= 0L && _groupName <= 32767L);
        return _groupName << 48 | _id << 32 | _hit << 16 | _path;
    }

    private OptionDescription unpack(long data2) {
        int _groupName = (int)(data2 >> 48 & 0xFFFFL);
        int _id = (int)(data2 >> 32 & 0xFFFFL);
        int _hit = (int)(data2 >> 16 & 0xFFFFL);
        int _path = (int)(data2 & 0xFFFFL);
        assert (_id < Short.MAX_VALUE);
        assert (_hit <= Short.MAX_VALUE);
        assert (_path <= Short.MAX_VALUE);
        assert (_groupName <= Short.MAX_VALUE);
        String groupName = _groupName == Short.MAX_VALUE ? null : this.identifierTable.fromId(_groupName).toString();
        String configurableId = this.identifierTable.fromId(_id).toString();
        String hit = _hit == Short.MAX_VALUE ? null : this.identifierTable.fromId(_hit).toString();
        String path = _path == Short.MAX_VALUE ? null : this.identifierTable.fromId(_path).toString();
        return new OptionDescription(null, configurableId, hit, path, groupName);
    }

    @NotNull
    public ConfigurableHit getConfigurables(@NotNull List<? extends ConfigurableGroup> groups2, DocumentEvent.EventType type, @Nullable Set<? extends Configurable> configurables, @NotNull String option2, @Nullable Project project) {
        if (groups2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(6);
        }
        if (option2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(7);
        }
        return this.findConfigurables(groups2, type, configurables, option2, project);
    }

    @NotNull
    private ConfigurableHit findConfigurables(@NotNull List<? extends ConfigurableGroup> groups2, DocumentEvent.EventType type, @Nullable Collection<Configurable> configurables, @NotNull String option2, @Nullable Project project) {
        HashSet<Configurable> currentConfigurables;
        Collection<Configurable> effectiveConfigurables;
        if (groups2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(8);
        }
        if (option2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(9);
        }
        if (ContainerUtil.isEmpty(configurables)) {
            configurables = null;
        }
        if (configurables == null) {
            effectiveConfigurables = new LinkedHashSet<Configurable>();
            CollectConsumer consumer2 = new CollectConsumer(effectiveConfigurables);
            for (ConfigurableGroup configurableGroup : groups2) {
                SearchUtil.processExpandedGroups(configurableGroup, (Consumer<? super Configurable>)consumer2);
            }
        } else {
            effectiveConfigurables = configurables;
        }
        String optionToCheck = StringUtil.toLowerCase((String)option2.trim());
        Set<String> options2 = this.getProcessedWordsWithoutStemming(optionToCheck);
        LinkedHashSet<Configurable> linkedHashSet = new LinkedHashSet<Configurable>();
        LinkedHashSet<Configurable> nameFullHits = new LinkedHashSet<Configurable>();
        for (Configurable each : effectiveConfigurables) {
            if (each.getDisplayName() == null) continue;
            String displayName = StringUtil.toLowerCase((String)each.getDisplayName());
            List allWords = StringUtil.getWordsIn((String)displayName);
            if (displayName.contains(optionToCheck)) {
                nameFullHits.add(each);
                linkedHashSet.add(each);
            }
            Iterator iterator2 = allWords.iterator();
            while (iterator2.hasNext()) {
                String eachWord = (String)iterator2.next();
                if (!eachWord.startsWith(optionToCheck)) continue;
                linkedHashSet.add(each);
                break;
            }
            if (!options2.isEmpty()) continue;
            linkedHashSet.add(each);
            nameFullHits.add(each);
        }
        HashSet<Configurable> hashSet = currentConfigurables = type == DocumentEvent.EventType.CHANGE ? new HashSet<Configurable>(effectiveConfigurables) : null;
        if (options2.isEmpty()) {
            String[] components = REG_EXP.split(optionToCheck);
            if (components.length > 0) {
                Collections.addAll(options2, components);
            } else {
                options2.add(option2);
            }
        }
        LinkedHashSet<Configurable> contentHits = configurables == null ? (LinkedHashSet<Configurable>)effectiveConfigurables : new LinkedHashSet<Configurable>(effectiveConfigurables);
        HashSet<String> helpIds = null;
        for (String opt : options2) {
            Set<OptionDescription> optionIds = this.getAcceptableDescriptions(opt);
            if (optionIds == null) {
                contentHits.clear();
                return new ConfigurableHit(linkedHashSet, nameFullHits, contentHits);
            }
            HashSet<String> ids = new HashSet<String>();
            for (OptionDescription id2 : optionIds) {
                ids.add(id2.getConfigurableId());
            }
            if (helpIds == null) {
                helpIds = ids;
            }
            helpIds.retainAll(ids);
        }
        if (helpIds != null) {
            Iterator it = contentHits.iterator();
            while (it.hasNext()) {
                Configurable configurable2 = (Configurable)it.next();
                boolean needToRemove = true;
                if (configurable2 instanceof SearchableConfigurable && helpIds.contains(((SearchableConfigurable)configurable2).getId())) {
                    needToRemove = false;
                }
                if (configurable2 instanceof SearchableConfigurable.Merged) {
                    List mergedConfigurables = ((SearchableConfigurable.Merged)configurable2).getMergedConfigurables();
                    for (Configurable mergedConfigurable : mergedConfigurables) {
                        if (!(mergedConfigurable instanceof SearchableConfigurable) || !helpIds.contains(((SearchableConfigurable)mergedConfigurable).getId())) continue;
                        needToRemove = false;
                        break;
                    }
                }
                if (!needToRemove) continue;
                it.remove();
            }
        }
        if (type == DocumentEvent.EventType.CHANGE && configurables != null && currentConfigurables.equals(contentHits)) {
            ConfigurableHit configurableHit = this.getConfigurables(groups2, DocumentEvent.EventType.CHANGE, null, option2, project);
            if (configurableHit == null) {
                SearchableOptionsRegistrarImpl.$$$reportNull$$$0(10);
            }
            return configurableHit;
        }
        return new ConfigurableHit(linkedHashSet, nameFullHits, contentHits);
    }

    @Nullable
    public synchronized Set<OptionDescription> getAcceptableDescriptions(@Nullable String prefix) {
        if (prefix == null) {
            return null;
        }
        String stemmedPrefix = PorterStemmerUtil.stem(prefix);
        if (StringUtil.isEmptyOrSpaces((String)stemmedPrefix)) {
            return null;
        }
        this.initialize();
        HashSet<OptionDescription> result2 = null;
        for (Map.Entry<CharSequence, long[]> entry : this.storage.entrySet()) {
            String stemmedOption;
            long[] descriptions = entry.getValue();
            CharSequence option2 = entry.getKey();
            if (!StringUtil.startsWith((CharSequence)option2, (CharSequence)prefix) && !StringUtil.startsWith((CharSequence)option2, (CharSequence)stemmedPrefix) && (stemmedOption = PorterStemmerUtil.stem(option2.toString())) != null && !stemmedOption.startsWith(prefix) && !stemmedOption.startsWith(stemmedPrefix)) continue;
            if (result2 == null) {
                result2 = new HashSet<OptionDescription>();
            }
            for (long description : descriptions) {
                OptionDescription desc = this.unpack(description);
                result2.add(desc);
            }
        }
        return result2;
    }

    @Nullable
    private Set<OptionDescription> getOptionDescriptionsByWords(SearchableConfigurable configurable2, Set<String> words) {
        HashSet<OptionDescription> path = null;
        for (String word : words) {
            Set<OptionDescription> configs = this.getAcceptableDescriptions(word);
            if (configs == null) {
                return null;
            }
            HashSet<OptionDescription> paths = new HashSet<OptionDescription>();
            for (OptionDescription config2 : configs) {
                if (!Comparing.strEqual((String)config2.getConfigurableId(), (String)configurable2.getId())) continue;
                paths.add(config2);
            }
            if (path == null) {
                path = paths;
            }
            path.retainAll(paths);
        }
        return path;
    }

    @NotNull
    public Set<String> getInnerPaths(SearchableConfigurable configurable2, String option2) {
        this.initialize();
        Set<String> words = this.getProcessedWordsWithoutStemming(option2);
        Set<OptionDescription> path = this.getOptionDescriptionsByWords(configurable2, words);
        HashSet<String> resultSet = new HashSet<String>();
        if (path != null && !path.isEmpty()) {
            OptionDescription theOnlyResult = null;
            for (OptionDescription description : path) {
                String hit = description.getHit();
                if (hit != null) {
                    boolean theBest = true;
                    for (String word : words) {
                        if (StringUtil.containsIgnoreCase((String)hit, (String)word)) continue;
                        theBest = false;
                        break;
                    }
                    if (theBest) {
                        resultSet.add(description.getPath());
                    }
                }
                theOnlyResult = description;
            }
            if (resultSet.isEmpty()) {
                resultSet.add(theOnlyResult.getPath());
            }
        }
        HashSet<String> hashSet = resultSet;
        if (hashSet == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    public boolean isStopWord(String word) {
        return this.stopWords.contains(word);
    }

    @NotNull
    public Set<String> getProcessedWordsWithoutStemming(@NotNull String text2) {
        if (text2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(12);
        }
        HashSet<String> result2 = new HashSet<String>();
        SearchableOptionsRegistrarImpl.collectProcessedWordsWithoutStemming(text2, result2, this.stopWords);
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @ApiStatus.Internal
    public static void collectProcessedWordsWithoutStemming(@NotNull String text2, @NotNull Set<? super String> result2, @NotNull Set<String> stopWords) {
        if (text2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(15);
        }
        if (stopWords == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(16);
        }
        for (String opt : REG_EXP.split(Strings.toLowerCase((String)text2))) {
            String processed2;
            if (stopWords.contains(opt) || stopWords.contains(processed2 = PorterStemmerUtil.stem(opt))) continue;
            result2.add(opt);
        }
    }

    public Set<String> getProcessedWords(@NotNull String text2) {
        if (text2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(17);
        }
        HashSet<String> result2 = new HashSet<String>();
        SearchableOptionsRegistrarImpl.collectProcessedWords(text2, result2, this.stopWords);
        return result2;
    }

    static void collectProcessedWords(@NotNull String text2, @NotNull Set<? super String> result2, @NotNull Set<String> stopWords) {
        String[] options2;
        if (text2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(19);
        }
        if (stopWords == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(20);
        }
        String toLowerCase = StringUtil.toLowerCase((String)text2);
        for (String opt : options2 = REG_EXP.split(toLowerCase)) {
            if (stopWords.contains(opt) || (opt = PorterStemmerUtil.stem(opt)) == null) continue;
            result2.add(opt);
        }
    }

    @NotNull
    public Set<String> replaceSynonyms(@NotNull Set<String> options2, @NotNull SearchableConfigurable configurable2) {
        if (options2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(21);
        }
        if (configurable2 == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(22);
        }
        if (this.highlightOptionToSynonym.isEmpty()) {
            Set<String> set2 = options2;
            if (set2 == null) {
                SearchableOptionsRegistrarImpl.$$$reportNull$$$0(23);
            }
            return set2;
        }
        HashSet<String> result2 = new HashSet<String>(options2);
        this.initialize();
        for (String option2 : options2) {
            Set<String> synonyms = this.highlightOptionToSynonym.get(new Pair((Object)option2, (Object)configurable2.getId()));
            if (synonyms != null) {
                result2.addAll(synonyms);
                continue;
            }
            result2.add(option2);
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            SearchableOptionsRegistrarImpl.$$$reportNull$$$0(24);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierTable";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopWords";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadStopWords";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurables";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerPaths";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedWordsWithoutStemming";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSynonyms";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processSearchableOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pack";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurables";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurables";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedWordsWithoutStemming";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedWordsWithoutStemming";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedWords";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedWords";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replaceSynonyms";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

