/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaSliderUIThemes;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.plaf.basic.BasicSliderUI;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J\b\u0010\n\u001a\u00020\bH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0014J\"\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\rH\u0014J8\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0012\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016J \u0010#\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\rH\u0014J \u0010'\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\rH\u0014J \u0010)\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\rH\u0014J \u0010*\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\rH\u0014J\u0010\u0010+\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010,\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/DarculaSliderUI;", "Ljavax/swing/plaf/basic/BasicSliderUI;", "b", "Ljavax/swing/JComponent;", "(Ljavax/swing/JComponent;)V", "theme", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaSliderUIThemes;", "calculateLabelRect", "", "calculateThumbLocation", "calculateTickRect", "calculateTrackBuffer", "getBaseline", "", "c", "width", "height", "getHPath", "Ljava/awt/geom/GeneralPath;", "x1", "y1", "x2", "y2", "x3", "y3", "getThumbSize", "Ljava/awt/Dimension;", "getTickLength", "getVPath", "installDefaults", "slider", "Ljavax/swing/JSlider;", "paintFocus", "g", "Ljava/awt/Graphics;", "paintMajorTickForHorizSlider", "tickBounds", "Ljava/awt/Rectangle;", "x_", "paintMajorTickForVertSlider", "y_", "paintMinorTickForHorizSlider", "paintMinorTickForVertSlider", "paintThumb", "paintTrack", "setThumbLocation", "x", "y", "Companion", "intellij.platform.ide.impl"})
public class DarculaSliderUI
extends BasicSliderUI {
    private final DarculaSliderUIThemes theme;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintThumb(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            Paint paint2;
            GeneralPath path;
            GeneralPath generalPath;
            int y3;
            int y2;
            int y1;
            int x3;
            int x2;
            int x1;
            JSlider jSlider = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
            if (jSlider.getOrientation() == 0) {
                x1 = this.thumbRect.x + this.theme.getFocusBorderThickness();
                x2 = x1 + this.thumbRect.width - this.theme.getFocusBorderThickness() * 2;
                x3 = this.theme.getThumbHalfWidth() + 1 + x1;
                y1 = this.thumbRect.y + this.theme.getFocusBorderThickness();
                y2 = y1 + this.theme.getThumbOverhang();
                y3 = y1 + this.thumbRect.height - this.theme.getFocusBorderThickness() * 2;
                generalPath = this.getHPath(x1, y1, x2, y2, x3, y3);
            } else {
                x1 = this.thumbRect.x + this.theme.getFocusBorderThickness();
                x2 = x1 + this.theme.getThumbOverhang();
                x3 = x1 + this.thumbRect.width - this.theme.getFocusBorderThickness() * 2;
                y1 = this.thumbRect.y + this.theme.getFocusBorderThickness();
                y2 = y1 + this.theme.getThumbHalfWidth() + 1;
                y3 = y1 + this.thumbRect.height - this.theme.getFocusBorderThickness() * 2;
                generalPath = path = this.getVPath(x1, y1, x2, x3, y2, y3);
            }
            if (this.slider.hasFocus()) {
                g2d.setStroke(new BasicStroke(this.theme.getFocusBorderThickness() + this.theme.getBorderThickness()));
                g2d.setPaint(this.theme.getFocusedOuterColor());
                g2d.draw(path);
            }
            JSlider jSlider2 = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider2, (String)"slider");
            g2d.setPaint(jSlider2.isEnabled() ? (Paint)this.theme.getButtonColor() : (Paint)this.theme.getDisabledButtonColor());
            g2d.fill(path);
            if (this.slider.hasFocus()) {
                paint2 = this.theme.getFocusedBorderColor();
            } else {
                JSlider jSlider3 = this.slider;
                Intrinsics.checkNotNullExpressionValue((Object)jSlider3, (String)"slider");
                paint2 = jSlider3.isEnabled() ? this.theme.getButtonBorderColor() : this.theme.getDisabledButtonBorderColor();
            }
            g2d.setPaint(paint2);
            g2d.setStroke(new BasicStroke(this.theme.getBorderThickness()));
            g2d.draw(path);
        }
        finally {
            g2d.dispose();
        }
    }

    private final GeneralPath getHPath(int x1, int y1, int x2, int y2, int x3, int y3) {
        GeneralPath path = new GeneralPath();
        path.moveTo((double)(x1 + this.theme.getArc()), (double)y1);
        path.lineTo((double)(x2 - this.theme.getArc()), (double)y1);
        path.lineTo((double)x2, (double)(y1 + this.theme.getArc()));
        path.lineTo((double)x2, (double)y2);
        path.lineTo((double)x3, (double)y3);
        path.lineTo((double)x1, (double)y2);
        path.lineTo((double)x1, (double)(y1 + this.theme.getArc()));
        path.lineTo((double)x1 + (double)this.theme.getArc(), (double)y1);
        path.closePath();
        return path;
    }

    private final GeneralPath getVPath(int x1, int y1, int x2, int x3, int y2, int y3) {
        GeneralPath path = new GeneralPath();
        path.moveTo((double)(x1 + this.theme.getArc()), (double)y1);
        path.lineTo((double)x2, (double)y1);
        path.lineTo((double)x3, (double)y2);
        path.lineTo((double)x2, (double)y3);
        path.lineTo((double)(x1 + this.theme.getArc()), (double)y3);
        path.lineTo((double)x1, (double)(y3 - this.theme.getArc()));
        path.lineTo((double)x1, (double)(y1 + this.theme.getArc()));
        path.lineTo((double)(x1 + this.theme.getArc()), (double)y1);
        path.closePath();
        return path;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        if (jSlider.getOrientation() == 0) {
            JSlider jSlider2 = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider2, (String)"slider");
            int valuePosition = this.xPositionForValue(jSlider2.getValue());
            this.thumbRect.x = valuePosition - this.theme.getFocusedThumbHalfWidth();
            this.thumbRect.y = this.trackRect.y;
        } else {
            JSlider jSlider3 = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider3, (String)"slider");
            int valuePosition = this.yPositionForValue(jSlider3.getValue());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = valuePosition - this.theme.getFocusedThumbHalfWidth();
        }
    }

    @Override
    public void setThumbLocation(int x, int y) {
        super.setThumbLocation(x, y);
        this.slider.repaint();
    }

    @Override
    public int getBaseline(@Nullable JComponent c, int width, int height) {
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        if (jSlider.getOrientation() == 0) {
            int n = this.theme.getThumbOverhang() + 2 * this.theme.getFocusBorderThickness();
            JSlider jSlider2 = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider2, (String)"slider");
            return n + jSlider2.getInsets().top + this.theme.getBorderThickness();
        }
        return super.getBaseline(c, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTrack(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        g2d.setPaint(jSlider.isEnabled() ? (Paint)this.theme.getTrackColor() : (Paint)this.theme.getDisabledTrackColor());
        try {
            JSlider jSlider2 = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider2, (String)"slider");
            if (jSlider2.getOrientation() == 0) {
                int y = this.thumbRect.y + this.theme.getFocusBorderThickness() + this.theme.getThumbOverhang() - this.theme.getTrackThickness();
                double d = this.trackRect.getX();
                double d2 = y;
                Rectangle rectangle = this.trackRect;
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"trackRect");
                LinePainter2D.paint((Graphics2D)g2d, (double)d, (double)d2, (double)rectangle.getMaxX(), (double)y, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)this.theme.getTrackThickness());
            } else {
                int x = this.thumbRect.x + this.theme.getFocusBorderThickness() + this.theme.getThumbOverhang() - this.theme.getTrackThickness();
                double d = x;
                double d3 = this.trackRect.y;
                double d4 = x;
                Rectangle rectangle = this.trackRect;
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"trackRect");
                LinePainter2D.paint((Graphics2D)g2d, (double)d, (double)d3, (double)d4, (double)rectangle.getMaxY(), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)this.theme.getTrackThickness());
            }
        }
        finally {
            g2d.dispose();
        }
    }

    @Override
    public void paintFocus(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.paintThumb(g);
    }

    @Override
    @NotNull
    protected Dimension getThumbSize() {
        int width = this.theme.getFocusedThumbHalfWidth() * 2 + 1;
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        return jSlider.getOrientation() == 0 ? new Dimension(width, this.theme.getThumbHeight()) : new Dimension(this.theme.getThumbHeight(), width);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void calculateTrackBuffer() {
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        if (jSlider.getPaintLabels()) {
            JSlider jSlider2 = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider2, (String)"slider");
            if (jSlider2.getLabelTable() != null) {
                Component highLabel = this.getHighestValueLabel();
                Component lowLabel = this.getLowestValueLabel();
                JSlider jSlider3 = this.slider;
                Intrinsics.checkNotNullExpressionValue((Object)jSlider3, (String)"slider");
                if (jSlider3.getOrientation() == 0) {
                    if (highLabel != null && lowLabel != null) {
                        this.trackBuffer = RangesKt.coerceAtLeast((int)highLabel.getBounds().width, (int)lowLabel.getBounds().width) / 2;
                    }
                    this.trackBuffer = RangesKt.coerceAtLeast((int)this.trackBuffer, (int)this.theme.getFocusedThumbHalfWidth());
                    return;
                }
                if (highLabel != null && lowLabel != null) {
                    this.trackBuffer = RangesKt.coerceAtLeast((int)highLabel.getBounds().height, (int)lowLabel.getBounds().height) / 2;
                }
                this.trackBuffer = RangesKt.coerceAtLeast((int)this.trackBuffer, (int)this.theme.getFocusedThumbHalfWidth()) + 1;
                return;
            }
        }
        this.trackBuffer = this.theme.getFocusedThumbHalfWidth() + 1;
    }

    @Override
    protected void calculateLabelRect() {
        super.calculateLabelRect();
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        if (jSlider.getOrientation() == 0) {
            this.labelRect.y += this.theme.getTickBottom();
        } else {
            this.labelRect.x += this.theme.getTickBottom();
        }
    }

    @Override
    protected void calculateTickRect() {
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        if (jSlider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.theme.getFocusBorderThickness() + this.theme.getThumbOverhang() + this.theme.getTickTop();
            this.tickRect.width = this.trackRect.width;
            JSlider jSlider2 = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider2, (String)"slider");
            this.tickRect.height = jSlider2.getPaintTicks() ? this.getTickLength() : 0;
        } else {
            JSlider jSlider3 = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider3, (String)"slider");
            this.tickRect.width = jSlider3.getPaintTicks() ? this.getTickLength() : 0;
            JSlider jSlider4 = this.slider;
            Intrinsics.checkNotNullExpressionValue((Object)jSlider4, (String)"slider");
            ComponentOrientation componentOrientation = jSlider4.getComponentOrientation();
            Intrinsics.checkNotNullExpressionValue((Object)componentOrientation, (String)"slider.componentOrientation");
            this.tickRect.x = componentOrientation.isLeftToRight() ? this.trackRect.x + this.theme.getFocusBorderThickness() + this.theme.getThumbOverhang() + this.theme.getTickTop() : this.trackRect.x - (this.theme.getFocusBorderThickness() + this.theme.getThumbOverhang() + this.theme.getTickTop());
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
    }

    @Override
    protected int getTickLength() {
        return this.theme.getMajorTickHeight();
    }

    @Override
    protected void installDefaults(@Nullable JSlider slider) {
        LookAndFeel.installColorsAndFont(slider, "Slider.background", "Slider.foreground", "Slider.font");
        this.focusInsets = (Insets)JBUI.emptyInsets();
    }

    @Override
    protected void paintMinorTickForHorizSlider(@NotNull Graphics g, @NotNull Rectangle tickBounds, int x_) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tickBounds, (String)"tickBounds");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        Graphics2D graphics2D = (Graphics2D)g;
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        graphics2D.setColor(jSlider.isEnabled() ? this.theme.getTickColor() : this.theme.getDisabledTickColor());
        int x = x_ + 1;
        ((Graphics2D)g).setStroke(new BasicStroke(this.theme.getBorderThickness()));
        g.drawLine(x, 0, x, this.theme.getMinorTickHeight());
    }

    @Override
    protected void paintMajorTickForHorizSlider(@NotNull Graphics g, @NotNull Rectangle tickBounds, int x_) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tickBounds, (String)"tickBounds");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        Graphics2D graphics2D = (Graphics2D)g;
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        graphics2D.setColor(jSlider.isEnabled() ? this.theme.getTickColor() : this.theme.getDisabledTickColor());
        int x = x_ + 1;
        ((Graphics2D)g).setStroke(new BasicStroke(this.theme.getBorderThickness()));
        g.drawLine(x, 0, x, this.theme.getMajorTickHeight());
    }

    @Override
    protected void paintMinorTickForVertSlider(@NotNull Graphics g, @NotNull Rectangle tickBounds, int y_) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tickBounds, (String)"tickBounds");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        Graphics2D graphics2D = (Graphics2D)g;
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        graphics2D.setColor(jSlider.isEnabled() ? this.theme.getTickColor() : this.theme.getDisabledTickColor());
        int y = y_ + 1;
        ((Graphics2D)g).setStroke(new BasicStroke(this.theme.getBorderThickness()));
        g.drawLine(0, y, this.theme.getMinorTickHeight(), y);
    }

    @Override
    protected void paintMajorTickForVertSlider(@NotNull Graphics g, @NotNull Rectangle tickBounds, int y_) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tickBounds, (String)"tickBounds");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        Graphics2D graphics2D = (Graphics2D)g;
        JSlider jSlider = this.slider;
        Intrinsics.checkNotNullExpressionValue((Object)jSlider, (String)"slider");
        graphics2D.setColor(jSlider.isEnabled() ? this.theme.getTickColor() : this.theme.getDisabledTickColor());
        int y = y_ + 1;
        ((Graphics2D)g).setStroke(new BasicStroke(this.theme.getBorderThickness()));
        g.drawLine(0, y, this.theme.getMajorTickHeight(), y);
    }

    public DarculaSliderUI(@Nullable JComponent b) {
        JComponent jComponent = b;
        if (jComponent == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JSlider");
        }
        super((JSlider)jComponent);
        this.theme = new DarculaSliderUIThemes();
    }

    public /* synthetic */ DarculaSliderUI(JComponent jComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jComponent = null;
        }
        this(jComponent);
    }

    public DarculaSliderUI() {
        this(null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final DarculaSliderUI createUI(@NotNull JComponent c) {
        return Companion.createUI(c);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/DarculaSliderUI$Companion;", "", "()V", "createUI", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaSliderUI;", "c", "Ljavax/swing/JComponent;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DarculaSliderUI createUI(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return new DarculaSliderUI(c);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

