/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DarculaButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;
    private static final Color GOTIT_BORDER_COLOR_START = JBColor.namedColor((String)"GotItTooltip.startBorderColor", (Color)JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false));
    private static final Color GOTIT_BORDER_COLOR_END = JBColor.namedColor((String)"GotItTooltip.endBorderColor", (Color)JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)false));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Path2D.Float border;
            boolean paintComboFocus;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            boolean isSmallComboButton = DarculaButtonUI.isSmallVariant(c);
            int diam = DarculaButtonUI.HELP_BUTTON_DIAMETER.get();
            float lw = DarculaUIUtil.LW.getFloat();
            float bw = isSmallComboButton || DarculaButtonUI.isGotItButton(c) ? 0.0f : DarculaUIUtil.BW.getFloat();
            float arc = DarculaButtonUI.isTag(c) ? (float)height - bw * 2.0f - lw * 2.0f : DarculaUIUtil.BUTTON_ARC.getFloat();
            Rectangle r = new Rectangle(x, y, width, height);
            boolean bl = paintComboFocus = isSmallComboButton && c.isFocusable() && c.hasFocus();
            if (paintComboFocus) {
                g2.setColor(JBUI.CurrentTheme.Focus.focusColor());
                border = new Path2D.Float(0);
                border.append(new RoundRectangle2D.Float(r.x, r.y, r.width, r.height, arc + lw, arc + lw), false);
                border.append(new RoundRectangle2D.Float((float)r.x + lw * 2.0f, (float)r.y + lw * 2.0f, (float)r.width - lw * 4.0f, (float)r.height - lw * 4.0f, arc, arc), false);
                g2.fill(border);
            }
            if (!DarculaButtonUI.isGotItButton(c)) {
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            }
            g2.translate(r.x, r.y);
            if (!isSmallComboButton) {
                if (c.hasFocus()) {
                    if (UIUtil.isHelpButton((Component)c)) {
                        DarculaUIUtil.paintFocusOval(g2, (float)(r.width - diam) / 2.0f, (float)(r.height - diam) / 2.0f, diam, diam);
                    } else if (DarculaButtonUI.isTag(c)) {
                        DarculaUIUtil.paintTag(g2, r.width, r.height, c.hasFocus(), DarculaUIUtil.computeOutlineFor(c));
                    } else {
                        DarculaUIUtil.Outline type = DarculaButtonUI.isDefaultButton((JComponent)c) ? DarculaUIUtil.Outline.defaultButton : DarculaUIUtil.Outline.focus;
                        DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, arc, true, true, type);
                    }
                } else if (DarculaButtonUI.isTag(c)) {
                    DarculaUIUtil.paintTag(g2, r.width, r.height, c.hasFocus(), DarculaUIUtil.computeOutlineFor(c));
                }
            }
            g2.setPaint(this.getBorderPaint(c));
            if (UIUtil.isHelpButton((Component)c)) {
                g2.draw(new Ellipse2D.Float((float)(r.width - diam) / 2.0f, (float)(r.height - diam) / 2.0f, diam, diam));
            } else if (!paintComboFocus) {
                border = new Path2D.Float(0);
                border.append(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc), false);
                arc = arc > lw ? arc - lw : 0.0f;
                border.append(new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc, arc), false);
                g2.fill(border);
            }
        }
        finally {
            g2.dispose();
        }
    }

    public Paint getBorderPaint(Component button2) {
        AbstractButton b = (AbstractButton)button2;
        Color borderColor = (Color)b.getClientProperty("JButton.borderColor");
        Rectangle r = new Rectangle(b.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)b.getInsets());
        boolean defButton = DarculaButtonUI.isDefaultButton(b);
        if (button2.isEnabled()) {
            return Objects.requireNonNullElseGet(borderColor, () -> DarculaButtonUI.isGotItButton(button2) ? new GradientPaint(0.0f, 0.0f, GOTIT_BORDER_COLOR_START, 0.0f, r.height, GOTIT_BORDER_COLOR_END) : (button2.hasFocus() ? JBUI.CurrentTheme.Button.focusBorderColor((boolean)defButton) : new GradientPaint(0.0f, 0.0f, JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)defButton), 0.0f, r.height, JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)defButton))));
        }
        return JBUI.CurrentTheme.Button.disabledOutlineColor();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return DarculaButtonUI.isGotItButton(c) ? JBUI.emptyInsets().asUIResource() : (DarculaButtonUI.isSmallVariant(c) ? JBUI.insets((int)1, (int)2).asUIResource() : JBUI.insets((int)3).asUIResource());
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

