/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.laf.AsyncDetector;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0006\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/ui/laf/WindowsDetector;", "Lcom/intellij/ide/ui/laf/AsyncDetector;", "syncFunction", "Ljava/util/function/Consumer;", "", "(Ljava/util/function/Consumer;)V", "detectionSupported", "getDetectionSupported", "()Z", "getSyncFunction", "()Ljava/util/function/Consumer;", "isDark", "Companion", "intellij.platform.ide.impl"})
final class WindowsDetector
extends AsyncDetector {
    @NotNull
    private final Consumer<Boolean> syncFunction;
    @NonNls
    @NotNull
    public static final String REGISTRY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize";
    @NonNls
    @NotNull
    public static final String REGISTRY_VALUE = "AppsUseLightTheme";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean getDetectionSupported() {
        return SystemInfo.isWin10OrNewer && JnaLoader.isLoaded();
    }

    @Override
    public boolean isDark() {
        try {
            return Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) && Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) == 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    @NotNull
    public Consumer<Boolean> getSyncFunction() {
        return this.syncFunction;
    }

    public WindowsDetector(@NotNull Consumer<Boolean> syncFunction) {
        Intrinsics.checkNotNullParameter(syncFunction, (String)"syncFunction");
        this.syncFunction = syncFunction;
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.lightTheme.on", new PropertyChangeListener(){

            @Override
            public final void propertyChange(@NotNull PropertyChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.getSyncFunction().accept(Intrinsics.areEqual((Object)e.getNewValue(), (Object)Boolean.TRUE) ^ true);
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/ui/laf/WindowsDetector$Companion;", "", "()V", "REGISTRY_PATH", "", "REGISTRY_VALUE", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

