/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.util.SVGLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIThemeBasedLookAndFeelInfo
extends UIManager.LookAndFeelInfo {
    private final UITheme myTheme;
    private boolean myInitialised;

    public UIThemeBasedLookAndFeelInfo(@NotNull UITheme theme) {
        if (theme == null) {
            UIThemeBasedLookAndFeelInfo.$$$reportNull$$$0(0);
        }
        super(theme.getName(), theme.isDark() ? DarculaLaf.class.getName() : IntelliJLaf.class.getName());
        this.myTheme = theme;
    }

    public UITheme getTheme() {
        return this.myTheme;
    }

    public void installTheme(UIDefaults defaults, boolean lockEditorScheme) {
        SVGLoader.SvgElementColorPatcherProvider colorPatcher;
        this.myTheme.applyProperties(defaults);
        IconPathPatcher patcher = this.myTheme.getPatcher();
        if (patcher != null) {
            IconLoader.installPathPatcher((IconPathPatcher)patcher);
        }
        if ((colorPatcher = this.myTheme.getColorPatcher()) != null) {
            SVGLoader.setColorPatcherProvider((SVGLoader.SvgElementColorPatcherProvider)colorPatcher);
        }
        this.installBackgroundImage();
        if (!lockEditorScheme) {
            this.installEditorScheme();
        }
        this.myInitialised = true;
    }

    public boolean isInitialised() {
        return this.myInitialised;
    }

    protected void installEditorScheme() {
        EditorColorsManager editorColorManager;
        EditorColorsScheme scheme2;
        String name = this.myTheme.getEditorSchemeName();
        if (name != null && (scheme2 = (editorColorManager = EditorColorsManager.getInstance()).getScheme(name)) != null) {
            editorColorManager.setGlobalScheme(scheme2);
        }
    }

    private void installBackgroundImage() {
        boolean installed = this.installBackgroundImage(this.myTheme.getBackground(), "idea.background.editor");
        boolean bl = installed = this.installBackgroundImage(this.myTheme.getEmptyFrameBackground(), "idea.background.frame") || installed;
        if (installed) {
            IdeBackgroundUtil.repaintAllWindows();
        }
    }

    private boolean installBackgroundImage(@Nullable Map<String, Object> backgroundProps, String bgImageProperty) {
        Object path;
        Object object = path = backgroundProps == null ? null : backgroundProps.get("image");
        if (!(path instanceof String)) {
            return false;
        }
        try {
            Path tmpImage = FileUtil.createTempFile((String)"ijBackgroundImage", (String)path.toString().substring(((String)path).lastIndexOf(".")), (boolean)true).toPath();
            InputStream stream = this.myTheme.getResourceAsStream((String)path);
            if (stream == null) {
                throw new IllegalArgumentException("Can't load background: " + path);
            }
            try (InputStream inputStream2 = stream;){
                Files.copy(stream, tmpImage, new CopyOption[0]);
            }
            Object transparency = backgroundProps.get("transparency");
            String alpha = String.valueOf(transparency instanceof Integer ? (Integer)transparency : 15);
            String fill = UIThemeBasedLookAndFeelInfo.parseEnumValue(backgroundProps.get("fill"), IdeBackgroundUtil.Fill.SCALE);
            String anchor2 = UIThemeBasedLookAndFeelInfo.parseEnumValue(backgroundProps.get("anchor"), IdeBackgroundUtil.Anchor.CENTER);
            String spec = String.join((CharSequence)",", tmpImage.toString(), alpha, fill, anchor2);
            PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
            String currentSpec = propertyComponent.getValue(bgImageProperty);
            propertyComponent.setValue("old." + bgImageProperty, currentSpec);
            propertyComponent.setValue(bgImageProperty, spec);
            return true;
        }
        catch (IOException e) {
            Logger.getInstance(this.getClass()).error((Throwable)e);
            return false;
        }
    }

    private static <T extends Enum<T>> String parseEnumValue(Object value2, T defaultValue) {
        if (value2 instanceof String) {
            String name = StringUtil.toUpperCase((String)((String)value2));
            for (Enum t : (Enum[])defaultValue.getClass().getEnumConstants()) {
                if (!t.name().equals(name)) continue;
                return StringUtil.toLowerCase((String)value2.toString());
            }
        }
        return StringUtil.toLowerCase((String)defaultValue.name());
    }

    public void dispose() {
        IconPathPatcher patcher = this.myTheme.getPatcher();
        if (patcher != null) {
            IconLoader.removePathPatcher((IconPathPatcher)patcher);
        }
        SVGLoader.setColorPatcherProvider(null);
        this.unsetBackgroundProperties("idea.background.editor");
        this.unsetBackgroundProperties("idea.background.frame");
    }

    private void unsetBackgroundProperties(String backgroundPropertyKey) {
        PropertiesComponent propertyManager = PropertiesComponent.getInstance();
        String value2 = propertyManager.getValue("old." + backgroundPropertyKey);
        propertyManager.unsetValue("old." + backgroundPropertyKey);
        if (value2 == null) {
            if (this.myTheme.getBackground() != null) {
                propertyManager.unsetValue(backgroundPropertyKey);
            }
        } else {
            propertyManager.setValue(backgroundPropertyKey, value2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/intellij/ide/ui/laf/UIThemeBasedLookAndFeelInfo", "<init>"));
    }
}

