/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.ProjectTopHitCache;
import com.intellij.ide.ui.TopHitCache;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.text.Matcher;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class OptionsTopHitProvider
implements OptionsSearchTopHitProvider,
SearchTopHitProvider {
    public static final ExtensionPointName<OptionsSearchTopHitProvider.ProjectLevelProvider> PROJECT_LEVEL_EP = new ExtensionPointName("com.intellij.search.projectOptionsTopHitProvider");

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public abstract Collection<OptionDescription> getOptions(@Nullable Project var1);

    @NotNull
    private static Collection<OptionDescription> getCachedOptions(@NotNull OptionsSearchTopHitProvider provider2, @Nullable Project project, @Nullable PluginDescriptor pluginDescriptor) {
        if (provider2 == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(0);
        }
        TopHitCache cache2 = project == null || provider2 instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider ? TopHitCache.getInstance() : ProjectTopHitCache.getInstance(project);
        Collection<OptionDescription> collection = cache2.getCachedOptions(provider2, project, pluginDescriptor);
        if (collection == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public final void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(2);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(3);
        }
        OptionsTopHitProvider.consumeTopHits(this, pattern, collector, project);
    }

    static void consumeTopHits(@NotNull OptionsSearchTopHitProvider provider2, @NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (provider2 == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(5);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(6);
        }
        if ((pattern = OptionsTopHitProvider.checkPattern(pattern)) == null) {
            return;
        }
        List parts = StringUtil.split((String)pattern, (String)" ");
        if (!parts.isEmpty()) {
            OptionsTopHitProvider.doConsumeTopHits(provider2, pattern, (String)parts.get(0), collector, project);
        }
    }

    private static void doConsumeTopHits(@NotNull OptionsSearchTopHitProvider provider2, @NotNull String pattern, @NotNull String id2, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (provider2 == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(7);
        }
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(8);
        }
        if (id2 == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(9);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(10);
        }
        if (provider2.getId().startsWith(id2) || pattern.startsWith(" ")) {
            pattern = pattern.startsWith(" ") ? pattern.trim() : pattern.substring(id2.length()).trim();
            OptionsTopHitProvider.consumeTopHitsForApplicableProvider(provider2, OptionsTopHitProvider.buildMatcher(pattern), collector, project);
        }
    }

    private static void consumeTopHitsForApplicableProvider(@NotNull OptionsSearchTopHitProvider provider2, @NotNull Matcher matcher, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (provider2 == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(11);
        }
        if (matcher == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(12);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(13);
        }
        for (OptionDescription option2 : OptionsTopHitProvider.getCachedOptions(provider2, project, null)) {
            if (!matcher.matches(option2.getOption())) continue;
            collector.accept(option2);
        }
    }

    @NotNull
    @VisibleForTesting
    public static Matcher buildMatcher(String pattern) {
        return new WordPrefixMatcher(pattern);
    }

    @Nullable
    private static String checkPattern(@NotNull String pattern) {
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(14);
        }
        if (!pattern.startsWith(SearchTopHitProvider.getTopHitAccelerator())) {
            return null;
        }
        pattern = pattern.substring(1);
        return pattern;
    }

    @Override
    @NotNull
    public abstract String getId();

    @Nls
    public static String messageApp(@PropertyKey(resourceBundle="messages.ApplicationBundle") @PropertyKey(resourceBundle="messages.ApplicationBundle") String property) {
        return StringUtil.stripHtml((String)ApplicationBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    @Nls
    public static String messageIde(@PropertyKey(resourceBundle="messages.IdeBundle") @PropertyKey(resourceBundle="messages.IdeBundle") String property) {
        return StringUtil.stripHtml((String)IdeBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/OptionsTopHitProvider";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/OptionsTopHitProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOptions";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "consumeTopHits";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doConsumeTopHits";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "consumeTopHitsForApplicableProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Activity
    extends PreloadingActivity
    implements StartupActivity.DumbAware {
        Activity() {
            if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        @Override
        public void preload(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                Activity.$$$reportNull$$$0(0);
            }
            Activity.cacheAll(indicator, null);
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                Activity.$$$reportNull$$$0(1);
            }
            NonUrgentExecutor.getInstance().execute(() -> {
                if (project.isDisposed()) {
                    return;
                }
                Activity.cacheAll(null, project);
                StartUpPerformanceService.getInstance().lastOptionTopHitProviderFinishedForProject(project);
            });
        }

        private static void cacheAll(@Nullable ProgressIndicator indicator, @Nullable Project project) {
            String name = project == null ? "application" : "project";
            com.intellij.diagnostic.Activity activity = StartUpMeasurer.startActivity((String)("cache options in " + name));
            SearchTopHitProvider.EP_NAME.processWithPluginDescriptor((provider2, pluginDescriptor) -> {
                OptionsSearchTopHitProvider p;
                if (!(!(provider2 instanceof OptionsSearchTopHitProvider) || project != null && provider2 instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider || !(p = (OptionsSearchTopHitProvider)provider2).preloadNeeded() || indicator != null && indicator.isCanceled() || project != null && project.isDisposed())) {
                    OptionsTopHitProvider.getCachedOptions(p, project, pluginDescriptor);
                }
            });
            if (project != null) {
                PROJECT_LEVEL_EP.processWithPluginDescriptor((provider2, pluginDescriptor) -> {
                    if (indicator != null) {
                        indicator.checkCanceled();
                    }
                    try {
                        OptionsTopHitProvider.getCachedOptions(provider2, project, pluginDescriptor);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Logger.getInstance(OptionsTopHitProvider.class).error((Throwable)e);
                    }
                });
            }
            activity.end();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/OptionsTopHitProvider$Activity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preload";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runActivity";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ProjectLevelProvidersAdapter
    implements SearchTopHitProvider {
        public void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
            if (pattern == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(0);
            }
            if (collector == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(1);
            }
            if (project == null) {
                return;
            }
            if ((pattern = OptionsTopHitProvider.checkPattern(pattern)) == null) {
                return;
            }
            List parts = StringUtil.split((String)pattern, (String)" ");
            if (parts.isEmpty()) {
                return;
            }
            for (OptionsSearchTopHitProvider.ProjectLevelProvider provider2 : PROJECT_LEVEL_EP.getExtensionList()) {
                OptionsTopHitProvider.doConsumeTopHits(provider2, pattern, (String)parts.get(0), collector, project);
            }
        }

        public void consumeAllTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
            if (pattern == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(2);
            }
            if (collector == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(3);
            }
            Matcher matcher = OptionsTopHitProvider.buildMatcher(pattern);
            for (OptionsSearchTopHitProvider.ProjectLevelProvider provider2 : PROJECT_LEVEL_EP.getExtensionList()) {
                OptionsTopHitProvider.consumeTopHitsForApplicableProvider(provider2, matcher, collector, project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collector";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/OptionsTopHitProvider$ProjectLevelProvidersAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consumeTopHits";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consumeAllTopHits";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Deprecated
    public static interface CoveredByToggleActions {
    }
}

