/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.ide.todo.SetTodoFilterAction;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoCompositeRenderer;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.VisibilityWatcher;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TodoPanel
extends SimpleToolWindowPanel
implements OccurenceNavigator,
DataProvider,
Disposable {
    protected static final Logger LOG = Logger.getInstance(TodoPanel.class);
    protected Project myProject;
    private final TodoPanelSettings mySettings;
    private final boolean myCurrentFileMode;
    private final Content myContent;
    private final Tree myTree;
    private final TreeExpander myTreeExpander;
    private final MyOccurenceNavigator myOccurenceNavigator;
    protected final TodoTreeBuilder myTodoTreeBuilder;
    private MyVisibilityWatcher myVisibilityWatcher;
    private UsagePreviewPanel myUsagePreviewPanel;
    private MyAutoScrollToSourceHandler myAutoScrollToSourceHandler;
    public static final DataKey<TodoPanel> TODO_PANEL_DATA_KEY = DataKey.create("TodoPanel");

    TodoPanel(Project project, TodoPanelSettings settings, boolean currentFileMode, Content content2) {
        super(false, true);
        this.myProject = project;
        this.mySettings = settings;
        this.myCurrentFileMode = currentFileMode;
        this.myContent = content2;
        DefaultTreeModel model2 = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model2);
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myOccurenceNavigator = new MyOccurenceNavigator();
        this.initUI();
        this.myTodoTreeBuilder = this.setupTreeStructure();
        this.updateTodoFilter();
        this.myTodoTreeBuilder.setShowPackages(this.mySettings.arePackagesShown);
        this.myTodoTreeBuilder.setShowModules(this.mySettings.areModulesShown);
        this.myTodoTreeBuilder.setFlattenPackages(this.mySettings.areFlattenPackages);
        this.myVisibilityWatcher = new MyVisibilityWatcher();
        this.myVisibilityWatcher.install((Component)((Object)this));
    }

    private TodoTreeBuilder setupTreeStructure() {
        TodoTreeBuilder todoTreeBuilder = this.createTreeBuilder((JTree)this.myTree, this.myProject);
        Disposer.register((Disposable)this, (Disposable)todoTreeBuilder);
        TodoTreeStructure structure = todoTreeBuilder.getTodoTreeStructure();
        StructureTreeModel<TodoTreeStructure> structureTreeModel = new StructureTreeModel<TodoTreeStructure>(structure, TodoTreeBuilder.NODE_DESCRIPTOR_COMPARATOR, (Disposable)this.myProject);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)((Object)structureTreeModel), (Disposable)this.myProject);
        this.myTree.setModel((TreeModel)((Object)asyncTreeModel));
        asyncTreeModel.addTreeModelListener((TreeModelListener)((Object)new MyExpandListener(todoTreeBuilder)));
        todoTreeBuilder.setModel(structureTreeModel);
        Object selectableElement = structure.getFirstSelectableElement();
        if (selectableElement != null) {
            todoTreeBuilder.select(selectableElement);
        }
        return todoTreeBuilder;
    }

    protected Tree getTree() {
        return this.myTree;
    }

    protected abstract TodoTreeBuilder createTreeBuilder(JTree var1, Project var2);

    private void initUI() {
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(false);
        this.myTree.setRowHeight(0);
        this.myTree.setCellRenderer((TreeCellRenderer)new TodoCompositeRenderer());
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add(ActionManager.getInstance().getAction("EditSource"));
        group2.addSeparator();
        group2.add(CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this)));
        group2.add(CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this)));
        group2.addSeparator();
        group2.add(ActionManager.getInstance().getAction("VersionControlsGroup"));
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)group2, (String)"TodoViewPopup", (ActionManager)ActionManager.getInstance());
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, FindInProjectUtil.setupViewPresentation(false, new FindModel()));
        Disposer.register((Disposable)this, (Disposable)this.myUsagePreviewPanel);
        this.myUsagePreviewPanel.setVisible(this.mySettings.showPreview);
        this.setContent(this.createCenterComponent());
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (TodoPanel.this.myUsagePreviewPanel.isVisible()) {
                        TodoPanel.this.updatePreviewPanel();
                    }
                }, ModalityState.NON_MODAL, TodoPanel.this.myProject.getDisposed());
            }
        });
        this.myAutoScrollToSourceHandler = new MyAutoScrollToSourceHandler();
        this.myAutoScrollToSourceHandler.install((JTree)this.myTree);
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new PreviousOccurenceToolbarAction(this.myOccurenceNavigator));
        toolbarGroup.add((AnAction)new NextOccurenceToolbarAction(this.myOccurenceNavigator));
        toolbarGroup.add((AnAction)new SetTodoFilterAction(this.myProject, this.mySettings, (Consumer<? super TodoFilter>)((Consumer)todoFilter -> this.setTodoFilter((TodoFilter)todoFilter))));
        toolbarGroup.add(this.createAutoScrollToSourceAction());
        toolbarGroup.add(CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this)));
        toolbarGroup.add(CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this)));
        if (!this.myCurrentFileMode) {
            DefaultActionGroup groupBy = this.createGroupByActionGroup();
            toolbarGroup.add((AnAction)groupBy);
        }
        toolbarGroup.add((AnAction)new MyPreviewAction());
        this.setToolbar(ActionManager.getInstance().createActionToolbar("TodoViewToolbar", (ActionGroup)toolbarGroup, false).getComponent());
    }

    @NotNull
    protected DefaultActionGroup createGroupByActionGroup() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup defaultActionGroup = (DefaultActionGroup)actionManager.getAction("TodoViewGroupByGroup");
        if (defaultActionGroup == null) {
            TodoPanel.$$$reportNull$$$0(0);
        }
        return defaultActionGroup;
    }

    protected AnAction createAutoScrollToSourceAction() {
        return this.myAutoScrollToSourceHandler.createToggleAction();
    }

    protected JComponent createCenterComponent() {
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree));
        return splitter;
    }

    private void updatePreviewPanel() {
        Object element2;
        TodoItemNode pointer;
        DefaultMutableTreeNode node;
        Object userObject;
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        ArrayList<UsageInfo> infos = new ArrayList<UsageInfo>();
        TreePath path = this.myTree.getSelectionPath();
        if (path != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof NodeDescriptor && (pointer = this.myTodoTreeBuilder.getFirstPointerForElement(element2 = ((NodeDescriptor)userObject).getElement())) != null) {
            SmartTodoItemPointer value2 = (SmartTodoItemPointer)pointer.getValue();
            Document document = value2.getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            RangeMarker rangeMarker = value2.getRangeMarker();
            if (psiFile != null) {
                infos.add(new UsageInfo((PsiElement)psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
                for (RangeMarker additionalMarker : value2.getAdditionalRangeMarkers()) {
                    if (!additionalMarker.isValid()) continue;
                    infos.add(new UsageInfo((PsiElement)psiFile, additionalMarker.getStartOffset(), additionalMarker.getEndOffset()));
                }
            }
        }
        this.myUsagePreviewPanel.updateLayout(infos.isEmpty() ? null : infos);
    }

    public void dispose() {
        if (this.myVisibilityWatcher != null) {
            this.myVisibilityWatcher.deinstall((Component)((Object)this));
            this.myVisibilityWatcher = null;
        }
        this.myProject = null;
    }

    void rebuildCache() {
        this.myTodoTreeBuilder.rebuildCache();
    }

    void rebuildCache(@NotNull Set<? extends VirtualFile> files2) {
        if (files2 == null) {
            TodoPanel.$$$reportNull$$$0(1);
        }
        this.myTodoTreeBuilder.rebuildCache(files2);
    }

    void updateTree() {
        this.myTodoTreeBuilder.updateTree();
    }

    void updateTodoFilter() {
        TodoFilter filter = TodoConfiguration.getInstance().getTodoFilter(this.mySettings.todoFilterName);
        this.setTodoFilter(filter);
    }

    private void setTodoFilter(TodoFilter filter) {
        String filterName;
        this.mySettings.todoFilterName = filterName = filter != null ? filter.getName() : null;
        this.myTodoTreeBuilder.setTodoFilter(filter);
        this.myContent.setDescription(filterName);
    }

    @Nullable
    protected PsiFile getSelectedFile() {
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        LOG.assertTrue(node != null);
        if (node.getUserObject() == null) {
            return null;
        }
        return TodoTreeBuilder.getFileForNode(node);
    }

    protected void setDisplayName(@NlsContexts.TabTitle String tabName) {
        this.myContent.setDisplayName(tabName);
    }

    @Nullable
    private PsiElement getSelectedElement() {
        if (this.myTree == null) {
            return null;
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        PsiElement selectedElement = TodoTreeHelper.getInstance(this.myProject).getSelectedElement(userObject);
        if (selectedElement != null) {
            return selectedElement;
        }
        return this.getSelectedFile();
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            TodoPanel.$$$reportNull$$$0(2);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            TreePath path = this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            Object element2 = ((NodeDescriptor)userObject).getElement();
            if (!(element2 instanceof TodoFileNode) && !(element2 instanceof TodoItemNode)) {
                return null;
            }
            TodoItemNode pointer = this.myTodoTreeBuilder.getFirstPointerForElement(element2);
            if (pointer != null) {
                return PsiNavigationSupport.getInstance().createNavigatable(this.myProject, ((SmartTodoItemPointer)pointer.getValue()).getTodoItem().getFile().getVirtualFile(), ((SmartTodoItemPointer)pointer.getValue()).getRangeMarker().getStartOffset());
            }
            return null;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            PsiFile file2 = this.getSelectedFile();
            return file2 != null ? file2.getVirtualFile() : null;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.getSelectedElement();
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            PsiFile file3 = this.getSelectedFile();
            if (file3 != null) {
                return new VirtualFile[]{file3.getVirtualFile()};
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "find.todoList";
        }
        if (TODO_PANEL_DATA_KEY.is(dataId)) {
            return this;
        }
        return super.getData(dataId);
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator.goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myOccurenceNavigator.getNextOccurenceActionName();
        if (string == null) {
            TodoPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator.goNextOccurence();
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator.hasNextOccurence();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myOccurenceNavigator.getPreviousOccurenceActionName();
        if (string == null) {
            TodoPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator.hasPreviousOccurence();
    }

    protected void rebuildWithAlarm(Alarm alarm2) {
        alarm2.cancelAllRequests();
        alarm2.addRequest(() -> this.myTodoTreeBuilder.rebuildCache(), 300);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/TodoPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupByActionGroup";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/TodoPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rebuildCache";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyPreviewAction
    extends ToggleAction {
        MyPreviewAction() {
            super(IdeBundle.messagePointer((String)"todo.panel.preview.source.action.text", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.PreviewDetails);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPreviewAction.$$$reportNull$$$0(0);
            }
            return TodoPanel.this.mySettings.showPreview;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyPreviewAction.$$$reportNull$$$0(1);
            }
            TodoPanel.this.mySettings.showPreview = state;
            TodoPanel.this.myUsagePreviewPanel.setVisible(state);
            if (state) {
                TodoPanel.this.updatePreviewPanel();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/todo/TodoPanel$MyPreviewAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyVisibilityWatcher
    extends VisibilityWatcher {
        private MyVisibilityWatcher() {
        }

        @Override
        public void visibilityChanged() {
            if (TodoPanel.this.myProject.isOpen()) {
                PsiDocumentManager.getInstance((Project)TodoPanel.this.myProject).performWhenAllCommitted(() -> TodoPanel.this.myTodoTreeBuilder.setUpdatable(TodoPanel.this.isShowing()));
            }
        }
    }

    public static final class MyFlattenPackagesAction
    extends ToggleAction {
        public MyFlattenPackagesAction() {
            super(IdeBundle.messagePointer((String)"action.flatten.view", (Object[])new Object[0]), PlatformIcons.FLATTEN_PACKAGES_ICON);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFlattenPackagesAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setText("   " + this.getTemplateText());
            TodoPanel todoPanel = (TodoPanel)e.getData(TODO_PANEL_DATA_KEY);
            e.getPresentation().setEnabled(todoPanel != null && todoPanel.mySettings.arePackagesShown);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            TodoPanel todoPanel;
            if (e == null) {
                MyFlattenPackagesAction.$$$reportNull$$$0(1);
            }
            return (todoPanel = (TodoPanel)e.getData(TODO_PANEL_DATA_KEY)) != null && todoPanel.mySettings.areFlattenPackages;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            TodoPanel todoPanel;
            if (e == null) {
                MyFlattenPackagesAction.$$$reportNull$$$0(2);
            }
            if ((todoPanel = (TodoPanel)e.getData(TODO_PANEL_DATA_KEY)) != null) {
                todoPanel.mySettings.areFlattenPackages = state;
                todoPanel.myTodoTreeBuilder.setFlattenPackages(state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/todo/TodoPanel$MyFlattenPackagesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MyShowModulesAction
    extends ToggleAction {
        public MyShowModulesAction() {
            super(IdeBundle.messagePointer((String)"action.group.by.modules", (Object[])new Object[0]), AllIcons.Actions.GroupByModule);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowModulesAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(e.getData(TODO_PANEL_DATA_KEY) != null);
            super.update(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            TodoPanel todoPanel;
            if (e == null) {
                MyShowModulesAction.$$$reportNull$$$0(1);
            }
            return (todoPanel = (TodoPanel)e.getData(TODO_PANEL_DATA_KEY)) != null && todoPanel.mySettings.areModulesShown;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            TodoPanel todoPanel;
            if (e == null) {
                MyShowModulesAction.$$$reportNull$$$0(2);
            }
            if ((todoPanel = (TodoPanel)e.getData(TODO_PANEL_DATA_KEY)) != null) {
                todoPanel.mySettings.areModulesShown = state;
                todoPanel.myTodoTreeBuilder.setShowModules(state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/todo/TodoPanel$MyShowModulesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class MyShowPackagesAction
    extends ToggleAction {
        public MyShowPackagesAction() {
            super(IdeBundle.messagePointer((String)"action.group.by.packages", (Object[])new Object[0]), PlatformIcons.GROUP_BY_PACKAGES);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowPackagesAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(e.getData(TODO_PANEL_DATA_KEY) != null);
            super.update(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            TodoPanel todoPanel;
            if (e == null) {
                MyShowPackagesAction.$$$reportNull$$$0(1);
            }
            return (todoPanel = (TodoPanel)e.getData(TODO_PANEL_DATA_KEY)) != null && todoPanel.mySettings.arePackagesShown;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            TodoPanel todoPanel;
            if (e == null) {
                MyShowPackagesAction.$$$reportNull$$$0(2);
            }
            if ((todoPanel = (TodoPanel)e.getData(TODO_PANEL_DATA_KEY)) != null) {
                todoPanel.mySettings.arePackagesShown = state;
                todoPanel.myTodoTreeBuilder.setShowPackages(state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/todo/TodoPanel$MyShowPackagesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyOccurenceNavigator
    implements OccurenceNavigator {
        private MyOccurenceNavigator() {
        }

        public boolean hasNextOccurence() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject == null) {
                return false;
            }
            if (userObject instanceof NodeDescriptor && ((NodeDescriptor)userObject).getElement() instanceof TodoItemNode) {
                return TodoPanel.this.myTree.getRowCount() != TodoPanel.this.myTree.getRowForPath(path) + 1;
            }
            return node.getChildCount() > 0;
        }

        public boolean hasPreviousOccurence() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            return userObject instanceof NodeDescriptor && !this.isFirst(node);
        }

        private boolean isFirst(TreeNode node) {
            TreeNode parent = node.getParent();
            return parent == null || parent.getIndex(node) == 0 && this.isFirst(parent);
        }

        @Nullable
        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return this.goToPointer(this.getNextPointer());
        }

        @Nullable
        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return this.goToPointer(this.getPreviousPointer());
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string = IdeBundle.message((String)"action.next.todo", (Object[])new Object[0]);
            if (string == null) {
                MyOccurenceNavigator.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string = IdeBundle.message((String)"action.previous.todo", (Object[])new Object[0]);
            if (string == null) {
                MyOccurenceNavigator.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        private OccurenceNavigator.OccurenceInfo goToPointer(TodoItemNode pointer) {
            if (pointer == null) {
                return null;
            }
            TodoPanel.this.myTodoTreeBuilder.select(pointer);
            return new OccurenceNavigator.OccurenceInfo(PsiNavigationSupport.getInstance().createNavigatable(TodoPanel.this.myProject, ((SmartTodoItemPointer)pointer.getValue()).getTodoItem().getFile().getVirtualFile(), ((SmartTodoItemPointer)pointer.getValue()).getRangeMarker().getStartOffset()), -1, -1);
        }

        @Nullable
        private TodoItemNode getNextPointer() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            Object element2 = ((NodeDescriptor)userObject).getElement();
            TodoItemNode pointer = element2 instanceof TodoItemNode ? TodoPanel.this.myTodoTreeBuilder.getNextPointer((TodoItemNode)element2) : TodoPanel.this.myTodoTreeBuilder.getFirstPointerForElement(element2);
            return pointer;
        }

        @Nullable
        private TodoItemNode getPreviousPointer() {
            TodoItemNode pointer;
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            Object element2 = ((NodeDescriptor)userObject).getElement();
            if (element2 instanceof TodoItemNode) {
                pointer = TodoPanel.this.myTodoTreeBuilder.getPreviousPointer((TodoItemNode)element2);
            } else {
                Object sibling = TodoPanel.this.myTodoTreeBuilder.getPreviousSibling(element2);
                if (sibling == null) {
                    return null;
                }
                pointer = TodoPanel.this.myTodoTreeBuilder.getLastPointerForElement(sibling);
            }
            return pointer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/todo/TodoPanel$MyOccurenceNavigator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOccurenceActionName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousOccurenceActionName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private final class MyAutoScrollToSourceHandler
    extends AutoScrollToSourceHandler {
        MyAutoScrollToSourceHandler() {
        }

        protected boolean isAutoScrollMode() {
            return TodoPanel.this.mySettings.isAutoScrollToSource;
        }

        protected void setAutoScrollMode(boolean state) {
            TodoPanel.this.mySettings.isAutoScrollToSource = state;
        }
    }

    private class MyExpandListener
    extends TreeModelAdapter {
        private final TodoTreeBuilder myBuilder;

        MyExpandListener(TodoTreeBuilder builder2) {
            this.myBuilder = builder2;
        }

        public void treeNodesInserted(TreeModelEvent e) {
            Object[] children2;
            TreePath parentPath = e.getTreePath();
            if (parentPath == null || parentPath.getPathCount() > 2) {
                return;
            }
            for (Object o : children2 = e.getChildren()) {
                NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getUserObject(NodeDescriptor.class, (Object)o);
                if (descriptor2 == null || !this.myBuilder.isAutoExpandNode(descriptor2)) continue;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (TodoPanel.this.myTree.isVisible(parentPath) && TodoPanel.this.myTree.isExpanded(parentPath)) {
                        TodoPanel.this.myTree.expandPath(parentPath.pathByAddingChild(o));
                    }
                }, this.myBuilder.myProject.getDisposed());
            }
        }
    }

    public static class GroupByActionGroup
    extends DefaultActionGroup {
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GroupByActionGroup.$$$reportNull$$$0(0);
            }
            JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).showUnderneathOf(e.getInputEvent().getComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoPanel$GroupByActionGroup", "actionPerformed"));
        }
    }
}

