/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchImplUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LRUPopupBuilder<T> {
    private static final Logger LOG = Logger.getInstance(LRUPopupBuilder.class);
    private static final int MAX_VISIBLE_SIZE = 20;
    private static final int LRU_ITEMS = 4;
    private final @NlsContexts.PopupTitle String myTitle;
    private final PropertiesComponent myPropertiesComponent;
    private final Map<T, Pair<@Nls String, Icon>> myPresentations;
    private T mySelection;
    private Consumer<? super T> myOnChosen;
    private Comparator<? super T> myComparator;
    private Iterable<? extends T> myItemsIterable;
    private JBIterable<T> myExtraItems;

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project, @NotNull @NlsContexts.PopupTitle String title, @NotNull Iterable<? extends VirtualFile> files2, @NotNull PerFileMappings<Language> mappings) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(0);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(2);
        }
        if (mappings == null) {
            LRUPopupBuilder.$$$reportNull$$$0(3);
        }
        VirtualFile[] filesCopy = VfsUtilCore.toVirtualFileArray((Collection)JBIterable.from(files2).toList());
        Arrays.sort(filesCopy, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (!o1.isCaseSensitive() ? 1 : 0) != 0));
        return LRUPopupBuilder.forFileLanguages(project, title, null, (Consumer<? super Language>)((Consumer)t -> {
            try {
                WriteCommandAction.writeCommandAction((Project)project).withName(LangBundle.message((String)"command.name.change.language", (Object[])new Object[0])).run(() -> LRUPopupBuilder.changeLanguageWithUndo(project, t, filesCopy, mappings));
            }
            catch (UnexpectedUndoException e) {
                LOG.error((Throwable)e);
            }
        }));
    }

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project, @NotNull @NlsContexts.PopupTitle String title, @Nullable Language selection, @NotNull Consumer<? super Language> onChosen) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(4);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(5);
        }
        if (onChosen == null) {
            LRUPopupBuilder.$$$reportNull$$$0(6);
        }
        ListPopup listPopup = LRUPopupBuilder.languagePopupBuilder(project, title).forValues(LanguageUtil.getFileLanguages()).withSelection(selection).onChosen(onChosen).buildPopup();
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(7);
        }
        return listPopup;
    }

    @NotNull
    public static LRUPopupBuilder<Language> languagePopupBuilder(@NotNull Project project, @NotNull @NlsContexts.PopupTitle String title) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(8);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(9);
        }
        LRUPopupBuilder<Language> lRUPopupBuilder = new LRUPopupBuilder<Language>(project, title){

            @Override
            public String getDisplayName(Language language) {
                return language.getDisplayName();
            }

            @Override
            public Icon getIcon(Language language) {
                LanguageFileType associatedLanguage = language.getAssociatedFileType();
                return associatedLanguage != null ? associatedLanguage.getIcon() : null;
            }

            @Override
            public String getStorageId(Language language) {
                return language.getID();
            }
        }.withComparator(LanguageUtil.LANGUAGE_COMPARATOR);
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(10);
        }
        return lRUPopupBuilder;
    }

    protected LRUPopupBuilder(@NotNull Project project, @NotNull @NlsContexts.PopupTitle String title) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(11);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(12);
        }
        this.myPresentations = new IdentityHashMap<T, Pair<String, Icon>>();
        this.myExtraItems = JBIterable.empty();
        this.myTitle = title;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)project);
    }

    public abstract String getDisplayName(T var1);

    public abstract String getStorageId(T var1);

    public abstract Icon getIcon(T var1);

    @NotNull
    public LRUPopupBuilder<T> forValues(@Nullable Iterable<? extends T> items) {
        this.myItemsIterable = items;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(13);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withSelection(@Nullable T t) {
        this.mySelection = t;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(14);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withExtra(@NotNull T extra, @Nls @NotNull String displayName, @Nullable Icon icon2) {
        if (extra == null) {
            LRUPopupBuilder.$$$reportNull$$$0(15);
        }
        if (displayName == null) {
            LRUPopupBuilder.$$$reportNull$$$0(16);
        }
        this.myExtraItems = this.myExtraItems.append(extra);
        this.myPresentations.put(extra, (Pair<String, Icon>)Pair.create((Object)displayName, (Object)icon2));
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(17);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> onChosen(@Nullable Consumer<? super T> consumer2) {
        this.myOnChosen = consumer2;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(18);
        }
        return lRUPopupBuilder;
    }

    public LRUPopupBuilder<T> withComparator(@Nullable Comparator<? super T> comparator2) {
        this.myComparator = comparator2;
        return this;
    }

    @NotNull
    public ListPopup buildPopup() {
        ArrayList ids = ContainerUtil.newArrayList((Object[])this.restoreLRUItems());
        if (this.mySelection != null) {
            ids.add(this.getStorageId(this.mySelection));
        }
        ArrayList<Object> lru = new ArrayList<Object>(4);
        ArrayList<? super T> items = new ArrayList<T>(20);
        final List extra = this.myExtraItems.toList();
        if (this.myItemsIterable != null) {
            for (T t : this.myItemsIterable) {
                (ids.contains(this.getStorageId(t)) ? lru : items).add(t);
            }
        }
        if (this.myComparator != null) {
            items.sort(this.myComparator);
        }
        if (!lru.isEmpty()) {
            lru.sort(Comparator.comparingInt(o -> ids.indexOf(this.getStorageId(o))));
        }
        final Object separator1 = !lru.isEmpty() && !items.isEmpty() ? items.get(0) : null;
        final Object separator2 = !lru.isEmpty() || !items.isEmpty() ? ContainerUtil.getFirstItem((List)extra) : null;
        List combinedItems = ContainerUtil.concat((List[])new List[]{lru, items, extra});
        BaseListPopupStep step = new BaseListPopupStep<T>(this.myTitle, combinedItems){

            @NotNull
            public String getTextFor(T t) {
                String string = t == null ? "" : (String)LRUPopupBuilder.this.getPresentation(t).first;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(T t) {
                return t == null ? null : (Icon)LRUPopupBuilder.this.getPresentation(t).second;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(T t, boolean finalChoice) {
                if (!extra.contains(t)) {
                    LRUPopupBuilder.this.storeLRUItems(t);
                }
                if (LRUPopupBuilder.this.myOnChosen != null) {
                    this.doFinalStep(() -> LRUPopupBuilder.this.myOnChosen.consume(t));
                }
                return null;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(T value2) {
                return value2 == separator1 || value2 == separator2 ? new ListSeparator() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder$2", "getTextFor"));
            }
        };
        int selection = Math.max(0, this.mySelection != null ? combinedItems.indexOf(this.mySelection) : 0);
        step.setDefaultOptionIndex(selection);
        return LRUPopupBuilder.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
    }

    private @NotNull Pair<@Nls String, Icon> getPresentation(T t) {
        Pair p = this.myPresentations.get(t);
        if (p == null) {
            p = Pair.create((Object)this.getDisplayName(t), (Object)this.getIcon(t));
            this.myPresentations.put(t, (Pair<String, Icon>)p);
        }
        Pair pair = p;
        if (pair == null) {
            LRUPopupBuilder.$$$reportNull$$$0(19);
        }
        return pair;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup2) {
        if (popup2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(20);
        }
        int nameLen = 0;
        ListPopupStep step = popup2.getListStep();
        List values = step.getValues();
        for (Object v : values) {
            nameLen = Math.max(nameLen, step.getTextFor(v).length());
        }
        if (values.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getPreferredSize();
            size.width += 20;
            size.height *= 20;
            popup2.setSize(size);
        }
        ListPopup listPopup = popup2;
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(21);
        }
        return listPopup;
    }

    private String @NotNull [] restoreLRUItems() {
        String[] stringArray = (String[])ObjectUtils.notNull((Object)this.myPropertiesComponent.getValues(this.getLRUKey()), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            LRUPopupBuilder.$$$reportNull$$$0(22);
        }
        return stringArray;
    }

    private void storeLRUItems(@NotNull T t) {
        if (t == null) {
            LRUPopupBuilder.$$$reportNull$$$0(23);
        }
        String[] values = this.myPropertiesComponent.getValues(this.getLRUKey());
        ArrayList<String> lastUsed = new ArrayList<String>(4);
        lastUsed.add(this.getStorageId(t));
        if (values != null) {
            for (String value2 : values) {
                if (!lastUsed.contains(value2)) {
                    lastUsed.add(value2);
                }
                if (lastUsed.size() == 4) break;
            }
        }
        this.myPropertiesComponent.setValues(this.getLRUKey(), ArrayUtilRt.toStringArray(lastUsed));
    }

    @NotNull
    private String getLRUKey() {
        String string = this.getClass().getName() + "/" + this.myTitle;
        if (string == null) {
            LRUPopupBuilder.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static void changeLanguageWithUndo(@NotNull Project project, final @NotNull Language t, final VirtualFile @NotNull [] sortedFiles, final @NotNull PerFileMappings<Language> mappings) throws UnexpectedUndoException {
        ReadonlyStatusHandler.OperationStatus status;
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(25);
        }
        if (t == null) {
            LRUPopupBuilder.$$$reportNull$$$0(26);
        }
        if (mappings == null) {
            LRUPopupBuilder.$$$reportNull$$$0(27);
        }
        if (sortedFiles == null) {
            LRUPopupBuilder.$$$reportNull$$$0(28);
        }
        if ((status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Arrays.asList(sortedFiles))).hasReadonlyFiles()) {
            return;
        }
        LinkedHashSet<VirtualFile> matchedExtensions = new LinkedHashSet<VirtualFile>();
        final HashMap<VirtualFile, Language> oldMapping = new HashMap<VirtualFile, Language>();
        for (VirtualFile file2 : sortedFiles) {
            oldMapping.put(file2, (Language)mappings.getMapping(file2));
            if (!ScratchImplUtil.hasMatchingExtension(project, file2)) continue;
            matchedExtensions.add(file2);
        }
        BasicUndoableAction action2 = new BasicUndoableAction(sortedFiles){

            public void undo() {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, (Object)((Language)oldMapping.get(file2)));
                }
            }

            public void redo() {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, (Object)t);
                }
            }
        };
        action2.redo();
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)action2);
        for (VirtualFile file3 : matchedExtensions) {
            try {
                ScratchImplUtil.updateFileExtension(project, file3);
            }
            catch (IOException iOException) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/LRUPopupBuilder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/LRUPopupBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forFileLanguages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "languagePopupBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "forValues";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withSelection";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtra";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "onChosen";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakSizeToPreferred";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreLRUItems";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLRUKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forFileLanguages";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "languagePopupBuilder";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "withExtra";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tweakSizeToPreferred";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "storeLRUItems";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "changeLanguageWithUndo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

