/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryGroupNode
extends ProjectViewNode<LibraryGroupElement> {
    public LibraryGroupNode(Project project, @NotNull LibraryGroupElement value2, ViewSettings viewSettings) {
        if (value2 == null) {
            LibraryGroupNode.$$$reportNull$$$0(0);
        }
        super(project, (Object)value2, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        OrderEntry[] orderEntries;
        Module module = ((LibraryGroupElement)this.getValue()).getModule();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ArrayList children2 = new ArrayList();
        for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
            JdkOrderEntry jdkOrderEntry;
            Sdk jdk;
            if (orderEntry instanceof LibraryOrderEntry) {
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                Library library2 = libraryOrderEntry.getLibrary();
                if (library2 == null) continue;
                String libraryName = library2.getName();
                if (libraryName == null || libraryName.length() == 0) {
                    LibraryGroupNode.addLibraryChildren((LibraryOrSdkOrderEntry)libraryOrderEntry, children2, this.getProject(), this);
                    continue;
                }
                children2.add((AbstractTreeNode<?>)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(module, (LibraryOrSdkOrderEntry)libraryOrderEntry), this.getSettings()));
                continue;
            }
            if (!(orderEntry instanceof JdkOrderEntry) || (jdk = (jdkOrderEntry = (JdkOrderEntry)orderEntry).getJdk()) == null) continue;
            children2.add((AbstractTreeNode<?>)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(module, (LibraryOrSdkOrderEntry)jdkOrderEntry), this.getSettings()));
        }
        ArrayList arrayList = children2;
        if (arrayList == null) {
            LibraryGroupNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static void addLibraryChildren(LibraryOrSdkOrderEntry entry, List<? super AbstractTreeNode<?>> children2, Project project, ProjectViewNode node) {
        VirtualFile[] files2;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file2 : files2 = entry instanceof LibraryOrderEntry ? LibraryGroupNode.getLibraryRoots((LibraryOrderEntry)entry) : entry.getRootFiles(OrderRootType.CLASSES)) {
            if (!file2.isValid()) continue;
            if (file2.isDirectory()) {
                PsiDirectory psiDir = psiManager.findDirectory(file2);
                if (psiDir == null) continue;
                children2.add((AbstractTreeNode<?>)new PsiDirectoryNode(project, psiDir, node.getSettings()));
                continue;
            }
            PsiFile psiFile = psiManager.findFile(file2);
            if (psiFile == null) continue;
            children2.add((AbstractTreeNode<?>)new PsiFileNode(project, psiFile, node.getSettings()));
        }
    }

    public String getTestPresentation() {
        return "Libraries";
    }

    public boolean contains(@NotNull VirtualFile file2) {
        ProjectFileIndex index2;
        if (file2 == null) {
            LibraryGroupNode.$$$reportNull$$$0(2);
        }
        if (!(index2 = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex()).isInLibrary(file2)) {
            return false;
        }
        return this.someChildContainsFile(file2, false);
    }

    public void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            LibraryGroupNode.$$$reportNull$$$0(3);
        }
        presentation2.setPresentableText(IdeBundle.message((String)"node.projectview.libraries", (Object[])new Object[0]));
        presentation2.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    public boolean canNavigate() {
        return ProjectSettingsService.getInstance(this.myProject).canOpenModuleLibrarySettings();
    }

    public void navigate(boolean requestFocus) {
        Module module = ((LibraryGroupElement)this.getValue()).getModule();
        ProjectSettingsService.getInstance(this.myProject).openModuleLibrarySettings(module);
    }

    public static VirtualFile @NotNull [] getLibraryRoots(@NotNull LibraryOrderEntry orderEntry) {
        Library library2;
        if (orderEntry == null) {
            LibraryGroupNode.$$$reportNull$$$0(4);
        }
        if ((library2 = orderEntry.getLibrary()) == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                LibraryGroupNode.$$$reportNull$$$0(5);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        OrderRootType[] rootTypes = LibraryType.DEFAULT_EXTERNAL_ROOT_TYPES;
        if (library2 instanceof LibraryEx) {
            if (((LibraryEx)library2).isDisposed()) {
                if (VirtualFile.EMPTY_ARRAY == null) {
                    LibraryGroupNode.$$$reportNull$$$0(6);
                }
                return VirtualFile.EMPTY_ARRAY;
            }
            PersistentLibraryKind libKind = ((LibraryEx)library2).getKind();
            if (libKind != null) {
                rootTypes = LibraryType.findByKind((LibraryKind)libKind).getExternalRootTypes();
            }
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (OrderRootType rootType : rootTypes) {
            files2.addAll(Arrays.asList(library2.getFiles(rootType)));
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files2);
        if (virtualFileArray == null) {
            LibraryGroupNode.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/LibraryGroupNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/LibraryGroupNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

