/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectViewDeleteElementProvider
implements DeleteProvider {
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return false;
        }
        PsiElement[] elements = this.getElementsToDelete(project, dataContext);
        return DeleteHandler.shouldEnableDeleteAction(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteElement(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(1);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return;
        }
        ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
        for (PsiElement psiElement : this.getElementsToDelete(project, dataContext)) {
            if (psiElement == null || !psiElement.isValid()) continue;
            validElements.add(psiElement);
        }
        PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
        LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
        try {
            DeleteHandler.deletePsiElement(elements, project);
        }
        finally {
            a.finish();
        }
    }

    protected abstract PsiElement @NotNull [] getSelectedPSIElements(@NotNull DataContext var1);

    protected abstract Boolean hideEmptyMiddlePackages(@NotNull DataContext var1);

    private PsiElement @NotNull [] getElementsToDelete(@NotNull Project project, @NotNull DataContext dataContext) {
        if (project == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(3);
        }
        PsiElement[] elements = this.getSelectedPSIElements(dataContext);
        for (int idx = 0; idx < elements.length; ++idx) {
            PsiFile psiFile;
            VirtualFile vFile;
            VirtualFile virtualFile;
            String path;
            PsiElement element2 = elements[idx];
            if (!(element2 instanceof PsiDirectory)) continue;
            PsiDirectory directory = (PsiDirectory)element2;
            ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance(project);
            if (this.hideEmptyMiddlePackages(dataContext).booleanValue() && directory.getChildren().length == 0 && !directoryHelper.skipDirectory(directory)) {
                PsiElement[] children2;
                PsiDirectory parent;
                while ((parent = directory.getParentDirectory()) != null && !directoryHelper.skipDirectory(parent) && !PsiDirectoryFactory.getInstance(project).getQualifiedName(parent, false).isEmpty() && ((children2 = parent.getChildren()).length == 0 || children2.length == 1 && children2[0] == directory)) {
                    directory = parent;
                }
                elements[idx] = directory;
            }
            if (!(path = (virtualFile = directory.getVirtualFile()).getPath()).endsWith("!/") || (vFile = LocalFileSystem.getInstance().findFileByPath(path.substring(0, path.length() - "!/".length()))) == null || (psiFile = PsiManager.getInstance((Project)project).findFile(vFile)) == null) continue;
            elements[idx] = psiFile;
        }
        if (elements == null) {
            ProjectViewDeleteElementProvider.$$$reportNull$$$0(4);
        }
        return elements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewDeleteElementProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewDeleteElementProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToDelete";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

