/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginUpdatesService {
    private static final List<PluginUpdatesService> SERVICES = new ArrayList<PluginUpdatesService>();
    private static final Object ourLock = new Object();
    private static Collection<IdeaPluginDescriptor> myCache;
    private static boolean myPrepared;
    private static boolean myPreparing;
    private static boolean myReset;
    private Consumer<? super Integer> myCountCallback;
    private Consumer<? super Collection<IdeaPluginDescriptor>> myUpdateCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static PluginUpdatesService connectWithCounter(@NotNull Consumer<? super Integer> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(0);
        }
        PluginUpdatesService service = new PluginUpdatesService();
        service.myCountCallback = callback2;
        Object object = ourLock;
        synchronized (object) {
            SERVICES.add(service);
            if (myPrepared) {
                callback2.accept(PluginUpdatesService.getCount());
                PluginUpdatesService pluginUpdatesService = service;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                if (pluginUpdatesService == null) {
                    PluginUpdatesService.$$$reportNull$$$0(1);
                }
                return pluginUpdatesService;
            }
        }
        PluginUpdatesService.calculateUpdates();
        PluginUpdatesService pluginUpdatesService = service;
        if (pluginUpdatesService == null) {
            PluginUpdatesService.$$$reportNull$$$0(2);
        }
        return pluginUpdatesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static PluginUpdatesService connectWithUpdates(@NotNull Consumer<? super Collection<IdeaPluginDescriptor>> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(3);
        }
        PluginUpdatesService service = new PluginUpdatesService();
        service.myUpdateCallback = callback2;
        Object object = ourLock;
        synchronized (object) {
            SERVICES.add(service);
            if (myPrepared) {
                callback2.accept(myCache);
            }
        }
        PluginUpdatesService pluginUpdatesService = service;
        if (pluginUpdatesService == null) {
            PluginUpdatesService.$$$reportNull$$$0(4);
        }
        return pluginUpdatesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateUpdates(@NotNull Consumer<? super Collection<IdeaPluginDescriptor>> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(5);
        }
        Object object = ourLock;
        synchronized (object) {
            this.myUpdateCallback = callback2;
            if (myPrepared) {
                callback2.accept(myCache);
                return;
            }
        }
        PluginUpdatesService.calculateUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finishUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(6);
        }
        Object object = ourLock;
        synchronized (object) {
            if (!myPrepared || myCache == null) {
                return;
            }
            Iterator<IdeaPluginDescriptor> I = myCache.iterator();
            while (I.hasNext()) {
                IdeaPluginDescriptor downloadedDescriptor = I.next();
                if (downloadedDescriptor.getPluginId() != descriptor2.getPluginId()) continue;
                I.remove();
                Integer countValue = PluginUpdatesService.getCount();
                for (PluginUpdatesService service : SERVICES) {
                    service.runCountCallbacks(countValue);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishUpdate() {
        Object object = ourLock;
        synchronized (object) {
            if (!myPrepared || myCache == null) {
                return;
            }
            Integer countValue = PluginUpdatesService.getCount();
            for (PluginUpdatesService service : SERVICES) {
                service.runCountCallbacks(countValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculateUpdates() {
        Object object = ourLock;
        synchronized (object) {
            for (PluginUpdatesService service : SERVICES) {
                service.runAllCallbacks(null);
            }
            if (myPreparing) {
                PluginUpdatesService.resetUpdates();
            } else {
                PluginUpdatesService.calculateUpdates();
            }
        }
    }

    private static void resetUpdates() {
        myReset = true;
    }

    public void dispose() {
        PluginUpdatesService.dispose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispose(@NotNull PluginUpdatesService service) {
        if (service == null) {
            PluginUpdatesService.$$$reportNull$$$0(7);
        }
        Object object = ourLock;
        synchronized (object) {
            SERVICES.remove(service);
            if (SERVICES.isEmpty()) {
                myCache = null;
                myPrepared = false;
                myPreparing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNeedUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(8);
        }
        PluginId pluginId = descriptor2.getPluginId();
        Object object = ourLock;
        synchronized (object) {
            if (myPrepared && myCache != null) {
                for (IdeaPluginDescriptor downloader : myCache) {
                    if (!pluginId.equals(downloader.getPluginId())) continue;
                    return true;
                }
            }
        }
        return InstalledPluginsState.getInstance().hasNewerVersion(pluginId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Collection<IdeaPluginDescriptor> getUpdates() {
        Object object = ourLock;
        synchronized (object) {
            return !myPrepared || myPreparing || myCache == null ? null : myCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void calculateUpdates() {
        Object object = ourLock;
        synchronized (object) {
            if (myPreparing) {
                return;
            }
            myPreparing = true;
            myCache = null;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        NonUrgentExecutor.getInstance().execute(() -> {
            UpdateChecker.CheckPluginsUpdateResult updates2 = UpdateChecker.checkPluginsUpdate((ProgressIndicator)new EmptyProgressIndicator());
            ApplicationManager.getApplication().invokeLater(() -> {
                Object object = ourLock;
                synchronized (object) {
                    myPreparing = false;
                    if (myReset) {
                        myReset = false;
                        PluginUpdatesService.calculateUpdates();
                        return;
                    }
                    myPrepared = true;
                    ArrayList<IdeaPluginDescriptor> cache2 = new ArrayList<IdeaPluginDescriptor>();
                    Collection<PluginDownloader> availableUpdates = updates2.getAvailableUpdates();
                    if (availableUpdates != null) {
                        cache2.addAll(ContainerUtil.map(availableUpdates, downloader -> downloader.getDescriptor()));
                    }
                    cache2.addAll(ContainerUtil.map(updates2.getAvailableDisabledUpdates(), downloader -> downloader.getDescriptor()));
                    myCache = cache2;
                    Integer countValue = PluginUpdatesService.getCount();
                    for (PluginUpdatesService service : SERVICES) {
                        service.runAllCallbacks(countValue);
                    }
                }
            }, ModalityState.any());
        });
    }

    private void runAllCallbacks(@Nullable Integer countValue) {
        this.runCountCallbacks(countValue);
        if (this.myUpdateCallback != null) {
            this.myUpdateCallback.accept(countValue == null ? null : myCache);
        }
    }

    private void runCountCallbacks(@Nullable Integer countValue) {
        if (this.myCountCallback != null) {
            this.myCountCallback.accept(countValue);
        }
    }

    @Nullable
    private static Integer getCount() {
        return myCache == null ? null : Integer.valueOf(myCache.size());
    }

    static {
        PluginStateManager.addStateListener(new PluginStateListener(){

            @Override
            public void install(@NotNull IdeaPluginDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                PluginUpdatesService.finishUpdate(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/newui/PluginUpdatesService$1", "install"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginUpdatesService";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginUpdatesService";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "connectWithCounter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "connectWithUpdates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "connectWithCounter";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "connectWithUpdates";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateUpdates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "finishUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNeedUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

