/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.CustomPluginRepositoryService;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.ProjectPluginTrackerManager;
import com.intellij.ide.plugins.ProjectPluginTrackerManagerState;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.newui.InstallPluginInfo;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.ProjectDependentPluginEnabledState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyPluginModel
extends InstalledPluginsTableModel
implements PluginManagerMain.PluginEnabler {
    private static final Logger LOG = Logger.getInstance(MyPluginModel.class);
    private final List<ListPluginComponent> myInstalledPluginComponents = new ArrayList<ListPluginComponent>();
    private final Map<PluginId, List<ListPluginComponent>> myInstalledPluginComponentMap = new HashMap<PluginId, List<ListPluginComponent>>();
    private final Map<PluginId, List<ListPluginComponent>> myMarketplacePluginComponentMap = new HashMap<PluginId, List<ListPluginComponent>>();
    private final List<PluginsGroup> myEnabledGroups = new ArrayList<PluginsGroup>();
    private PluginsGroupComponent myInstalledPanel;
    private PluginsGroup myDownloaded;
    private PluginsGroup myInstalling;
    private Configurable.TopComponentController myTopController;
    private List<String> myVendorsSorted;
    private List<String> myTagsSorted;
    private static final Set<IdeaPluginDescriptor> myInstallingPlugins = new HashSet<IdeaPluginDescriptor>();
    private static final Set<IdeaPluginDescriptor> myInstallingWithUpdatesPlugins = new HashSet<IdeaPluginDescriptor>();
    static final Map<PluginId, InstallPluginInfo> myInstallingInfos = new HashMap<PluginId, InstallPluginInfo>();
    public boolean needRestart;
    public boolean createShutdownCallback = true;
    private boolean myInstallsRequiringRestart;
    private final List<PluginDetailsPageComponent> myDetailPanels = new ArrayList<PluginDetailsPageComponent>();
    private StatusBarEx myStatusBar;
    private PluginUpdatesService myPluginUpdatesService;
    private Runnable myInvalidFixCallback;
    private Consumer<? super IdeaPluginDescriptor> myCancelInstallCallback;
    private final Map<PluginId, PendingDynamicPluginInstall> myDynamicPluginsToInstall = new LinkedHashMap<PluginId, PendingDynamicPluginInstall>();
    private final Set<IdeaPluginDescriptorImpl> myDynamicPluginsToUninstall = new HashSet<IdeaPluginDescriptorImpl>();
    private final Set<IdeaPluginDescriptorImpl> myPluginsToRemoveOnCancel = new HashSet<IdeaPluginDescriptorImpl>();
    private final Map<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>> myDiff = new HashMap<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>>();
    private final Map<PluginId, Boolean> myRequiredPluginsForProject = new HashMap<PluginId, Boolean>();
    private final Map<IdeaPluginDescriptorImpl, Boolean> myRequiresRestart = new HashMap<IdeaPluginDescriptorImpl, Boolean>();
    private final Set<IdeaPluginDescriptor> myUninstalled = new HashSet<IdeaPluginDescriptor>();
    private final Set<PluginId> myErrorPluginsToDisable = new HashSet<PluginId>();
    private final Map<String, Icon> myIcons = new HashMap<String, Icon>();

    public MyPluginModel(@Nullable Project project) {
        super(project);
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        this.myStatusBar = MyPluginModel.getStatusBar(window);
        if (this.myStatusBar == null && window != null) {
            this.myStatusBar = MyPluginModel.getStatusBar(window.getOwner());
        }
    }

    @Nullable
    private static StatusBarEx getStatusBar(@Nullable Window frame) {
        if (frame instanceof IdeFrame && !(frame instanceof WelcomeFrame)) {
            return (StatusBarEx)((IdeFrame)frame).getStatusBar();
        }
        return null;
    }

    public boolean isModified() {
        return this.needRestart || !this.myDynamicPluginsToInstall.isEmpty() || !this.myDynamicPluginsToUninstall.isEmpty() || !this.myPluginsToRemoveOnCancel.isEmpty() || !this.myDiff.isEmpty();
    }

    public boolean apply(JComponent parent) throws ConfigurationException {
        boolean changesAppliedWithoutRestart;
        ArrayList<CallSite> dependencies = new ArrayList<CallSite>();
        this.updatePluginDependencies();
        block2: for (Map.Entry<PluginId, Set<PluginId>> entry : this.getDependentToRequiredListMap().entrySet()) {
            PluginId id2 = entry.getKey();
            if (!this.isLoaded(id2)) continue;
            for (PluginId dependId : (Set)entry.getValue()) {
                if (PluginManagerCore.isModuleDependency(dependId)) continue;
                IdeaPluginDescriptor descriptor2 = PluginManagerCore.getPlugin(id2);
                if (descriptor2 instanceof IdeaPluginDescriptorImpl && (((IdeaPluginDescriptorImpl)descriptor2).isDeleted() || descriptor2.isImplementationDetail())) continue block2;
                dependencies.add((CallSite)((Object)("\"" + (descriptor2 == null ? id2.getIdString() : descriptor2.getName()) + "\"")));
                continue block2;
            }
        }
        if (!dependencies.isEmpty()) {
            throw new ConfigurationException(XmlStringUtil.wrapInHtml((CharSequence)IdeBundle.message((String)"dialog.message.unable.to.apply.changes", (Object[])new Object[]{dependencies.size(), StringUtil.join(dependencies, (String)", ")})));
        }
        HashSet<Object> uninstallsRequiringRestart = new HashSet<Object>();
        for (IdeaPluginDescriptorImpl pluginDescriptor : this.myDynamicPluginsToUninstall) {
            this.myDiff.remove(pluginDescriptor);
            PluginId pluginId = pluginDescriptor.getPluginId();
            if (!PluginInstaller.uninstallDynamicPlugin(parent, pluginDescriptor, false)) {
                uninstallsRequiringRestart.add(pluginId);
            } else {
                this.getEnabledMap().remove(pluginId);
            }
            ((ProjectPluginTrackerManagerState)ProjectPluginTrackerManager.getInstance().getState()).stopTracking(List.of(pluginId));
        }
        boolean installsRequiringRestart = this.myInstallsRequiringRestart;
        ArrayList dynamicPluginsRequiringRestart = new ArrayList();
        for (PendingDynamicPluginInstall pendingPluginInstall : this.myDynamicPluginsToInstall.values()) {
            PluginId pluginId = pendingPluginInstall.getPluginDescriptor().getPluginId();
            if (!uninstallsRequiringRestart.contains(pluginId)) {
                InstalledPluginsState.getInstance().trackPluginInstallation(() -> {
                    if (!PluginInstaller.installAndLoadDynamicPlugin(pendingPluginInstall.getFile(), parent, pendingPluginInstall.getPluginDescriptor())) {
                        dynamicPluginsRequiringRestart.add(pluginId);
                    }
                });
                continue;
            }
            try {
                PluginInstaller.installAfterRestart(pendingPluginInstall.getFile(), !Registry.is((String)"ide.plugins.keep.archive", (boolean)true), null, (IdeaPluginDescriptor)pendingPluginInstall.getPluginDescriptor());
                installsRequiringRestart = true;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myDynamicPluginsToInstall.clear();
        this.myPluginsToRemoveOnCancel.clear();
        boolean enableDisableAppliedWithoutRestart = this.applyEnableDisablePlugins(parent);
        this.myDynamicPluginsToUninstall.clear();
        this.myDiff.clear();
        boolean bl = changesAppliedWithoutRestart = enableDisableAppliedWithoutRestart && uninstallsRequiringRestart.isEmpty() && !installsRequiringRestart && dynamicPluginsRequiringRestart.isEmpty();
        if (!changesAppliedWithoutRestart) {
            InstalledPluginsState.getInstance().setRestartRequired(true);
        }
        return changesAppliedWithoutRestart;
    }

    public void clear(@Nullable JComponent parentComponent) {
        this.cancel(parentComponent);
        this.updateAfterEnableDisable();
    }

    public void cancel(@Nullable JComponent parentComponent) {
        this.myDiff.forEach((key, value2) -> this.setEnabled(key.getPluginId(), (PluginEnabledState)((Object)((Object)value2.getSecond()))));
        this.myDiff.clear();
        this.myPluginsToRemoveOnCancel.forEach(pluginDescriptor -> PluginInstaller.uninstallDynamicPlugin(parentComponent, pluginDescriptor, false));
        this.myPluginsToRemoveOnCancel.clear();
    }

    private boolean applyEnableDisablePlugins(@Nullable JComponent parentComponent) {
        EnumMap<PluginEnableDisableAction, List> descriptorsByAction = new EnumMap<PluginEnableDisableAction, List>(PluginEnableDisableAction.class);
        for (Map.Entry<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>> entry : this.myDiff.entrySet()) {
            PluginEnabledState newState2;
            Pair<PluginEnableDisableAction, PluginEnabledState> pair;
            PluginEnabledState oldState;
            IdeaPluginDescriptor descriptor2 = entry.getKey();
            PluginId pluginId = descriptor2.getPluginId();
            if (descriptor2.isImplementationDetail() || !this.isLoaded(pluginId) || (oldState = (PluginEnabledState)((Object)(pair = entry.getValue()).getSecond())) == (newState2 = this.getState(pluginId)) && (!newState2.isDisabled() || !this.myErrorPluginsToDisable.contains(pluginId))) continue;
            descriptorsByAction.computeIfAbsent((PluginEnableDisableAction)((Object)pair.getFirst()), __ -> new ArrayList()).add(descriptor2);
        }
        boolean result2 = true;
        ProjectPluginTrackerManager pluginTrackerManager = ProjectPluginTrackerManager.getInstance();
        for (Map.Entry entry : descriptorsByAction.entrySet()) {
            if (pluginTrackerManager.updatePluginsState((Collection)entry.getValue(), entry.getKey(), this.getProject(), parentComponent)) continue;
            result2 = false;
        }
        return result2;
    }

    public void pluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData) {
        if (callbackData == null) {
            MyPluginModel.$$$reportNull$$$0(0);
        }
        this.appendOrUpdateDescriptor(callbackData.getPluginDescriptor(), callbackData.getRestartNeeded());
        if (!callbackData.getRestartNeeded()) {
            this.myDynamicPluginsToInstall.put(callbackData.getPluginDescriptor().getPluginId(), new PendingDynamicPluginInstall(callbackData.getFile(), callbackData.getPluginDescriptor()));
        }
    }

    public void addComponent(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(1);
        }
        IdeaPluginDescriptor descriptor2 = component2.getPluginDescriptor();
        if (!component2.isMarketplace()) {
            if (myInstallingPlugins.contains(descriptor2) && (this.myInstalling == null || this.myInstalling.ui == null || this.myInstalling.ui.findComponent(descriptor2) == null)) {
                return;
            }
            this.myInstalledPluginComponents.add(component2);
            List components = this.myInstalledPluginComponentMap.computeIfAbsent(descriptor2.getPluginId(), __ -> new ArrayList());
            components.add(component2);
        } else {
            List components = this.myMarketplacePluginComponentMap.computeIfAbsent(descriptor2.getPluginId(), __ -> new ArrayList());
            components.add(component2);
        }
    }

    public void removeComponent(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(2);
        }
        PluginId pluginId = component2.getPluginDescriptor().getPluginId();
        if (!component2.isMarketplace()) {
            this.myInstalledPluginComponents.remove(component2);
            List<ListPluginComponent> components = this.myInstalledPluginComponentMap.get(pluginId);
            if (components != null) {
                components.remove(component2);
                if (components.isEmpty()) {
                    this.myInstalledPluginComponentMap.remove(pluginId);
                }
            }
        } else {
            List<ListPluginComponent> components = this.myMarketplacePluginComponentMap.get(pluginId);
            if (components != null) {
                components.remove(component2);
                if (components.isEmpty()) {
                    this.myMarketplacePluginComponentMap.remove(pluginId);
                }
            }
        }
    }

    public void setTopController(@NotNull Configurable.TopComponentController topController) {
        if (topController == null) {
            MyPluginModel.$$$reportNull$$$0(3);
        }
        this.myTopController = topController;
        this.myTopController.showProject(false);
        for (InstallPluginInfo info : myInstallingInfos.values()) {
            info.fromBackground(this);
        }
        if (!myInstallingInfos.isEmpty()) {
            this.myTopController.showProgress(true);
        }
    }

    public void setPluginUpdatesService(@NotNull PluginUpdatesService service) {
        if (service == null) {
            MyPluginModel.$$$reportNull$$$0(4);
        }
        this.myPluginUpdatesService = service;
    }

    @Nullable
    public PluginsGroup getDownloadedGroup() {
        return this.myDownloaded;
    }

    @NotNull
    public static Set<IdeaPluginDescriptor> getInstallingPlugins() {
        Set<IdeaPluginDescriptor> set2 = myInstallingPlugins;
        if (set2 == null) {
            MyPluginModel.$$$reportNull$$$0(5);
        }
        return set2;
    }

    static boolean isInstallingOrUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(6);
        }
        return myInstallingWithUpdatesPlugins.contains(descriptor2);
    }

    void installOrUpdatePlugin(@Nullable JComponent parentComponent, @NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptor updateDescriptor, @NotNull ModalityState modalityState) {
        PluginNode pluginNode;
        IdeaPluginDescriptor actionDescriptor;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(7);
        }
        if (modalityState == null) {
            MyPluginModel.$$$reportNull$$$0(8);
        }
        IdeaPluginDescriptor ideaPluginDescriptor = actionDescriptor = updateDescriptor == null ? descriptor2 : updateDescriptor;
        if (!PluginManagerMain.checkThirdPartyPluginsAllowed(Collections.singletonList(actionDescriptor))) {
            return;
        }
        boolean allowUninstallWithoutRestart = true;
        if (updateDescriptor != null) {
            IdeaPluginDescriptorImpl installedPluginDescriptor = PluginDescriptorLoader.tryLoadFullDescriptor((IdeaPluginDescriptorImpl)descriptor2);
            if (installedPluginDescriptor == null || !DynamicPlugins.allowLoadUnloadWithoutRestart(installedPluginDescriptor)) {
                allowUninstallWithoutRestart = false;
            } else if (!installedPluginDescriptor.isEnabled()) {
                try {
                    FileUtil.delete((Path)installedPluginDescriptor.getPluginPath());
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            } else if (DynamicPlugins.allowLoadUnloadSynchronously(installedPluginDescriptor)) {
                if (!PluginInstaller.uninstallDynamicPlugin(parentComponent, installedPluginDescriptor, true)) {
                    allowUninstallWithoutRestart = false;
                }
            } else {
                this.performUninstall(installedPluginDescriptor);
            }
        }
        if (actionDescriptor instanceof PluginNode) {
            pluginNode = (PluginNode)actionDescriptor;
            if (!pluginNode.detailsLoaded()) {
                Ref fullNode = new Ref();
                if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> fullNode.set((Object)MarketplaceRequests.getInstance().loadPluginDetails((PluginNode)actionDescriptor)), IdeBundle.message((String)"progress.title.loading.plugin.details", (Object[])new Object[0]), true, null, parentComponent)) {
                    return;
                }
                pluginNode = (PluginNode)fullNode.get();
            }
        } else {
            pluginNode = new PluginNode(actionDescriptor.getPluginId(), actionDescriptor.getName(), "-1");
            pluginNode.setDependencies(actionDescriptor.getDependencies());
            pluginNode.setRepositoryName("__unknown_repository__");
        }
        ArrayList pluginsToInstall = ContainerUtil.newArrayList((Object[])new PluginNode[]{pluginNode});
        PluginManagerMain.suggestToEnableInstalledDependantPlugins(this, pluginsToInstall);
        this.installPlugin(pluginsToInstall, this.prepareToInstall(descriptor2, updateDescriptor), allowUninstallWithoutRestart, modalityState);
    }

    private void installPlugin(@NotNull List<PluginNode> pluginsToInstall, @NotNull InstallPluginInfo info, boolean allowInstallWithoutRestart, @NotNull ModalityState modalityState) {
        if (pluginsToInstall == null) {
            MyPluginModel.$$$reportNull$$$0(9);
        }
        if (info == null) {
            MyPluginModel.$$$reportNull$$$0(10);
        }
        if (modalityState == null) {
            MyPluginModel.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean cancel = false;
            boolean error = false;
            boolean showErrors = true;
            boolean restartRequired = true;
            ArrayList<PendingDynamicPluginInstall> pluginsToInstallSynchronously = new ArrayList<PendingDynamicPluginInstall>();
            try {
                PluginInstallOperation operation2 = new PluginInstallOperation(pluginsToInstall, this.getCustomRepoPlugins(), (PluginManagerMain.PluginEnabler)this, (ProgressIndicator)info.indicator);
                operation2.setAllowInstallWithoutRestart(allowInstallWithoutRestart);
                operation2.run();
                for (PendingDynamicPluginInstall install : operation2.getPendingDynamicPluginInstalls()) {
                    if (DynamicPlugins.allowLoadUnloadSynchronously(install.getPluginDescriptor())) {
                        pluginsToInstallSynchronously.add(install);
                        this.myPluginsToRemoveOnCancel.add(install.getPluginDescriptor());
                        continue;
                    }
                    this.myDynamicPluginsToInstall.put(install.getPluginDescriptor().getPluginId(), install);
                }
                error = !operation2.isSuccess();
                showErrors = !operation2.isShownErrors();
                restartRequired = operation2.isRestartRequired();
            }
            catch (ProcessCanceledException e) {
                cancel = true;
            }
            catch (Throwable e) {
                LOG.error(e);
                error = true;
            }
            boolean success2 = !error;
            boolean _cancel = cancel;
            boolean _showErrors = showErrors;
            boolean finalRestartRequired = restartRequired;
            ApplicationManager.getApplication().invokeLater(() -> {
                boolean dynamicRestartRequired = false;
                for (PendingDynamicPluginInstall install : pluginsToInstallSynchronously) {
                    boolean installedWithoutRestart = PluginInstaller.installAndLoadDynamicPlugin(install.getFile(), (Component)((Object)this.myInstalledPanel), install.getPluginDescriptor());
                    if (installedWithoutRestart) {
                        IdeaPluginDescriptor installedDescriptor = PluginManagerCore.getPlugin(info.getDescriptor().getPluginId());
                        if (installedDescriptor == null) continue;
                        info.setInstalledDescriptor((IdeaPluginDescriptorImpl)installedDescriptor);
                        continue;
                    }
                    dynamicRestartRequired = true;
                }
                info.finish(success2, _cancel, _showErrors, finalRestartRequired || dynamicRestartRequired);
            }, modalityState);
        });
    }

    public boolean toBackground() {
        for (InstallPluginInfo info : myInstallingInfos.values()) {
            info.toBackground(this.myStatusBar);
        }
        return !myInstallingInfos.isEmpty();
    }

    @NotNull
    private InstallPluginInfo prepareToInstall(@NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptor updateDescriptor) {
        List<ListPluginComponent> listComponents;
        List<ListPluginComponent> gridComponents;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(12);
        }
        boolean install = updateDescriptor == null;
        InstallPluginInfo info = new InstallPluginInfo(descriptor2, updateDescriptor, this, install);
        myInstallingInfos.put(descriptor2.getPluginId(), info);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(true);
        }
        myInstallingWithUpdatesPlugins.add(descriptor2);
        if (install) {
            myInstallingPlugins.add(descriptor2);
        }
        if (install && this.myInstalling != null) {
            if (this.myInstalling.ui == null) {
                this.myInstalling.descriptors.add(descriptor2);
                this.myInstalledPanel.addGroup(this.myInstalling, 0);
            } else {
                this.myInstalledPanel.addToGroup(this.myInstalling, descriptor2);
            }
            this.myInstalling.titleWithCount();
            this.myInstalledPanel.doLayout();
        }
        if ((gridComponents = this.myMarketplacePluginComponentMap.get(descriptor2.getPluginId())) != null) {
            for (ListPluginComponent gridComponent : gridComponents) {
                gridComponent.showProgress();
            }
        }
        if ((listComponents = this.myInstalledPluginComponentMap.get(descriptor2.getPluginId())) != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.showProgress();
            }
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.getPlugin() != descriptor2) continue;
            panel2.showProgress();
        }
        InstallPluginInfo installPluginInfo = info;
        if (installPluginInfo == null) {
            MyPluginModel.$$$reportNull$$$0(13);
        }
        return installPluginInfo;
    }

    void finishInstall(@NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptorImpl installedDescriptor, boolean success2, boolean showErrors, boolean restartRequired) {
        List<ListPluginComponent> installedComponents;
        List<ListPluginComponent> marketplaceComponents;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(14);
        }
        InstallPluginInfo info = MyPluginModel.finishInstall(descriptor2);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(false);
        }
        if ((marketplaceComponents = this.myMarketplacePluginComponentMap.get(descriptor2.getPluginId())) != null) {
            for (ListPluginComponent listPluginComponent : marketplaceComponents) {
                if (installedDescriptor != null) {
                    listPluginComponent.setPluginDescriptor(installedDescriptor);
                }
                listPluginComponent.hideProgress(success2, restartRequired);
            }
        }
        if ((installedComponents = this.myInstalledPluginComponentMap.get(descriptor2.getPluginId())) != null) {
            for (ListPluginComponent listComponent : installedComponents) {
                if (installedDescriptor != null) {
                    listComponent.setPluginDescriptor(installedDescriptor);
                }
                listComponent.hideProgress(success2, restartRequired);
                listComponent.updateErrors();
            }
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (!panel2.isShowingPlugin(descriptor2)) continue;
            panel2.setPlugin(installedDescriptor);
            panel2.hideProgress(success2);
        }
        if (info.install) {
            if (this.myInstalling != null && this.myInstalling.ui != null) {
                this.clearInstallingProgress(descriptor2);
                if (myInstallingPlugins.isEmpty()) {
                    this.myInstalledPanel.removeGroup(this.myInstalling);
                } else {
                    this.myInstalledPanel.removeFromGroup(this.myInstalling, descriptor2);
                    this.myInstalling.titleWithCount();
                }
                this.myInstalledPanel.doLayout();
            }
            if (success2) {
                this.appendOrUpdateDescriptor(installedDescriptor != null ? installedDescriptor : descriptor2, restartRequired);
                this.appendDependsAfterInstall();
            } else if (this.myCancelInstallCallback != null) {
                this.myCancelInstallCallback.accept((IdeaPluginDescriptor)descriptor2);
            }
        } else if (success2) {
            ListPluginComponent listPluginComponent;
            if (this.myDownloaded != null && this.myDownloaded.ui != null && restartRequired && (listPluginComponent = this.myDownloaded.ui.findComponent(descriptor2)) != null) {
                listPluginComponent.enableRestart();
            }
        } else {
            this.myPluginUpdatesService.finishUpdate();
        }
        info.indicator.cancel();
        if (success2) {
            this.needRestart = true;
            this.myInstallsRequiringRestart |= restartRequired;
        }
        if (!success2 && showErrors) {
            Messages.showErrorDialog((Project)this.getProject(), (String)IdeBundle.message((String)"plugins.configurable.plugin.installing.failed", (Object[])new Object[]{descriptor2.getName()}), (String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
        }
    }

    private void clearInstallingProgress(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(15);
        }
        if (myInstallingPlugins.isEmpty()) {
            for (ListPluginComponent listComponent : this.myInstalling.ui.plugins) {
                listComponent.clearProgress();
            }
        } else {
            for (ListPluginComponent listComponent : this.myInstalling.ui.plugins) {
                if (listComponent.getPluginDescriptor() != descriptor2) continue;
                listComponent.clearProgress();
                return;
            }
        }
    }

    @NotNull
    static InstallPluginInfo finishInstall(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(16);
        }
        InstallPluginInfo info = myInstallingInfos.remove(descriptor2.getPluginId());
        info.close();
        myInstallingWithUpdatesPlugins.remove(descriptor2);
        if (info.install) {
            myInstallingPlugins.remove(descriptor2);
        }
        InstallPluginInfo installPluginInfo = info;
        if (installPluginInfo == null) {
            MyPluginModel.$$$reportNull$$$0(17);
        }
        return installPluginInfo;
    }

    static void addProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            MyPluginModel.$$$reportNull$$$0(19);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor2.getPluginId()).indicator.addStateDelegate(indicator);
    }

    static void removeProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(20);
        }
        if (indicator == null) {
            MyPluginModel.$$$reportNull$$$0(21);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor2.getPluginId()).indicator.removeStateDelegate(indicator);
    }

    public void addEnabledGroup(@NotNull PluginsGroup group2) {
        if (group2 == null) {
            MyPluginModel.$$$reportNull$$$0(22);
        }
        this.myEnabledGroups.add(group2);
    }

    public void setDownloadedGroup(@NotNull PluginsGroupComponent panel2, @NotNull PluginsGroup downloaded, @NotNull PluginsGroup installing) {
        if (panel2 == null) {
            MyPluginModel.$$$reportNull$$$0(23);
        }
        if (downloaded == null) {
            MyPluginModel.$$$reportNull$$$0(24);
        }
        if (installing == null) {
            MyPluginModel.$$$reportNull$$$0(25);
        }
        this.myInstalledPanel = panel2;
        this.myDownloaded = downloaded;
        this.myInstalling = installing;
    }

    private void appendDependsAfterInstall() {
        if (this.myDownloaded == null || this.myDownloaded.ui == null) {
            return;
        }
        block0: for (IdeaPluginDescriptor descriptor2 : InstalledPluginsState.getInstance().getInstalledPlugins()) {
            if (this.myDownloaded.ui.findComponent(descriptor2) != null) continue;
            this.appendOrUpdateDescriptor(descriptor2, true);
            String id2 = descriptor2.getPluginId().getIdString();
            for (Map.Entry<PluginId, List<ListPluginComponent>> entry : this.myMarketplacePluginComponentMap.entrySet()) {
                if (!id2.equals(entry.getKey().getIdString())) continue;
                for (ListPluginComponent component2 : entry.getValue()) {
                    component2.hideProgress(true, true);
                }
                continue block0;
            }
        }
    }

    public void addDetailPanel(@NotNull PluginDetailsPageComponent detailPanel) {
        if (detailPanel == null) {
            MyPluginModel.$$$reportNull$$$0(26);
        }
        this.myDetailPanels.add(detailPanel);
    }

    private void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
        int index2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(27);
        }
        if ((index2 = this.view.indexOf(descriptor2)) < 0) {
            this.view.add(descriptor2);
        } else {
            this.view.set(index2, descriptor2);
        }
    }

    void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor2, boolean restartNeeded) {
        PluginId id2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(28);
        }
        if (!PluginManagerCore.isPluginInstalled(id2 = descriptor2.getPluginId())) {
            this.appendOrUpdateDescriptor(descriptor2);
            this.setEnabled(id2, PluginEnabledState.ENABLED);
        }
        if (restartNeeded) {
            this.myInstallsRequiringRestart = true;
            this.needRestart = true;
        }
        if (this.myDownloaded == null) {
            return;
        }
        this.myVendorsSorted = null;
        this.myTagsSorted = null;
        if (this.myDownloaded.ui == null) {
            this.myDownloaded.descriptors.add(descriptor2);
            this.myDownloaded.titleWithEnabled(this);
            this.myInstalledPanel.addGroup(this.myDownloaded, this.myInstalling == null || this.myInstalling.ui == null ? 0 : 1);
            this.myInstalledPanel.setSelection(this.myDownloaded.ui.plugins.get(0));
            this.myInstalledPanel.doLayout();
            this.addEnabledGroup(this.myDownloaded);
        } else {
            ListPluginComponent component2 = this.myDownloaded.ui.findComponent(descriptor2);
            if (component2 != null) {
                this.myInstalledPanel.setSelection(component2);
                component2.enableRestart();
                return;
            }
            this.myInstalledPanel.addToGroup(this.myDownloaded, descriptor2);
            this.myDownloaded.titleWithEnabled(this);
            this.myInstalledPanel.setSelection(this.myDownloaded.ui.plugins.get(this.myDownloaded.descriptors.indexOf(descriptor2)));
            this.myInstalledPanel.doLayout();
        }
    }

    @NotNull
    public List<String> getVendors() {
        if (ContainerUtil.isEmpty(this.myVendorsSorted)) {
            this.myVendorsSorted = MyPluginModel.getVendors(this.getInstalledDescriptors());
        }
        List<String> list2 = this.myVendorsSorted;
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(29);
        }
        return list2;
    }

    @NotNull
    public List<String> getTags() {
        if (ContainerUtil.isEmpty(this.myTagsSorted)) {
            HashSet<String> allTags = new HashSet<String>();
            for (IdeaPluginDescriptor descriptor2 : this.getInstalledDescriptors()) {
                allTags.addAll(PluginManagerConfigurable.getTags(descriptor2));
            }
            this.myTagsSorted = ContainerUtil.sorted(allTags, String::compareToIgnoreCase);
        }
        List<String> list2 = this.myTagsSorted;
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    public List<IdeaPluginDescriptor> getInstalledDescriptors() {
        assert (this.myInstalledPanel != null);
        List<IdeaPluginDescriptor> list2 = this.myInstalledPanel.getGroups().stream().flatMap(group2 -> group2.plugins.stream()).map(ListPluginComponent::getPluginDescriptor).collect(Collectors.toList());
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @NotNull
    public static List<String> getVendors(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            MyPluginModel.$$$reportNull$$$0(32);
        }
        HashMap<String, Integer> vendors = new HashMap<String, Integer>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
            String vendor = StringUtil.trim((String)ideaPluginDescriptor.getVendor());
            if (StringUtil.isEmptyOrSpaces((String)vendor)) continue;
            Integer count = (Integer)vendors.get(vendor);
            if (count == null) {
                vendors.put(vendor, 1);
                continue;
            }
            vendors.put(vendor, count + 1);
        }
        List list2 = ContainerUtil.sorted(vendors.keySet(), (v1, v2) -> {
            int result2 = (Integer)vendors.get(v2) - (Integer)vendors.get(v1);
            return result2 == 0 ? v2.compareToIgnoreCase((String)v1) : result2;
        });
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(33);
        }
        return list2;
    }

    public static boolean isVendor(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Set<String> vendors) {
        String vendor;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(34);
        }
        if (vendors == null) {
            MyPluginModel.$$$reportNull$$$0(35);
        }
        if (StringUtil.isEmpty((String)(vendor = StringUtil.trim((String)descriptor2.getVendor())))) {
            return false;
        }
        for (String vendorToFind : vendors) {
            if (!vendor.equalsIgnoreCase(vendorToFind) && !StringUtil.containsIgnoreCase((String)vendor, (String)vendorToFind)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(36);
        }
        return !this.isDisabled(descriptor2.getPluginId());
    }

    @NotNull
    public PluginEnabledState getState(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(37);
        }
        PluginEnabledState pluginEnabledState = this.getState(descriptor2.getPluginId());
        if (pluginEnabledState == null) {
            MyPluginModel.$$$reportNull$$$0(38);
        }
        return pluginEnabledState;
    }

    @NotNull
    ProjectDependentPluginEnabledState getProjectDependentState(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(39);
        }
        PluginId pluginId = descriptor2.getPluginId();
        return new ProjectDependentPluginEnabledState(pluginId, this.getState(pluginId), this.getProject());
    }

    @NotNull
    PluginEnabledState getState(@NotNull PluginId pluginId) {
        PluginEnabledState state;
        if (pluginId == null) {
            MyPluginModel.$$$reportNull$$$0(40);
        }
        PluginEnabledState pluginEnabledState = (state = this.getEnabledMap().get(pluginId)) != null ? state : PluginEnabledState.ENABLED;
        if (pluginEnabledState == null) {
            MyPluginModel.$$$reportNull$$$0(41);
        }
        return pluginEnabledState;
    }

    boolean isRequiredPluginForProject(@NotNull PluginId pluginId) {
        Project project;
        if (pluginId == null) {
            MyPluginModel.$$$reportNull$$$0(42);
        }
        return (project = this.getProject()) != null && this.myRequiredPluginsForProject.computeIfAbsent(pluginId, id2 -> ContainerUtil.exists(MyPluginModel.getDependenciesOnPlugins(project), id2.getIdString()::equals)) != false;
    }

    boolean requiresRestart(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(43);
        }
        return this.myRequiresRestart.computeIfAbsent(descriptor2 instanceof IdeaPluginDescriptorImpl ? (IdeaPluginDescriptorImpl)descriptor2 : null, descriptorImpl -> {
            IdeaPluginDescriptorImpl fullDescriptor = descriptorImpl == null ? null : PluginDescriptorLoader.tryLoadFullDescriptor(descriptorImpl);
            return fullDescriptor == null || DynamicPlugins.checkCanUnloadWithoutRestart(fullDescriptor) != null;
        });
    }

    boolean isUninstalled(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(44);
        }
        return this.myUninstalled.contains(descriptor2);
    }

    void addUninstalled(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(45);
        }
        this.myUninstalled.add(descriptor2);
    }

    public void changeEnableDisable(@NotNull Set<? extends IdeaPluginDescriptor> plugins2, @NotNull PluginEnableDisableAction action2) {
        if (plugins2 == null) {
            MyPluginModel.$$$reportNull$$$0(46);
        }
        if (action2 == null) {
            MyPluginModel.$$$reportNull$$$0(47);
        }
        this.enableRows(plugins2, action2);
        this.updateAfterEnableDisable();
        this.runInvalidFixCallback();
    }

    @Override
    public void enablePlugins(@NotNull Set<? extends IdeaPluginDescriptor> plugins2) {
        if (plugins2 == null) {
            MyPluginModel.$$$reportNull$$$0(48);
        }
        this.changeEnableDisable(plugins2, PluginEnableDisableAction.ENABLE_GLOBALLY);
    }

    @Override
    public void disablePlugins(@NotNull Set<? extends IdeaPluginDescriptor> plugins2) {
        if (plugins2 == null) {
            MyPluginModel.$$$reportNull$$$0(49);
        }
        this.changeEnableDisable(plugins2, PluginEnableDisableAction.DISABLE_GLOBALLY);
    }

    void enableRequiredPlugins(@NotNull IdeaPluginDescriptor descriptor2) {
        Set<PluginId> requiredPluginIds;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(50);
        }
        if (ContainerUtil.isEmpty(requiredPluginIds = this.getRequiredPlugins(descriptor2.getPluginId()))) {
            return;
        }
        List<IdeaPluginDescriptor> allPlugins = this.getAllPlugins();
        HashSet<IdeaPluginDescriptor> requiredPlugins = new HashSet<IdeaPluginDescriptor>();
        for (PluginId pluginId : requiredPluginIds) {
            IdeaPluginDescriptor result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> pluginId.equals(d.getPluginId()));
            if (result2 == null && PluginManagerCore.isModuleDependency(pluginId) && (result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> d instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)d).getModules().contains(pluginId))) != null) {
                this.setEnabled(pluginId, PluginEnabledState.ENABLED);
            }
            if (result2 == null) continue;
            requiredPlugins.add(result2);
        }
        if (!requiredPlugins.isEmpty()) {
            this.enablePlugins(requiredPlugins);
        }
    }

    @Override
    protected void handleBeforeChangeEnableState(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Pair<PluginEnableDisableAction, PluginEnabledState> pair) {
        PluginEnabledState newState2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(51);
        }
        if (pair == null) {
            MyPluginModel.$$$reportNull$$$0(52);
        }
        PluginId pluginId = descriptor2.getPluginId();
        Pair<PluginEnableDisableAction, PluginEnabledState> oldPair = this.myDiff.get(descriptor2);
        PluginEnabledState oldState = oldPair != null ? (PluginEnabledState)((Object)oldPair.getSecond()) : null;
        if (oldState != (newState2 = (PluginEnabledState)((Object)pair.getSecond()))) {
            PluginEnabledState state = oldState != null ? oldState : this.getState(pluginId);
            this.myDiff.put(descriptor2, (Pair<PluginEnableDisableAction, PluginEnabledState>)Pair.create((Object)((Object)((PluginEnableDisableAction)((Object)pair.getFirst()))), (Object)((Object)state)));
        } else {
            this.myDiff.remove(descriptor2);
        }
        this.myErrorPluginsToDisable.remove(pluginId);
        if (newState2.isEnabled() || descriptor2.isEnabled()) {
            return;
        }
        if (PluginManagerCore.isIncompatible(descriptor2) || PluginManagerCore.isBrokenPlugin(descriptor2) || this.hasProblematicDependencies(pluginId)) {
            this.myErrorPluginsToDisable.add(pluginId);
        }
    }

    private void runInvalidFixCallback() {
        if (this.myInvalidFixCallback != null) {
            ApplicationManager.getApplication().invokeLater(this.myInvalidFixCallback, ModalityState.any());
        }
    }

    public void setInvalidFixCallback(@Nullable Runnable invalidFixCallback) {
        this.myInvalidFixCallback = invalidFixCallback;
    }

    public void setCancelInstallCallback(@NotNull Consumer<? super IdeaPluginDescriptor> callback2) {
        if (callback2 == null) {
            MyPluginModel.$$$reportNull$$$0(53);
        }
        this.myCancelInstallCallback = callback2;
    }

    private void updateAfterEnableDisable() {
        for (ListPluginComponent component2 : this.myInstalledPluginComponents) {
            component2.updateEnabledState();
        }
        for (PluginDetailsPageComponent detailPanel : this.myDetailPanels) {
            detailPanel.updateEnabledState();
        }
        for (PluginsGroup group2 : this.myEnabledGroups) {
            group2.titleWithEnabled(this);
        }
    }

    public void runRestartButton(@NotNull Component component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(54);
        }
        if (PluginManagerConfigurable.showRestartDialog() == 0) {
            this.needRestart = true;
            this.createShutdownCallback = false;
            DialogWrapper settings = DialogWrapper.findInstance((Component)component2);
            if (settings instanceof SettingsDialog) {
                ((SettingsDialog)settings).applyAndClose(false);
            } else if (this.isModified()) {
                try {
                    this.apply(null);
                }
                catch (ConfigurationException e) {
                    LOG.error((Throwable)e);
                }
            }
            ApplicationManager.getApplication().exit(true, false, true);
        }
    }

    static boolean showUninstallDialog(@NotNull Component uiParent, @Nullable String singleName, int count) {
        if (uiParent == null) {
            MyPluginModel.$$$reportNull$$$0(55);
        }
        String message2 = singleName == null ? IdeBundle.message((String)"prompt.uninstall.several.plugins", (Object[])new Object[]{count}) : IdeBundle.message((String)"prompt.uninstall.plugin", (Object[])new Object[]{singleName});
        return MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0]), (String)message2).ask(uiParent);
    }

    void uninstallAndUpdateUi(@NotNull Component uiParent, @NotNull IdeaPluginDescriptor descriptor2) {
        List<IdeaPluginDescriptor> deps;
        if (uiParent == null) {
            MyPluginModel.$$$reportNull$$$0(56);
        }
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(57);
        }
        if (!(deps = this.dependent(descriptor2)).isEmpty()) {
            String listOfDeps = StringUtil.join(deps, plugin2 -> "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + plugin2.getName(), (String)"<br>");
            String message2 = XmlStringUtil.wrapInHtml((CharSequence)IdeBundle.message((String)"dialog.message.following.plugin.depend.on", (Object[])new Object[]{deps.size(), descriptor2.getName(), listOfDeps}));
            String title = IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0]);
            if (!MessageDialogBuilder.yesNo((String)title, (String)message2).ask(uiParent)) {
                return;
            }
        }
        boolean needRestartForUninstall = this.performUninstall((IdeaPluginDescriptorImpl)descriptor2);
        this.needRestart |= descriptor2.isEnabled() && needRestartForUninstall;
        this.myInstallsRequiringRestart |= needRestartForUninstall;
        List<ListPluginComponent> listComponents = this.myInstalledPluginComponentMap.get(descriptor2.getPluginId());
        if (listComponents != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.updateAfterUninstall(needRestartForUninstall);
            }
        }
        for (ListPluginComponent component2 : this.myInstalledPluginComponents) {
            component2.updateErrors();
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.getPlugin() != descriptor2) continue;
            panel2.updateButtons();
        }
    }

    private boolean performUninstall(IdeaPluginDescriptorImpl descriptorImpl) {
        boolean needRestartForUninstall = true;
        try {
            descriptorImpl.setDeleted(true);
            IdeaPluginDescriptorImpl fullDescriptor = PluginDescriptorLoader.tryLoadFullDescriptor(descriptorImpl);
            LOG.assertTrue(fullDescriptor != null);
            needRestartForUninstall = PluginInstaller.prepareToUninstall(fullDescriptor);
            InstalledPluginsState.getInstance().onPluginUninstall(descriptorImpl, needRestartForUninstall);
            if (!needRestartForUninstall) {
                this.myDynamicPluginsToUninstall.add(fullDescriptor);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return needRestartForUninstall;
    }

    @Nullable
    public static IdeaPluginDescriptor findPlugin(@NotNull PluginId id2) {
        IdeaPluginDescriptor descriptor2;
        IdeaPluginDescriptor plugin2;
        if (id2 == null) {
            MyPluginModel.$$$reportNull$$$0(58);
        }
        if ((plugin2 = PluginManagerCore.getPlugin(id2)) == null && PluginManagerCore.isModuleDependency(id2) && (descriptor2 = PluginManagerCore.findPluginByModuleDependency(id2)) != null) {
            return descriptor2;
        }
        return plugin2;
    }

    public boolean hasProblematicDependencies(PluginId pluginId) {
        Set<PluginId> ids = this.getDependentToRequiredListMap().get(pluginId);
        if (ContainerUtil.isEmpty(ids)) {
            return false;
        }
        for (PluginId id2 : ids) {
            IdeaPluginDescriptor plugin2 = MyPluginModel.findPlugin(id2);
            if (plugin2 == null || this.isEnabled(plugin2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors(@NotNull IdeaPluginDescriptor plugin2) {
        if (plugin2 == null) {
            MyPluginModel.$$$reportNull$$$0(59);
        }
        return this.getErrorMessage(plugin2, null) != null;
    }

    @Nullable
    @Nls
    public String getErrorMessage(@NotNull IdeaPluginDescriptor pluginDescriptor, @Nullable Ref<? super @Nls String> enableAction) {
        if (pluginDescriptor == null) {
            MyPluginModel.$$$reportNull$$$0(60);
        }
        if (pluginDescriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)pluginDescriptor).isDeleted()) {
            return null;
        }
        if (InstalledPluginsState.getInstance().wasUninstalledWithoutRestart(pluginDescriptor.getPluginId())) {
            return null;
        }
        if (InstalledPluginsState.getInstance().wasInstalledWithoutRestart(pluginDescriptor.getPluginId())) {
            return null;
        }
        String message2 = PluginManagerCore.getShortLoadingErrorMessage(pluginDescriptor);
        PluginId disabledDependency = PluginManagerCore.getFirstDisabledDependency(pluginDescriptor);
        if (disabledDependency != null) {
            Set<PluginId> requiredPlugins = MyPluginModel.filterRequiredPlugins(this.getRequiredPlugins(pluginDescriptor.getPluginId()));
            if (!ContainerUtil.isEmpty(requiredPlugins)) {
                boolean[] enable = new boolean[]{true};
                String deps = StringUtil.join(requiredPlugins, id2 -> {
                    IdeaPluginDescriptor plugin2 = MyPluginModel.findPlugin(id2);
                    if (enable[0] && (plugin2 == null || PluginManagerCore.isIncompatible(plugin2))) {
                        enable[0] = false;
                    }
                    return StringUtil.wrapWithDoubleQuote((String)(plugin2 != null ? plugin2.getName() : id2.getIdString()));
                }, (String)", ");
                int size = requiredPlugins.size();
                message2 = IdeBundle.message((String)"new.plugin.manager.incompatible.deps.tooltip", (Object[])new Object[]{size, deps});
                if (enable[0] && enableAction != null) {
                    enableAction.set((Object)IdeBundle.message((String)"new.plugin.manager.incompatible.deps.action", (Object[])new Object[]{size}));
                }
            } else {
                message2 = null;
            }
        }
        return message2;
    }

    @Nullable
    private static Set<PluginId> filterRequiredPlugins(@Nullable Set<PluginId> requiredPlugins) {
        if (ContainerUtil.isEmpty(requiredPlugins)) {
            return requiredPlugins;
        }
        return requiredPlugins.stream().filter(id2 -> {
            IdeaPluginDescriptor plugin2 = MyPluginModel.findPlugin(id2);
            return plugin2 == null || !plugin2.isEnabled();
        }).collect(Collectors.toSet());
    }

    @NotNull
    protected Collection<IdeaPluginDescriptor> getCustomRepoPlugins() {
        Collection<IdeaPluginDescriptor> collection = CustomPluginRepositoryService.getInstance().getCustomRepositoryPlugins();
        if (collection == null) {
            MyPluginModel.$$$reportNull$$$0(61);
        }
        return collection;
    }

    @NotNull
    private List<IdeaPluginDescriptor> dependent(@NotNull IdeaPluginDescriptor rootDescriptor) {
        if (rootDescriptor == null) {
            MyPluginModel.$$$reportNull$$$0(62);
        }
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        PluginId rootId = rootDescriptor.getPluginId();
        ArrayList<IdeaPluginDescriptor> result2 = new ArrayList<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor plugin2 : this.getAllPlugins()) {
            PluginId pluginId = plugin2.getPluginId();
            if (pluginId == rootId || appInfo.isEssentialPlugin(pluginId) || !plugin2.isEnabled() || plugin2.isImplementationDetail() || !(plugin2 instanceof IdeaPluginDescriptorImpl) || ((IdeaPluginDescriptorImpl)plugin2).isDeleted()) continue;
            PluginManagerCore.processAllDependencies((IdeaPluginDescriptorImpl)plugin2, false, PluginManagerCore.buildPluginIdMap(), (id2, descriptor2) -> {
                if (id2 == rootId) {
                    result2.add(plugin2);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            });
        }
        ArrayList<IdeaPluginDescriptor> arrayList = result2;
        if (arrayList == null) {
            MyPluginModel.$$$reportNull$$$0(63);
        }
        return arrayList;
    }

    @NotNull
    public Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2, boolean big, boolean error, boolean disabled) {
        String key;
        Icon icon2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(64);
        }
        if ((icon2 = this.myIcons.get(key = descriptor2.getPluginId().getIdString() + big + error + disabled)) == null && (icon2 = PluginLogo.getIcon(descriptor2, big, error, disabled)) != PluginLogo.getDefault().getIcon(big, error, disabled)) {
            this.myIcons.put(key, icon2);
        }
        Icon icon3 = icon2;
        if (icon3 == null) {
            MyPluginModel.$$$reportNull$$$0(65);
        }
        return icon3;
    }

    @NotNull
    private static List<String> getDependenciesOnPlugins(@NotNull Project project) {
        if (project == null) {
            MyPluginModel.$$$reportNull$$$0(66);
        }
        List list2 = ContainerUtil.map(ExternalDependenciesManager.getInstance(project).getDependencies(DependencyOnPlugin.class), DependencyOnPlugin::getPluginId);
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(67);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 13: 
            case 17: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 38: 
            case 41: 
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 13: 
            case 17: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 38: 
            case 41: 
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackData";
                break;
            }
            case 1: 
            case 2: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topController";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: 
            case 13: 
            case 17: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 38: 
            case 41: 
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 27: 
            case 28: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 50: 
            case 51: 
            case 57: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloaded";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installing";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailPanel";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendors";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 46: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiParent";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallingPlugins";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareToInstall";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "finishInstall";
                break;
            }
            case 29: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendors";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDescriptors";
                break;
            }
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRepoPlugins";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "dependent";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesOnPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pluginInstalledFromDisk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTopController";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setPluginUpdatesService";
                break;
            }
            case 5: 
            case 13: 
            case 17: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 38: 
            case 41: 
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInstallingOrUpdate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installOrUpdatePlugin";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installPlugin";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "finishInstall";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clearInstallingProgress";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addProgress";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeProgress";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addEnabledGroup";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setDownloadedGroup";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addDetailPanel";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendOrUpdateDescriptor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getVendors";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isVendor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 37: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDependentState";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isRequiredPluginForProject";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "requiresRestart";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isUninstalled";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addUninstalled";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "changeEnableDisable";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugins";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugins";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "enableRequiredPlugins";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeChangeEnableState";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setCancelInstallCallback";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "runRestartButton";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "showUninstallDialog";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "uninstallAndUpdateUi";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "hasErrors";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "dependent";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getDependenciesOnPlugins";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 13: 
            case 17: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 38: 
            case 41: 
            case 61: 
            case 63: 
            case 65: 
            case 67: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

