/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.certificates.PluginCertificateStore;
import com.intellij.ide.plugins.marketplace.PluginSignatureChecker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.verifier.InvalidSignatureResult;
import org.jetbrains.zip.signer.verifier.MissingSignatureResult;
import org.jetbrains.zip.signer.verifier.SuccessfulVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerifier;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0015\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J+\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u00132\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0015\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u001fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/intellij/ide/plugins/marketplace/PluginSignatureChecker;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "certificateStore", "Lcom/intellij/ide/plugins/certificates/PluginCertificateStore;", "jetbrainsCertificate", "Ljava/security/cert/Certificate;", "getJetbrainsCertificate", "()Ljava/security/cert/Certificate;", "jetbrainsCertificate$delegate", "Lkotlin/Lazy;", "isSignedBy", "", "pluginName", "", "pluginFile", "Ljava/io/File;", "certificate", "", "(Ljava/lang/String;Ljava/io/File;[Ljava/security/cert/Certificate;)Z", "isSignedByAnyCertificates", "isSignedByCustomCertificates", "isSignedByJetBrains", "processSignatureWarning", "errorMessage", "verifyPluginAndGetErrorMessage", "file", "certificates", "(Ljava/io/File;[Ljava/security/cert/Certificate;)Ljava/lang/String;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class PluginSignatureChecker {
    private static final Logger LOG;
    private static final Lazy jetbrainsCertificate$delegate;
    private static final PluginCertificateStore certificateStore;
    @NotNull
    public static final PluginSignatureChecker INSTANCE;

    private final Certificate getJetbrainsCertificate() {
        Lazy lazy = jetbrainsCertificate$delegate;
        PluginSignatureChecker pluginSignatureChecker = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Certificate)lazy.getValue();
    }

    @JvmStatic
    public static final boolean isSignedByAnyCertificates(@NotNull String pluginName, @NotNull File pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        Certificate certificate = INSTANCE.getJetbrainsCertificate();
        if (certificate == null) {
            String string = IdeBundle.message((String)"jetbrains.certificate.not.found", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"jetbr\u2026s.certificate.not.found\")");
            return INSTANCE.processSignatureWarning(pluginName, string);
        }
        Certificate jbCert = certificate;
        List list2 = certificateStore.getCustomTrustManager().getCertificates();
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List certificates = CollectionsKt.plus((Collection)list3, (Object)jbCert);
        Collection $this$toTypedArray$iv = certificates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Certificate[] certificateArray = thisCollection$iv.toArray(new Certificate[0]);
        if (certificateArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return INSTANCE.isSignedBy(pluginName, pluginFile, Arrays.copyOf(certificateArray, certificateArray.length));
    }

    @JvmStatic
    public static final boolean isSignedByCustomCertificates(@NotNull String pluginName, @NotNull File pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        List certificates = certificateStore.getCustomTrustManager().getCertificates();
        if (certificates.isEmpty()) {
            return true;
        }
        List list2 = certificates;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"certificates");
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
        if (x509CertificateArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Certificate[] certificateArray = x509CertificateArray;
        return INSTANCE.isSignedBy(pluginName, pluginFile, Arrays.copyOf(certificateArray, certificateArray.length));
    }

    @JvmStatic
    public static final boolean isSignedByJetBrains(@NotNull String pluginName, @NotNull File pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        Certificate certificate = INSTANCE.getJetbrainsCertificate();
        if (certificate == null) {
            String string = IdeBundle.message((String)"jetbrains.certificate.not.found", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"jetbr\u2026s.certificate.not.found\")");
            return INSTANCE.processSignatureWarning(pluginName, string);
        }
        Certificate jbCert = certificate;
        return INSTANCE.isSignedBy(pluginName, pluginFile, jbCert);
    }

    private final boolean isSignedBy(String pluginName, File pluginFile, Certificate ... certificate) {
        String errorMessage = this.verifyPluginAndGetErrorMessage(pluginFile, Arrays.copyOf(certificate, certificate.length));
        if (errorMessage != null) {
            return this.processSignatureWarning(pluginName, errorMessage);
        }
        return true;
    }

    private final String verifyPluginAndGetErrorMessage(File file2, Certificate ... certificates) {
        String string;
        ZipVerificationResult verificationResult = ZipVerifier.INSTANCE.verify(file2);
        if (verificationResult instanceof InvalidSignatureResult) {
            string = ((InvalidSignatureResult)verificationResult).getErrorMessage();
        } else if (verificationResult instanceof MissingSignatureResult) {
            string = IdeBundle.message((String)"plugin.signature.not.signed", (Object[])new Object[0]);
        } else if (verificationResult instanceof SuccessfulVerificationResult) {
            boolean isSigned;
            block7: {
                boolean bl;
                Certificate[] $this$any$iv = certificates;
                boolean $i$f$any = false;
                Certificate[] certificateArray = $this$any$iv;
                int n = certificateArray.length;
                for (int j = 0; j < n; ++j) {
                    Certificate element$iv;
                    Certificate certificate = element$iv = certificateArray[j];
                    boolean bl2 = false;
                    if (!((SuccessfulVerificationResult)verificationResult).isSignedBy(certificate)) continue;
                    bl = true;
                    break block7;
                }
                bl = isSigned = false;
            }
            string = !isSigned ? IdeBundle.message((String)"plugin.signature.not.signed.by", (Object[])new Object[0]) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean processSignatureWarning(String pluginName, String errorMessage) {
        void result2;
        String title = IdeBundle.message((String)"plugin.signature.checker.title", (Object[])new Object[0]);
        String message2 = IdeBundle.message((String)"plugin.signature.checker.untrusted.message", (Object[])new Object[]{pluginName, errorMessage});
        String yesText = IdeBundle.message((String)"plugin.signature.checker.yes", (Object[])new Object[0]);
        String noText = IdeBundle.message((String)"plugin.signature.checker.no", (Object[])new Object[0]);
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        ApplicationManager.getApplication().invokeAndWait(new Runnable((Ref.IntRef)result2, message2, title, yesText, noText){
            final /* synthetic */ Ref.IntRef $result;
            final /* synthetic */ String $message;
            final /* synthetic */ String $title;
            final /* synthetic */ String $yesText;
            final /* synthetic */ String $noText;

            public final void run() {
                this.$result.element = Messages.showYesNoDialog((String)this.$message, (String)this.$title, (String)this.$yesText, (String)this.$noText, (Icon)Messages.getWarningIcon());
            }
            {
                this.$result = intRef;
                this.$message = string;
                this.$title = string2;
                this.$yesText = string3;
                this.$noText = string4;
            }
        }, ModalityState.any());
        return result2.element == 0;
    }

    private PluginSignatureChecker() {
    }

    static {
        PluginSignatureChecker pluginSignatureChecker;
        INSTANCE = pluginSignatureChecker = new PluginSignatureChecker();
        Logger logger = Logger.getInstance(PluginSignatureChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Plugi\u2026atureChecker::class.java)");
        LOG = logger;
        jetbrainsCertificate$delegate = LazyKt.lazy((Function0)jetbrainsCertificate.2.INSTANCE);
        certificateStore = PluginCertificateStore.Companion.getInstance();
    }

    public static final /* synthetic */ Logger access$getLOG$p(PluginSignatureChecker $this) {
        PluginSignatureChecker pluginSignatureChecker = $this;
        return LOG;
    }
}

