/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\bR$\u0010\u0003\u001a\u0018\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/plugins/marketplace/PluginModulesHelper;", "", "()V", "pluginsModuleCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lcom/intellij/ide/plugins/marketplace/PluginModule;", "Ljava/util/Optional;", "Lcom/intellij/openapi/extensions/PluginId;", "getInstalledPluginIdByModule", "depPluginId", "getMarketplacePluginIdByModule", "Companion", "intellij.platform.ide.impl"})
public class PluginModulesHelper {
    private final Cache<String, Optional<PluginId>> pluginsModuleCache;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final PluginId getMarketplacePluginIdByModule(@NotNull PluginId depPluginId) {
        PluginId cachedModule;
        Intrinsics.checkNotNullParameter((Object)depPluginId, (String)"depPluginId");
        IdeaPluginDescriptor installedPluginWithModule = PluginManagerCore.findPluginByModuleDependency(depPluginId);
        if (installedPluginWithModule != null) {
            return installedPluginWithModule.getPluginId();
        }
        String string = depPluginId.getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"depPluginId.idString");
        String pluginModule = string;
        Optional optional = (Optional)this.pluginsModuleCache.getIfPresent((Object)pluginModule);
        PluginId pluginId = cachedModule = optional != null ? (PluginId)optional.orElse(null) : null;
        if (cachedModule != null) {
            return cachedModule;
        }
        List updatesByModule = MarketplaceRequests.getCompatibleUpdatesByModule$default(MarketplaceRequests.Companion.getInstance(), pluginModule, null, 2, null);
        IdeCompatibleUpdate ideCompatibleUpdate = (IdeCompatibleUpdate)CollectionsKt.firstOrNull((List)updatesByModule);
        IdeCompatibleUpdate ideCompatibleUpdate2 = ideCompatibleUpdate;
        if (ideCompatibleUpdate == null) return null;
        IdeCompatibleUpdate ideCompatibleUpdate3 = ideCompatibleUpdate2;
        boolean bl = false;
        boolean bl2 = false;
        IdeCompatibleUpdate it = ideCompatibleUpdate3;
        boolean bl3 = false;
        PluginId pluginId2 = PluginId.getId((String)it.getPluginId());
        ideCompatibleUpdate2 = pluginId2;
        if (pluginId2 == null) return null;
        ideCompatibleUpdate3 = ideCompatibleUpdate2;
        bl = false;
        bl2 = false;
        it = ideCompatibleUpdate3;
        boolean bl4 = false;
        this.pluginsModuleCache.put((Object)pluginModule, Optional.ofNullable(it));
        IdeCompatibleUpdate ideCompatibleUpdate4 = ideCompatibleUpdate3;
        return ideCompatibleUpdate4;
    }

    @Nullable
    public final PluginId getInstalledPluginIdByModule(@NotNull PluginId depPluginId) {
        Intrinsics.checkNotNullParameter((Object)depPluginId, (String)"depPluginId");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.findPluginByModuleDependency(depPluginId);
        return ideaPluginDescriptor != null ? ideaPluginDescriptor.getPluginId() : null;
    }

    public PluginModulesHelper() {
        Cache cache2 = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"Caffeine\n    .newBuilder\u2026eUnit.HOURS)\n    .build()");
        this.pluginsModuleCache = cache2;
    }

    @JvmStatic
    @NotNull
    public static final PluginModulesHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/plugins/marketplace/PluginModulesHelper$Companion;", "", "()V", "getInstance", "Lcom/intellij/ide/plugins/marketplace/PluginModulesHelper;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PluginModulesHelper getInstance() {
            boolean $i$f$service = false;
            Class<PluginModulesHelper> serviceClass$iv = PluginModulesHelper.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (PluginModulesHelper)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

