/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.AggregationSearchResponse;
import com.intellij.ide.plugins.marketplace.CompatibleUpdateForModuleRequest;
import com.intellij.ide.plugins.marketplace.CompatibleUpdateRequest;
import com.intellij.ide.plugins.marketplace.FeatureImpl;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.IntellijUpdateMetadata;
import com.intellij.ide.plugins.marketplace.MarketplaceBrokenPlugin;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests$loadJetBrainsPluginsIds$1$2;
import com.intellij.ide.plugins.marketplace.MarketplaceRequestsKt;
import com.intellij.ide.plugins.marketplace.MarketplaceSearchPluginData;
import com.intellij.ide.plugins.marketplace.RepositoryContentHandler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.IoErrorText;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 U2\u00020\u0001:\u0001UB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0016\u001a\u00020\b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0016J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040&J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0&J\r\u0010*\u001a\u00020$H\u0000\u00a2\u0006\u0002\b+J\u0006\u0010,\u001a\u00020\u0004J\"\u0010-\u001a\b\u0012\u0004\u0012\u00020.0&2\u0006\u0010/\u001a\u00020\u00042\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0007J \u00102\u001a\b\u0012\u0004\u0012\u0002030&2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018J*\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u00042\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0007J&\u00104\u001a\b\u0012\u0004\u0012\u00020.0&2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00040&2\n\b\u0002\u00100\u001a\u0004\u0018\u000101J\u000e\u00108\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00040&2\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020.H\u0002J\u0010\u0010<\u001a\u00020\u00042\u0006\u0010;\u001a\u00020.H\u0002J\b\u0010=\u001a\u00020$H\u0002J\u0006\u0010>\u001a\u00020?J(\u0010@\u001a\b\u0012\u0004\u0012\u0002050&2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00040&2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0007J\"\u0010A\u001a\u0002052\u0006\u0010B\u001a\u00020\u00042\u0006\u0010C\u001a\u00020.2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u000e\u0010D\u001a\u0002052\u0006\u0010E\u001a\u000205J\u0018\u0010F\u001a\n H*\u0004\u0018\u00010G0G2\u0006\u0010I\u001a\u00020JH\u0002J$\u0010K\u001a\u0016\u0012\u0004\u0012\u00020\u0004 H*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&0&2\u0006\u0010I\u001a\u00020JH\u0002JK\u0010L\u001a\u0002HM\"\u0004\b\u0000\u0010M2\b\u0010N\u001a\u0004\u0018\u00010$2\u0006\u0010O\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010!2\b\b\u0001\u0010P\u001a\u00020\u00042\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u0002HM0R\u00a2\u0006\u0002\u0010SJ\u001c\u0010T\u001a\b\u0012\u0004\u0012\u0002050&2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006V"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests;", "", "()V", "COMPATIBLE_UPDATE_URL", "", "IDE_BUILD_FOR_REQUEST", "Lorg/jetbrains/annotations/NotNull;", "JETBRAINS_PLUGINS_URL", "Lcom/intellij/util/Url;", "MARKETPLACE_ORGANIZATIONS_URL", "PLUGIN_MANAGER_URL", "<set-?>", "", "jetBrainsPluginsIds", "getJetBrainsPluginsIds", "()Ljava/util/Set;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "createFeatureUrl", "param", "", "createSearchUrl", "query", "count", "", "downloadPlugin", "Ljava/io/File;", "pluginUrl", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadPluginViaBlockMap", "prevPlugin", "Ljava/nio/file/Path;", "getAllPluginsTags", "", "getAllPluginsVendors", "getBrokenPlugins", "Lcom/intellij/ide/plugins/marketplace/MarketplaceBrokenPlugin;", "getBrokenPluginsFile", "getBrokenPluginsFile$intellij_platform_ide_impl", "getBuildForPluginRepositoryRequests", "getCompatibleUpdatesByModule", "Lcom/intellij/ide/plugins/marketplace/IdeCompatibleUpdate;", "module", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "getFeatures", "Lcom/intellij/ide/plugins/marketplace/FeatureImpl;", "getLastCompatiblePluginUpdate", "Lcom/intellij/ide/plugins/PluginNode;", "id", "ids", "getMarketplaceCachedPlugins", "getMarketplacePlugins", "getUpdateMetadataFile", "update", "getUpdateMetadataUrl", "getUpdatesMetadataFilesDirectory", "loadJetBrainsPluginsIds", "", "loadLastCompatiblePluginDescriptors", "loadPluginDescriptor", "xmlId", "ideCompatibleUpdate", "loadPluginDetails", "pluginNode", "parseJsonPluginMeta", "Lcom/intellij/ide/plugins/marketplace/IntellijUpdateMetadata;", "kotlin.jvm.PlatformType", "reader", "Ljava/io/Reader;", "parseXmlIds", "readOrUpdateFile", "T", "file", "url", "indicatorMessage", "parser", "Lkotlin/Function1;", "(Ljava/nio/file/Path;Ljava/lang/String;Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "searchPlugins", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class MarketplaceRequests {
    private final String PLUGIN_MANAGER_URL;
    private final String IDE_BUILD_FOR_REQUEST;
    private final Url MARKETPLACE_ORGANIZATIONS_URL;
    private final Url JETBRAINS_PLUGINS_URL;
    private final String COMPATIBLE_UPDATE_URL;
    private final Lazy objectMapper$delegate;
    @Nullable
    private Set<String> jetBrainsPluginsIds;
    private static final MarketplaceRequests INSTANCE;
    @NotNull
    public static final Companion Companion;

    private final ObjectMapper getObjectMapper() {
        Lazy lazy = this.objectMapper$delegate;
        MarketplaceRequests marketplaceRequests = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ObjectMapper)lazy.getValue();
    }

    private final Path getUpdatesMetadataFilesDirectory() {
        Path path = Paths.get(PathManager.getPluginsPath(), "meta");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.getPluginsPath(), \"meta\")");
        return path;
    }

    @NotNull
    public final Path getBrokenPluginsFile$intellij_platform_ide_impl() {
        Path path = Paths.get(PathManager.getPluginsPath(), "brokenPlugins.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.ge\u2026(), \"brokenPlugins.json\")");
        return path;
    }

    private final Path getUpdateMetadataFile(IdeCompatibleUpdate update2) {
        Path path = this.getUpdatesMetadataFilesDirectory().resolve(update2.getExternalUpdateId() + ".json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getUpdatesMetadataFilesD\u2026ternalUpdateId + \".json\")");
        return path;
    }

    private final String getUpdateMetadataUrl(IdeCompatibleUpdate update2) {
        return this.PLUGIN_MANAGER_URL + "/files/" + update2.getExternalPluginId() + '/' + update2.getExternalUpdateId() + "/meta.json";
    }

    private final Url createSearchUrl(String query2, int count) {
        return Urls.newFromEncoded((String)(this.PLUGIN_MANAGER_URL + "/api/search/plugins?" + query2 + "&build=" + this.IDE_BUILD_FOR_REQUEST + "&max=" + count));
    }

    private final Url createFeatureUrl(Map<String, String> param) {
        Url url = Urls.newFromEncoded((String)(this.PLUGIN_MANAGER_URL + "/feature/getImplementations")).addParameters(param);
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"Urls.newFromEncoded(\"${P\u2026ns\").addParameters(param)");
        return url;
    }

    @NotNull
    public final List<FeatureImpl> getFeatures(@NotNull Map<String, String> param) {
        Intrinsics.checkNotNullParameter(param, (String)"param");
        if (param.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        try {
            Object object = HttpRequests.request((Url)this.createFeatureUrl(param)).throwStatusCodeException(false).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends FeatureImpl>>(this){
                final /* synthetic */ MarketplaceRequests this$0;

                public final List<FeatureImpl> process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (List)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends FeatureImpl>>(){});
                }
                {
                    this.this$0 = marketplaceRequests;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n        .re\u2026 {}\n          )\n        }");
            return (List)object;
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get features from Marketplace", e);
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public final List<String> getMarketplacePlugins(@Nullable ProgressIndicator indicator) throws IOException {
        Path pluginXmlIdsFile = Paths.get(PathManager.getPluginsPath(), "pluginsXMLIds.json");
        String string = this.PLUGIN_MANAGER_URL + "/files/pluginsXMLIds.json";
        String string2 = IdeBundle.message((String)"progress.downloading.available.plugins", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"progr\u2026ading.available.plugins\")");
        Object t = this.readOrUpdateFile(pluginXmlIdsFile, string, indicator, string2, (Function1)new Function1<Reader, List<? extends String>>(this){

            public final List<String> invoke(@NotNull Reader p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return MarketplaceRequests.access$parseXmlIds((MarketplaceRequests)this.receiver, p1);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"readOrUpdateFile(\n      \u2026      ::parseXmlIds\n    )");
        return (List)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final List<String> getMarketplaceCachedPlugins() throws IOException {
        block7: {
            Path pluginXmlIdsFile = Paths.get(PathManager.getPluginsPath(), "pluginsXMLIds.json");
            try {
                List<String> list2;
                if (Files.size(pluginXmlIdsFile) <= 0L) break block7;
                Closeable closeable = Files.newBufferedReader(pluginXmlIdsFile);
                MarketplaceRequests marketplaceRequests = this;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Reader p1 = (Reader)closeable;
                    boolean bl3 = false;
                    list2 = marketplaceRequests.parseXmlIds(p1);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return list2;
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public final String getBuildForPluginRepositoryRequests() {
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
        ApplicationInfoEx appInfo = applicationInfoEx;
        String string = PluginManagerCore.getPluginsCompatibleBuild();
        if (string == null) {
            string = appInfo.getApiVersion();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PluginManagerCore.getPlu\u2026d() ?: appInfo.apiVersion");
        String compatibleBuild = string;
        BuildNumber buildNumber = appInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"appInfo.build");
        BuildNumber buildNumber2 = BuildNumber.fromStringWithProductCode((String)compatibleBuild, (String)buildNumber.getProductCode());
        Intrinsics.checkNotNull((Object)buildNumber2);
        String string2 = buildNumber2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BuildNumber.fromStringWi\u2026productCode)!!.asString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginNode> searchPlugins(@NotNull String query2, int count) throws IOException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        MarketplaceSearchPluginData it;
        void $this$filterTo$iv$iv;
        List marketplaceSearchPluginData2;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        List list2 = marketplaceSearchPluginData2 = (List)HttpRequests.request((Url)this.createSearchUrl(query2, count)).throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends MarketplaceSearchPluginData>>(this){
            final /* synthetic */ MarketplaceRequests this$0;

            public final List<MarketplaceSearchPluginData> process(@NotNull HttpRequests.Request it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (List)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends MarketplaceSearchPluginData>>(){});
            }
            {
                this.this$0 = marketplaceRequests;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"marketplaceSearchPluginData");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MarketplaceSearchPluginData)element$iv$iv;
            boolean bl = false;
            if (!(it.getExternalUpdateId() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MarketplaceSearchPluginData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PluginNode pluginNode = it.toPluginNode();
            collection.add(pluginNode);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> getAllPluginsVendors() {
        try {
            Object object = HttpRequests.request((Url)this.MARKETPLACE_ORGANIZATIONS_URL).productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends String>>(this){
                final /* synthetic */ MarketplaceRequests this$0;

                public final List<String> process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return CollectionsKt.toList((Iterable)((AggregationSearchResponse)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), AggregationSearchResponse.class)).getAggregations().keySet());
                }
                {
                    this.this$0 = marketplaceRequests;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n        .re\u2026s.keys.toList()\n        }");
            return (List)object;
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get organizations from Marketplace", e);
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public final List<MarketplaceBrokenPlugin> getBrokenPlugins() {
        try {
            Object t = this.readOrUpdateFile(this.getBrokenPluginsFile$intellij_platform_ide_impl(), this.PLUGIN_MANAGER_URL + "/files/brokenPlugins.json", null, "", (Function1)new Function1<Reader, List<? extends MarketplaceBrokenPlugin>>(this){
                final /* synthetic */ MarketplaceRequests this$0;

                public final List<MarketplaceBrokenPlugin> invoke(@NotNull Reader it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (List)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it, (TypeReference)new TypeReference<List<? extends MarketplaceBrokenPlugin>>(){});
                }
                {
                    this.this$0 = marketplaceRequests;
                    super(1);
                }
            });
            Intrinsics.checkNotNullExpressionValue(t, (String)"readOrUpdateFile(\n      \u2026aceBrokenPlugin>>() {}) }");
            return (List)t;
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get broken plugins file from Marketplace", e);
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public final List<String> getAllPluginsTags() {
        try {
            Object object = HttpRequests.request((Url)Urls.newFromEncoded((String)(this.PLUGIN_MANAGER_URL + "/api/search/aggregation/tags")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)this.IDE_BUILD_FOR_REQUEST)))).productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends String>>(this){
                final /* synthetic */ MarketplaceRequests this$0;

                public final List<String> process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return CollectionsKt.toList((Iterable)((AggregationSearchResponse)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), AggregationSearchResponse.class)).getAggregations().keySet());
                }
                {
                    this.this$0 = marketplaceRequests;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n        .re\u2026s.keys.toList()\n        }");
            return (List)object;
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get tags from Marketplace", e);
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public final PluginNode loadPluginDescriptor(@NotNull String xmlId, @NotNull IdeCompatibleUpdate ideCompatibleUpdate, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)xmlId, (String)"xmlId");
        Intrinsics.checkNotNullParameter((Object)ideCompatibleUpdate, (String)"ideCompatibleUpdate");
        Path path = this.getUpdateMetadataFile(ideCompatibleUpdate);
        String string = this.getUpdateMetadataUrl(ideCompatibleUpdate);
        String string2 = IdeBundle.message((String)"progress.downloading.plugins.meta", (Object[])new Object[]{xmlId});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"progr\u2026ing.plugins.meta\", xmlId)");
        return ((IntellijUpdateMetadata)this.readOrUpdateFile(path, string, indicator, string2, (Function1)new Function1<Reader, IntellijUpdateMetadata>(this){

            public final IntellijUpdateMetadata invoke(@NotNull Reader p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return MarketplaceRequests.access$parseJsonPluginMeta((MarketplaceRequests)this.receiver, p1);
            }
        })).toPluginNode();
    }

    public static /* synthetic */ PluginNode loadPluginDescriptor$default(MarketplaceRequests marketplaceRequests, String string, IdeCompatibleUpdate ideCompatibleUpdate, ProgressIndicator progressIndicator, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadPluginDescriptor");
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        return marketplaceRequests.loadPluginDescriptor(string, ideCompatibleUpdate, progressIndicator);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final List<PluginNode> loadLastCompatiblePluginDescriptors(@NotNull List<String> ids, @Nullable BuildNumber buildNumber) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = this.getLastCompatiblePluginUpdate(ids, buildNumber);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdeCompatibleUpdate ideCompatibleUpdate = (IdeCompatibleUpdate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PluginNode pluginNode = this.loadPluginDescriptor(it.getPluginId(), (IdeCompatibleUpdate)it, null);
            collection.add(pluginNode);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List loadLastCompatiblePluginDescriptors$default(MarketplaceRequests marketplaceRequests, List list2, BuildNumber buildNumber, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadLastCompatiblePluginDescriptors");
        }
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        return marketplaceRequests.loadLastCompatiblePluginDescriptors(list2, buildNumber);
    }

    @JvmOverloads
    @NotNull
    public final List<PluginNode> loadLastCompatiblePluginDescriptors(@NotNull List<String> ids) {
        return MarketplaceRequests.loadLastCompatiblePluginDescriptors$default(this, ids, null, 2, null);
    }

    @NotNull
    public final PluginNode loadPluginDetails(@NotNull PluginNode pluginNode) {
        Intrinsics.checkNotNullParameter((Object)pluginNode, (String)"pluginNode");
        String externalPluginId = pluginNode.getExternalPluginId();
        String externalUpdateId = pluginNode.getExternalUpdateId();
        if (externalPluginId == null || externalUpdateId == null) {
            return pluginNode;
        }
        IdeCompatibleUpdate ideCompatibleUpdate = new IdeCompatibleUpdate(externalUpdateId, externalPluginId, null, null, 12, null);
        PluginId pluginId = pluginNode.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"pluginNode.pluginId");
        String string = pluginId.getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginNode.pluginId.idString");
        PluginNode pluginNode2 = MarketplaceRequests.loadPluginDescriptor$default(this, string, ideCompatibleUpdate, null, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        PluginNode $this$apply = pluginNode2;
        boolean bl3 = false;
        $this$apply.setRating(pluginNode.getRating());
        $this$apply.setDownloads(pluginNode.getDownloads());
        $this$apply.setDate(pluginNode.getDate());
        return pluginNode2;
    }

    public final <T> T readOrUpdateFile(@Nullable Path file2, @NotNull String url, @Nullable ProgressIndicator indicator, @Nls @NotNull String indicatorMessage, @NotNull Function1<? super Reader, ? extends T> parser) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)indicatorMessage, (String)"indicatorMessage");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        String eTag = file2 == null ? null : MarketplaceRequestsKt.access$loadETagForFile(file2);
        return (T)HttpRequests.request((String)url).tuner(new HttpRequests.ConnectionTuner(eTag){
            final /* synthetic */ String $eTag;

            public final void tune(@NotNull URLConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                if (this.$eTag != null) {
                    connection.setRequestProperty("If-None-Match", this.$eTag);
                }
            }
            {
                this.$eTag = string;
            }
        }).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor<T>(indicator, file2, parser, indicatorMessage, url){
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Path $file;
            final /* synthetic */ Function1 $parser;
            final /* synthetic */ String $indicatorMessage;
            final /* synthetic */ String $url;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final T process(@NotNull HttpRequests.Request request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                try {
                    Object object;
                    ProgressIndicator progressIndicator = this.$indicator;
                    if (progressIndicator != null) {
                        progressIndicator.checkCanceled();
                    }
                    URLConnection uRLConnection = request.getConnection();
                    Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"request.connection");
                    URLConnection connection = uRLConnection;
                    if (this.$file != null && MarketplaceRequestsKt.access$isNotModified(connection, this.$file)) {
                        Object object2;
                        Closeable closeable = Files.newBufferedReader(this.$file);
                        Function1 function1 = this.$parser;
                        boolean bl = false;
                        boolean bl2 = false;
                        Throwable throwable = null;
                        try {
                            object2 = function1.invoke((Object)closeable);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return (T)object2;
                    }
                    if (this.$indicator != null) {
                        this.$indicator.checkCanceled();
                        this.$indicator.setText2(this.$indicatorMessage);
                    }
                    if (this.$file == null) {
                        Object object3;
                        Closeable closeable = request.getReader();
                        Function1 function1 = this.$parser;
                        boolean bl = false;
                        boolean bl3 = false;
                        Throwable throwable = null;
                        try {
                            object3 = function1.invoke((Object)closeable);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return (T)object3;
                    }
                    Object object4 = MarketplaceRequests.access$getINSTANCE$cp();
                    boolean bl = false;
                    boolean bl4 = false;
                    synchronized (object4) {
                        Unit unit;
                        boolean bl5 = false;
                        request.saveToFile(this.$file, this.$indicator);
                        String string = connection.getHeaderField("ETag");
                        if (string != null) {
                            object = string;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            String it = object;
                            boolean bl8 = false;
                            MarketplaceRequestsKt.access$saveETagForFile(this.$file, it);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                    object4 = Files.newBufferedReader(this.$file);
                    Function1 function1 = this.$parser;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    Throwable throwable = null;
                    try {
                        object = function1.invoke(object4);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable);
                    }
                    return (T)object;
                }
                catch (HttpRequests.HttpStatusException e) {
                    MarketplaceRequestsKt.access$getLOG$p().warn("Cannot load data from " + this.$url + " (statusCode=" + e.getStatusCode() + ')', (Throwable)e);
                    throw (Throwable)e;
                }
                catch (Exception e) {
                    Path path = this.$file;
                    MarketplaceRequestsKt.access$getLOG$p().warn("Error reading Marketplace file: url=" + this.$url + " file=" + (path != null ? path.getFileName() : null), (Throwable)e);
                    if (this.$file != null && MarketplaceRequestsKt.access$getLOG$p().isDebugEnabled()) {
                        String string;
                        StringBuilder stringBuilder;
                        Logger logger;
                        StringBuilder stringBuilder2 = new StringBuilder().append("File content:\n");
                        Logger logger2 = MarketplaceRequestsKt.access$getLOG$p();
                        try {
                            logger = logger2;
                            stringBuilder = stringBuilder2;
                            string = Files.readString(this.$file);
                        }
                        catch (Exception exception) {
                            void e2;
                            logger = logger2;
                            stringBuilder = stringBuilder2;
                            string = IoErrorText.message((Throwable)((Throwable)e2));
                        }
                        logger.debug(stringBuilder.append(string).toString());
                    }
                    throw (Throwable)e;
                }
            }
            {
                this.$indicator = progressIndicator;
                this.$file = path;
                this.$parser = function1;
                this.$indicatorMessage = string;
                this.$url = string2;
            }
        });
    }

    @NotNull
    public final List<IdeCompatibleUpdate> getLastCompatiblePluginUpdate(@NotNull List<String> ids, @Nullable BuildNumber buildNumber) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        try {
            if (ids.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            ObjectMapper objectMapper2 = this.getObjectMapper();
            String string = PluginDownloader.getBuildNumberForDownload(buildNumber);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PluginDownloader.getBuil\u2026rForDownload(buildNumber)");
            String data2 = objectMapper2.writeValueAsString((Object)new CompatibleUpdateRequest(string, ids));
            Object object = HttpRequests.post((String)Urls.newFromEncoded((String)this.COMPATIBLE_UPDATE_URL).toExternalForm(), (String)"application/json; charset=utf-8").productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends IdeCompatibleUpdate>>(this, data2){
                final /* synthetic */ MarketplaceRequests this$0;
                final /* synthetic */ String $data;

                public final List<IdeCompatibleUpdate> process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.write(this.$data);
                    return (List)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends IdeCompatibleUpdate>>(){});
                }
                {
                    this.this$0 = marketplaceRequests;
                    this.$data = string;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n        .po\u2026eUpdate>>() {})\n        }");
            return (List)object;
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get compatible updates from Marketplace", e);
            return CollectionsKt.emptyList();
        }
    }

    public static /* synthetic */ List getLastCompatiblePluginUpdate$default(MarketplaceRequests marketplaceRequests, List list2, BuildNumber buildNumber, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLastCompatiblePluginUpdate");
        }
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        return marketplaceRequests.getLastCompatiblePluginUpdate(list2, buildNumber);
    }

    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull String id2, @Nullable BuildNumber buildNumber, @Nullable ProgressIndicator indicator) {
        PluginNode pluginNode;
        IdeCompatibleUpdate data2;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        IdeCompatibleUpdate ideCompatibleUpdate = data2 = (IdeCompatibleUpdate)CollectionsKt.firstOrNull(this.getLastCompatiblePluginUpdate(CollectionsKt.listOf((Object)id2), buildNumber));
        if (ideCompatibleUpdate != null) {
            IdeCompatibleUpdate ideCompatibleUpdate2 = ideCompatibleUpdate;
            boolean bl = false;
            boolean bl2 = false;
            IdeCompatibleUpdate it = ideCompatibleUpdate2;
            boolean bl3 = false;
            pluginNode = this.loadPluginDescriptor(id2, it, indicator);
        } else {
            pluginNode = null;
        }
        return pluginNode;
    }

    public static /* synthetic */ PluginNode getLastCompatiblePluginUpdate$default(MarketplaceRequests marketplaceRequests, String string, BuildNumber buildNumber, ProgressIndicator progressIndicator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLastCompatiblePluginUpdate");
        }
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        return marketplaceRequests.getLastCompatiblePluginUpdate(string, buildNumber, progressIndicator);
    }

    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull String id2, @Nullable BuildNumber buildNumber) {
        return MarketplaceRequests.getLastCompatiblePluginUpdate$default(this, id2, buildNumber, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final PluginNode getLastCompatiblePluginUpdate(@NotNull String id2) {
        return MarketplaceRequests.getLastCompatiblePluginUpdate$default(this, id2, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IdeCompatibleUpdate> getCompatibleUpdatesByModule(@NotNull String module, @Nullable BuildNumber buildNumber) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        try {
            ObjectMapper objectMapper2 = this.getObjectMapper();
            String string = PluginDownloader.getBuildNumberForDownload(buildNumber);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PluginDownloader.getBuil\u2026rForDownload(buildNumber)");
            String data2 = objectMapper2.writeValueAsString((Object)new CompatibleUpdateForModuleRequest(string, module));
            String string2 = Urls.newFromEncoded((String)this.COMPATIBLE_UPDATE_URL).toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Urls.newFromEncoded(COMP\u2026ATE_URL).toExternalForm()");
            String url = string2;
            Object object = HttpRequests.post((String)url, (String)"application/json; charset=utf-8").productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<? extends IdeCompatibleUpdate>>(this, data2){
                final /* synthetic */ MarketplaceRequests this$0;
                final /* synthetic */ String $data;

                public final List<IdeCompatibleUpdate> process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.write(this.$data);
                    return (List)MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends IdeCompatibleUpdate>>(){});
                }
                {
                    this.this$0 = marketplaceRequests;
                    this.$data = string;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests\n        .po\u2026eUpdate>>() {})\n        }");
            return (List)object;
        }
        catch (Exception e) {
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get compatible update by module from Marketplace", e);
            return CollectionsKt.emptyList();
        }
    }

    public static /* synthetic */ List getCompatibleUpdatesByModule$default(MarketplaceRequests marketplaceRequests, String string, BuildNumber buildNumber, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCompatibleUpdatesByModule");
        }
        if ((n & 2) != 0) {
            buildNumber = null;
        }
        return marketplaceRequests.getCompatibleUpdatesByModule(string, buildNumber);
    }

    @JvmOverloads
    @NotNull
    public final List<IdeCompatibleUpdate> getCompatibleUpdatesByModule(@NotNull String module) {
        return MarketplaceRequests.getCompatibleUpdatesByModule$default(this, module, null, 2, null);
    }

    @Nullable
    public final Set<String> getJetBrainsPluginsIds() {
        return this.jetBrainsPluginsIds;
    }

    public final void loadJetBrainsPluginsIds() {
        Set set2;
        MarketplaceRequests marketplaceRequests;
        if (this.jetBrainsPluginsIds != null) {
            return;
        }
        MarketplaceRequests marketplaceRequests2 = this;
        try {
            marketplaceRequests = marketplaceRequests2;
            set2 = (Set)HttpRequests.request((Url)this.JETBRAINS_PLUGINS_URL).productNameAsUserAgent().throwStatusCodeException(false).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Set<? extends String>>(this){
                final /* synthetic */ MarketplaceRequests this$0;

                public final Set<String> process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object object = MarketplaceRequests.access$getObjectMapper$p(this.this$0).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends MarketplaceSearchPluginData>>(){});
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.readValue(i\u2026eSearchPluginData>>() {})");
                    return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)((Function1)MarketplaceRequests$loadJetBrainsPluginsIds$1$2.INSTANCE)));
                }
                {
                    this.this$0 = marketplaceRequests;
                }
            });
        }
        catch (Exception e) {
            marketplaceRequests = marketplaceRequests2;
            MarketplaceRequestsKt.access$logWarnOrPrintIfDebug("Can not get JetBrains plugins' IDs from Marketplace", e);
            set2 = null;
        }
        marketplaceRequests.jetBrainsPluginsIds = set2;
    }

    private final List<String> parseXmlIds(Reader reader) {
        return (List)this.getObjectMapper().readValue(reader, (TypeReference)new TypeReference<List<? extends String>>(){});
    }

    private final IntellijUpdateMetadata parseJsonPluginMeta(Reader reader) {
        return (IntellijUpdateMetadata)this.getObjectMapper().readValue(reader, IntellijUpdateMetadata.class);
    }

    @NotNull
    public File downloadPlugin(@NotNull String pluginUrl, @NotNull ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return MarketplacePluginDownloadService.INSTANCE.downloadPlugin(pluginUrl, indicator);
    }

    @NotNull
    public File downloadPluginViaBlockMap(@NotNull String pluginUrl, @NotNull Path prevPlugin, @NotNull ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Intrinsics.checkNotNullParameter((Object)prevPlugin, (String)"prevPlugin");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return MarketplacePluginDownloadService.INSTANCE.downloadPluginViaBlockMap(pluginUrl, prevPlugin, indicator);
    }

    public MarketplaceRequests() {
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"ApplicationInfoImpl.getShadowInstance()");
        String string = applicationInfoEx.getPluginManagerUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationInfoImpl.getS\u2026stance().pluginManagerUrl");
        this.PLUGIN_MANAGER_URL = StringsKt.trimEnd((String)string, (char[])new char[]{'/'});
        String string2 = URLUtil.encodeURIComponent((String)this.getBuildForPluginRepositoryRequests());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"URLUtil.encodeURICompone\u2026uginRepositoryRequests())");
        this.IDE_BUILD_FOR_REQUEST = string2;
        Url url = Urls.newFromEncoded((String)(this.PLUGIN_MANAGER_URL + "/api/search/aggregation/organizations")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)this.IDE_BUILD_FOR_REQUEST)));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"Urls.newFromEncoded(\"${P\u2026o IDE_BUILD_FOR_REQUEST))");
        this.MARKETPLACE_ORGANIZATIONS_URL = url;
        Url url2 = Urls.newFromEncoded((String)(this.PLUGIN_MANAGER_URL + "/api/search/plugins?organization=JetBrains&max=1000")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"build", (Object)this.IDE_BUILD_FOR_REQUEST)));
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"Urls.newFromEncoded(\n   \u2026o IDE_BUILD_FOR_REQUEST))");
        this.JETBRAINS_PLUGINS_URL = url2;
        this.COMPATIBLE_UPDATE_URL = this.PLUGIN_MANAGER_URL + "/api/search/compatibleUpdates";
        this.objectMapper$delegate = LazyKt.lazy((Function0)objectMapper.2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new MarketplaceRequests();
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(MarketplaceRequests $this) {
        return $this.getObjectMapper();
    }

    public static final /* synthetic */ List access$parseXmlIds(MarketplaceRequests $this, Reader reader) {
        return $this.parseXmlIds(reader);
    }

    public static final /* synthetic */ IntellijUpdateMetadata access$parseJsonPluginMeta(MarketplaceRequests $this, Reader reader) {
        return $this.parseJsonPluginMeta(reader);
    }

    @JvmStatic
    @NotNull
    public static final MarketplaceRequests getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final List<PluginNode> parsePluginList(@NotNull Reader reader) {
        return Companion.parsePluginList(reader);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests$Companion;", "", "()V", "INSTANCE", "Lcom/intellij/ide/plugins/marketplace/MarketplaceRequests;", "getInstance", "parsePluginList", "", "Lcom/intellij/ide/plugins/PluginNode;", "reader", "Ljava/io/Reader;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MarketplaceRequests getInstance() {
            return INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final List<PluginNode> parsePluginList(@NotNull Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                RepositoryContentHandler handler2 = new RepositoryContentHandler();
                parser.parse(new InputSource(reader), (DefaultHandler)handler2);
                List<PluginNode> list2 = handler2.getPluginsList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"handler.pluginsList");
                return list2;
            }
            catch (Exception e) {
                Exception exception = e;
                if (exception instanceof ParserConfigurationException || exception instanceof SAXException || exception instanceof RuntimeException) {
                    throw (Throwable)new IOException(e);
                }
                throw (Throwable)e;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

