/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.cl;

import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.SmartList;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.ui.EDT;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
@ApiStatus.NonExtendable
public class PluginClassLoader
extends UrlClassLoader
implements PluginAwareClassLoader {
    public static final ClassLoader[] EMPTY_CLASS_LOADER_ARRAY = new ClassLoader[0];
    private static final boolean isParallelCapable = USE_PARALLEL_LOADING && PluginClassLoader.registerAsParallelCapable();
    @Nullable
    private static final Writer logStream;
    private static final AtomicInteger instanceIdProducer;
    private static final AtomicInteger parentListCacheIdCounter;
    private static final Set<String> KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private ClassLoader[] parents;
    private volatile ClassLoader[] allParents;
    private volatile int allParentsLastCacheId;
    private final PluginDescriptor pluginDescriptor;
    private final PluginId pluginId;
    private final String packagePrefix;
    private final List<String> libDirectories;
    private final AtomicLong edtTime;
    private final AtomicLong backgroundTime;
    private final AtomicInteger loadedClassCounter;
    @NotNull
    private final ClassLoader coreLoader;
    private final int instanceId;
    private volatile int state;
    @Nullable
    private final ResolveScopeManager resolveScopeManager;

    public PluginClassLoader(@NotNull UrlClassLoader.Builder builder2, @NotNull @NotNull ClassLoader @NotNull [] parents2, @NotNull PluginDescriptor pluginDescriptor, @Nullable Path pluginRoot, @NotNull ClassLoader coreLoader, @Nullable ResolveScopeManager resolveScopeManager, @Nullable String packagePrefix, @Nullable ClassPath.ResourceFileFactory resourceFileFactory) {
        Path libDir;
        if (builder2 == null) {
            PluginClassLoader.$$$reportNull$$$0(0);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(1);
        }
        if (pluginDescriptor == null) {
            PluginClassLoader.$$$reportNull$$$0(2);
        }
        if (coreLoader == null) {
            PluginClassLoader.$$$reportNull$$$0(3);
        }
        super(builder2, resourceFileFactory, isParallelCapable);
        this.edtTime = new AtomicLong();
        this.backgroundTime = new AtomicLong();
        this.loadedClassCounter = new AtomicInteger();
        this.state = 1;
        this.instanceId = instanceIdProducer.incrementAndGet();
        this.resolveScopeManager = resolveScopeManager;
        this.parents = parents2;
        this.pluginDescriptor = pluginDescriptor;
        this.pluginId = pluginDescriptor.getPluginId();
        this.packagePrefix = packagePrefix == null || packagePrefix.endsWith(".") ? packagePrefix : packagePrefix + '.';
        this.coreLoader = coreLoader;
        if (PluginClassLoader.class.desiredAssertionStatus()) {
            for (ClassLoader parent : this.parents) {
                if (parent != coreLoader) continue;
                Logger.getInstance(PluginClassLoader.class).error("Core loader must be not specified in parents (parents=" + Arrays.toString(parents2) + ", coreLoader=" + coreLoader + ")");
            }
        }
        this.libDirectories = new SmartList();
        if (pluginRoot != null && Files.exists(libDir = pluginRoot.resolve("lib"), new LinkOption[0])) {
            this.libDirectories.add(libDir.toAbsolutePath().toString());
        }
    }

    @Nullable
    public final String getPackagePrefix() {
        return this.packagePrefix;
    }

    @ApiStatus.Internal
    public final int getState() {
        return this.state;
    }

    @ApiStatus.Internal
    public final void setState(int state) {
        this.state = state;
    }

    public final int getInstanceId() {
        return this.instanceId;
    }

    public final long getEdtTime() {
        return this.edtTime.get();
    }

    public final long getBackgroundTime() {
        return this.backgroundTime.get();
    }

    public final long getLoadedClassCount() {
        return this.loadedClassCounter.get();
    }

    public final Class<?> loadClass(@NotNull String name, boolean resolve2) throws ClassNotFoundException {
        Class<?> c;
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(4);
        }
        if ((c = this.tryLoadingClass(name, false)) == null) {
            PluginClassLoader.flushDebugLog();
            throw new ClassNotFoundException(name + " " + (Object)((Object)this));
        }
        return c;
    }

    @Nullable
    public final Class<?> tryLoadingClass(@NotNull String name, boolean forceLoadFromSubPluginClassloader) throws ClassNotFoundException {
        Class c;
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(5);
        }
        if (PluginClassLoader.mustBeLoadedByPlatform(name)) {
            return this.coreLoader.loadClass(name);
        }
        long startTime = StartUpMeasurer.measuringPluginStartupCosts ? StartUpMeasurer.getCurrentTime() : -1L;
        try {
            c = this.loadClassInsideSelf(name, forceLoadFromSubPluginClassloader);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        if (c == null) {
            for (ClassLoader classloader : this.getAllParents()) {
                if (classloader instanceof UrlClassLoader) {
                    try {
                        c = ((UrlClassLoader)classloader).loadClassInsideSelf(name, false);
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                    if (c == null) continue;
                    break;
                }
                try {
                    c = classloader.loadClass(name);
                    if (c == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (startTime != -1L) {
            (EDT.isCurrentThreadEdt() ? this.edtTime : this.backgroundTime).addAndGet(StartUpMeasurer.getCurrentTime() - startTime);
        }
        return c;
    }

    @NotNull
    private @NotNull ClassLoader @NotNull [] getAllParents() {
        ClassLoader classLoader;
        ClassLoader[] result2 = this.allParents;
        if (result2 != null && this.allParentsLastCacheId == parentListCacheIdCounter.get()) {
            if (result2 == null) {
                PluginClassLoader.$$$reportNull$$$0(6);
            }
            return result2;
        }
        if (this.parents.length == 0) {
            result2 = new ClassLoader[]{this.coreLoader};
            this.allParents = result2;
            if (result2 == null) {
                PluginClassLoader.$$$reportNull$$$0(7);
            }
            return result2;
        }
        LinkedHashSet<ClassLoader> parentSet = new LinkedHashSet<ClassLoader>();
        ArrayDeque queue2 = new ArrayDeque();
        Collections.addAll(queue2, this.parents);
        while ((classLoader = (ClassLoader)queue2.pollFirst()) != null) {
            if (classLoader == this.coreLoader || !parentSet.add(classLoader) || !(classLoader instanceof PluginClassLoader)) continue;
            Collections.addAll(queue2, ((PluginClassLoader)((Object)classLoader)).parents);
        }
        parentSet.add(this.coreLoader);
        result2 = parentSet.toArray(EMPTY_CLASS_LOADER_ARRAY);
        this.allParents = result2;
        this.allParentsLastCacheId = parentListCacheIdCounter.get();
        if (result2 == null) {
            PluginClassLoader.$$$reportNull$$$0(8);
        }
        return result2;
    }

    public final void clearParentListCache() {
        this.allParents = null;
    }

    private static boolean mustBeLoadedByPlatform(@NonNls String className) {
        if (className.startsWith("java.")) {
            return true;
        }
        return className.startsWith("kotlin.") && (className.startsWith("kotlin.jvm.functions.") || className.startsWith("kotlin.reflect.") && className.indexOf(46, 15) < 0 || KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES.contains(className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Class<?> loadClassInsideSelf(@NotNull String name, boolean forceLoadFromSubPluginClassloader) throws IOException {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(9);
        }
        if (this.resolveScopeManager != null && this.resolveScopeManager.isDefinitelyAlienClass(name, this.packagePrefix)) {
            return null;
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class c = this.findLoadedClass(name);
            if (c != null && c.getClassLoader() == this) {
                return c;
            }
            Writer logStream = PluginClassLoader.logStream;
            try {
                c = this.classPath.findClass(name);
            }
            catch (LinkageError e) {
                if (logStream != null) {
                    this.logClass(name, logStream, e);
                }
                PluginClassLoader.flushDebugLog();
                throw new PluginException("Cannot load class " + name + " (\n  error: " + e.getMessage() + ",\n  classLoader=" + (Object)((Object)this) + "\n)", (Throwable)e, this.pluginId);
            }
            if (c == null) {
                return null;
            }
            this.loadedClassCounter.incrementAndGet();
            if (logStream != null) {
                this.logClass(name, logStream, null);
            }
            return c;
        }
    }

    private void logClass(@NotNull String name, @NotNull Writer logStream, @Nullable LinkageError exception) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(10);
        }
        if (logStream == null) {
            PluginClassLoader.$$$reportNull$$$0(11);
        }
        try {
            String descriptorPath = ((IdeaPluginDescriptor)this.pluginDescriptor).getDescriptorPath();
            String specifier = descriptorPath == null ? "m" : "sub = " + descriptorPath;
            logStream.write(name + " [" + specifier + "] " + this.pluginId.getIdString() + (this.packagePrefix == null ? "" : ':' + this.packagePrefix) + '\n' + (exception == null ? "" : exception.getMessage()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public final URL findResource(@NotNull String name) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(12);
        }
        return this.findResource(name, Resource::getURL, ClassLoader::getResource);
    }

    @Nullable
    public final InputStream getResourceAsStream(@NotNull String name) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(13);
        }
        Function<Resource, InputStream> f1 = resource -> {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                Logger.getInstance(PluginClassLoader.class).error((Throwable)e);
                return null;
            }
        };
        BiFunction<ClassLoader, String, InputStream> f2 = (cl, path) -> {
            try {
                return cl.getResourceAsStream((String)path);
            }
            catch (Exception e) {
                Logger.getInstance(PluginClassLoader.class).error((Throwable)e);
                return null;
            }
        };
        return this.findResource(name, f1, f2);
    }

    @Nullable
    private <T> T findResource(String name, Function<Resource, T> f1, BiFunction<ClassLoader, String, T> f2) {
        Resource resource;
        String canonicalPath = PluginClassLoader.toCanonicalPath((String)name);
        if (canonicalPath.startsWith("/")) {
            canonicalPath = canonicalPath.substring(1);
        }
        if ((resource = this.classPath.findResource(canonicalPath)) != null) {
            return f1.apply(resource);
        }
        for (ClassLoader classloader : this.getAllParents()) {
            if (classloader instanceof PluginClassLoader) {
                resource = ((PluginClassLoader)((Object)classloader)).classPath.findResource(canonicalPath);
                if (resource == null) continue;
                return f1.apply(resource);
            }
            T t = f2.apply(classloader, canonicalPath);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @NotNull
    public final Enumeration<URL> findResources(@NotNull String name) throws IOException {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(14);
        }
        ArrayList<Enumeration<URL>> resources = new ArrayList<Enumeration<URL>>();
        resources.add(this.classPath.getResources(name));
        for (ClassLoader classloader : this.getAllParents()) {
            if (classloader instanceof PluginClassLoader) {
                resources.add(((PluginClassLoader)((Object)classloader)).classPath.getResources(name));
                continue;
            }
            try {
                resources.add(classloader.getResources(name));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new DeepEnumeration(resources);
    }

    public final void addLibDirectories(@NotNull Collection<String> libDirectories) {
        if (libDirectories == null) {
            PluginClassLoader.$$$reportNull$$$0(15);
        }
        this.libDirectories.addAll(libDirectories);
    }

    protected final String findLibrary(String libName) {
        if (!this.libDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i2 = this.libDirectories.listIterator(this.libDirectories.size());
            while (i2.hasPrevious()) {
                File libFile = new File(i2.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    @NotNull
    public final PluginId getPluginId() {
        PluginId pluginId = this.pluginId;
        if (pluginId == null) {
            PluginClassLoader.$$$reportNull$$$0(16);
        }
        return pluginId;
    }

    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.pluginDescriptor;
        if (pluginDescriptor == null) {
            PluginClassLoader.$$$reportNull$$$0(17);
        }
        return pluginDescriptor;
    }

    public final String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(plugin=" + this.pluginDescriptor + ", packagePrefix=" + this.packagePrefix + ", instanceId=" + this.instanceId + ", state=" + (this.state == 1 ? "active" : "unload in progress") + ")";
    }

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public final List<ClassLoader> _getParents() {
        List<ClassLoader> list2 = Collections.unmodifiableList(Arrays.asList(this.parents));
        if (list2 == null) {
            PluginClassLoader.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @ApiStatus.Internal
    public final void attachParent(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            PluginClassLoader.$$$reportNull$$$0(19);
        }
        int length = this.parents.length;
        ClassLoader[] result2 = new ClassLoader[length + 1];
        System.arraycopy(this.parents, 0, result2, 0, length);
        result2[length] = classLoader;
        this.parents = result2;
        parentListCacheIdCounter.incrementAndGet();
    }

    @ApiStatus.Internal
    public final boolean detachParent(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            PluginClassLoader.$$$reportNull$$$0(20);
        }
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            if (classLoader != this.parents[i2]) continue;
            int length = this.parents.length;
            ClassLoader[] result2 = new ClassLoader[length - 1];
            System.arraycopy(this.parents, 0, result2, 0, i2);
            System.arraycopy(this.parents, i2 + 1, result2, i2, length - i2 - 1);
            this.parents = result2;
            parentListCacheIdCounter.incrementAndGet();
            return true;
        }
        return false;
    }

    protected final ProtectionDomain getProtectionDomain() {
        return PROTECTION_DOMAIN;
    }

    private static void flushDebugLog() {
        if (logStream != null) {
            try {
                logStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        instanceIdProducer = new AtomicInteger();
        parentListCacheIdCounter = new AtomicInteger();
        PROTECTION_DOMAIN = new ProtectionDomain(new CodeSource(null, (Certificate[])null), null);
        HashSet<String> kotlinStdlibClassesUsedInSignatures = new HashSet<String>(Arrays.asList("kotlin.Function", "kotlin.sequences.Sequence", "kotlin.ranges.IntRange", "kotlin.ranges.IntRange$Companion", "kotlin.ranges.IntProgression", "kotlin.ranges.ClosedRange", "kotlin.ranges.IntProgressionIterator", "kotlin.ranges.IntProgression$Companion", "kotlin.ranges.IntProgression", "kotlin.collections.IntIterator", "kotlin.Lazy", "kotlin.Unit", "kotlin.Pair", "kotlin.Triple", "kotlin.jvm.internal.DefaultConstructorMarker", "kotlin.jvm.internal.ClassBasedDeclarationContainer", "kotlin.properties.ReadWriteProperty", "kotlin.properties.ReadOnlyProperty", "kotlin.coroutines.ContinuationInterceptor", "kotlinx.coroutines.CoroutineDispatcher", "kotlin.coroutines.Continuation", "kotlin.coroutines.CoroutineContext", "kotlin.coroutines.CoroutineContext$Element", "kotlin.coroutines.CoroutineContext$Key"));
        String classes = System.getProperty("idea.kotlin.classes.used.in.signatures");
        if (classes != null) {
            StringTokenizer t = new StringTokenizer(classes, ",");
            while (t.hasMoreTokens()) {
                kotlinStdlibClassesUsedInSignatures.add(t.nextToken());
            }
        }
        KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES = kotlinStdlibClassesUsedInSignatures;
        BufferedWriter logStreamCandidate = null;
        String debugFilePath = System.getProperty("plugin.classloader.debug", "");
        if (!debugFilePath.isEmpty()) {
            try {
                logStreamCandidate = Files.newBufferedWriter(Paths.get(debugFilePath, new String[0]), new OpenOption[0]);
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (logStream != null) {
                                logStream.close();
                            }
                        }
                        catch (IOException e) {
                            Logger.getInstance(PluginClassLoader.class).error((Throwable)e);
                        }
                    }
                });
            }
            catch (IOException e) {
                Logger.getInstance(PluginClassLoader.class).error((Throwable)e);
            }
        }
        logStream = logStreamCandidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/cl/PluginClassLoader";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logStream";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirectories";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/cl/PluginClassLoader";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllParents";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "_getParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadingClass";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadClassInsideSelf";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findResources";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addLibDirectories";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "attachParent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "detachParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DeepEnumeration
    implements Enumeration<URL> {
        @NotNull
        private final List<? extends Enumeration<URL>> list;
        private int myIndex;

        DeepEnumeration(@NotNull List<? extends Enumeration<URL>> enumerations) {
            if (enumerations == null) {
                DeepEnumeration.$$$reportNull$$$0(0);
            }
            this.list = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.list.size()) {
                Enumeration<URL> e = this.list.get(this.myIndex);
                if (e != null && e.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.myIndex).nextElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumerations", "com/intellij/ide/plugins/cl/PluginClassLoader$DeepEnumeration", "<init>"));
        }
    }

    public static interface ResolveScopeManager {
        public boolean isDefinitelyAlienClass(String var1, String var2);
    }
}

