/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.certificates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.certificates.PluginCertificateManager;
import com.intellij.ide.plugins.certificates.PluginCertificateManager$$special$;
import com.intellij.ide.plugins.certificates.PluginCertificateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.net.ssl.CertificateInfoPanel;
import com.intellij.util.net.ssl.CertificateListener;
import com.intellij.util.net.ssl.CertificateTreeBuilder;
import com.intellij.util.net.ssl.CertificateUtil;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeSelectionModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\b\u0010\"\u001a\u00020\u001cH\u0002J\b\u0010#\u001a\u00020\u0010H\u0016J\b\u0010$\u001a\u00020\u001cH\u0016J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\b\u0010&\u001a\u00020\u001cH\u0002J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u001cH\u0002J\b\u0010*\u001a\u00020\u001cH\u0016J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ide/plugins/certificates/PluginCertificateManager;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "Lcom/intellij/util/net/ssl/CertificateListener;", "()V", "CERTIFICATE_DESCRIPTOR", "Lcom/intellij/openapi/fileChooser/FileTypeDescriptor;", "EMPTY_PANEL", "", "myCertificates", "", "Ljava/security/cert/X509Certificate;", "myCertificatesListPanel", "Ljavax/swing/JPanel;", "myDetailsPanel", "myEmptyPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getMyEmptyPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "myRootPanel", "getMyRootPanel", "myTree", "Lcom/intellij/ui/treeStructure/Tree;", "myTreeBuilder", "Lcom/intellij/util/net/ssl/CertificateTreeBuilder;", "myTrustManager", "Lcom/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager;", "addCertificate", "", "certificate", "addCertificatePanel", "apply", "certificateAdded", "certificateRemoved", "chooseFileAndAdd", "createPanel", "disposeUIResources", "getCardName", "init", "isModified", "", "removeSelectedCertificates", "reset", "showCard", "cardName", "intellij.platform.ide.impl"})
public final class PluginCertificateManager
extends BoundConfigurable
implements Configurable.NoScroll,
CertificateListener {
    private final Tree myTree;
    private final JPanel myCertificatesListPanel;
    private final JPanel myDetailsPanel;
    @NotNull
    private final DialogPanel myRootPanel;
    @NotNull
    private final DialogPanel myEmptyPanel;
    private final FileTypeDescriptor CERTIFICATE_DESCRIPTOR;
    private final String EMPTY_PANEL;
    private final ConfirmingTrustManager.MutableTrustManager myTrustManager;
    private final CertificateTreeBuilder myTreeBuilder;
    private final Set<X509Certificate> myCertificates;

    @NotNull
    public final DialogPanel getMyRootPanel() {
        return this.myRootPanel;
    }

    @NotNull
    public final DialogPanel getMyEmptyPanel() {
        return this.myEmptyPanel;
    }

    @NotNull
    public DialogPanel createPanel() {
        this.init();
        return this.myRootPanel;
    }

    public void certificateAdded(@NotNull X509Certificate certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, certificate){
            final /* synthetic */ PluginCertificateManager this$0;
            final /* synthetic */ X509Certificate $certificate;

            public final void run() {
                if (!PluginCertificateManager.access$getMyCertificates$p(this.this$0).contains(this.$certificate)) {
                    PluginCertificateManager.access$getMyCertificates$p(this.this$0).add(this.$certificate);
                    PluginCertificateManager.access$getMyTreeBuilder$p(this.this$0).addCertificate(this.$certificate);
                    PluginCertificateManager.access$addCertificatePanel(this.this$0, this.$certificate);
                }
            }
            {
                this.this$0 = pluginCertificateManager;
                this.$certificate = x509Certificate;
            }
        });
    }

    public void certificateRemoved(@NotNull X509Certificate certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, certificate){
            final /* synthetic */ PluginCertificateManager this$0;
            final /* synthetic */ X509Certificate $certificate;

            public final void run() {
                if (PluginCertificateManager.access$getMyCertificates$p(this.this$0).contains(this.$certificate)) {
                    PluginCertificateManager.access$getMyCertificates$p(this.this$0).remove(this.$certificate);
                    PluginCertificateManager.access$getMyTreeBuilder$p(this.this$0).removeCertificate(this.$certificate);
                }
            }
            {
                this.this$0 = pluginCertificateManager;
                this.$certificate = x509Certificate;
            }
        });
    }

    public boolean isModified() {
        return Intrinsics.areEqual(this.myCertificates, new HashSet(this.myTrustManager.getCertificates())) ^ true;
    }

    public void apply() throws ConfigurationException {
        List existing;
        List list2 = existing = this.myTrustManager.getCertificates();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"existing");
        Set added2 = SetsKt.minus(this.myCertificates, (Iterable)list2);
        List removed = CollectionsKt.minus((Iterable)existing, (Iterable)this.myCertificates);
        for (X509Certificate certificate : added2) {
            if (this.myTrustManager.addCertificate(certificate)) continue;
            throw (Throwable)new ConfigurationException(IdeBundle.message((String)"settings.certificate.cannot.add.certificate.for", (Object[])new Object[]{CertificateUtil.getCommonName((X509Certificate)certificate)}), IdeBundle.message((String)"settings.certificate.cannot.add.certificate", (Object[])new Object[0]));
        }
        for (X509Certificate certificate : removed) {
            if (this.myTrustManager.removeCertificate(certificate)) continue;
            throw (Throwable)new ConfigurationException(IdeBundle.message((String)"settings.certificate.cannot.remove.certificate.for", (Object[])new Object[]{CertificateUtil.getCommonName((X509Certificate)certificate)}), IdeBundle.message((String)"settings.certificate.cannot.remove.certificate", (Object[])new Object[0]));
        }
    }

    public void reset() {
        List original = this.myTrustManager.getCertificates();
        this.myTreeBuilder.reset((Collection)original);
        this.myCertificates.clear();
        List list2 = original;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"original");
        this.myCertificates.addAll(list2);
        this.myDetailsPanel.removeAll();
        this.myDetailsPanel.add((Component)this.myEmptyPanel, "empty.panel");
        Iterator iterator2 = original.iterator();
        while (iterator2.hasNext()) {
            X509Certificate certificate;
            X509Certificate x509Certificate = certificate = (X509Certificate)iterator2.next();
            Intrinsics.checkNotNull((Object)x509Certificate);
            this.addCertificatePanel(x509Certificate);
        }
        Collection collection = this.myCertificates;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.myTreeBuilder.selectFirstCertificate();
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)((Disposable)this.myTreeBuilder));
        this.myTrustManager.removeListener((CertificateListener)this);
    }

    private final void init() {
        this.myTrustManager.addListener((CertificateListener)this);
        StatusText statusText = this.myTree.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"myTree.emptyText");
        statusText.setText(IdeBundle.message((String)"settings.certificate.no.certificates", (Object[])new Object[0]));
        TreeSelectionModel treeSelectionModel = this.myTree.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeSelectionModel, (String)"myTree.selectionModel");
        treeSelectionModel.setSelectionMode(1);
        this.myTree.setRootVisible(false);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(this){
            final /* synthetic */ PluginCertificateManager this$0;

            public final void valueChanged(TreeSelectionEvent it) {
                X509Certificate certificate = PluginCertificateManager.access$getMyTreeBuilder$p(this.this$0).getFirstSelectedCertificate(true);
                if (certificate != null) {
                    PluginCertificateManager.access$showCard(this.this$0, PluginCertificateManager.access$getCardName(this.this$0, certificate));
                }
            }
            {
                this.this$0 = pluginCertificateManager;
            }
        });
        this.myCertificatesListPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"settings.trusted.certificates", (Object[])new Object[0]), (boolean)false, (Insets)((Insets)JBUI.insetsTop((int)8))).setShowLine(false));
    }

    private final void chooseFileAndAdd() {
        FileChooser.chooseFile((FileChooserDescriptor)((FileChooserDescriptor)this.CERTIFICATE_DESCRIPTOR), null, null, (Consumer)((Consumer)new Consumer<VirtualFile>(this){
            final /* synthetic */ PluginCertificateManager this$0;

            public final void consume(@NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                String string = file2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                String path = string;
                X509Certificate certificate = CertificateUtil.loadX509Certificate((String)path);
                if (certificate == null) {
                    Messages.showErrorDialog((Component)((Component)this.this$0.getMyRootPanel()), (String)IdeBundle.message((String)"settings.certificate.malformed.x509.server.certificate", (Object[])new Object[0]), (String)IdeBundle.message((String)"settings.certificate.not.imported", (Object[])new Object[0]));
                } else if (PluginCertificateManager.access$getMyCertificates$p(this.this$0).contains(certificate)) {
                    Messages.showWarningDialog((Component)((Component)this.this$0.getMyRootPanel()), (String)IdeBundle.message((String)"settings.certificate.certificate.already.exists", (Object[])new Object[0]), (String)IdeBundle.message((String)"settings.certificate.not.imported", (Object[])new Object[0]));
                } else {
                    PluginCertificateManager.access$addCertificate(this.this$0, certificate);
                }
            }
            {
                this.this$0 = pluginCertificateManager;
            }
        }));
    }

    private final void addCertificate(X509Certificate certificate) {
        this.myCertificates.add(certificate);
        this.myTreeBuilder.addCertificate(certificate);
        this.addCertificatePanel(certificate);
        this.myTreeBuilder.selectCertificate(certificate);
    }

    private final void removeSelectedCertificates() {
        for (X509Certificate certificate : this.myTreeBuilder.getSelectedCertificates(true)) {
            this.myCertificates.remove(certificate);
            this.myTreeBuilder.removeCertificate(certificate);
        }
        if (this.myCertificates.isEmpty()) {
            this.showCard(this.EMPTY_PANEL);
        } else {
            this.myTreeBuilder.selectFirstCertificate();
        }
    }

    private final void showCard(String cardName) {
        LayoutManager layoutManager = this.myDetailsPanel.getLayout();
        if (layoutManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.CardLayout");
        }
        ((CardLayout)layoutManager).show(this.myDetailsPanel, cardName);
    }

    private final String getCardName(X509Certificate certificate) {
        X500Principal x500Principal = certificate.getSubjectX500Principal();
        Intrinsics.checkNotNullExpressionValue((Object)x500Principal, (String)"certificate.subjectX500Principal");
        String string = x500Principal.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"certificate.subjectX500Principal.name");
        return string;
    }

    private final void addCertificatePanel(X509Certificate certificate) {
        String uniqueName = this.getCardName(certificate);
        JPanel infoPanel = (JPanel)new CertificateInfoPanel(certificate);
        UIUtil.addInsets((JComponent)infoPanel, (Insets)UIUtil.PANEL_REGULAR_INSETS);
        JBScrollPane scrollPane = new JBScrollPane((Component)infoPanel);
        this.myDetailsPanel.add((Component)scrollPane, uniqueName);
    }

    /*
     * WARNING - void declaration
     */
    public PluginCertificateManager() {
        void $this$panel;
        LayoutBuilder builder$iv;
        String string = IdeBundle.message((String)"plugin.manager.custom.certificates", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"plugi\u2026ger.custom.certificates\")");
        super(string, "plugin.certificates");
        this.myTree = new Tree();
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder layoutBuilder = builder$iv = LayoutImplKt.createLayoutBuilder();
        PluginCertificateManager pluginCertificateManager = this;
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ PluginCertificateManager this$0;
            {
                this.this$0 = pluginCertificateManager;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                JPanel jPanel2 = ToolbarDecorator.createDecorator((JTree)((JTree)PluginCertificateManager.access$getMyTree$p(this.this$0))).disableUpDownActions().setAddAction(new AnActionButtonRunnable(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run(AnActionButton it) {
                        PluginCertificateManager.access$chooseFileAndAdd(this.this$0.this$0);
                    }
                }).setRemoveAction(new AnActionButtonRunnable(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run(AnActionButton it) {
                        PluginCertificateManager.access$removeSelectedCertificates(this.this$0.this$0);
                    }
                }).createPanel();
                Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"ToolbarDecorator.createD\u2026 }\n        .createPanel()");
                JPanel decorator = jPanel2;
                Cell.invoke$default($this$row, decorator, new CCFlags[]{$this$row.getGrowX()}, null, null, 6, null);
            }
        }, 3, null);
        Unit unit = Unit.INSTANCE;
        Object panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        pluginCertificateManager.myCertificatesListPanel = (JPanel)panel$iv;
        this.myDetailsPanel = new JPanel(new CardLayout());
        constraints$iv = new LCFlags[]{};
        title$iv = null;
        $i$f$panel = false;
        builder$iv = LayoutImplKt.createLayoutBuilder();
        panel$iv = builder$iv;
        pluginCertificateManager = this;
        boolean bl2 = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ PluginCertificateManager this$0;
            {
                this.this$0 = pluginCertificateManager;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, PluginCertificateManager.access$getMyCertificatesListPanel$p(this.this$0), new CCFlags[0], null, null, 6, null);
            }
        }, 3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ PluginCertificateManager this$0;
            {
                this.this$0 = pluginCertificateManager;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default($this$row, PluginCertificateManager.access$getMyDetailsPanel$p(this.this$0), new CCFlags[]{$this$row.getGrowX()}, null, null, 6, null);
            }
        }, 3, null);
        unit = Unit.INSTANCE;
        panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        pluginCertificateManager.myRootPanel = panel$iv;
        constraints$iv = new LCFlags[]{};
        title$iv = null;
        $i$f$panel = false;
        builder$iv = LayoutImplKt.createLayoutBuilder();
        panel$iv = builder$iv;
        pluginCertificateManager = this;
        boolean bl3 = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, false, (Function1)myEmptyPanel.1.1.INSTANCE, 3, null);
        unit = Unit.INSTANCE;
        panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        pluginCertificateManager.myEmptyPanel = panel$iv;
        this.CERTIFICATE_DESCRIPTOR = new FileTypeDescriptor(IdeBundle.message((String)"settings.certificate.choose.certificate", (Object[])new Object[0]), new String[]{".crt", ".CRT", ".cer", ".CER", ".pem", ".PEM", ".der", ".DER"});
        this.EMPTY_PANEL = "empty.panel";
        this.myTrustManager = PluginCertificateStore.Companion.getInstance().getCustomTrustManager();
        this.myTreeBuilder = new CertificateTreeBuilder(this.myTree);
        boolean bl4 = false;
        this.myCertificates = new LinkedHashSet();
    }

    public static final /* synthetic */ Set access$getMyCertificates$p(PluginCertificateManager $this) {
        return $this.myCertificates;
    }

    public static final /* synthetic */ CertificateTreeBuilder access$getMyTreeBuilder$p(PluginCertificateManager $this) {
        return $this.myTreeBuilder;
    }

    public static final /* synthetic */ void access$addCertificatePanel(PluginCertificateManager $this, X509Certificate certificate) {
        $this.addCertificatePanel(certificate);
    }

    public static final /* synthetic */ void access$showCard(PluginCertificateManager $this, String cardName) {
        $this.showCard(cardName);
    }

    public static final /* synthetic */ String access$getCardName(PluginCertificateManager $this, X509Certificate certificate) {
        return $this.getCardName(certificate);
    }

    public static final /* synthetic */ void access$addCertificate(PluginCertificateManager $this, X509Certificate certificate) {
        $this.addCertificate(certificate);
    }

    public static final /* synthetic */ Tree access$getMyTree$p(PluginCertificateManager $this) {
        return $this.myTree;
    }

    public static final /* synthetic */ void access$chooseFileAndAdd(PluginCertificateManager $this) {
        $this.chooseFileAndAdd();
    }

    public static final /* synthetic */ void access$removeSelectedCertificates(PluginCertificateManager $this) {
        $this.removeSelectedCertificates();
    }

    public static final /* synthetic */ JPanel access$getMyCertificatesListPanel$p(PluginCertificateManager $this) {
        return $this.myCertificatesListPanel;
    }

    public static final /* synthetic */ JPanel access$getMyDetailsPanel$p(PluginCertificateManager $this) {
        return $this.myDetailsPanel;
    }
}

