/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginHeaderPanel;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.PluginModulesHelper;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.xml.util.XmlStringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginManagerMain {
    private static final String TEXT_SUFFIX = "</body></html>";
    private static final String HTML_PREFIX = "<a href=\"";
    private static final String HTML_SUFFIX = "</a>";

    private PluginManagerMain() {
    }

    @NlsSafe
    private static String getTextPrefix() {
        int fontSize = JBUIScale.scale((int)12);
        int m1 = JBUIScale.scale((int)2);
        int m2 = JBUIScale.scale((int)5);
        return String.format("<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx        }    </style></head><body style=\"font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx;\">", fontSize, m1, m1, fontSize, m2, m2);
    }

    public static boolean downloadPlugins(List<PluginNode> plugins2, List<? extends IdeaPluginDescriptor> customPlugins, Runnable onSuccess2, PluginEnabler pluginEnabler, @Nullable Runnable cleanup) throws IOException {
        return PluginManagerMain.downloadPlugins(plugins2, customPlugins, false, onSuccess2, pluginEnabler, cleanup);
    }

    public static boolean downloadPlugins(List<PluginNode> plugins2, List<? extends IdeaPluginDescriptor> customPlugins, boolean allowInstallWithoutRestart, Runnable onSuccess2, PluginEnabler pluginEnabler, @Nullable Runnable cleanup) throws IOException {
        Function<Boolean, Void> function = cleanup == null ? null : aBoolean -> {
            cleanup.run();
            return null;
        };
        return PluginManagerMain.downloadPlugins(plugins2, customPlugins, allowInstallWithoutRestart, onSuccess2, pluginEnabler, function);
    }

    public static boolean downloadPlugins(final List<PluginNode> plugins2, final List<? extends IdeaPluginDescriptor> customPlugins, final boolean allowInstallWithoutRestart, final Runnable onSuccess2, final PluginEnabler pluginEnabler, final @Nullable Function<? super Boolean, Void> function) throws IOException {
        final boolean[] result2 = new boolean[1];
        try {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, IdeBundle.message((String)"progress.download.plugins", (Object[])new Object[0]), true, PluginManagerUISettings.getInstance()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        if (PluginInstaller.prepareToInstall(plugins2, customPlugins, allowInstallWithoutRestart, pluginEnabler, onSuccess2, indicator)) {
                            result2[0] = true;
                        }
                    }
                    finally {
                        if (function != null) {
                            ApplicationManager.getApplication().invokeLater(() -> function.apply(result2[0]));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginManagerMain$1", "run"));
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        return result2[0];
    }

    public static void pluginInfoUpdate(IdeaPluginDescriptor plugin2, @Nullable String filter, @NotNull JEditorPane descriptionTextArea, @NotNull PluginHeaderPanel header2) {
        String changeNotes;
        if (descriptionTextArea == null) {
            PluginManagerMain.$$$reportNull$$$0(0);
        }
        if (header2 == null) {
            PluginManagerMain.$$$reportNull$$$0(1);
        }
        if (plugin2 == null) {
            PluginManagerMain.setTextValue(null, filter, descriptionTextArea);
            header2.getPanel().setVisible(false);
            return;
        }
        StringBuilder sb = new StringBuilder();
        header2.setPlugin(plugin2);
        String description = plugin2.getDescription();
        if (!Strings.isEmptyOrSpaces((CharSequence)description)) {
            sb.append(description);
        }
        if (!Strings.isEmptyOrSpaces((CharSequence)(changeNotes = plugin2.getChangeNotes()))) {
            sb.append("<h4>Change Notes</h4>");
            sb.append(changeNotes);
        }
        if (!plugin2.isBundled()) {
            String size;
            String vendor = plugin2.getVendor();
            String vendorEmail = plugin2.getVendorEmail();
            String vendorUrl = plugin2.getVendorUrl();
            if (!(Strings.isEmptyOrSpaces((CharSequence)vendor) && Strings.isEmptyOrSpaces((CharSequence)vendorEmail) && Strings.isEmptyOrSpaces((CharSequence)vendorUrl))) {
                sb.append("<h4>Vendor</h4>");
                if (!Strings.isEmptyOrSpaces((CharSequence)vendor)) {
                    sb.append(vendor);
                }
                if (!Strings.isEmptyOrSpaces((CharSequence)vendorUrl)) {
                    sb.append("<br>").append(PluginManagerMain.composeHref(vendorUrl));
                }
                if (!Strings.isEmptyOrSpaces((CharSequence)vendorEmail)) {
                    sb.append("<br>").append(HTML_PREFIX).append("mailto:").append(vendorEmail).append("\">").append(vendorEmail).append(HTML_SUFFIX);
                }
            }
            String pluginDescriptorUrl = plugin2.getUrl();
            try {
                List<String> marketplacePlugins2 = MarketplaceRequests.getInstance().getMarketplaceCachedPlugins();
                if (marketplacePlugins2 == null) {
                    PluginManagerMain.setPluginHomePage(pluginDescriptorUrl, sb);
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        try {
                            MarketplaceRequests.getInstance().getMarketplacePlugins(null);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                } else if (marketplacePlugins2.contains(plugin2.getPluginId().getIdString())) {
                    PluginManagerMain.setPluginHomePage(pluginDescriptorUrl, sb);
                }
            }
            catch (IOException marketplacePlugins2) {
                // empty catch block
            }
            String string = size = plugin2 instanceof PluginNode ? ((PluginNode)plugin2).getSize() : null;
            if (!Strings.isEmptyOrSpaces((CharSequence)size)) {
                sb.append("<h4>Size</h4>").append(PluginManagerColumnInfo.getFormattedSize(size));
            }
        }
        PluginManagerMain.setTextValue(sb, filter, descriptionTextArea);
    }

    private static void setPluginHomePage(String pluginDescriptorUrl, StringBuilder sb) {
        if (!Strings.isEmptyOrSpaces((CharSequence)pluginDescriptorUrl)) {
            sb.append("<h4>Plugin homepage</h4>").append(PluginManagerMain.composeHref(pluginDescriptorUrl));
        }
    }

    private static void setTextValue(@Nullable StringBuilder text2, @Nullable String filter, JEditorPane pane2) {
        if (text2 != null) {
            text2.insert(0, PluginManagerMain.getTextPrefix());
            text2.append(TEXT_SUFFIX);
            @NlsSafe String markup = SearchUtil.markup(text2.toString(), filter);
            pane2.setText(markup.trim());
            pane2.setCaretPosition(0);
        } else {
            pane2.setText(PluginManagerMain.getTextPrefix() + TEXT_SUFFIX);
        }
    }

    private static String composeHref(String vendorUrl) {
        return HTML_PREFIX + vendorUrl + "\">" + vendorUrl + HTML_SUFFIX;
    }

    public static boolean isAccepted(@Nullable String filter, @NotNull Set<String> search2, @NotNull IdeaPluginDescriptor descriptor2) {
        if (search2 == null) {
            PluginManagerMain.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            PluginManagerMain.$$$reportNull$$$0(3);
        }
        if (Strings.isEmpty((String)filter) || StringUtil.indexOfIgnoreCase((String)descriptor2.getName(), (String)filter, (int)0) >= 0 || PluginManagerMain.isAccepted(search2, filter, descriptor2.getName())) {
            return true;
        }
        if (PluginManagerMain.isAccepted(search2, filter, descriptor2.getDescription())) {
            return true;
        }
        String category = descriptor2.getCategory();
        return category != null && (StringUtil.containsIgnoreCase((String)category, (String)filter) || PluginManagerMain.isAccepted(search2, filter, category));
    }

    public static boolean isAccepted(@NotNull Set<String> search2, @NotNull String filter, @Nullable String description) {
        if (search2 == null) {
            PluginManagerMain.$$$reportNull$$$0(4);
        }
        if (filter == null) {
            PluginManagerMain.$$$reportNull$$$0(5);
        }
        if (Strings.isEmpty((String)description) || filter.length() <= 2) {
            return false;
        }
        Set words = SearchableOptionsRegistrar.getInstance().getProcessedWords(description);
        if (words.contains(filter)) {
            return true;
        }
        if (search2.isEmpty()) {
            return false;
        }
        HashSet<String> descriptionSet = new HashSet<String>(search2);
        descriptionSet.removeAll(words);
        return descriptionSet.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean suggestToEnableInstalledDependantPlugins(@NotNull PluginEnabler pluginEnabler, @NotNull List<? extends IdeaPluginDescriptor> list2) {
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(6);
        }
        if (list2 == null) {
            PluginManagerMain.$$$reportNull$$$0(7);
        }
        HashSet<Object> disabled = new HashSet<Object>();
        HashSet<IdeaPluginDescriptor> disabledDependants = new HashSet<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : list2) {
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            if (pluginEnabler.isDisabled(pluginId)) {
                disabled.add(ideaPluginDescriptor);
            }
            for (IdeaPluginDependency dependency : ideaPluginDescriptor.getDependencies()) {
                IdeaPluginDescriptor pluginDescriptor2;
                PluginId pluginIdByModule;
                PluginId dependantId;
                if (dependency.isOptional() || PluginManagerCore.isModuleDependency(dependantId = dependency.getPluginId()) && (pluginIdByModule = PluginModulesHelper.getInstance().getInstalledPluginIdByModule(dependantId)) == null || (pluginDescriptor2 = PluginManagerCore.getPlugin(dependantId)) == null || !pluginEnabler.isDisabled(dependantId)) continue;
                disabledDependants.add(pluginDescriptor2);
            }
        }
        if (!disabled.isEmpty() || !disabledDependants.isEmpty()) {
            void var5_8;
            Object message2 = "";
            if (disabled.size() == 1) {
                message2 = (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part1", (Object[])new Object[]{((IdeaPluginDescriptor)disabled.iterator().next()).getName()});
            } else if (!disabled.isEmpty()) {
                message2 = (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part2", (Object[])new Object[]{StringUtil.join(disabled, pluginDescriptor -> pluginDescriptor.getName(), (String)", ")});
            }
            if (!disabledDependants.isEmpty()) {
                message2 = (String)message2 + "<br>";
                message2 = (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part3", (Object[])new Object[]{list2.size()});
                message2 = (String)message2 + " ";
                message2 = disabledDependants.size() == 1 ? (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part4", (Object[])new Object[]{((IdeaPluginDescriptor)disabledDependants.iterator().next()).getName()}) : (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part5", (Object[])new Object[]{StringUtil.join(disabledDependants, pluginDescriptor -> pluginDescriptor.getName(), (String)", ")});
            }
            message2 = (String)message2 + " ";
            message2 = (String)message2 + IdeBundle.message((String)(disabled.isEmpty() ? "plugin.manager.main.suggest.to.enable.message.part6" : "plugin.manager.main.suggest.to.enable.message.part7"), (Object[])new Object[0]);
            if (!disabled.isEmpty() && !disabledDependants.isEmpty()) {
                int code = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)IdeBundle.message((String)"dialog.title.dependent.plugins.found", (Object[])new Object[0]), (String)XmlStringUtil.wrapInHtml((CharSequence)message2)).yesText(IdeBundle.message((String)"button.enable.all", (Object[])new Object[0]))).noText(IdeBundle.message((String)"button.enable.updated.plugin.0", (Object[])new Object[]{disabled.size()}))).guessWindowAndAsk();
                if (code == 2) {
                    return false;
                }
                boolean bl = code == 0;
            } else {
                message2 = (String)message2 + "<br>";
                message2 = !disabled.isEmpty() ? (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part8", (Object[])new Object[]{disabled.size()}) : (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part9", (Object[])new Object[]{disabledDependants.size()});
                message2 = (String)message2 + "?";
                boolean bl = MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"dialog.title.dependent.plugins.found", (Object[])new Object[0]), (String)XmlStringUtil.wrapInHtml((CharSequence)message2)).guessWindowAndAsk();
                if (!bl) {
                    return false;
                }
            }
            if (var5_8 != false) {
                disabled.addAll(disabledDependants);
                pluginEnabler.enablePlugins(disabled);
            } else if (!disabled.isEmpty()) {
                pluginEnabler.enablePlugins(disabled);
            }
            return true;
        }
        return false;
    }

    public static void notifyPluginsUpdated(@Nullable Project project) {
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        String title = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        String action2 = IdeBundle.message((String)"ide.restart.required.notification", (Object[])new Object[]{app.isRestartCapable() ? 1 : 0});
        Notification notification = UpdateChecker.getNotificationGroup().createNotification(title, "", NotificationType.INFORMATION, null, "plugins.updated.suggest.restart");
        notification.addAction((AnAction)new NotificationAction(action2){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (PluginManagerConfigurable.showRestartDialog() == 0) {
                    notification.expire();
                    ApplicationManagerEx.getApplicationEx().restart(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/PluginManagerMain$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(project);
    }

    public static boolean checkThirdPartyPluginsAllowed(Iterable<? extends IdeaPluginDescriptor> descriptors2) {
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        if (updateSettings.isThirdPartyPluginsAllowed()) {
            return true;
        }
        PluginManager pluginManager = PluginManager.getInstance();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
            String noText;
            String yesText;
            if (pluginManager.isDevelopedByJetBrains((PluginDescriptor)ideaPluginDescriptor)) continue;
            String title = IdeBundle.message((String)"third.party.plugins.privacy.note.title", (Object[])new Object[0]);
            String message2 = IdeBundle.message((String)"third.party.plugins.privacy.note.message", (Object[])new Object[0]);
            if (Messages.showYesNoDialog((String)message2, (String)title, (String)(yesText = IdeBundle.message((String)"third.party.plugins.privacy.note.yes", (Object[])new Object[0])), (String)(noText = IdeBundle.message((String)"third.party.plugins.privacy.note.no", (Object[])new Object[0])), (Icon)Messages.getWarningIcon()) == 0) {
                updateSettings.setThirdPartyPluginsAllowed(true);
                return true;
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionTextArea";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "search";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerMain";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "pluginInfoUpdate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAccepted";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestToEnableInstalledDependantPlugins";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface PluginEnabler {
        public void enablePlugins(@NotNull Set<? extends IdeaPluginDescriptor> var1);

        public void disablePlugins(@NotNull Set<? extends IdeaPluginDescriptor> var1);

        public boolean isDisabled(@NotNull PluginId var1);

        public static class HEADLESS
        implements PluginEnabler {
            @Override
            public void enablePlugins(@NotNull Set<? extends IdeaPluginDescriptor> plugins2) {
                if (plugins2 == null) {
                    HEADLESS.$$$reportNull$$$0(0);
                }
                DisabledPluginsState.enablePlugins(plugins2, true);
            }

            @Override
            public void disablePlugins(@NotNull Set<? extends IdeaPluginDescriptor> plugins2) {
                if (plugins2 == null) {
                    HEADLESS.$$$reportNull$$$0(1);
                }
                for (IdeaPluginDescriptor ideaPluginDescriptor : plugins2) {
                    PluginManagerCore.disablePlugin(ideaPluginDescriptor.getPluginId());
                }
            }

            @Override
            public boolean isDisabled(@NotNull PluginId pluginId) {
                if (pluginId == null) {
                    HEADLESS.$$$reportNull$$$0(2);
                }
                return PluginManagerCore.isDisabled(pluginId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "plugins";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginId";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerMain$PluginEnabler$HEADLESS";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "enablePlugins";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "disablePlugins";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isDisabled";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class MyHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane2 = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane2.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.browse((URL)url);
                    }
                }
            }
        }
    }
}

