/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.CachingSemiGraph;
import com.intellij.ide.plugins.ClassLoaderConfigurator;
import com.intellij.ide.plugins.ClassPathXmlPathResolver;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManagerState;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.lang.UrlClassLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.TestOnly;

public final class PluginManagerCore {
    @NonNls
    public static final String META_INF = "META-INF/";
    public static final String IDEA_IS_INTERNAL_PROPERTY = "idea.is.internal";
    public static final PluginId CORE_ID = PluginId.getId((String)"com.intellij");
    public static final String CORE_PLUGIN_ID = "com.intellij";
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId((String)"com.intellij.java");
    static final PluginId JAVA_MODULE_ID = PluginId.getId((String)"com.intellij.modules.java");
    public static final String PLUGIN_XML = "plugin.xml";
    public static final String PLUGIN_XML_PATH = "META-INF/plugin.xml";
    static final PluginId ALL_MODULES_MARKER = PluginId.getId((String)"com.intellij.modules.all");
    public static final String VENDOR_JETBRAINS = "JetBrains";
    public static final String VENDOR_JETBRAINS_SRO = "JetBrains s.r.o.";
    private static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    private static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId((String)"IDEA CORE");
    static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    @NonNls
    public static final String DISABLE = "disable";
    @NonNls
    public static final String ENABLE = "enable";
    @NonNls
    public static final String EDIT = "edit";
    private static final boolean IGNORE_DISABLED_PLUGINS = Boolean.getBoolean("idea.ignore.disabled.plugins");
    private static final MethodType HAS_LOADED_CLASS_METHOD_TYPE = MethodType.methodType(Boolean.TYPE, String.class);
    private static Reference<Map<PluginId, Set<String>>> ourBrokenPluginVersions;
    private static volatile IdeaPluginDescriptorImpl[] ourPlugins;
    @Nullable
    private static volatile Set<IdeaPluginDescriptorImpl> pluginIdentitySetCache;
    private static volatile List<IdeaPluginDescriptorImpl> ourLoadedPlugins;
    private static Map<PluginId, PluginLoadingError> ourPluginLoadingErrors;
    private static Map<String, String[]> ourAdditionalLayoutMap;
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    static final boolean usePluginClassLoader;
    @ApiStatus.Internal
    private static final List<Supplier<? extends HtmlChunk>> ourPluginErrors;
    @ApiStatus.Internal
    public static Set<PluginId> ourPluginsToDisable;
    @ApiStatus.Internal
    public static Set<PluginId> ourPluginsToEnable;
    @ApiStatus.Internal
    public static boolean ourDisableNonBundledPlugins;
    private static Set<PluginId> ourShadowedBundledPlugins;
    private static Boolean isRunningFromSources;
    private static volatile CompletableFuture<DescriptorListLoadingContext> descriptorListFuture;
    private static BuildNumber ourBuildNumber;

    @ApiStatus.Internal
    @Nullable
    public static String getPluginsCompatibleBuild() {
        return System.getProperty("idea.plugins.compatible.build");
    }

    @NotNull
    public static @NotNull IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] result2 = ourPlugins;
        if (result2 == null) {
            PluginManagerCore.loadAndInitializePlugins(null, null);
            if (ourPlugins == null) {
                PluginManagerCore.$$$reportNull$$$0(0);
            }
            return ourPlugins;
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(1);
        }
        return result2;
    }

    @NotNull
    static Collection<IdeaPluginDescriptorImpl> getAllPlugins() {
        List<IdeaPluginDescriptorImpl> list2 = Arrays.asList(ourPlugins);
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(2);
        }
        return list2;
    }

    static boolean hasDescriptorByIdentity(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        Set<IdeaPluginDescriptorImpl> cache2;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(3);
        }
        if ((cache2 = pluginIdentitySetCache) == null) {
            IdeaPluginDescriptorImpl[] allPlugins = ourPlugins;
            cache2 = Collections.newSetFromMap(new IdentityHashMap(allPlugins.length));
            Collections.addAll(cache2, allPlugins);
            pluginIdentitySetCache = cache2;
        }
        return cache2.contains(descriptor2);
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        return PluginManagerCore.getLoadedPlugins(null);
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> getLoadedPlugins(@Nullable ClassLoader coreClassLoader) {
        List<IdeaPluginDescriptorImpl> result2 = ourLoadedPlugins;
        if (result2 == null) {
            PluginManagerCore.loadAndInitializePlugins(null, coreClassLoader);
            List<IdeaPluginDescriptorImpl> list2 = ourLoadedPlugins;
            if (list2 == null) {
                PluginManagerCore.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<IdeaPluginDescriptorImpl> list3 = result2;
        if (list3 == null) {
            PluginManagerCore.$$$reportNull$$$0(5);
        }
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @NotNull
    public static List<HtmlChunk> getAndClearPluginLoadingErrors() {
        List<Supplier<? extends HtmlChunk>> list3 = ourPluginErrors;
        // MONITORENTER : list3
        List errors = ContainerUtil.map(ourPluginErrors, Supplier::get);
        ourPluginErrors.clear();
        List list2 = errors;
        // MONITOREXIT : list3
        if (list2 != null) return list2;
        PluginManagerCore.$$$reportNull$$$0(6);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerPluginErrors(List<? extends Supplier<? extends HtmlChunk>> errors) {
        List<Supplier<? extends HtmlChunk>> list2 = ourPluginErrors;
        synchronized (list2) {
            ourPluginErrors.addAll(errors);
        }
    }

    @ApiStatus.Internal
    public static boolean arePluginsInitialized() {
        return ourPlugins != null;
    }

    static synchronized void doSetPlugins(@NotNull IdeaPluginDescriptorImpl @Nullable [] value2) {
        ourPlugins = value2;
        ourLoadedPlugins = value2 == null ? null : Collections.unmodifiableList(PluginManagerCore.getOnlyEnabledPlugins(value2));
        pluginIdentitySetCache = null;
    }

    public static boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        return DisabledPluginsState.isDisabled(pluginId);
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId pluginId;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(8);
        }
        if ((pluginId = descriptor2.getPluginId()) == null) {
            return true;
        }
        Set<String> set2 = PluginManagerCore.getBrokenPluginVersions().get(pluginId);
        return set2 != null && set2.contains(descriptor2.getVersion());
    }

    public static void updateBrokenPlugins(Map<PluginId, Set<String>> brokenPlugins) {
        ourBrokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(brokenPlugins);
    }

    @NotNull
    private static Map<PluginId, Set<String>> getBrokenPluginVersions() {
        if (IGNORE_DISABLED_PLUGINS) {
            Map<PluginId, Set<String>> map2 = Collections.emptyMap();
            if (map2 == null) {
                PluginManagerCore.$$$reportNull$$$0(9);
            }
            return map2;
        }
        Map<PluginId, Set<String>> result2 = (Map<PluginId, Set<String>>)com.intellij.reference.SoftReference.dereference(ourBrokenPluginVersions);
        if (result2 == null) {
            result2 = PluginManagerCore.readBrokenPluginFile();
            ourBrokenPluginVersions = new com.intellij.reference.SoftReference(result2);
        }
        Map<PluginId, Set<String>> map3 = result2;
        if (map3 == null) {
            PluginManagerCore.$$$reportNull$$$0(10);
        }
        return map3;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static Map<PluginId, Set<String>> readBrokenPluginFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writePluginsList(@NotNull Collection<PluginId> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        ArrayList<PluginId> sortedIds = new ArrayList<PluginId>(ids);
        sortedIds.sort(null);
        for (PluginId id2 : sortedIds) {
            writer.write(id2.getIdString());
            writer.write(10);
        }
    }

    public static boolean disablePlugin(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(16);
        }
        return DisabledPluginsState.disablePlugin(id2);
    }

    public static boolean enablePlugin(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(17);
        }
        return DisabledPluginsState.enablePlugin(id2);
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(18);
        }
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    @ApiStatus.Internal
    @NotNull
    public static PluginException createPluginException(@NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        ClassLoader classLoader;
        if (errorMessage == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        if (pluginClass == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        PluginId pluginId = (classLoader = pluginClass.getClassLoader()) instanceof PluginAwareClassLoader ? ((PluginAwareClassLoader)classLoader).getPluginId() : PluginManagerCore.getPluginByClassName(pluginClass.getName());
        return new PluginException(errorMessage, cause, pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        PluginId id2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        return (id2 = PluginManagerCore.getPluginOrPlatformByClassName(className)) == null || CORE_ID == id2 ? null : id2;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        PluginDescriptor result2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        return (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result2.getPluginId();
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull @NonNls String className) {
        List<IdeaPluginDescriptorImpl> loadedPlugins;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        if ((loadedPlugins = ourLoadedPlugins) == null || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("kotlin.") || className.startsWith("groovy.") || !className.contains(".")) {
            return null;
        }
        IdeaPluginDescriptorImpl result2 = null;
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            ClassLoader classLoader = o.getPluginClassLoader();
            if (!PluginManagerCore.hasLoadedClass(className, classLoader)) continue;
            result2 = o;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (result2.getPluginId() != CORE_ID || className.startsWith("com.jetbrains.") || className.startsWith("org.jetbrains.") || className.startsWith("com.intellij.") || className.startsWith("org.intellij.") || className.startsWith("com.android.") || className.startsWith("git4idea.") || className.startsWith("org.angularjs.")) {
            return result2;
        }
        String root = null;
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            if (!o.isUseIdeaClassLoader()) continue;
            if (root == null && (root = PathManager.getResourceRoot((ClassLoader)result2.getPluginClassLoader(), (String)(className.replace('.', '/') + ".class"))) == null) {
                return null;
            }
            Path path = o.getPluginPath();
            if (!root.startsWith(FileUtilRt.toSystemIndependentName((String)path.toString()))) continue;
            return o;
        }
        return null;
    }

    private static boolean hasLoadedClass(@NotNull String className, @NotNull ClassLoader loader2) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        if (loader2 == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        if (loader2 instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader2).hasLoadedClass(className);
        }
        Class<?> aClass = loader2.getClass();
        if (aClass.isAnonymousClass() || aClass.isMemberClass()) {
            aClass = aClass.getSuperclass();
        }
        try {
            return MethodHandles.publicLookup().findVirtual(aClass, "hasLoadedClass", HAS_LOADED_CLASS_METHOD_TYPE).invoke(loader2, className);
        }
        catch (IllegalAccessError | IllegalAccessException | NoSuchMethodError throwable) {
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().error(e);
        }
        return false;
    }

    @Nullable
    static IdeaPluginDescriptorImpl getImplicitDependency(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Supplier<IdeaPluginDescriptorImpl> javaDepGetter) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (javaDepGetter == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        if (descriptor2.isBundled() || descriptor2.getPluginId() == CORE_ID || descriptor2.getPluginId() == JAVA_PLUGIN_ID || VENDOR_JETBRAINS.equals(descriptor2.getVendor())) {
            return null;
        }
        IdeaPluginDescriptorImpl javaDep = javaDepGetter.get();
        if (javaDep == null) {
            return null;
        }
        return PluginManagerCore.hasModuleDependencies(descriptor2) ? null : javaDep;
    }

    static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        for (PluginDependency dependency : descriptor2.getPluginDependencies()) {
            PluginId depId = dependency.id;
            if (depId != JAVA_PLUGIN_ID && depId != JAVA_MODULE_ID && !PluginManagerCore.isModuleDependency(depId)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void invalidatePlugins() {
        PluginManagerCore.doSetPlugins(null);
        DisabledPluginsState.invalidate();
        ourShadowedBundledPlugins = null;
    }

    private static void logPlugins(@NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] plugins2, Collection<IdeaPluginDescriptorImpl> incompletePlugins) {
        if (plugins2 == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        StringBuilder bundled = new StringBuilder();
        StringBuilder disabled = new StringBuilder();
        StringBuilder custom = new StringBuilder();
        HashSet<PluginId> disabledPlugins = new HashSet<PluginId>();
        for (IdeaPluginDescriptorImpl descriptor2 : plugins2) {
            StringBuilder target2;
            if (!descriptor2.isEnabled()) {
                if (!DisabledPluginsState.isDisabled(descriptor2.getPluginId())) continue;
                disabledPlugins.add(descriptor2.getPluginId());
                target2 = disabled;
            } else {
                target2 = descriptor2.isBundled() || descriptor2.getPluginId() == SPECIAL_IDEA_PLUGIN_ID ? bundled : custom;
            }
            PluginManagerCore.appendPlugin(descriptor2, target2);
        }
        for (IdeaPluginDescriptorImpl plugin2 : incompletePlugins) {
            if (!DisabledPluginsState.isDisabled(plugin2.getPluginId()) || disabledPlugins.contains(plugin2.getPluginId())) continue;
            PluginManagerCore.appendPlugin(plugin2, disabled);
        }
        Logger logger = PluginManagerCore.getLogger();
        logger.info("Loaded bundled plugins: " + bundled);
        if (custom.length() > 0) {
            logger.info("Loaded custom plugins: " + custom);
        }
        if (disabled.length() > 0) {
            logger.info("Disabled plugins: " + disabled);
        }
    }

    private static void appendPlugin(IdeaPluginDescriptor descriptor2, StringBuilder target2) {
        if (target2.length() > 0) {
            target2.append(", ");
        }
        target2.append(descriptor2.getName());
        String version2 = descriptor2.getVersion();
        if (version2 != null) {
            target2.append(" (").append(version2).append(')');
        }
    }

    public static boolean isRunningFromSources() {
        Boolean result2 = isRunningFromSources;
        if (result2 == null) {
            isRunningFromSources = result2 = Boolean.valueOf(Files.isDirectory(Paths.get(PathManager.getHomePath(), ".idea"), new LinkOption[0]));
        }
        return result2;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull Map<PluginId, PluginLoadingError> pluginErrors, @NotNull List<? extends Supplier<@NlsContexts.DetailedDescription String>> globalErrors, @NotNull List<? extends Supplier<? extends HtmlChunk>> actions) {
        if (pluginErrors == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        if (globalErrors == null) {
            PluginManagerCore.$$$reportNull$$$0(31);
        }
        if (actions == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        ourPluginLoadingErrors = pluginErrors;
        String logMessage = !pluginErrors.isEmpty() || !globalErrors.isEmpty() ? "Problems found loading plugins:\n  " + Stream.concat(globalErrors.stream().map(Supplier::get), pluginErrors.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> ((PluginLoadingError)e.getValue()).getInternalMessage())).collect(Collectors.joining("\n  ")) : null;
        Application app = ApplicationManager.getApplication();
        if (app == null || !app.isHeadlessEnvironment() || isUnitTestMode) {
            List errorsList = Stream.concat(globalErrors.stream().map(message2 -> () -> PluginManagerCore.lambda$prepareLoadingPluginsErrorMessage$1((Supplier)message2)), pluginErrors.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).filter(PluginLoadingError::isNotifyUser).map(error -> () -> HtmlChunk.text((String)error.getDetailedMessage()))).collect(Collectors.toList());
            if (!errorsList.isEmpty()) {
                PluginManagerCore.registerPluginErrors(ContainerUtil.concat(errorsList, actions));
            }
            if (logMessage != null) {
                PluginManagerCore.getLogger().warn(logMessage);
            }
        } else if (logMessage != null) {
            PluginManagerCore.getLogger().error(logMessage);
        }
    }

    @Nullable
    @NlsContexts.Label
    public static String getShortLoadingErrorMessage(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        PluginLoadingError error;
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        if ((error = ourPluginLoadingErrors.get(pluginDescriptor.getPluginId())) != null) {
            return error.getShortMessage();
        }
        return null;
    }

    @Nullable
    public static PluginId getFirstDisabledDependency(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        PluginLoadingError error;
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        if ((error = ourPluginLoadingErrors.get(pluginDescriptor.getPluginId())) != null) {
            return error.getDisabledDependency();
        }
        return null;
    }

    @NotNull
    static CachingSemiGraph<IdeaPluginDescriptorImpl> createPluginIdGraph(@NotNull Collection<IdeaPluginDescriptorImpl> descriptors2, @NotNull Function<? super PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, boolean withOptional, boolean hasAllModules) {
        if (descriptors2 == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        Supplier<IdeaPluginDescriptorImpl> javaDep = () -> (IdeaPluginDescriptorImpl)idToDescriptorMap.apply(JAVA_MODULE_ID);
        HashSet uniqueCheck = new HashSet();
        HashMap<IdeaPluginDescriptorImpl, List<IdeaPluginDescriptorImpl>> in = new HashMap<IdeaPluginDescriptorImpl, List<IdeaPluginDescriptorImpl>>(descriptors2.size());
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors2) {
            List<IdeaPluginDescriptorImpl> list2 = PluginManagerCore.getDirectDependencies(descriptor2, idToDescriptorMap, withOptional, hasAllModules, javaDep, uniqueCheck);
            if (list2.isEmpty()) continue;
            in.put(descriptor2, list2);
        }
        return new CachingSemiGraph<IdeaPluginDescriptorImpl>(descriptors2, in);
    }

    @NotNull
    private static List<IdeaPluginDescriptorImpl> getDirectDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Function<? super PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, boolean withOptional, boolean hasAllModules, @NotNull Supplier<IdeaPluginDescriptorImpl> javaDep, @NotNull Set<? super IdeaPluginDescriptorImpl> uniqueCheck) {
        IdeaPluginDescriptorImpl dep;
        List<Object> incompatibleModuleIds;
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        if (javaDep == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        if (uniqueCheck == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        List<PluginDependency> dependencies = rootDescriptor.pluginDependencies;
        List<Object> list2 = incompatibleModuleIds = rootDescriptor.incompatibilities == null ? Collections.emptyList() : rootDescriptor.incompatibilities;
        if (dependencies == null) {
            dependencies = Collections.emptyList();
        }
        IdeaPluginDescriptorImpl implicitDep = hasAllModules ? PluginManagerCore.getImplicitDependency(rootDescriptor, javaDep) : null;
        int capacity = dependencies.size() + incompatibleModuleIds.size();
        if (!withOptional) {
            for (PluginDependency dependency : dependencies) {
                if (!dependency.isOptional) continue;
                --capacity;
            }
        }
        if (capacity == 0) {
            List<Object> list3 = implicitDep == null ? Collections.emptyList() : Collections.singletonList(implicitDep);
            if (list3 == null) {
                PluginManagerCore.$$$reportNull$$$0(41);
            }
            return list3;
        }
        uniqueCheck.clear();
        ArrayList<IdeaPluginDescriptorImpl> plugins2 = new ArrayList<IdeaPluginDescriptorImpl>(capacity + (implicitDep == null ? 0 : 1));
        if (implicitDep != null) {
            if (rootDescriptor == implicitDep) {
                PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self");
            } else {
                uniqueCheck.add(implicitDep);
                plugins2.add(implicitDep);
            }
        }
        for (PluginDependency pluginDependency : dependencies) {
            if (!withOptional && pluginDependency.isOptional || (dep = idToDescriptorMap.apply((PluginId)pluginDependency.id)) == null) continue;
            if (rootDescriptor == dep) {
                if (rootDescriptor.getPluginId() == CORE_ID) continue;
                PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self");
                continue;
            }
            if (!uniqueCheck.add(dep)) continue;
            plugins2.add(dep);
        }
        for (PluginId pluginId : incompatibleModuleIds) {
            dep = idToDescriptorMap.apply((PluginId)pluginId);
            if (dep == null || !uniqueCheck.add(dep)) continue;
            plugins2.add(dep);
        }
        ArrayList<IdeaPluginDescriptorImpl> arrayList = plugins2;
        if (arrayList == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    private static void checkPluginCycles(@NotNull List<IdeaPluginDescriptorImpl> descriptors2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull List<Supplier<@Nls String>> errors) {
        if (descriptors2 == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph2 = PluginManagerCore.createPluginIdGraph(descriptors2, idToDescriptorMap::get, true, idToDescriptorMap.containsKey(ALL_MODULES_MARKER));
        DFSTBuilder builder2 = new DFSTBuilder(GraphGenerator.generate(graph2));
        if (builder2.isAcyclic()) {
            return;
        }
        for (Collection component2 : builder2.getComponents()) {
            if (component2.size() < 2) continue;
            for (IdeaPluginDescriptor descriptor2 : component2) {
                descriptor2.setEnabled(false);
            }
            String pluginsString = component2.stream().map(it -> "'" + it.getName() + "'").collect(Collectors.joining(", "));
            errors.add(PluginManagerCore.message("plugin.loading.error.plugins.cannot.be.loaded.because.they.form.a.dependency.cycle", pluginsString));
            StringBuilder detailedMessage = new StringBuilder();
            Function<IdeaPluginDescriptorImpl, String> pluginToString = plugin2 -> "id = " + plugin2.getPluginId().getIdString() + " (" + plugin2.getName() + ")";
            detailedMessage.append("Detected plugin dependencies cycle details (only related dependencies are included):\n");
            component2.stream().map(p -> Pair.create((Object)p, (Object)((String)pluginToString.apply((IdeaPluginDescriptorImpl)p)))).sorted(Comparator.comparing(p -> (String)p.second, String.CASE_INSENSITIVE_ORDER)).forEach(p -> {
                detailedMessage.append("  ").append((String)p.getSecond()).append(" depends on:\n");
                ContainerUtil.toCollection(() -> graph2.getIn((IdeaPluginDescriptorImpl)p.first)).stream().filter(dep -> component2.contains(dep)).map(pluginToString).sorted(String.CASE_INSENSITIVE_ORDER).forEach(dep -> detailedMessage.append("    ").append((String)dep).append("\n"));
            });
            PluginManagerCore.getLogger().info(detailedMessage.toString());
        }
    }

    public static void getDescriptorsToMigrate(@NotNull Path dir, @Nullable BuildNumber compatibleBuildNumber, @Nullable Path bundledPluginsPath, @Nullable Map<PluginId, Set<String>> brokenPluginVersions, List<? super IdeaPluginDescriptorImpl> pluginsToMigrate, List<? super IdeaPluginDescriptorImpl> incompatiblePlugins) throws ExecutionException, InterruptedException {
        if (dir == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        PluginLoadingResult loadingResult = new PluginLoadingResult(brokenPluginVersions != null ? brokenPluginVersions : PluginManagerCore.getBrokenPluginVersions(), () -> compatibleBuildNumber == null ? PluginManagerCore.getBuildNumber() : compatibleBuildNumber);
        int flags = 6;
        DescriptorListLoadingContext context = new DescriptorListLoadingContext(flags, Collections.emptySet(), loadingResult);
        Path effectiveBundledPluginPath = bundledPluginsPath != null || isUnitTestMode ? bundledPluginsPath : Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]);
        PluginDescriptorLoader.loadBundledDescriptorsAndDescriptorsFromDir(context, dir, effectiveBundledPluginPath);
        for (IdeaPluginDescriptorImpl descriptor2 : loadingResult.idMap.values()) {
            if (descriptor2.isBundled()) continue;
            if (loadingResult.isBroken(descriptor2.getPluginId())) {
                incompatiblePlugins.add(descriptor2);
                continue;
            }
            pluginsToMigrate.add(descriptor2);
        }
        for (IdeaPluginDescriptorImpl descriptor2 : loadingResult.incompletePlugins.values()) {
            if (descriptor2.isBundled()) continue;
            incompatiblePlugins.add(descriptor2);
        }
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull Map<PluginId, String> disabledIds, @NotNull Set<PluginId> disabledRequiredIds, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idMap, @NotNull Map<PluginId, PluginLoadingError> pluginErrors, @NotNull List<? extends Supplier<String>> globalErrors) {
        if (disabledIds == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        if (pluginErrors == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if (globalErrors == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        ArrayList<Supplier<HtmlChunk>> actions = new ArrayList<Supplier<HtmlChunk>>();
        if (!disabledIds.isEmpty()) {
            PluginId id2;
            String nameToDisable = disabledIds.size() == 1 ? (idMap.containsKey(id2 = disabledIds.keySet().iterator().next()) ? idMap.get(id2).getName() : id2.getIdString()) : null;
            actions.add(() -> HtmlChunk.link((String)DISABLE, (String)CoreBundle.message((String)"link.text.disable.plugin.or.plugins", (Object[])new Object[]{nameToDisable, nameToDisable != null ? 0 : 1})));
            if (!disabledRequiredIds.isEmpty()) {
                String nameToEnable = disabledRequiredIds.size() == 1 && idMap.containsKey(disabledRequiredIds.iterator().next()) ? idMap.get(disabledRequiredIds.iterator().next()).getName() : null;
                actions.add(() -> HtmlChunk.link((String)ENABLE, (String)CoreBundle.message((String)"link.text.enable.plugin.or.plugins", (Object[])new Object[]{nameToEnable, nameToEnable != null ? 0 : 1})));
            }
            actions.add(() -> HtmlChunk.link((String)EDIT, (String)CoreBundle.message((String)"link.text.open.plugin.manager", (Object[])new Object[0])));
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(pluginErrors, globalErrors, actions);
    }

    @TestOnly
    @NotNull
    public static List<? extends IdeaPluginDescriptor> testLoadDescriptorsFromClassPath(@NotNull ClassLoader loader2) throws ExecutionException, InterruptedException {
        if (loader2 == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        LinkedHashMap<URL, String> urlsFromClassPath = new LinkedHashMap<URL, String>();
        PluginDescriptorLoader.collectPluginFilesInClassPath(loader2, urlsFromClassPath);
        BuildNumber buildNumber = BuildNumber.fromString((String)"2042.42");
        DescriptorListLoadingContext context = new DescriptorListLoadingContext(0, Collections.emptySet(), new PluginLoadingResult(Collections.emptyMap(), () -> buildNumber, false));
        try (DescriptorLoadingContext loadingContext = new DescriptorLoadingContext(context, true, true, new ClassPathXmlPathResolver(loader2));){
            PluginDescriptorLoader.loadDescriptorsFromClassPath(urlsFromClassPath, loadingContext, null);
        }
        context.result.finishLoading();
        List<IdeaPluginDescriptorImpl> list2 = context.result.getEnabledPlugins();
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        return list2;
    }

    public static void scheduleDescriptorLoading() {
        PluginManagerCore.getOrScheduleLoading();
    }

    @NotNull
    private static synchronized CompletableFuture<DescriptorListLoadingContext> getOrScheduleLoading() {
        CompletableFuture<DescriptorListLoadingContext> future2 = descriptorListFuture;
        if (future2 != null) {
            CompletableFuture<DescriptorListLoadingContext> completableFuture = future2;
            if (completableFuture == null) {
                PluginManagerCore.$$$reportNull$$$0(54);
            }
            return completableFuture;
        }
        descriptorListFuture = future2 = CompletableFuture.supplyAsync(() -> {
            Activity activity = StartUpMeasurer.startActivity((String)"plugin descriptor loading");
            DescriptorListLoadingContext context = PluginDescriptorLoader.loadDescriptors();
            activity.end();
            return context;
        }, AppExecutorUtil.getAppExecutorService());
        CompletableFuture<DescriptorListLoadingContext> completableFuture = future2;
        if (completableFuture == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        return completableFuture;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> getEnabledPluginRawList() {
        List<IdeaPluginDescriptorImpl> list2 = PluginManagerCore.getOrScheduleLoading().join().result.getEnabledPlugins();
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        return list2;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletionStage<List<IdeaPluginDescriptorImpl>> initPlugins(@NotNull ClassLoader coreClassLoader) {
        CompletableFuture<DescriptorListLoadingContext> future2;
        if (coreClassLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        if ((future2 = descriptorListFuture) == null) {
            future2 = CompletableFuture.completedFuture(null);
        }
        CompletionStage completionStage = future2.thenApply(context -> {
            PluginManagerCore.loadAndInitializePlugins(context, coreClassLoader);
            return ourLoadedPlugins;
        });
        if (completionStage == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        return completionStage;
    }

    @NotNull
    static PluginLoadingResult createLoadingResult(@Nullable BuildNumber buildNumber) {
        return new PluginLoadingResult(PluginManagerCore.getBrokenPluginVersions(), () -> buildNumber == null ? PluginManagerCore.getBuildNumber() : buildNumber);
    }

    @NotNull
    private static Map<String, String[]> loadAdditionalLayoutMap() {
        Path fileWithLayout;
        Path path = fileWithLayout = usePluginClassLoader ? Paths.get(PathManager.getSystemPath(), PlatformUtils.getPlatformPrefix() + ".txt") : null;
        if (fileWithLayout == null || !Files.exists(fileWithLayout, new LinkOption[0])) {
            Map<String, String[]> map2 = Collections.emptyMap();
            if (map2 == null) {
                PluginManagerCore.$$$reportNull$$$0(59);
            }
            return map2;
        }
        LinkedHashMap<String, String[]> additionalLayoutMap = new LinkedHashMap<String, String[]>();
        try (BufferedReader bufferedReader = Files.newBufferedReader(fileWithLayout);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                List parameters2 = ParametersListUtil.parse((String)line.trim());
                if (parameters2.size() < 2) continue;
                additionalLayoutMap.put((String)parameters2.get(0), ArrayUtilRt.toStringArray(parameters2.subList(1, parameters2.size())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LinkedHashMap<String, String[]> linkedHashMap = additionalLayoutMap;
        if (linkedHashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        return linkedHashMap;
    }

    @ApiStatus.Internal
    @NotNull
    public static ClassLoaderConfigurator createClassLoaderConfiguratorForDynamicPlugin(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = PluginManagerCore.buildPluginIdMap(ContainerUtil.concat(PluginManagerCore.getLoadedPlugins(null), Collections.singletonList(pluginDescriptor)));
        return new ClassLoaderConfigurator(true, PluginManagerCore.class.getClassLoader(), idMap, ourAdditionalLayoutMap);
    }

    @NotNull
    public static BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromString((String)PluginManagerCore.getPluginsCompatibleBuild());
            if (result2 == null) {
                if (isUnitTestMode) {
                    result2 = BuildNumber.currentVersion();
                } else {
                    try {
                        result2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result2 = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result2;
        }
        BuildNumber buildNumber = result2;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        return buildNumber;
    }

    private static void disableIncompatiblePlugins(@NotNull List<IdeaPluginDescriptorImpl> descriptors2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Map<PluginId, PluginLoadingError> errors) {
        boolean isNonBundledPluginDisabled;
        if (descriptors2 == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if (isNonBundledPluginDisabled = ourDisableNonBundledPlugins) {
            PluginManagerCore.getLogger().info("Running with disableThirdPartyPlugins argument, third-party plugins will be disabled");
        }
        String selectedIds = System.getProperty("idea.load.plugins.id");
        String selectedCategory = System.getProperty("idea.load.plugins.category");
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        LinkedHashSet<IdeaPluginDescriptorImpl> explicitlyEnabled = null;
        if (selectedIds != null) {
            HashSet set2 = new HashSet();
            for (String it : selectedIds.split(",")) {
                set2.add(PluginId.getId((String)it));
            }
            set2.addAll(ApplicationInfoImpl.getShadowInstance().getEssentialPluginsIds());
            explicitlyEnabled = new LinkedHashSet(set2.size());
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                PluginId id3 = (PluginId)iterator2.next();
                IdeaPluginDescriptorImpl descriptor2 = idMap.get(id3);
                if (descriptor2 == null) continue;
                explicitlyEnabled.add(descriptor2);
            }
        } else if (selectedCategory != null) {
            explicitlyEnabled = new LinkedHashSet<IdeaPluginDescriptorImpl>();
            for (IdeaPluginDescriptorImpl descriptor3 : descriptors2) {
                if (!selectedCategory.equals(descriptor3.getCategory())) continue;
                explicitlyEnabled.add(descriptor3);
            }
        }
        if (explicitlyEnabled != null) {
            LinkedHashSet<IdeaPluginDescriptorImpl> finalExplicitlyEnabled = explicitlyEnabled;
            HashSet depProcessed = new HashSet();
            for (IdeaPluginDescriptorImpl descriptor4 : new ArrayList(explicitlyEnabled)) {
                PluginManagerCore.processAllDependencies(descriptor4, false, idMap, depProcessed, (id2, dependency) -> {
                    finalExplicitlyEnabled.add((IdeaPluginDescriptorImpl)dependency);
                    return FileVisitResult.CONTINUE;
                });
            }
        }
        Map<PluginId, Set<String>> brokenPluginVersions = PluginManagerCore.getBrokenPluginVersions();
        boolean shouldLoadPlugins = Boolean.parseBoolean(System.getProperty("idea.load.plugins", "true"));
        for (IdeaPluginDescriptorImpl descriptor5 : descriptors2) {
            if (descriptor5 == coreDescriptor) continue;
            Set<String> set3 = brokenPluginVersions.get(descriptor5.getPluginId());
            if (set3 != null && set3.contains(descriptor5.getVersion())) {
                descriptor5.setEnabled(false);
                PluginLoadingError.create(descriptor5, PluginManagerCore.message("plugin.loading.error.long.marked.as.broken", descriptor5.getName(), descriptor5.getVersion()), PluginManagerCore.message("plugin.loading.error.short.marked.as.broken", new Object[0])).register(errors);
                continue;
            }
            if (explicitlyEnabled != null) {
                if (explicitlyEnabled.contains(descriptor5)) continue;
                descriptor5.setEnabled(false);
                PluginManagerCore.getLogger().info("Plugin '" + descriptor5.getName() + "' " + (selectedIds != null ? "is not in 'idea.load.plugins.id' system property" : "category doesn't match 'idea.load.plugins.category' system property"));
                continue;
            }
            if (!shouldLoadPlugins) {
                descriptor5.setEnabled(false);
                PluginLoadingError.create(descriptor5, PluginManagerCore.message("plugin.loading.error.long.plugin.loading.disabled", descriptor5.getName()), PluginManagerCore.message("plugin.loading.error.short.plugin.loading.disabled", new Object[0])).register(errors);
                continue;
            }
            if (!isNonBundledPluginDisabled || descriptor5.isBundled()) continue;
            descriptor5.setEnabled(false);
            PluginLoadingError.create(descriptor5, PluginManagerCore.message("plugin.loading.error.long.custom.plugin.loading.disabled", descriptor5.getName()), PluginManagerCore.message("plugin.loading.error.short.custom.plugin.loading.disabled", new Object[0]), false).register(errors);
        }
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        return !PluginManagerCore.isIncompatible(descriptor2);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        return !PluginManagerCore.isIncompatible(descriptor2, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        return PluginManagerCore.isIncompatible(descriptor2, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(69);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        return PluginManagerCore.checkBuildNumberCompatibility(descriptor2, buildNumber) != null;
    }

    @Nullable
    public static PluginLoadingError checkBuildNumberCompatibility(@NotNull IdeaPluginDescriptor descriptor2, @NotNull BuildNumber ideBuildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        if (ideBuildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        return PluginManagerCore.checkBuildNumberCompatibility(descriptor2, ideBuildNumber, null);
    }

    @Nullable
    public static PluginLoadingError checkBuildNumberCompatibility(@NotNull IdeaPluginDescriptor descriptor2, @NotNull BuildNumber ideBuildNumber, @Nullable Runnable beforeCreateErrorCallback) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        if (ideBuildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        String sinceBuild = descriptor2.getSinceBuild();
        String untilBuild = descriptor2.getUntilBuild();
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            BuildNumber buildNumber = sinceBuildNumber = sinceBuild == null ? null : BuildNumber.fromString((String)sinceBuild, null, null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(ideBuildNumber) > 0) {
                if (beforeCreateErrorCallback != null) {
                    beforeCreateErrorCallback.run();
                }
                return PluginLoadingError.create(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.since.build", descriptor2.getName(), descriptor2.getVersion(), sinceBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.since.build", sinceBuild));
            }
            BuildNumber buildNumber2 = untilBuildNumber = untilBuild == null ? null : BuildNumber.fromString((String)untilBuild, null, null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(ideBuildNumber) < 0) {
                if (beforeCreateErrorCallback != null) {
                    beforeCreateErrorCallback.run();
                }
                return PluginLoadingError.create(descriptor2, PluginManagerCore.message("plugin.loading.error.long.incompatible.until.build", descriptor2.getName(), descriptor2.getVersion(), untilBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.until.build", untilBuild));
            }
            return null;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            return PluginLoadingError.create(descriptor2, PluginManagerCore.message("plugin.loading.error.long.failed.to.load.requirements.for.ide.version", descriptor2.getName()), PluginManagerCore.message("plugin.loading.error.short.failed.to.load.requirements.for.ide.version", new Object[0]));
        }
    }

    private static void checkEssentialPluginsAreAvailable(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        List<PluginId> required = ApplicationInfoImpl.getShadowInstance().getEssentialPluginsIds();
        ArrayList<String> missing = null;
        for (PluginId id2 : required) {
            IdeaPluginDescriptorImpl descriptor2 = idMap.get(id2);
            if (descriptor2 != null && descriptor2.isEnabled()) continue;
            if (missing == null) {
                missing = new ArrayList<String>();
            }
            missing.add(id2.getIdString());
        }
        if (missing != null) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    @NotNull
    static PluginManagerState initializePlugins(@NotNull DescriptorListLoadingContext context, @NotNull ClassLoader coreLoader, boolean checkEssentialPlugins) {
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        PluginLoadingResult loadingResult = context.result;
        HashMap<PluginId, PluginLoadingError> pluginErrors = new HashMap<PluginId, PluginLoadingError>(loadingResult.getPluginErrors());
        @NotNull List<Supplier<String>> globalErrors = loadingResult.getGlobalErrors();
        if (loadingResult.duplicateModuleMap != null) {
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry : loadingResult.duplicateModuleMap.entrySet()) {
                globalErrors.add(() -> CoreBundle.message((String)"plugin.loading.error.module.declared.by.multiple.plugins", (Object[])new Object[]{entry.getKey(), ((List)entry.getValue()).stream().map(IdeaPluginDescriptorImpl::toString).collect(Collectors.joining("\n  "))}));
            }
        }
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = loadingResult.idMap;
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        if (checkEssentialPlugins && coreDescriptor == null) {
            throw new EssentialPluginMissingException(Collections.singletonList(CORE_ID + " (platform prefix: " + System.getProperty("idea.platform.prefix") + ")"));
        }
        List<IdeaPluginDescriptorImpl> descriptors2 = loadingResult.getEnabledPlugins();
        PluginManagerCore.disableIncompatiblePlugins(descriptors2, idMap, pluginErrors);
        PluginManagerCore.checkPluginCycles(descriptors2, idMap, globalErrors);
        IdeaPluginDescriptorImpl[] sortedRequired = PluginManagerCore.getTopologicallySorted(PluginManagerCore.createPluginIdGraph(descriptors2, idMap::get, false, idMap.containsKey(ALL_MODULES_MARKER)));
        LinkedHashSet<PluginId> enabledPluginIds = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> enabledModuleIds = new LinkedHashSet<PluginId>();
        LinkedHashMap<PluginId, String> disabledIds = new LinkedHashMap<PluginId, String>();
        LinkedHashSet<PluginId> disabledRequiredIds = new LinkedHashSet<PluginId>();
        for (IdeaPluginDescriptorImpl descriptor2 : sortedRequired) {
            boolean wasEnabled = descriptor2.isEnabled();
            if (wasEnabled && PluginManagerCore.computePluginEnabled(descriptor2, enabledPluginIds, enabledModuleIds, idMap, disabledRequiredIds, context.disabledPlugins, pluginErrors)) {
                enabledPluginIds.add(descriptor2.getPluginId());
                enabledModuleIds.addAll(descriptor2.getModules());
                continue;
            }
            descriptor2.setEnabled(false);
            if (!wasEnabled) continue;
            disabledIds.put(descriptor2.getPluginId(), descriptor2.getName());
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(disabledIds, disabledRequiredIds, idMap, pluginErrors, globalErrors);
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph2 = PluginManagerCore.createPluginIdGraph(Arrays.asList(sortedRequired), idMap::get, true, idMap.containsKey(ALL_MODULES_MARKER));
        IdeaPluginDescriptorImpl[] sortedAll = PluginManagerCore.getTopologicallySorted(graph2);
        List<IdeaPluginDescriptorImpl> enabledPlugins = PluginManagerCore.getOnlyEnabledPlugins(sortedAll);
        for (IdeaPluginDescriptorImpl plugin2 : enabledPlugins) {
            if (plugin2.pluginDependencies == null) continue;
            PluginManagerCore.checkOptionalDescriptors(plugin2.pluginDependencies, idMap);
        }
        Map<String, String[]> additionalLayoutMap = PluginManagerCore.loadAdditionalLayoutMap();
        ourAdditionalLayoutMap = additionalLayoutMap;
        ClassLoaderConfigurator classLoaderConfigurator = new ClassLoaderConfigurator(context.usePluginClassLoader, coreLoader, idMap, additionalLayoutMap);
        enabledPlugins.forEach(classLoaderConfigurator::configure);
        if (checkEssentialPlugins) {
            PluginManagerCore.checkEssentialPluginsAreAvailable(idMap);
        }
        HashSet<PluginId> effectiveDisabledIds = disabledIds.isEmpty() ? Collections.emptySet() : new HashSet<PluginId>(disabledIds.keySet());
        return new PluginManagerState(sortedAll, enabledPlugins, disabledRequiredIds, effectiveDisabledIds, idMap);
    }

    private static void checkOptionalDescriptors(@NotNull List<PluginDependency> pluginDependencies, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (pluginDependencies == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        for (PluginDependency dependency : pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor = dependency.subDescriptor;
            if (subDescriptor == null || dependency.isDisabledOrBroken) continue;
            IdeaPluginDescriptorImpl dependencyDescriptor = idMap.get(dependency.id);
            if (dependencyDescriptor == null || !dependencyDescriptor.isEnabled()) {
                dependency.isDisabledOrBroken = true;
                continue;
            }
            List<PluginDependency> childDependencies = subDescriptor.pluginDependencies;
            if (childDependencies == null || PluginManagerCore.checkChildDeps(childDependencies, idMap)) continue;
            dependency.isDisabledOrBroken = true;
        }
    }

    private static boolean checkChildDeps(@NotNull List<PluginDependency> childDependencies, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (childDependencies == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        for (PluginDependency dependency : childDependencies) {
            List<PluginDependency> list2;
            if (dependency.isDisabledOrBroken) {
                if (dependency.isOptional) continue;
                return false;
            }
            IdeaPluginDescriptorImpl dependentDescriptor = idMap.get(dependency.id);
            if (dependentDescriptor == null || !dependentDescriptor.isEnabled()) {
                dependency.isDisabledOrBroken = true;
                if (dependency.isOptional) continue;
                return false;
            }
            if (dependency.subDescriptor == null || (list2 = dependency.subDescriptor.pluginDependencies) == null || PluginManagerCore.checkChildDeps(list2, idMap)) continue;
            dependency.isDisabledOrBroken = true;
            if (dependency.isOptional) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static @NotNull IdeaPluginDescriptorImpl @NotNull [] getTopologicallySorted(@NotNull InboundSemiGraph<IdeaPluginDescriptorImpl> graph2) {
        if (graph2 == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        DFSTBuilder requiredOnlyGraph = new DFSTBuilder(GraphGenerator.generate(graph2));
        IdeaPluginDescriptorImpl[] sortedRequired = graph2.getNodes().toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        Comparator comparator2 = requiredOnlyGraph.comparator();
        Arrays.sort(sortedRequired, (o1, o2) -> {
            if (o1.getPluginId() == CORE_ID) {
                return -1;
            }
            if (o2.getPluginId() == CORE_ID) {
                return 1;
            }
            return comparator2.compare(o1, o2);
        });
        if (sortedRequired == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        return sortedRequired;
    }

    @NotNull
    static @NotNull IdeaPluginDescriptorImpl @NotNull [] getPluginsSortedByDependency(@NotNull List<IdeaPluginDescriptorImpl> descriptors2) {
        if (descriptors2 == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph2 = PluginManagerCore.createPluginIdGraph(descriptors2, id2 -> (IdeaPluginDescriptorImpl)PluginManagerCore.getPlugin(id2), true, PluginManagerCore.findPluginByModuleDependency(ALL_MODULES_MARKER) != null);
        return PluginManagerCore.getTopologicallySorted(graph2);
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap(@NotNull List<IdeaPluginDescriptorImpl> descriptors2) {
        if (descriptors2 == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        LinkedHashMap<PluginId, IdeaPluginDescriptorImpl> idMap = new LinkedHashMap<PluginId, IdeaPluginDescriptorImpl>(descriptors2.size());
        Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap = null;
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors2) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, descriptor2.getPluginId(), idMap, duplicateMap);
            if (newDuplicateMap != null) {
                duplicateMap = newDuplicateMap;
                continue;
            }
            for (PluginId module : descriptor2.getModules()) {
                newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, module, idMap, duplicateMap);
                if (newDuplicateMap == null) continue;
                duplicateMap = newDuplicateMap;
            }
        }
        LinkedHashMap<PluginId, IdeaPluginDescriptorImpl> linkedHashMap = idMap;
        if (linkedHashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        return linkedHashMap;
    }

    @Nullable
    private static Map<PluginId, List<IdeaPluginDescriptorImpl>> checkAndPut(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginId id2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @Nullable Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap) {
        List<IdeaPluginDescriptorImpl> duplicates;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        if (duplicateMap != null && (duplicates = duplicateMap.get(id2)) != null) {
            duplicates.add(descriptor2);
            return duplicateMap;
        }
        IdeaPluginDescriptorImpl existingDescriptor = idMap.put(id2, descriptor2);
        if (existingDescriptor == null) {
            return null;
        }
        idMap.remove(id2);
        if (duplicateMap == null) {
            duplicateMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list2 = new ArrayList<IdeaPluginDescriptorImpl>();
        list2.add(existingDescriptor);
        list2.add(descriptor2);
        duplicateMap.put(id2, list2);
        return duplicateMap;
    }

    private static boolean computePluginEnabled(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Set<PluginId> loadedPluginIds, @NotNull Set<PluginId> loadedModuleIds, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<? super PluginId> disabledRequiredIds, @NotNull Set<PluginId> disabledPlugins, @NotNull Map<PluginId, PluginLoadingError> errors) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        if (loadedPluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        if (loadedModuleIds == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(94);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        if (descriptor2.getPluginId() == CORE_ID) {
            return true;
        }
        boolean notifyUser = !descriptor2.isImplementationDetail();
        boolean result2 = true;
        for (PluginId pluginId : descriptor2.incompatibilities == null ? Collections.emptyList() : descriptor2.incompatibilities) {
            if (!loadedModuleIds.contains(pluginId) || disabledPlugins.contains(pluginId)) continue;
            result2 = false;
            String presentableName = pluginId.getIdString();
            PluginLoadingError.create(descriptor2, PluginManagerCore.message("plugin.loading.error.long.ide.contains.conflicting.module", descriptor2.getName(), presentableName), PluginManagerCore.message("plugin.loading.error.short.ide.contains.conflicting.module", presentableName), notifyUser).register(errors);
        }
        if (descriptor2.pluginDependencies == null) {
            return result2;
        }
        for (PluginDependency pluginDependency : descriptor2.pluginDependencies) {
            String depName;
            PluginId depId = pluginDependency.id;
            if (pluginDependency.isOptional || loadedPluginIds.contains(depId) || loadedModuleIds.contains(depId)) continue;
            result2 = false;
            IdeaPluginDescriptor dep = idMap.get(depId);
            if (dep != null && disabledPlugins.contains(depId)) {
                disabledRequiredIds.add((PluginId)dep.getPluginId());
            }
            String string = depName = dep == null ? null : dep.getName();
            if (depName == null) {
                @NlsSafe String depPresentableId = depId.getIdString();
                if (errors.containsKey(depId)) {
                    PluginLoadingError.create(descriptor2, PluginManagerCore.message("plugin.loading.error.long.depends.on.failed.to.load.plugin", descriptor2.getName(), depPresentableId), PluginManagerCore.message("plugin.loading.error.short.depends.on.failed.to.load.plugin", depPresentableId), notifyUser).register(errors);
                    continue;
                }
                PluginLoadingError.create(descriptor2, PluginManagerCore.message("plugin.loading.error.long.depends.on.not.installed.plugin", descriptor2.getName(), depPresentableId), PluginManagerCore.message("plugin.loading.error.short.depends.on.not.installed.plugin", depPresentableId), notifyUser).register(errors);
                continue;
            }
            PluginLoadingError error = PluginLoadingError.create(descriptor2, PluginManagerCore.message("plugin.loading.error.long.depends.on.disabled.plugin", descriptor2.getName(), depName), PluginManagerCore.message("plugin.loading.error.short.depends.on.disabled.plugin", depName), notifyUser);
            error.setDisabledDependency(dep.getPluginId());
            error.register(errors);
        }
        return result2;
    }

    @NotNull
    @Nls
    private static Supplier<String> message(final @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") String key, final Object ... params) {
        if (key == null) {
            PluginManagerCore.$$$reportNull$$$0(96);
        }
        if (params == null) {
            PluginManagerCore.$$$reportNull$$$0(97);
        }
        return new Supplier<String>(){

            @Override
            public String get() {
                return CoreBundle.message((String)key, (Object[])params);
            }
        };
    }

    public static void registerExtensionPointAndExtensions(@NotNull Path pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor2;
        if (pluginRoot == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(99);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        DescriptorListLoadingContext parentContext = DescriptorListLoadingContext.createSingleDescriptorContext(DisabledPluginsState.disabledPlugins());
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, true, true, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            descriptor2 = Files.isDirectory(pluginRoot, new LinkOption[0]) ? PluginDescriptorLoader.loadDescriptorFromDir(pluginRoot, META_INF + fileName, null, context) : PluginDescriptorLoader.loadDescriptorFromJar(pluginRoot, fileName, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER, context, null);
        }
        if (descriptor2 == null) {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
            return;
        }
        List<ExtensionPointImpl<?>> extensionPoints = descriptor2.appContainerDescriptor.extensionPoints;
        if (extensionPoints != null) {
            ((ExtensionsAreaImpl)area).registerExtensionPoints(extensionPoints, false);
        }
        descriptor2.registerExtensions((ExtensionsAreaImpl)area, descriptor2.appContainerDescriptor, null);
    }

    private static synchronized void loadAndInitializePlugins(@Nullable DescriptorListLoadingContext context, @Nullable ClassLoader coreLoader) {
        if (coreLoader == null) {
            Class callerClass = ReflectionUtil.findCallerClass((int)1);
            assert (callerClass != null);
            coreLoader = callerClass.getClassLoader();
        }
        try {
            if (context == null) {
                context = PluginDescriptorLoader.loadDescriptors();
            }
            Activity activity = StartUpMeasurer.startActivity((String)"plugin initialization");
            PluginManagerState initResult = PluginManagerCore.initializePlugins(context, coreLoader, !isUnitTestMode);
            ourPlugins = initResult.sortedPlugins;
            PluginLoadingResult result2 = context.result;
            if (!result2.incompletePlugins.isEmpty()) {
                int oldSize = initResult.sortedPlugins.length;
                Object[] all = Arrays.copyOf(initResult.sortedPlugins, oldSize + result2.incompletePlugins.size());
                ArrayUtil.copy(result2.incompletePlugins.values(), (Object[])all, (int)oldSize);
                ourPlugins = all;
            }
            ourPluginsToDisable = initResult.effectiveDisabledIds;
            ourPluginsToEnable = initResult.disabledRequiredIds;
            ourLoadedPlugins = initResult.sortedEnabledPlugins;
            ourShadowedBundledPlugins = result2.getShadowedBundledIds();
            activity.end();
            activity.setDescription("plugin count: " + ourLoadedPlugins.size());
            PluginManagerCore.logPlugins(initResult.sortedPlugins, result2.incompletePlugins.values());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            throw e;
        }
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        return logger;
    }

    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id2) {
        if (id2 != null) {
            for (IdeaPluginDescriptor plugin2 : PluginManagerCore.getPlugins()) {
                if (id2 != plugin2.getPluginId()) continue;
                return plugin2;
            }
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptor findPluginByModuleDependency(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        for (IdeaPluginDescriptorImpl descriptor2 : ourPlugins) {
            if (!descriptor2.getModules().contains(id2)) continue;
            return descriptor2;
        }
        return null;
    }

    public static boolean isPluginInstalled(PluginId id2) {
        return PluginManagerCore.getPlugin(id2) != null;
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        return PluginManagerCore.buildPluginIdMap(Arrays.asList(ourPlugins));
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Function<? super IdeaPluginDescriptor, FileVisitResult> consumer2) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(103);
        }
        if (consumer2 == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, PluginManagerCore.buildPluginIdMap(), consumer2);
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Function<? super IdeaPluginDescriptor, FileVisitResult> consumer2) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(106);
        }
        if (consumer2 == null) {
            PluginManagerCore.$$$reportNull$$$0(107);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, idToMap, new HashSet(), (id2, descriptor2) -> descriptor2 != null ? (FileVisitResult)((Object)((Object)consumer2.apply((IdeaPluginDescriptor)descriptor2))) : FileVisitResult.SKIP_SUBTREE);
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull @NotNull BiFunction<? super @NotNull PluginId, ? super @Nullable IdeaPluginDescriptor, FileVisitResult> consumer2) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(108);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(109);
        }
        if (consumer2 == null) {
            PluginManagerCore.$$$reportNull$$$0(110);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, idToMap, new HashSet(), consumer2);
    }

    @ApiStatus.Internal
    private static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Set<? super IdeaPluginDescriptor> depProcessed, @NotNull BiFunction<? super PluginId, ? super IdeaPluginDescriptorImpl, FileVisitResult> consumer2) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(111);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(112);
        }
        if (depProcessed == null) {
            PluginManagerCore.$$$reportNull$$$0(113);
        }
        if (consumer2 == null) {
            PluginManagerCore.$$$reportNull$$$0(114);
        }
        if (rootDescriptor.pluginDependencies == null) {
            return true;
        }
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            if (!withOptionalDeps && dependency.isOptional) continue;
            IdeaPluginDescriptorImpl descriptor2 = idToMap.get(dependency.id);
            PluginId pluginId = descriptor2 == null ? dependency.id : descriptor2.getPluginId();
            switch (consumer2.apply((PluginId)pluginId, descriptor2)) {
                case TERMINATE: {
                    return false;
                }
                case CONTINUE: {
                    if (descriptor2 == null || !depProcessed.add(descriptor2)) break;
                    PluginManagerCore.processAllDependencies(descriptor2, withOptionalDeps, idToMap, depProcessed, consumer2);
                    break;
                }
                case SKIP_SUBTREE: {
                    break;
                }
                case SKIP_SIBLINGS: {
                    throw new UnsupportedOperationException("FileVisitResult.SKIP_SIBLINGS is not supported");
                }
            }
        }
        return true;
    }

    @NotNull
    private static List<IdeaPluginDescriptorImpl> getOnlyEnabledPlugins(@NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] sortedAll) {
        if (sortedAll == null) {
            PluginManagerCore.$$$reportNull$$$0(115);
        }
        ArrayList<IdeaPluginDescriptorImpl> enabledPlugins = new ArrayList<IdeaPluginDescriptorImpl>(sortedAll.length);
        for (IdeaPluginDescriptorImpl descriptor2 : sortedAll) {
            if (!descriptor2.isEnabled()) continue;
            enabledPlugins.add(descriptor2);
        }
        ArrayList<IdeaPluginDescriptorImpl> arrayList = enabledPlugins;
        if (arrayList == null) {
            PluginManagerCore.$$$reportNull$$$0(116);
        }
        return arrayList;
    }

    public static synchronized boolean isUpdatedBundledPlugin(@NotNull PluginDescriptor plugin2) {
        if (plugin2 == null) {
            PluginManagerCore.$$$reportNull$$$0(117);
        }
        return ourShadowedBundledPlugins != null && ourShadowedBundledPlugins.contains(plugin2.getPluginId());
    }

    @Deprecated
    public static boolean isDisabled(@NotNull String pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(118);
        }
        return PluginManagerCore.isDisabled(PluginId.getId((String)pluginId));
    }

    @Deprecated
    public static boolean disablePlugin(@NotNull String id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(119);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId((String)id2));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean enablePlugin(@NotNull String id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(120);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId((String)id2));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public static void addDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManagerCore.$$$reportNull$$$0(121);
        }
        DisabledPluginsState.addDisablePluginListener(listener2);
    }

    private static /* synthetic */ HtmlChunk lambda$prepareLoadingPluginsErrorMessage$1(Supplier message2) {
        return HtmlChunk.text((String)((String)message2.get()));
    }

    static {
        ourAdditionalLayoutMap = Collections.emptyMap();
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        usePluginClassLoader = Boolean.getBoolean("idea.from.sources.plugins.class.loader");
        ourPluginErrors = new ArrayList<Supplier<? extends HtmlChunk>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 3: 
            case 8: 
            case 26: 
            case 28: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 16: 
            case 17: 
            case 87: 
            case 102: 
            case 119: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 25: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDepGetter";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 30: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginErrors";
                break;
            }
            case 31: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalErrors";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 33: 
            case 34: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 35: 
            case 43: 
            case 63: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 36: 
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptorMap";
                break;
            }
            case 37: 
            case 103: 
            case 105: 
            case 108: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDep";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueCheck";
                break;
            }
            case 45: 
            case 65: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 48: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 49: 
            case 64: 
            case 74: 
            case 78: 
            case 80: 
            case 88: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreClassLoader";
                break;
            }
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideBuildNumber";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDependencies";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childDependencies";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPluginIds";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedModuleIds";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 104: 
            case 107: 
            case 110: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 106: 
            case 109: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToMap";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedAll";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPlugins";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearPluginLoadingErrors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readBrokenPluginFile";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectDependencies";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScheduleLoading";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAdditionalLayoutMap";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopologicallySorted";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnlyEnabledPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasDescriptorByIdentity";
                break;
            }
            case 7: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 16: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 17: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitDependency";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getShortLoadingErrorMessage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFirstDisabledDependency";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createPluginIdGraph";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDirectDependencies";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "checkPluginCycles";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorsToMigrate";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "initPlugins";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createClassLoaderConfiguratorForDynamicPlugin";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "checkBuildNumberCompatibility";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "checkOptionalDescriptors";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "checkChildDeps";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getTopologicallySorted";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsSortedByDependency";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "buildPluginIdMap";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "computePluginEnabled";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "processAllDependencies";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyEnabledPlugins";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 57: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EssentialPluginMissingException
    extends RuntimeException {
        public final List<String> pluginIds;

        EssentialPluginMissingException(@NotNull List<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + String.join((CharSequence)", ", ids));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }
}

