/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.VersionComparatorUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class PluginLoadingResult {
    private final Map<PluginId, Set<String>> brokenPluginVersions;
    @NotNull
    final Supplier<BuildNumber> productBuildNumber;
    final Map<PluginId, IdeaPluginDescriptorImpl> incompletePlugins;
    private final Map<PluginId, IdeaPluginDescriptorImpl> plugins;
    final Map<PluginId, IdeaPluginDescriptorImpl> idMap;
    @Nullable
    Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateModuleMap;
    private final Map<PluginId, PluginLoadingError> pluginErrors;
    private final List<Supplier<@NlsContexts.DetailedDescription String>> globalErrors;
    private final Set<PluginId> shadowedBundledIds;
    private final boolean checkModuleDependencies;
    private List<IdeaPluginDescriptorImpl> enabledPlugins;

    @NotNull
    List<IdeaPluginDescriptorImpl> getEnabledPlugins() {
        List<IdeaPluginDescriptorImpl> list2 = this.enabledPlugins;
        if (list2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(0);
        }
        return list2;
    }

    PluginLoadingResult(@NotNull Map<PluginId, Set<String>> brokenPluginVersions, @NotNull Supplier<BuildNumber> productBuildNumber) {
        if (brokenPluginVersions == null) {
            PluginLoadingResult.$$$reportNull$$$0(1);
        }
        if (productBuildNumber == null) {
            PluginLoadingResult.$$$reportNull$$$0(2);
        }
        this(brokenPluginVersions, productBuildNumber, !PlatformUtils.isIntelliJ());
    }

    PluginLoadingResult(@NotNull Map<PluginId, Set<String>> brokenPluginVersions, @NotNull Supplier<BuildNumber> productBuildNumber, boolean checkModuleDependencies) {
        if (brokenPluginVersions == null) {
            PluginLoadingResult.$$$reportNull$$$0(3);
        }
        if (productBuildNumber == null) {
            PluginLoadingResult.$$$reportNull$$$0(4);
        }
        this.incompletePlugins = new ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl>();
        this.plugins = new HashMap<PluginId, IdeaPluginDescriptorImpl>();
        this.idMap = new ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl>();
        this.pluginErrors = new ConcurrentHashMap<PluginId, PluginLoadingError>();
        this.globalErrors = Collections.synchronizedList(new ArrayList());
        this.shadowedBundledIds = new HashSet<PluginId>();
        this.brokenPluginVersions = brokenPluginVersions;
        this.productBuildNumber = productBuildNumber;
        this.checkModuleDependencies = checkModuleDependencies;
    }

    int enabledPluginCount() {
        return this.plugins.size();
    }

    void finishLoading() {
        IdeaPluginDescriptorImpl[] enabledPlugins = this.plugins.values().toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        this.plugins.clear();
        Arrays.sort(enabledPlugins, Comparator.comparing(IdeaPluginDescriptorImpl::getPluginId));
        this.enabledPlugins = Arrays.asList(enabledPlugins);
    }

    boolean isBroken(@NotNull PluginId id2) {
        Set<String> set2;
        if (id2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(5);
        }
        if ((set2 = this.brokenPluginVersions.get(id2)) == null) {
            return false;
        }
        IdeaPluginDescriptorImpl descriptor2 = this.idMap.get(id2);
        return descriptor2 != null && set2.contains(descriptor2.getVersion());
    }

    @NotNull
    Map<PluginId, PluginLoadingError> getPluginErrors() {
        Map<PluginId, PluginLoadingError> map2 = Collections.unmodifiableMap(this.pluginErrors);
        if (map2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(6);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Supplier<@NlsContexts.DetailedDescription String>> getGlobalErrors() {
        List<Supplier<String>> list2 = this.globalErrors;
        synchronized (list2) {
            return new ArrayList<Supplier<String>>(this.globalErrors);
        }
    }

    void addIncompletePlugin(@NotNull IdeaPluginDescriptorImpl plugin2, @Nullable PluginLoadingError error) {
        if (plugin2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(7);
        }
        if (!this.idMap.containsKey(plugin2.getPluginId())) {
            this.incompletePlugins.put(plugin2.getPluginId(), plugin2);
        }
        if (error != null) {
            this.pluginErrors.put(plugin2.getPluginId(), error);
        }
    }

    void reportIncompatiblePlugin(@NotNull IdeaPluginDescriptorImpl plugin2, @NotNull PluginLoadingError error) {
        if (plugin2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(8);
        }
        if (error == null) {
            PluginLoadingResult.$$$reportNull$$$0(9);
        }
        if (this.idMap.containsKey(plugin2.getPluginId())) {
            return;
        }
        error.register(this.pluginErrors);
    }

    void reportCannotLoad(@NotNull Path file2, Exception e) {
        if (file2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(10);
        }
        DescriptorListLoadingContext.LOG.warn("Cannot load " + file2, (Throwable)e);
        this.globalErrors.add(() -> CoreBundle.message((String)"plugin.loading.error.text.file.contains.invalid.plugin.descriptor", (Object[])new Object[]{FileUtil.getLocationRelativeToUserHome((String)file2.toString(), (boolean)false)}));
    }

    boolean add(@NotNull IdeaPluginDescriptorImpl descriptor2, boolean overrideUseIfCompatible) {
        PluginId pluginId;
        if (descriptor2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(11);
        }
        if ((pluginId = descriptor2.getPluginId()) == null) {
            PluginManagerCore.getLogger().warn("No id is provided by \"" + descriptor2.getPluginPath().getFileName().toString() + "\"");
            return true;
        }
        if (descriptor2.incomplete) {
            return true;
        }
        if (!descriptor2.isBundled() && this.checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor2)) {
            PluginLoadingError.create(descriptor2, () -> CoreBundle.message((String)"plugin.loading.error.long.compatible.with.intellij.idea.only", (Object[])new Object[]{descriptor2.getName()}), () -> CoreBundle.message((String)"plugin.loading.error.short.compatible.with.intellij.idea.only", (Object[])new Object[0])).register(this.pluginErrors);
            return false;
        }
        this.pluginErrors.remove(pluginId);
        this.incompletePlugins.remove(pluginId);
        IdeaPluginDescriptorImpl prevDescriptor = this.plugins.put(pluginId, descriptor2);
        if (prevDescriptor == null) {
            this.idMap.put(pluginId, descriptor2);
            for (PluginId module : descriptor2.getModules()) {
                this.checkAndAdd(descriptor2, module);
            }
            return true;
        }
        if (prevDescriptor.isBundled() || descriptor2.isBundled()) {
            this.shadowedBundledIds.add(pluginId);
        }
        if (this.isCompatible(descriptor2) && (overrideUseIfCompatible || VersionComparatorUtil.compare((String)descriptor2.getVersion(), (String)prevDescriptor.getVersion()) > 0)) {
            PluginManagerCore.getLogger().info(descriptor2.getPluginPath() + " overrides " + prevDescriptor.getPluginPath());
            this.idMap.put(pluginId, descriptor2);
            return true;
        }
        this.plugins.put(pluginId, prevDescriptor);
        return false;
    }

    private boolean isCompatible(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(12);
        }
        return PluginManagerCore.checkBuildNumberCompatibility(descriptor2, this.productBuildNumber.get()) == null;
    }

    private void checkAndAdd(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginId id2) {
        List<IdeaPluginDescriptorImpl> duplicates;
        if (descriptor2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(13);
        }
        if (id2 == null) {
            PluginLoadingResult.$$$reportNull$$$0(14);
        }
        if (this.duplicateModuleMap != null && (duplicates = this.duplicateModuleMap.get(id2)) != null) {
            duplicates.add(descriptor2);
            return;
        }
        IdeaPluginDescriptorImpl existingDescriptor = this.idMap.put(id2, descriptor2);
        if (existingDescriptor == null) {
            return;
        }
        this.idMap.remove(id2);
        if (this.duplicateModuleMap == null) {
            this.duplicateModuleMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list2 = new ArrayList<IdeaPluginDescriptorImpl>();
        list2.add(existingDescriptor);
        list2.add(descriptor2);
        this.duplicateModuleMap.put(id2, list2);
    }

    Set<PluginId> getShadowedBundledIds() {
        return this.shadowedBundledIds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginLoadingResult";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenPluginVersions";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productBuildNumber";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPlugins";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginLoadingResult";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginErrors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBroken";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addIncompletePlugin";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportIncompatiblePlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportCannotLoad";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkAndAdd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

