/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.core.CoreBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.CustomPluginRepositoryService;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.PluginSignatureChecker;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginInstaller {
    private static final Logger LOG = Logger.getInstance(PluginInstaller.class);
    public static final String UNKNOWN_HOST_MARKER = "__unknown_repository__";
    static final Object ourLock = new Object();
    private static final String PLUGINS_PRESELECTION_PATH = "plugins.preselection.path";

    private PluginInstaller() {
    }

    public static boolean prepareToInstall(List<PluginNode> pluginsToInstall, List<? extends IdeaPluginDescriptor> customOrAllPlugins, boolean allowInstallWithoutRestart, PluginManagerMain.PluginEnabler pluginEnabler, Runnable onSuccess2, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PluginInstaller.$$$reportNull$$$0(0);
        }
        PluginInstallOperation operation2 = new PluginInstallOperation(pluginsToInstall, customOrAllPlugins, pluginEnabler, indicator);
        operation2.setAllowInstallWithoutRestart(allowInstallWithoutRestart);
        operation2.run();
        boolean success2 = operation2.isSuccess();
        if (success2) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (allowInstallWithoutRestart) {
                    for (PendingDynamicPluginInstall install : operation2.getPendingDynamicPluginInstalls()) {
                        PluginInstaller.installAndLoadDynamicPlugin(install.getFile(), null, install.getPluginDescriptor());
                    }
                }
                if (onSuccess2 != null) {
                    onSuccess2.run();
                }
            });
        }
        return success2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean prepareToUninstall(@NotNull IdeaPluginDescriptor pluginDescriptor) throws IOException {
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(1);
        }
        Object object = ourLock;
        synchronized (object) {
            if (PluginManagerCore.isPluginInstalled(pluginDescriptor.getPluginId())) {
                if (pluginDescriptor.isBundled()) {
                    LOG.error("Plugin is bundled: " + pluginDescriptor.getPluginId());
                } else {
                    boolean needRestart;
                    boolean bl = needRestart = !DynamicPlugins.allowLoadUnloadWithoutRestart((IdeaPluginDescriptorImpl)pluginDescriptor);
                    if (needRestart) {
                        PluginInstaller.uninstallAfterRestart(pluginDescriptor);
                    }
                    PluginStateManager.fireState(pluginDescriptor, false);
                    return needRestart;
                }
            }
        }
        return false;
    }

    private static void uninstallAfterRestart(IdeaPluginDescriptor pluginDescriptor) throws IOException {
        StartupActionScriptManager.addActionCommands(Collections.singletonList(new StartupActionScriptManager.DeleteCommand(pluginDescriptor.getPluginPath())));
    }

    public static boolean uninstallDynamicPlugin(@Nullable JComponent parentComponent, @NotNull IdeaPluginDescriptorImpl pluginDescriptor, boolean isUpdate) {
        boolean uninstalledWithoutRestart;
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(2);
        }
        DynamicPlugins.UnloadPluginOptions options2 = new DynamicPlugins.UnloadPluginOptions().withUpdate(isUpdate).withWaitForClassloaderUnload(true);
        boolean bl = uninstalledWithoutRestart = parentComponent != null ? DynamicPlugins.unloadPluginWithProgress(null, parentComponent, pluginDescriptor, options2) : DynamicPlugins.unloadPlugin(pluginDescriptor, options2);
        if (uninstalledWithoutRestart) {
            try {
                FileUtil.delete((Path)pluginDescriptor.getPluginPath());
            }
            catch (IOException e) {
                LOG.info("Failed to delete jar of dynamic plugin", (Throwable)e);
                uninstalledWithoutRestart = false;
            }
        }
        if (!uninstalledWithoutRestart) {
            try {
                PluginInstaller.uninstallAfterRestart(pluginDescriptor);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return uninstalledWithoutRestart;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public static void installAfterRestart(@NotNull File sourceFile, boolean deleteSourceFile, @Nullable File existingPlugin, @NotNull IdeaPluginDescriptor descriptor2) throws IOException {
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            PluginInstaller.$$$reportNull$$$0(4);
        }
    }

    public static void installAfterRestart(@NotNull Path sourceFile, boolean deleteSourceFile, @Nullable Path existingPlugin, @NotNull IdeaPluginDescriptor descriptor2) throws IOException {
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            PluginInstaller.$$$reportNull$$$0(6);
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        if (existingPlugin != null) {
            commands.add(new StartupActionScriptManager.DeleteCommand(existingPlugin));
        }
        Path pluginsPath = Paths.get(PathManager.getPluginsPath(), new String[0]);
        if (sourceFile.getFileName().toString().endsWith(".jar")) {
            commands.add(new StartupActionScriptManager.CopyCommand(sourceFile, pluginsPath.resolve(sourceFile.getFileName())));
        } else {
            commands.add(new StartupActionScriptManager.DeleteCommand(pluginsPath.resolve(PluginInstaller.rootEntryName(sourceFile))));
            commands.add(new StartupActionScriptManager.UnzipCommand(sourceFile, pluginsPath));
        }
        if (deleteSourceFile) {
            commands.add(new StartupActionScriptManager.DeleteCommand(sourceFile));
        }
        StartupActionScriptManager.addActionCommands(commands);
        PluginStateManager.fireState(descriptor2, true);
    }

    @Nullable
    private static Path installWithoutRestart(@NotNull Path sourceFile, IdeaPluginDescriptorImpl descriptor2, Component parent) {
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(7);
        }
        Ref ref = new Ref();
        Ref refTarget = new Ref();
        String pluginName = descriptor2.getName();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                refTarget.set((Object)PluginInstaller.unpackPlugin(sourceFile, Paths.get(PathManager.getPluginsPath(), new String[0])));
            }
            catch (Throwable e) {
                LOG.warn("Plugin " + descriptor2 + " failed to install without restart. " + e.getMessage(), e);
                ref.set((Object)e);
            }
        }, IdeBundle.message((String)"progress.title.installing.plugin", (Object[])new Object[]{pluginName}), false, null, parent instanceof JComponent ? (JComponent)parent : null);
        Throwable exception = (Throwable)ref.get();
        PluginStateManager.fireState(descriptor2, true);
        return exception != null ? null : (Path)refTarget.get();
    }

    @NotNull
    public static Path unpackPlugin(@NotNull Path sourceFile, @NotNull Path targetPath) throws IOException {
        Path target2;
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(8);
        }
        if (targetPath == null) {
            PluginInstaller.$$$reportNull$$$0(9);
        }
        if (sourceFile.getFileName().toString().endsWith(".jar")) {
            target2 = targetPath.resolve(sourceFile.getFileName());
            FileUtilRt.copy((File)sourceFile.toFile(), (File)target2.toFile());
        } else {
            target2 = targetPath.resolve(PluginInstaller.rootEntryName(sourceFile));
            FileUtilRt.delete((File)target2.toFile());
            new Decompressor.Zip(sourceFile).extract(targetPath);
        }
        Path path = target2;
        if (path == null) {
            PluginInstaller.$$$reportNull$$$0(10);
        }
        return path;
    }

    public static String rootEntryName(@NotNull Path zip) throws IOException {
        if (zip == null) {
            PluginInstaller.$$$reportNull$$$0(11);
        }
        try (ZipFile zipFile = new ZipFile(zip.toFile());){
            Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
            while (entries2.hasMoreElements()) {
                ZipEntry zipEntry = entries2.nextElement();
                String name = zipEntry.getName();
                int i2 = name.indexOf(47);
                if (i2 <= 0) continue;
                String string = name.substring(0, i2);
                return string;
            }
        }
        throw new IOException("Corrupted archive (no file entries): " + zip);
    }

    public static void addStateListener(@NotNull PluginStateListener listener2) {
        if (listener2 == null) {
            PluginInstaller.$$$reportNull$$$0(12);
        }
        PluginStateManager.addStateListener(listener2);
    }

    public static boolean installFromDisk(@NotNull InstalledPluginsTableModel model2, @NotNull Path file2, @NotNull Consumer<? super PluginInstallCallbackData> callback2, @Nullable Component parent) {
        if (model2 == null) {
            PluginInstaller.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(14);
        }
        if (callback2 == null) {
            PluginInstaller.$$$reportNull$$$0(15);
        }
        try {
            boolean installWithoutRestart;
            IdeaPluginDescriptorImpl pluginDescriptor = PluginDescriptorLoader.loadDescriptorFromArtifact(file2, null);
            if (pluginDescriptor == null) {
                MessagesEx.showErrorDialog(parent, IdeBundle.message((String)"dialog.message.fail.to.load.plugin.descriptor.from.file", (Object[])new Object[]{file2.getFileName().toString()}), CommonBundle.getErrorTitle());
                return false;
            }
            if (Registry.is((String)"marketplace.certificate.signature.check") && !PluginSignatureChecker.isSignedByAnyCertificates(pluginDescriptor.name, file2.toFile())) {
                return false;
            }
            InstalledPluginsState ourState = InstalledPluginsState.getInstance();
            if (ourState.wasInstalled(pluginDescriptor.getPluginId())) {
                String message2 = IdeBundle.message((String)"dialog.message.plugin.was.already.installed", (Object[])new Object[]{pluginDescriptor.getName()});
                MessagesEx.showWarningDialog(parent, message2, IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]));
                return false;
            }
            PluginLoadingError error = PluginManagerCore.checkBuildNumberCompatibility(pluginDescriptor, PluginManagerCore.getBuildNumber());
            if (error != null) {
                MessagesEx.showErrorDialog(parent, error.getDetailedMessage(), CommonBundle.getErrorTitle());
                return false;
            }
            if (PluginManagerCore.isBrokenPlugin(pluginDescriptor)) {
                String message3 = CoreBundle.message((String)"plugin.loading.error.long.marked.as.broken", (Object[])new Object[]{pluginDescriptor.getName(), pluginDescriptor.getVersion()});
                MessagesEx.showErrorDialog(parent, message3, CommonBundle.getErrorTitle());
                return false;
            }
            IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(pluginDescriptor.getPluginId());
            if (installedPlugin != null && ApplicationInfoEx.getInstanceEx().isEssentialPlugin(installedPlugin.getPluginId())) {
                String message4 = IdeBundle.message((String)"dialog.message.plugin.core.part", (Object[])new Object[]{pluginDescriptor.getName(), ApplicationNamesInfo.getInstance().getFullProductName()});
                MessagesEx.showErrorDialog(parent, message4, CommonBundle.getErrorTitle());
                return false;
            }
            PluginManagerMain.PluginEnabler pluginEnabler = model2 instanceof PluginManagerMain.PluginEnabler ? (PluginManagerMain.PluginEnabler)((Object)model2) : new PluginManagerMain.PluginEnabler.HEADLESS();
            Ref cancel = Ref.create((Object)false);
            Ref toDisable = new Ref();
            Ref dependenciesRequireRestart = Ref.create((Object)false);
            HashSet installedDependencies = new HashSet();
            boolean success2 = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                PluginInstallOperation dependencyInstallOperation = new PluginInstallOperation(Collections.emptyList(), CustomPluginRepositoryService.getInstance().getCustomRepositoryPlugins(), pluginEnabler, ProgressManager.getInstance().getProgressIndicator());
                dependencyInstallOperation.setAllowInstallWithoutRestart(true);
                Ref<IdeaPluginDescriptor> ref = dependencyInstallOperation.checkDependenciesAndReplacements(pluginDescriptor, null);
                if (ref == null) {
                    cancel.set((Object)true);
                } else {
                    dependenciesRequireRestart.set((Object)dependencyInstallOperation.isRestartRequired());
                    installedDependencies.addAll(dependencyInstallOperation.getInstalledDependentPlugins());
                    toDisable.set((Object)((IdeaPluginDescriptor)ref.get()));
                }
            }, IdeBundle.message((String)"progress.title.checking.plugin.dependencies", (Object[])new Object[0]), true, null, (JComponent)parent);
            if (!success2 || ((Boolean)cancel.get()).booleanValue()) {
                return false;
            }
            Path oldFile = null;
            if (installedPlugin != null && !installedPlugin.isBundled()) {
                oldFile = installedPlugin.getPluginPath();
            }
            boolean bl = installWithoutRestart = oldFile == null && DynamicPlugins.allowLoadUnloadWithoutRestart(pluginDescriptor) && (Boolean)dependenciesRequireRestart.get() == false;
            if (!installWithoutRestart) {
                PluginInstaller.installAfterRestart(file2, false, oldFile, (IdeaPluginDescriptor)pluginDescriptor);
            }
            ourState.onPluginInstall(pluginDescriptor, installedPlugin != null, !installWithoutRestart);
            if (!toDisable.isNull()) {
                pluginEnabler.disablePlugins(Collections.singleton((IdeaPluginDescriptor)toDisable.get()));
            }
            ArrayList<IdeaPluginDescriptorImpl> installedPlugins = new ArrayList<IdeaPluginDescriptorImpl>();
            installedPlugins.add(pluginDescriptor);
            for (PluginInstallCallbackData plugin2 : installedDependencies) {
                installedPlugins.add(plugin2.getPluginDescriptor());
            }
            PluginInstaller.checkInstalledPluginDependencies(model2, pluginDescriptor, parent, ContainerUtil.map2Set(installedPlugins, descriptor2 -> descriptor2.getPluginId()));
            PluginManagerMain.suggestToEnableInstalledDependantPlugins(pluginEnabler, installedPlugins);
            callback2.accept(new PluginInstallCallbackData(file2, pluginDescriptor, !installWithoutRestart));
            for (PluginInstallCallbackData callbackData : installedDependencies) {
                if (callbackData.getPluginDescriptor().getPluginId().equals(pluginDescriptor.getPluginId())) continue;
                callback2.accept(callbackData);
            }
            if (file2.toString().endsWith(".zip") && Registry.is((String)"ide.plugins.keep.archive")) {
                File tempFile = MarketplacePluginDownloadService.INSTANCE.getPluginTempFile();
                FileUtil.copy((File)file2.toFile(), (File)tempFile);
                MarketplacePluginDownloadService.INSTANCE.renameFileToZipRoot(tempFile);
            }
            return true;
        }
        catch (IOException ex) {
            MessagesEx.showErrorDialog(parent, ex.getMessage(), CommonBundle.getErrorTitle());
            return false;
        }
    }

    public static boolean installAndLoadDynamicPlugin(@NotNull Path file2, @Nullable Component parent, IdeaPluginDescriptorImpl pluginDescriptor) {
        IdeaPluginDescriptorImpl targetDescriptor;
        Path targetFile;
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(16);
        }
        if ((targetFile = PluginInstaller.installWithoutRestart(file2, pluginDescriptor, parent)) != null && (targetDescriptor = PluginManager.loadDescriptor(targetFile, DisabledPluginsState.disabledPlugins(), false, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER)) != null) {
            return DynamicPlugins.loadPlugin(targetDescriptor);
        }
        return false;
    }

    private static void checkInstalledPluginDependencies(@NotNull InstalledPluginsTableModel model2, @NotNull IdeaPluginDescriptorImpl pluginDescriptor, @Nullable Component parent, Set<PluginId> installedDependencies) {
        if (model2 == null) {
            PluginInstaller.$$$reportNull$$$0(17);
        }
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(18);
        }
        HashSet<PluginId> notInstalled = new HashSet<PluginId>();
        for (IdeaPluginDependency dep : pluginDescriptor.getDependencies()) {
            PluginId id2;
            if (dep.isOptional() || installedDependencies.contains(id2 = dep.getPluginId())) continue;
            boolean disabled = model2.isDisabled(id2);
            boolean enabled = model2.isEnabled(id2);
            if (enabled || disabled || PluginManagerCore.isModuleDependency(id2)) continue;
            notInstalled.add(id2);
        }
        if (!notInstalled.isEmpty()) {
            String deps = StringUtil.join(notInstalled, PluginId::toString, (String)", ");
            String message2 = IdeBundle.message((String)"dialog.message.plugin.depends.on.unknown.plugin", (Object[])new Object[]{pluginDescriptor.getName(), notInstalled.size(), deps});
            MessagesEx.showWarningDialog(parent, message2, IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]));
        }
    }

    static void chooseAndInstall(@NotNull InstalledPluginsTableModel model2, @Nullable Component parent, @NotNull Consumer<? super PluginInstallCallbackData> callback2) {
        if (model2 == null) {
            PluginInstaller.$$$reportNull$$$0(19);
        }
        if (callback2 == null) {
            PluginInstaller.$$$reportNull$$$0(20);
        }
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, false, true, true, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                String extension2 = file2.getExtension();
                return Comparing.strEqual((String)extension2, (String)"jar") || Comparing.strEqual((String)extension2, (String)"zip");
            }
        };
        descriptor2.setTitle(IdeBundle.message((String)"chooser.title.plugin.file", (Object[])new Object[0]));
        descriptor2.setDescription(IdeBundle.message((String)"chooser.description.jar.and.zip.archives.are.accepted", (Object[])new Object[0]));
        String oldPath = PropertiesComponent.getInstance().getValue(PLUGINS_PRESELECTION_PATH);
        VirtualFile toSelect2 = oldPath == null ? null : VfsUtil.findFileByIoFile((File)new File(FileUtilRt.toSystemDependentName((String)oldPath)), (boolean)false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor2, null, (Component)parent, (VirtualFile)toSelect2, virtualFile -> {
            Path file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).toPath();
            PropertiesComponent.getInstance().setValue(PLUGINS_PRESELECTION_PATH, FileUtilRt.toSystemIndependentName((String)file2.getParent().toString()));
            PluginInstaller.installFromDisk(model2, file2, callback2, parent);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginInstaller";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginInstaller";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackPlugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareToUninstall";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uninstallDynamicPlugin";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installAfterRestart";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "installWithoutRestart";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unpackPlugin";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "rootEntryName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addStateListener";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "installFromDisk";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "installAndLoadDynamicPlugin";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkInstalledPluginDependencies";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndInstall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

