/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginReplacement;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.PluginModulesHelper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginInstallOperation {
    private static final Logger LOG = Logger.getInstance(PluginInstallOperation.class);
    private final List<PluginNode> myPluginsToInstall;
    private final Collection<? extends IdeaPluginDescriptor> myCustomReposPlugins;
    private final PluginManagerMain.PluginEnabler myPluginEnabler;
    private final ProgressIndicator myIndicator;
    private boolean mySuccess;
    private final Set<PluginInstallCallbackData> myDependant;
    private boolean myAllowInstallWithoutRestart;
    private final List<PendingDynamicPluginInstall> myPendingDynamicPluginInstalls;
    private boolean myRestartRequired;
    private boolean myShownErrors;
    private static final Map<PluginId, ActionCallback> ourInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
    private final Map<PluginId, ActionCallback> myLocalInstallCallbacks;
    private final Map<PluginId, ActionCallback> myLocalWaitInstallCallbacks;
    private static final Object ourInstallLock = new Object();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public PluginInstallOperation(@NotNull List<PluginNode> pluginsToInstall, List<? extends IdeaPluginDescriptor> customReposPlugins, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            PluginInstallOperation.$$$reportNull$$$0(1);
        }
        this(pluginsToInstall, (Collection<? extends IdeaPluginDescriptor>)customReposPlugins, pluginEnabler, indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginInstallOperation(@NotNull List<PluginNode> pluginsToInstall, Collection<? extends IdeaPluginDescriptor> customReposPlugins, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            PluginInstallOperation.$$$reportNull$$$0(3);
        }
        this.mySuccess = true;
        this.myDependant = new HashSet<PluginInstallCallbackData>();
        this.myAllowInstallWithoutRestart = false;
        this.myPendingDynamicPluginInstalls = new ArrayList<PendingDynamicPluginInstall>();
        this.myRestartRequired = false;
        this.myLocalInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
        this.myLocalWaitInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
        this.myPluginsToInstall = pluginsToInstall;
        this.myCustomReposPlugins = customReposPlugins;
        this.myPluginEnabler = pluginEnabler;
        this.myIndicator = indicator;
        Object object = ourInstallLock;
        synchronized (object) {
            for (PluginNode node : pluginsToInstall) {
                PluginId id2 = node.getPluginId();
                ActionCallback callback2 = ourInstallCallbacks.get(id2);
                if (callback2 == null) {
                    this.createInstallCallback(id2);
                    continue;
                }
                this.myLocalWaitInstallCallbacks.put(id2, callback2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstallCallback(@NotNull PluginId id2, @NotNull ActionCallback callback2, boolean isDone) {
        if (id2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(4);
        }
        if (callback2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(5);
        }
        Object object = ourInstallLock;
        synchronized (object) {
            ActionCallback oldValue = ourInstallCallbacks.get(id2);
            if (oldValue == callback2) {
                ourInstallCallbacks.remove(id2);
            }
        }
        if (isDone) {
            callback2.setDone();
        } else {
            callback2.setRejected();
        }
    }

    private void createInstallCallback(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(6);
        }
        ActionCallback callback2 = new ActionCallback();
        ourInstallCallbacks.put(id2, callback2);
        this.myLocalInstallCallbacks.put(id2, callback2);
    }

    public void setAllowInstallWithoutRestart(boolean allowInstallWithoutRestart) {
        this.myAllowInstallWithoutRestart = allowInstallWithoutRestart;
    }

    public List<PendingDynamicPluginInstall> getPendingDynamicPluginInstalls() {
        return this.myPendingDynamicPluginInstalls;
    }

    public boolean isRestartRequired() {
        return this.myRestartRequired;
    }

    public void run() {
        this.updateUrls();
        this.mySuccess = this.prepareToInstall(this.myPluginsToInstall);
    }

    public boolean isSuccess() {
        return this.mySuccess;
    }

    public Set<PluginInstallCallbackData> getInstalledDependentPlugins() {
        return this.myDependant;
    }

    public boolean isShownErrors() {
        return this.myShownErrors;
    }

    private void updateUrls() {
        boolean unknownNodes = false;
        for (PluginNode node : this.myPluginsToInstall) {
            if (node.getRepositoryName() != "__unknown_repository__") continue;
            unknownNodes = true;
            break;
        }
        if (!unknownNodes) {
            return;
        }
        SmartList hosts = new SmartList();
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.addAll(UpdateSettings.getInstance().getPluginHosts());
        HashMap<PluginId, IdeaPluginDescriptor> allPlugins = new HashMap<PluginId, IdeaPluginDescriptor>();
        for (String host : hosts) {
            try {
                List<IdeaPluginDescriptor> descriptors2 = RepositoryHelper.loadPlugins(host, this.myIndicator);
                for (IdeaPluginDescriptor descriptor2 : descriptors2) {
                    allPlugins.put(descriptor2.getPluginId(), descriptor2);
                }
            }
            catch (IOException descriptors2) {
            }
        }
        for (PluginNode node : this.myPluginsToInstall) {
            if (node.getRepositoryName() != "__unknown_repository__") continue;
            IdeaPluginDescriptor descriptor3 = (IdeaPluginDescriptor)allPlugins.get(node.getPluginId());
            if (descriptor3 != null) {
                node.setRepositoryName(((PluginNode)descriptor3).getRepositoryName());
                node.setDownloadUrl(((PluginNode)descriptor3).getDownloadUrl());
                continue;
            }
            node.setRepositoryName(null);
        }
    }

    private boolean prepareToInstall(@NotNull List<PluginNode> pluginsToInstall) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(7);
        }
        SmartList pluginIds2 = new SmartList();
        for (PluginNode pluginNode : pluginsToInstall) {
            pluginIds2.add(pluginNode.getPluginId());
        }
        boolean result2 = false;
        for (PluginNode pluginNode : pluginsToInstall) {
            this.myIndicator.setText(pluginNode.getName());
            try {
                result2 |= this.prepareToInstallWithCallback(pluginNode, (List<PluginId>)pluginIds2);
            }
            catch (IOException e) {
                String title = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
                Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Plugin Error", (String)title), title, pluginNode.getName() + ": " + e.getMessage(), NotificationType.ERROR));
                return false;
            }
        }
        return result2;
    }

    private boolean prepareToInstallWithCallback(PluginNode pluginNode, List<PluginId> pluginIds2) throws IOException {
        PluginId id2 = pluginNode.getPluginId();
        ActionCallback localCallback = this.myLocalInstallCallbacks.remove(id2);
        if (localCallback == null) {
            ActionCallback callback2 = this.myLocalWaitInstallCallbacks.remove(id2);
            if (callback2 == null) {
                return this.prepareToInstall(pluginNode, pluginIds2);
            }
            return callback2.waitFor(-1L) && callback2.isDone();
        }
        try {
            boolean result2 = this.prepareToInstall(pluginNode, pluginIds2);
            PluginInstallOperation.removeInstallCallback(id2, localCallback, result2);
            return result2;
        }
        catch (IOException | RuntimeException e) {
            PluginInstallOperation.removeInstallCallback(id2, localCallback, false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareToInstall(PluginNode pluginNode, List<PluginId> pluginIds2) throws IOException {
        Ref<IdeaPluginDescriptor> toDisable = this.checkDependenciesAndReplacements(pluginNode, pluginIds2);
        if (toDisable == null) {
            return false;
        }
        this.myShownErrors = false;
        PluginDownloader downloader = PluginDownloader.createDownloader(pluginNode, pluginNode.getRepositoryName(), null);
        IdeaPluginDescriptorImpl descriptor2 = downloader.prepareToInstallAndLoadDescriptor(this.myIndicator);
        if (descriptor2 != null) {
            boolean allowNoRestart;
            if (pluginNode.getDependencies().isEmpty() && !descriptor2.getDependencies().isEmpty() && !this.checkMissingDependencies(descriptor2, pluginIds2)) {
                return false;
            }
            boolean bl = allowNoRestart = this.myAllowInstallWithoutRestart && DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor2);
            if (allowNoRestart) {
                this.myPendingDynamicPluginInstalls.add(new PendingDynamicPluginInstall(downloader.getFile().toPath(), descriptor2));
                InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
                if (state != null) {
                    state.onPluginInstall(downloader.getDescriptor(), false, false);
                }
            } else {
                this.myRestartRequired = true;
                Object object = PluginInstaller.ourLock;
                synchronized (object) {
                    downloader.install();
                }
            }
            this.myDependant.add(new PluginInstallCallbackData(downloader.getFile().toPath(), descriptor2, !allowNoRestart));
            pluginNode.setStatus(PluginNode.Status.DOWNLOADED);
            if (!toDisable.isNull()) {
                this.myPluginEnabler.disablePlugins(Collections.singleton((IdeaPluginDescriptor)toDisable.get()));
            }
        } else {
            this.myShownErrors = downloader.isShownErrors();
            return false;
        }
        return true;
    }

    @Nullable
    public Ref<IdeaPluginDescriptor> checkDependenciesAndReplacements(IdeaPluginDescriptor pluginNode, @Nullable List<PluginId> pluginIds2) {
        if (!this.checkMissingDependencies(pluginNode, pluginIds2)) {
            return null;
        }
        Ref toDisable = Ref.create(null);
        PluginReplacement pluginReplacement = (PluginReplacement)ContainerUtil.find((Object[])((PluginReplacement[])PluginReplacement.EP_NAME.getExtensions()), r -> r.getNewPluginId().equals(pluginNode.getPluginId().getIdString()));
        if (pluginReplacement != null) {
            IdeaPluginDescriptor oldPlugin = PluginManagerCore.getPlugin(pluginReplacement.getOldPluginDescriptor().getPluginId());
            if (oldPlugin == null) {
                LOG.warn("Plugin with id '" + pluginReplacement.getOldPluginDescriptor().getPluginId() + "' not found");
            } else if (!this.myPluginEnabler.isDisabled(oldPlugin.getPluginId())) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    String title = IdeBundle.message((String)"plugin.manager.obsolete.plugins.detected.title", (Object[])new Object[0]);
                    String message2 = pluginReplacement.getReplacementMessage(oldPlugin, pluginNode);
                    if (Messages.showYesNoDialog((String)message2, (String)title, (String)IdeBundle.message((String)"button.disable", (Object[])new Object[0]), (String)Messages.getNoButton(), (Icon)Messages.getWarningIcon()) == 0) {
                        toDisable.set((Object)oldPlugin);
                    }
                }, ModalityState.any());
            }
        }
        return toDisable;
    }

    private boolean checkMissingDependencies(IdeaPluginDescriptor pluginNode, @Nullable List<PluginId> pluginIds2) {
        List dependencies = pluginNode.getDependencies();
        if (!dependencies.isEmpty()) {
            ArrayList<PluginNode> depends = new ArrayList<PluginNode>();
            ArrayList<PluginNode> optionalDeps = new ArrayList<PluginNode>();
            for (IdeaPluginDependency dependency : dependencies) {
                PluginId depPluginId = dependency.getPluginId();
                if (PluginManagerCore.isModuleDependency(depPluginId)) {
                    PluginId pluginIdByModule = PluginModulesHelper.getInstance().getMarketplacePluginIdByModule(depPluginId);
                    if (pluginIdByModule == null) continue;
                    depPluginId = pluginIdByModule;
                }
                if (PluginManagerCore.isPluginInstalled(depPluginId) || InstalledPluginsState.getInstance().wasInstalled(depPluginId) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart(depPluginId) || pluginIds2 != null && pluginIds2.contains(depPluginId)) continue;
                IdeaPluginDescriptor depPluginDescriptor = this.findPluginInRepo(depPluginId);
                PluginNode depPlugin = depPluginDescriptor instanceof PluginNode ? (PluginNode)depPluginDescriptor : new PluginNode(depPluginId, depPluginId.getIdString(), "-1");
                if (depPluginDescriptor == null) continue;
                if (dependency.isOptional()) {
                    optionalDeps.add(depPlugin);
                    continue;
                }
                depends.add(depPlugin);
            }
            if (!this.prepareDependencies(pluginNode, depends, "plugin.manager.dependencies.detected.title", "plugin.manager.dependencies.detected.message")) {
                return false;
            }
            if (Registry.is((String)"ide.plugins.suggest.install.optional.dependencies") && !this.prepareDependencies(pluginNode, optionalDeps, "plugin.manager.optional.dependencies.detected.title", "plugin.manager.optional.dependencies.detected.message")) {
                return false;
            }
        }
        return true;
    }

    private boolean prepareDependencies(@NotNull IdeaPluginDescriptor pluginNode, @NotNull List<PluginNode> depends, @NotNull String titleKey, @NotNull String messageKey) {
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(8);
        }
        if (depends == null) {
            PluginInstallOperation.$$$reportNull$$$0(9);
        }
        if (titleKey == null) {
            PluginInstallOperation.$$$reportNull$$$0(10);
        }
        if (messageKey == null) {
            PluginInstallOperation.$$$reportNull$$$0(11);
        }
        if (depends.isEmpty()) {
            return true;
        }
        boolean[] proceed = new boolean[1];
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                Object object = ourInstallLock;
                synchronized (object) {
                    ArrayList<PluginNode> dependsToShow = new ArrayList<PluginNode>();
                    Iterator I = depends.iterator();
                    while (I.hasNext()) {
                        PluginNode node = (PluginNode)I.next();
                        PluginId id2 = node.getPluginId();
                        ActionCallback callback2 = ourInstallCallbacks.get(id2);
                        if (callback2 == null || callback2.isRejected()) {
                            if (InstalledPluginsState.getInstance().wasInstalled(id2) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart(id2)) {
                                I.remove();
                                continue;
                            }
                            dependsToShow.add(node);
                            continue;
                        }
                        this.myLocalWaitInstallCallbacks.put(id2, callback2);
                    }
                    if (dependsToShow.isEmpty()) {
                        proceed[0] = true;
                        return;
                    }
                    String title = IdeBundle.message((String)titleKey, (Object[])new Object[0]);
                    String deps = PluginInstallOperation.getPluginsText(depends);
                    String message2 = IdeBundle.message((String)messageKey, (Object[])new Object[]{pluginNode.getName(), deps});
                    boolean bl = proceed[0] = Messages.showYesNoDialog((String)message2, (String)title, (String)IdeBundle.message((String)"button.install", (Object[])new Object[0]), (String)Messages.getNoButton(), (Icon)Messages.getWarningIcon()) == 0;
                    if (proceed[0]) {
                        for (PluginNode depend : dependsToShow) {
                            this.createInstallCallback(depend.getPluginId());
                        }
                    }
                }
            }, ModalityState.any());
        }
        catch (Exception e) {
            return false;
        }
        if (depends.isEmpty()) {
            return true;
        }
        return proceed[0] && this.prepareToInstall(depends);
    }

    @NotNull
    private static String getPluginsText(@NotNull List<PluginNode> pluginNodes) {
        int size;
        if (pluginNodes == null) {
            PluginInstallOperation.$$$reportNull$$$0(12);
        }
        if ((size = pluginNodes.size()) == 1) {
            String string = "\"" + pluginNodes.get(0).getName() + "\" plugin";
            if (string == null) {
                PluginInstallOperation.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = StringUtil.join(pluginNodes.subList(0, size - 1), node -> "\"" + node.getName() + "\"", (String)", ") + " and \"" + pluginNodes.get(size - 1) + "\" plugins";
        if (string == null) {
            PluginInstallOperation.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private IdeaPluginDescriptor findPluginInRepo(PluginId depPluginId) {
        IdeaPluginDescriptor pluginFromCustomRepos = ((Stream)this.myCustomReposPlugins.stream().parallel()).filter(p -> p.getPluginId().equals(depPluginId)).findAny().orElse(null);
        PluginNode pluginFromMarketplace = MarketplaceRequests.getInstance().getLastCompatiblePluginUpdate(depPluginId.getIdString());
        if (pluginFromCustomRepos == null) {
            return pluginFromMarketplace;
        }
        if (pluginFromMarketplace == null) {
            return pluginFromCustomRepos;
        }
        if (PluginDownloader.compareVersionsSkipBrokenAndIncompatible(pluginFromCustomRepos.getVersion(), pluginFromMarketplace) > 0) {
            return pluginFromCustomRepos;
        }
        return pluginFromMarketplace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depends";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleKey";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginNodes";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginInstallOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginInstallOperation";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeInstallCallback";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInstallCallback";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareDependencies";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsText";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

