/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.DynamicPluginsKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginXmlFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.util.io.URLUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/plugins/OptionalDependencyDescriptorLoader;", "", "()V", "listContext", "Lcom/intellij/ide/plugins/DescriptorListLoadingContext;", "Lorg/jetbrains/annotations/NotNull;", "pluginXmlFactory", "Lcom/intellij/ide/plugins/PluginXmlFactory;", "load", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "mainDescriptor", "dependencyConfigFile", "", "intellij.platform.ide.impl"})
final class OptionalDependencyDescriptorLoader {
    private final PluginXmlFactory pluginXmlFactory = new PluginXmlFactory();
    private final DescriptorListLoadingContext listContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IdeaPluginDescriptorImpl load(@NotNull IdeaPluginDescriptorImpl mainDescriptor, @NotNull String dependencyConfigFile) {
        Intrinsics.checkNotNullParameter((Object)mainDescriptor, (String)"mainDescriptor");
        Intrinsics.checkNotNullParameter((Object)dependencyConfigFile, (String)"dependencyConfigFile");
        DescriptorLoadingContext context = new DescriptorLoadingContext(this.listContext, mainDescriptor.isBundled(), false, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);
        PathBasedJdomXIncluder.PathResolver<?> pathResolver = PluginDescriptorLoader.createPathResolverForPlugin(mainDescriptor, context);
        Intrinsics.checkNotNullExpressionValue(pathResolver, (String)"PluginDescriptorLoader.c\u2026(mainDescriptor, context)");
        PathBasedJdomXIncluder.PathResolver<?> pathResolver2 = pathResolver;
        try {
            Pair jarPair = URLUtil.splitJarUrl((String)mainDescriptor.basePath.toUri().toString());
            Path newBasePath = jarPair == null ? mainDescriptor.basePath : context.open(Paths.get((String)jarPair.first, new String[0])).getPath((String)jarPair.second, new String[0]);
            Element element2 = pathResolver2.resolvePath(newBasePath, dependencyConfigFile, (SafeJdomFactory)this.pluginXmlFactory);
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"pathResolver.resolvePath\u2026igFile, pluginXmlFactory)");
            Element element3 = element2;
            IdeaPluginDescriptorImpl subDescriptor = new IdeaPluginDescriptorImpl(mainDescriptor.getPluginPath(), newBasePath, mainDescriptor.isBundled());
            subDescriptor.id = mainDescriptor.id;
            subDescriptor.name = mainDescriptor.name;
            subDescriptor.descriptorPath = dependencyConfigFile;
            if (subDescriptor.readExternal(element3, pathResolver2, this.listContext, mainDescriptor)) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = subDescriptor;
                return ideaPluginDescriptorImpl;
            }
            DynamicPluginsKt.access$getLOG$p().info("Can't read descriptor " + dependencyConfigFile + " for optional dependency of plugin being loaded/unloaded");
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
            return ideaPluginDescriptorImpl;
        }
        catch (Exception e) {
            DynamicPluginsKt.access$getLOG$p().info("Can't resolve optional dependency on plugin being loaded/unloaded: config file " + dependencyConfigFile, (Throwable)e);
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
            return ideaPluginDescriptorImpl;
        }
        finally {
            context.close();
        }
    }

    public OptionalDependencyDescriptorLoader() {
        DescriptorListLoadingContext descriptorListLoadingContext = DescriptorListLoadingContext.createSingleDescriptorContext(DisabledPluginsState.disabledPlugins());
        Intrinsics.checkNotNullExpressionValue((Object)descriptorListLoadingContext, (String)"DescriptorListLoadingCon\u2026sState.disabledPlugins())");
        this.listContext = descriptorListLoadingContext;
    }
}

