/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.ProjectPluginTracker;
import com.intellij.ide.plugins.ProjectPluginTrackerManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.FileVisitResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsTableModel {
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    protected final List<IdeaPluginDescriptor> view = new ArrayList<IdeaPluginDescriptor>();
    private final Map<PluginId, PluginEnabledState> myEnabled = new HashMap<PluginId, PluginEnabledState>();
    private final Map<PluginId, Set<PluginId>> myDependentToRequiredListMap = new HashMap<PluginId, Set<PluginId>>();
    @Nullable
    private final Project myProject;
    @Nullable
    private final ProjectPluginTracker myPluginTracker;

    public InstalledPluginsTableModel(@Nullable Project project) {
        this.myProject = project;
        this.myPluginTracker = this.myProject == null ? null : ProjectPluginTrackerManager.getInstance().getPluginTracker(this.myProject);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        for (IdeaPluginDescriptor plugin2 : PluginManagerCore.getPlugins()) {
            PluginId pluginId = plugin2.getPluginId();
            if (appInfo.isEssentialPlugin(pluginId)) {
                this.myEnabled.put(pluginId, PluginEnabledState.ENABLED);
                continue;
            }
            this.view.add(plugin2);
        }
        this.view.addAll(ourState.getInstalledPlugins());
        for (IdeaPluginDescriptor descriptor2 : this.view) {
            this.setEnabled(descriptor2);
        }
        this.updatePluginDependencies();
    }

    @Nullable
    protected final Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected List<IdeaPluginDescriptor> getAllPlugins() {
        return new ArrayList<IdeaPluginDescriptor>(this.view);
    }

    @Nullable
    public Set<PluginId> getRequiredPlugins(PluginId pluginId) {
        return this.myDependentToRequiredListMap.get(pluginId);
    }

    public final boolean isLoaded(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(0);
        }
        return InstalledPluginsTableModel.isLoaded(pluginId, this.getEnabledMap());
    }

    protected final void setEnabled(@NotNull IdeaPluginDescriptor ideaPluginDescriptor) {
        if (ideaPluginDescriptor == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(1);
        }
        PluginId pluginId = ideaPluginDescriptor.getPluginId();
        PluginEnabledState enabled = this.myPluginTracker != null && this.myPluginTracker.isEnabled(pluginId) ? PluginEnabledState.ENABLED_FOR_PROJECT : (this.myPluginTracker != null && this.myPluginTracker.isDisabled(pluginId) ? PluginEnabledState.DISABLED_FOR_PROJECT : (PluginManagerCore.isDisabled(pluginId) ? PluginEnabledState.DISABLED : (ideaPluginDescriptor.isEnabled() ? PluginEnabledState.ENABLED : null)));
        this.setEnabled(pluginId, enabled);
    }

    protected final void setEnabled(@NotNull PluginId pluginId, @Nullable PluginEnabledState enabled) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(2);
        }
        this.myEnabled.put(pluginId, enabled);
    }

    public Map<PluginId, Set<PluginId>> getDependentToRequiredListMap() {
        return this.myDependentToRequiredListMap;
    }

    protected void updatePluginDependencies() {
        this.myDependentToRequiredListMap.clear();
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = null;
        for (IdeaPluginDescriptor rootDescriptor : this.view) {
            PluginId pluginId = rootDescriptor.getPluginId();
            this.myDependentToRequiredListMap.remove(pluginId);
            if (rootDescriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)rootDescriptor).isDeleted() || this.isDisabled(pluginId)) continue;
            if (pluginIdMap == null) {
                pluginIdMap = PluginManagerCore.buildPluginIdMap();
            }
            boolean loaded = this.isLoaded(pluginId);
            if (rootDescriptor instanceof IdeaPluginDescriptorImpl) {
                PluginManagerCore.processAllDependencies((IdeaPluginDescriptorImpl)rootDescriptor, false, pluginIdMap, (depId, descriptor2) -> {
                    if (depId.equals(pluginId)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!this.isLoaded((PluginId)depId) && !ourState.wasInstalled((PluginId)depId) && !ourState.wasUpdated((PluginId)depId) && !ourState.wasInstalledWithoutRestart((PluginId)depId) || this.isDisabled((PluginId)depId)) {
                        Set<PluginId> required = this.myDependentToRequiredListMap.get(pluginId);
                        if (required == null) {
                            required = new HashSet<PluginId>();
                            this.myDependentToRequiredListMap.put(pluginId, required);
                        }
                        required.add((PluginId)depId);
                    }
                    return FileVisitResult.CONTINUE;
                });
            }
            if (loaded || this.myDependentToRequiredListMap.containsKey(pluginId) || !PluginManagerCore.isCompatible(rootDescriptor)) continue;
            this.setEnabled(pluginId, PluginEnabledState.ENABLED);
        }
    }

    protected final void enableRows(@NotNull Set<? extends IdeaPluginDescriptor> ideaPluginDescriptors, @NotNull PluginEnableDisableAction action2) {
        if (ideaPluginDescriptors == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(4);
        }
        HashMap<PluginId, PluginEnabledState> tempEnabled = new HashMap<PluginId, PluginEnabledState>(this.myEnabled);
        InstalledPluginsTableModel.setNewEnabled(ideaPluginDescriptors, tempEnabled, action2, (descriptor2, pair) -> {});
        boolean enabled = action2.isEnable();
        Set<Pair<@Nullable ? extends IdeaPluginDescriptor, @NotNull String>> dependencies = this.getDependenciesToUpdateState(ideaPluginDescriptors, tempEnabled, enabled);
        if (!(dependencies.isEmpty() || SystemProperties.getBooleanProperty((String)"startup.performance.framework", (boolean)false) || InstalledPluginsTableModel.createUpdateDependenciesDialog(action2, ContainerUtil.map(dependencies, pair -> (String)pair.getSecond())).ask(this.getProject()))) {
            return;
        }
        this.setNewEnabled(ContainerUtil.mapNotNull(dependencies, pair -> (IdeaPluginDescriptor)pair.getFirst()), action2);
        this.setNewEnabled(ideaPluginDescriptors, action2);
        this.updatePluginDependencies();
    }

    private void setNewEnabled(@NotNull @NotNull Collection<@NotNull ? extends IdeaPluginDescriptor> dependencies, @NotNull PluginEnableDisableAction action2) {
        if (dependencies == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(5);
        }
        if (action2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(6);
        }
        InstalledPluginsTableModel.setNewEnabled(dependencies, this.myEnabled, action2, this::handleBeforeChangeEnableState);
    }

    private static void setNewEnabled(@NotNull @NotNull Collection<@NotNull ? extends IdeaPluginDescriptor> descriptors2, @NotNull Map<PluginId, PluginEnabledState> enabledMap, @NotNull PluginEnableDisableAction action2, @NotNull @NotNull BiConsumer<@NotNull ? super IdeaPluginDescriptor, @NotNull Pair<PluginEnableDisableAction, PluginEnabledState>> beforeHandler) {
        if (descriptors2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(7);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(8);
        }
        if (action2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(9);
        }
        if (beforeHandler == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(10);
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            PluginEnabledState oldState = enabledMap.get(pluginId);
            PluginEnabledState newState2 = oldState == null ? PluginEnabledState.DISABLED : action2.apply(oldState);
            if (newState2 == null) continue;
            beforeHandler.accept((IdeaPluginDescriptor)ideaPluginDescriptor, (Pair<PluginEnableDisableAction, PluginEnabledState>)Pair.create((Object)((Object)action2), (Object)((Object)newState2)));
            enabledMap.put(pluginId, newState2);
        }
    }

    public boolean isEnabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(11);
        }
        return !InstalledPluginsTableModel.isDisabled(pluginId, this.myEnabled);
    }

    public boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(12);
        }
        return !InstalledPluginsTableModel.isEnabled(pluginId, this.myEnabled);
    }

    @NotNull
    protected final Map<PluginId, PluginEnabledState> getEnabledMap() {
        Map<PluginId, PluginEnabledState> map2 = this.myEnabled;
        if (map2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(13);
        }
        return map2;
    }

    @NotNull
    private @NotNull Set<@NotNull Pair<@Nullable ? extends IdeaPluginDescriptor, @NotNull String>> getDependenciesToUpdateState(@NotNull Set<? extends IdeaPluginDescriptor> descriptorsWithChangedEnabledState, @NotNull Map<PluginId, PluginEnabledState> enabledMap, boolean enabled) {
        if (descriptorsWithChangedEnabledState == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(14);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(15);
        }
        ArrayList<? extends IdeaPluginDescriptor> descriptorsToCheckDependencies = new ArrayList<IdeaPluginDescriptor>(enabled ? descriptorsWithChangedEnabledState : this.getAllPlugins());
        if (!enabled) {
            descriptorsToCheckDependencies.removeAll(descriptorsWithChangedEnabledState);
            descriptorsToCheckDependencies.removeIf(descriptor2 -> InstalledPluginsTableModel.isDisabled(descriptor2.getPluginId(), enabledMap));
        }
        HashSet<Pair<? extends IdeaPluginDescriptor, String>> dependencies = new HashSet<Pair<? extends IdeaPluginDescriptor, String>>();
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptorsToCheckDependencies) {
            if (!(ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl)) continue;
            IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)ideaPluginDescriptor;
            PluginManagerCore.processAllDependencies(pluginDescriptor, false, pluginIdMap, (depId, descriptor2) -> {
                if (depId == pluginDescriptor.getPluginId()) {
                    return FileVisitResult.CONTINUE;
                }
                if (!InstalledPluginsTableModel.isLoaded(depId, enabledMap)) {
                    return FileVisitResult.TERMINATE;
                }
                if (enabled && InstalledPluginsTableModel.isDisabled(depId, enabledMap)) {
                    String name = descriptor2 == null ? depId.getIdString() : descriptor2.getName();
                    dependencies.add(Pair.create((Object)descriptor2, (Object)name));
                }
                if (enabled || pluginDescriptor.isDeleted() || pluginDescriptor.isImplementationDetail()) {
                    return FileVisitResult.CONTINUE;
                }
                for (IdeaPluginDescriptor d : descriptorsWithChangedEnabledState) {
                    if (depId != d.getPluginId()) continue;
                    dependencies.add(Pair.create((Object)pluginDescriptor, (Object)pluginDescriptor.getName()));
                    break;
                }
                return FileVisitResult.CONTINUE;
            });
        }
        HashSet<Pair<? extends IdeaPluginDescriptor, String>> hashSet = dependencies;
        if (hashSet == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @NotNull
    private static OkCancelDialogBuilder createUpdateDependenciesDialog(@NotNull PluginEnableDisableAction action2, @NotNull List<String> dependencies) {
        String key;
        if (action2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(17);
        }
        if (dependencies == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(18);
        }
        boolean hasOnlyOneDependency = dependencies.size() == 1;
        switch (action2) {
            case ENABLE_GLOBALLY: {
                key = hasOnlyOneDependency ? "dialog.message.enable.required.plugin" : "dialog.message.enable.required.plugins";
                break;
            }
            case ENABLE_FOR_PROJECT: {
                key = hasOnlyOneDependency ? "dialog.message.enable.required.plugin.for.current.project" : "dialog.message.enable.required.plugins.for.current.project";
                break;
            }
            case ENABLE_FOR_PROJECT_DISABLE_GLOBALLY: {
                key = hasOnlyOneDependency ? "dialog.message.enable.dependent.plugin.for.current.project.only" : "dialog.message.enable.dependent.plugins.for.current.project.only";
                break;
            }
            case DISABLE_GLOBALLY: {
                key = hasOnlyOneDependency ? "dialog.message.disable.dependent.plugin" : "dialog.message.disable.dependent.plugins";
                break;
            }
            case DISABLE_FOR_PROJECT: {
                key = hasOnlyOneDependency ? "dialog.message.disable.dependent.plugin.for.current.project" : "dialog.message.disable.dependent.plugins.for.current.project";
                break;
            }
            case DISABLE_FOR_PROJECT_ENABLE_GLOBALLY: {
                key = hasOnlyOneDependency ? "dialog.message.disable.required.plugin.for.current.project.only" : "dialog.message.disable.required.plugins.for.current.project.only";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + action2);
            }
        }
        String dependenciesText = hasOnlyOneDependency ? dependencies.get(0) : StringUtil.join(dependencies, StringUtil.repeat((String)"&nbsp;", (int)5)::concat, (String)"<br>");
        boolean enabled = action2.isEnable();
        OkCancelDialogBuilder okCancelDialogBuilder = (OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)IdeBundle.message((String)(enabled ? "dialog.title.enable.required.plugins" : "dialog.title.disable.dependent.plugins"), (Object[])new Object[0]), (String)IdeBundle.message((String)key, (Object[])new Object[]{dependenciesText})).yesText(IdeBundle.message((String)(enabled ? "button.enable" : "button.disable"), (Object[])new Object[0]))).noText(Messages.getCancelButton());
        if (okCancelDialogBuilder == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(19);
        }
        return okCancelDialogBuilder;
    }

    protected void handleBeforeChangeEnableState(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Pair<PluginEnableDisableAction, PluginEnabledState> pair) {
        if (descriptor2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(20);
        }
        if (pair == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(21);
        }
    }

    protected static boolean isEnabled(@NotNull PluginId pluginId, @NotNull Map<PluginId, PluginEnabledState> enabledMap) {
        PluginEnabledState state;
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(22);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(23);
        }
        return (state = enabledMap.get(pluginId)) == null || state.isEnabled();
    }

    protected static boolean isDisabled(@NotNull PluginId pluginId, @NotNull Map<PluginId, PluginEnabledState> enabledMap) {
        PluginEnabledState state;
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(24);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(25);
        }
        return (state = enabledMap.get(pluginId)) == null || state.isDisabled();
    }

    protected static boolean isLoaded(@NotNull PluginId pluginId, @NotNull Map<PluginId, PluginEnabledState> enabledMap) {
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(26);
        }
        if (enabledMap == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(27);
        }
        return enabledMap.get(pluginId) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaPluginDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaPluginDescriptors";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 8: 
            case 15: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledMap";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeHandler";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/InstalledPluginsTableModel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsWithChangedEnabledState";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsTableModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesToUpdateState";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateDependenciesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLoaded";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "enableRows";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setNewEnabled";
                break;
            }
            case 11: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 12: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDependenciesToUpdateState";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateDependenciesDialog";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeChangeEnableState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

