/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPluginVfsListener;
import com.intellij.ide.plugins.DynamicPluginVfsListenerKt;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/plugins/DynamicPluginVfsListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "()V", "findPluginByPath", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "Companion", "intellij.platform.ide.impl"})
public final class DynamicPluginVfsListener
implements AsyncFileListener {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        IdeaPluginDescriptorImpl it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (!SystemProperties.is((String)"idea.auto.reload.plugins")) {
            return null;
        }
        if (!DynamicPluginVfsListenerKt.access$getInitialRefreshDone$p()) {
            return null;
        }
        boolean bl = false;
        HashSet<IdeaPluginDescriptorImpl> pluginsToReload = new HashSet<IdeaPluginDescriptorImpl>();
        for (VFileEvent vFileEvent : events) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (!vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
            VirtualFile virtualFile = ((VFileContentChangeEvent)vFileEvent).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
            if (this.findPluginByPath(virtualFile) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            IdeaPluginDescriptorImpl it2 = ideaPluginDescriptorImpl;
            boolean bl4 = false;
            LOG.info("Detected plugin .jar file change " + ((VFileContentChangeEvent)vFileEvent).getPath() + ", reloading plugin");
            pluginsToReload.add(it2);
        }
        Iterable iterable = pluginsToReload;
        boolean $i$f$filter = false;
        void var6_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeaPluginDescriptorImpl)element$iv$iv;
            boolean bl5 = false;
            if (!it.isEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdeaPluginDescriptorImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadFullDescriptor(it);
            collection.add(ideaPluginDescriptorImpl);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeaPluginDescriptorImpl)element$iv$iv;
            boolean bl7 = false;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = it;
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"it");
            if (!DynamicPlugins.allowLoadUnloadWithoutRestart$default(ideaPluginDescriptorImpl, null, null, 6, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        if (list2.isEmpty()) {
            return null;
        }
        return new AsyncFileListener.ChangeApplier(list2){
            final /* synthetic */ List $descriptorsToReload;

            public void afterVfsChange() {
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ prepareChange.2 this$0;

                    public final void run() {
                        boolean bl = false;
                        List reloaded2 = new ArrayList<E>();
                        boolean bl2 = false;
                        List unloadFailed = new ArrayList<E>();
                        Iterator<E> iterator2 = this.this$0.$descriptorsToReload.iterator();
                        while (iterator2.hasNext()) {
                            IdeaPluginDescriptorImpl pluginDescriptor;
                            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = pluginDescriptor = (IdeaPluginDescriptorImpl)iterator2.next();
                            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"pluginDescriptor");
                            if (!DynamicPlugins.unloadPlugin(ideaPluginDescriptorImpl, new DynamicPlugins.UnloadPluginOptions(false, true, false, false, true, false, null, 109, null))) {
                                String string = pluginDescriptor.name;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginDescriptor.name");
                                unloadFailed.add(string);
                                continue;
                            }
                            String string = pluginDescriptor.name;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginDescriptor.name");
                            reloaded2.add(string);
                            DynamicPlugins.loadPlugin$default(pluginDescriptor, false, 2, null);
                        }
                        Collection collection = unloadFailed;
                        boolean bl3 = false;
                        if (!collection.isEmpty()) {
                            String string = IdeBundle.message((String)"failed.to.unload.modified.plugins", (Object[])new Object[]{CollectionsKt.joinToString$default((Iterable)unloadFailed, null, null, null, (int)0, null, null, (int)63, null)});
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"faile\u2026oadFailed.joinToString())");
                            DynamicPlugins.INSTANCE.notify$intellij_platform_ide_impl(string, NotificationType.INFORMATION, new AnAction(IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0])){

                                public void actionPerformed(@NotNull AnActionEvent e) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    ApplicationManager.getApplication().restart();
                                }
                            });
                        } else {
                            collection = reloaded2;
                            bl3 = false;
                            if (!collection.isEmpty()) {
                                String string = IdeBundle.message((String)"plugins.reloaded.successfully", (Object[])new Object[]{CollectionsKt.joinToString$default((Iterable)reloaded2, null, null, null, (int)0, null, null, (int)63, null)});
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"plugi\u2026 reloaded.joinToString())");
                                DynamicPlugins.INSTANCE.notify$intellij_platform_ide_impl(string, NotificationType.INFORMATION, new AnAction[0]);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$descriptorsToReload = $captured_local_variable$0;
            }
        };
    }

    private final IdeaPluginDescriptorImpl findPluginByPath(VirtualFile file2) {
        IdeaPluginDescriptor ideaPluginDescriptor;
        block2: {
            if (!VfsUtilCore.isAncestorOrSelf((String)PathManager.getPluginsPath(), (VirtualFile)file2)) {
                return null;
            }
            IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManager.getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorArray, (String)"PluginManager.getPlugins()");
            IdeaPluginDescriptor[] $this$firstOrNull$iv = ideaPluginDescriptorArray;
            boolean $i$f$firstOrNull = false;
            IdeaPluginDescriptor[] ideaPluginDescriptorArray2 = $this$firstOrNull$iv;
            int n = ideaPluginDescriptorArray2.length;
            for (int j = 0; j < n; ++j) {
                IdeaPluginDescriptor element$iv;
                IdeaPluginDescriptor it = element$iv = ideaPluginDescriptorArray2[j];
                boolean bl = false;
                IdeaPluginDescriptor ideaPluginDescriptor2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor2, (String)"it");
                if (!VfsUtilCore.isAncestorOrSelf((String)((Object)ideaPluginDescriptor2.getPluginPath().toAbsolutePath()).toString(), (VirtualFile)file2)) continue;
                ideaPluginDescriptor = element$iv;
                break block2;
            }
            ideaPluginDescriptor = null;
        }
        return (IdeaPluginDescriptorImpl)ideaPluginDescriptor;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DynamicPluginVfsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Dynam\u2026nVfsListener::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/plugins/DynamicPluginVfsListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

