/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class DescriptorLoadingContext
implements AutoCloseable {
    private static final Map<String, String> ZIP_OPTIONS = Collections.singletonMap("zipinfo-time", "false");
    private final Map<Path, FileSystem> openedFiles;
    final DescriptorListLoadingContext parentContext;
    final boolean isBundled;
    final boolean isEssential;
    final PathBasedJdomXIncluder.PathResolver<?> pathResolver;

    DescriptorLoadingContext(@NotNull DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver) {
        if (parentContext == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(0);
        }
        if (pathResolver == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(1);
        }
        this.openedFiles = new HashMap<Path, FileSystem>();
        this.parentContext = parentContext;
        this.isBundled = isBundled;
        this.isEssential = isEssential;
        this.pathResolver = pathResolver;
    }

    @NotNull
    FileSystem open(@NotNull Path file2) throws IOException {
        if (file2 == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(2);
        }
        FileSystem fileSystem = this.openedFiles.computeIfAbsent(file2, it -> {
            try {
                return this.parentContext.zipFsProvider.newFileSystem((Path)it, (Map<String, ?>)ZIP_OPTIONS);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        if (fileSystem == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(3);
        }
        return fileSystem;
    }

    @Override
    public void close() {
        for (FileSystem file2 : this.openedFiles.values()) {
            try {
                file2.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public DescriptorLoadingContext copy(boolean isEssential) {
        return new DescriptorLoadingContext(this.parentContext, this.isBundled, isEssential, this.pathResolver);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/DescriptorLoadingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/DescriptorLoadingContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "open";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

