/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginXmlFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.text.DateFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DescriptorListLoadingContext
implements AutoCloseable {
    private static final boolean unitTestWithBundledPlugins = Boolean.getBoolean("idea.run.tests.with.bundled.plugins");
    static final int IS_PARALLEL = 1;
    static final int IGNORE_MISSING_INCLUDE = 2;
    static final int IGNORE_MISSING_SUB_DESCRIPTOR = 4;
    static final int CHECK_OPTIONAL_CONFIG_NAME_UNIQUENESS = 8;
    static final Logger LOG = PluginManagerCore.getLogger();
    @NotNull
    private final ExecutorService executorService;
    private final ConcurrentLinkedQueue<SafeJdomFactory[]> toDispose;
    private final Supplier<PluginXmlFactory> xmlFactorySupplier;
    @Nullable
    private final ThreadLocal<PluginXmlFactory[]> threadLocalXmlFactory;
    private final int maxThreads;
    @NotNull
    final PluginLoadingResult result;
    final Set<PluginId> disabledPlugins;
    private volatile String defaultVersion;
    final boolean ignoreMissingInclude;
    final boolean ignoreMissingSubDescriptor;
    boolean usePluginClassLoader;
    private final Map<String, PluginId> optionalConfigNames;
    final FileSystemProvider zipFsProvider;

    @NotNull
    public static DescriptorListLoadingContext createSingleDescriptorContext(@NotNull Set<PluginId> disabledPlugins) {
        if (disabledPlugins == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(0);
        }
        return new DescriptorListLoadingContext(4, disabledPlugins, PluginManagerCore.createLoadingResult(null));
    }

    DescriptorListLoadingContext(int flags, @NotNull Set<PluginId> disabledPlugins, @NotNull PluginLoadingResult result2) {
        if (disabledPlugins == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(2);
        }
        this.usePluginClassLoader = !PluginManagerCore.isUnitTestMode || unitTestWithBundledPlugins;
        this.result = result2;
        this.disabledPlugins = disabledPlugins;
        this.ignoreMissingInclude = (flags & 2) == 2;
        this.ignoreMissingSubDescriptor = (flags & 4) == 4;
        this.optionalConfigNames = (flags & 8) == 8 ? new ConcurrentHashMap() : null;
        this.zipFsProvider = DescriptorListLoadingContext.findZipFsProvider();
        int n = this.maxThreads = (flags & 1) == 1 ? Runtime.getRuntime().availableProcessors() - 1 : 1;
        if (this.maxThreads > 1) {
            this.executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PluginManager Loader", (int)this.maxThreads, (boolean)false);
            this.toDispose = new ConcurrentLinkedQueue();
            this.threadLocalXmlFactory = ThreadLocal.withInitial(() -> {
                PluginXmlFactory factory2 = new PluginXmlFactory();
                PluginXmlFactory[] ref = new PluginXmlFactory[]{factory2};
                this.toDispose.add((SafeJdomFactory[])ref);
                return ref;
            });
            this.xmlFactorySupplier = () -> this.threadLocalXmlFactory.get()[0];
        } else {
            this.executorService = ConcurrencyUtil.newSameThreadExecutorService();
            this.toDispose = null;
            this.threadLocalXmlFactory = null;
            PluginXmlFactory factory2 = new PluginXmlFactory();
            this.xmlFactorySupplier = () -> factory2;
        }
    }

    @NotNull
    private static FileSystemProvider findZipFsProvider() {
        for (FileSystemProvider provider2 : FileSystemProvider.installedProviders()) {
            FileSystemProvider fileSystemProvider;
            try {
                if (!provider2.getScheme().equals("jar")) continue;
                fileSystemProvider = provider2;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
            if (fileSystemProvider == null) {
                DescriptorListLoadingContext.$$$reportNull$$$0(3);
            }
            return fileSystemProvider;
        }
        throw new ProviderNotFoundException("Provider not found");
    }

    boolean isPluginDisabled(@NotNull PluginId id2) {
        if (id2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(4);
        }
        return id2 != PluginManagerCore.CORE_ID && this.disabledPlugins.contains(id2);
    }

    @NotNull
    ExecutorService getExecutorService() {
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(5);
        }
        return executorService;
    }

    @NotNull
    SafeJdomFactory getXmlFactory() {
        SafeJdomFactory safeJdomFactory = (SafeJdomFactory)this.xmlFactorySupplier.get();
        if (safeJdomFactory == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(6);
        }
        return safeJdomFactory;
    }

    @Override
    public void close() {
        if (this.threadLocalXmlFactory == null) {
            return;
        }
        if (this.maxThreads <= 1) {
            this.threadLocalXmlFactory.remove();
            return;
        }
        this.executorService.execute(() -> {
            for (SafeJdomFactory[] ref : this.toDispose) {
                ref[0] = null;
            }
        });
        this.executorService.shutdown();
    }

    @NotNull
    public String internString(@NotNull String string) {
        if (string == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(7);
        }
        String string2 = this.xmlFactorySupplier.get().intern(string);
        if (string2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    public String getDefaultVersion() {
        String result2 = this.defaultVersion;
        if (result2 == null) {
            this.defaultVersion = result2 = this.result.productBuildNumber.get().asStringWithoutProductCode();
        }
        String string = result2;
        if (string == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public DateFormat getDateParser() {
        DateFormat dateFormat = this.xmlFactorySupplier.get().releaseDateFormat;
        if (dateFormat == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(10);
        }
        return dateFormat;
    }

    @NotNull
    public List<String> getVisitedFiles() {
        List<String> list2 = this.xmlFactorySupplier.get().visitedFiles;
        if (list2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(11);
        }
        return list2;
    }

    boolean checkOptionalConfigShortName(@NotNull String configFile, @NotNull IdeaPluginDescriptor descriptor2, @NotNull IdeaPluginDescriptor rootDescriptor) {
        PluginId pluginId;
        if (configFile == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(12);
        }
        if (descriptor2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(13);
        }
        if (rootDescriptor == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(14);
        }
        if ((pluginId = descriptor2.getPluginId()) == null) {
            return false;
        }
        Map<String, PluginId> configNames = this.optionalConfigNames;
        if (configNames == null || configFile.startsWith("intellij.")) {
            return false;
        }
        PluginId oldPluginId = configNames.put(configFile, pluginId);
        if (oldPluginId == null || oldPluginId.equals(pluginId)) {
            return false;
        }
        LOG.error("Optional config file with name '" + configFile + "' already registered by '" + oldPluginId + "'. Please rename to ensure that lookup in the classloader by short name returns correct optional config. Current plugin: '" + rootDescriptor + "'. ");
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/DescriptorListLoadingContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/DescriptorListLoadingContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findZipFsProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutorService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlFactory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "internString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateParser";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisitedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSingleDescriptorContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPluginDisabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "internString";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkOptionalConfigShortName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

