/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.ClassLoaderConfigurationData;
import com.intellij.ide.plugins.ClassLoaderTreeCheckerKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.util.containers.WeakList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/plugins/ClassLoaderTreeChecker;", "", "unloadedMainDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "classLoaders", "Lcom/intellij/util/containers/WeakList;", "Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/util/containers/WeakList;)V", "checkThatClassLoaderNotReferencedByPluginClassLoader", "", "descriptor", "checkThatClassloaderNotReferenced", "intellij.platform.ide.impl"})
public final class ClassLoaderTreeChecker {
    private final IdeaPluginDescriptorImpl unloadedMainDescriptor;
    private final WeakList<PluginClassLoader> classLoaders;

    /*
     * WARNING - void declaration
     */
    public final void checkThatClassLoaderNotReferencedByPluginClassLoader() {
        void $this$forEach$iv;
        if (!ClassLoaderConfigurationData.SEPARATE_CLASSLOADER_FOR_SUB || !(this.unloadedMainDescriptor.getClassLoader() instanceof PluginClassLoader)) {
            return;
        }
        List<IdeaPluginDescriptorImpl> list2 = PluginManagerCore.getLoadedPlugins(null);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"PluginManagerCore.getLoadedPlugins(null)");
        Iterable iterable = list2;
        ClassLoaderTreeChecker classLoaderTreeChecker = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdeaPluginDescriptorImpl p1 = (IdeaPluginDescriptorImpl)element$iv;
            boolean bl = false;
            classLoaderTreeChecker.checkThatClassLoaderNotReferencedByPluginClassLoader(p1);
        }
    }

    private final void checkThatClassLoaderNotReferencedByPluginClassLoader(IdeaPluginDescriptorImpl descriptor2) {
        this.checkThatClassloaderNotReferenced(descriptor2);
        List<PluginDependency> list2 = descriptor2.pluginDependencies;
        if (list2 == null) {
            return;
        }
        for (PluginDependency dependency : list2) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = dependency.subDescriptor;
            if (ideaPluginDescriptorImpl == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"dependency.subDescriptor ?: continue");
            this.checkThatClassLoaderNotReferencedByPluginClassLoader(ideaPluginDescriptorImpl);
        }
    }

    private final void checkThatClassloaderNotReferenced(IdeaPluginDescriptorImpl descriptor2) {
        ClassLoader classLoader = descriptor2.getClassLoader();
        if (!(classLoader instanceof PluginClassLoader)) {
            classLoader = null;
        }
        PluginClassLoader pluginClassLoader = (PluginClassLoader)((Object)classLoader);
        if (pluginClassLoader == null) {
            return;
        }
        PluginClassLoader classLoader2 = pluginClassLoader;
        if (descriptor2 != this.unloadedMainDescriptor) {
            if (this.classLoaders.contains((Object)classLoader2)) {
                ClassLoaderTreeCheckerKt.access$getLOG$p().error((Object)((Object)classLoader2) + " must be unloaded but still referenced");
            }
            if (classLoader2.getPluginId() == this.unloadedMainDescriptor.getPluginId() && classLoader2.getPluginDescriptor() == descriptor2) {
                ClassLoaderTreeCheckerKt.access$getLOG$p().error("Classloader of " + descriptor2 + " must be nullified");
            }
        }
        List<ClassLoader> list2 = classLoader2._getParents();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"classLoader._getParents()");
        List<ClassLoader> parents2 = list2;
        for (PluginClassLoader unloadedClassLoader : this.classLoaders) {
            if (!parents2.contains((Object)unloadedClassLoader)) continue;
            ClassLoaderTreeCheckerKt.access$getLOG$p().error((Object)((Object)classLoader2) + " references via parents " + (Object)((Object)unloadedClassLoader) + " that must be unloaded");
        }
        for (ClassLoader parent : parents2) {
            if (!(parent instanceof PluginClassLoader) || ((PluginClassLoader)((Object)parent)).getPluginId() != this.unloadedMainDescriptor.getPluginId()) continue;
            ClassLoaderTreeCheckerKt.access$getLOG$p().error((Object)((Object)classLoader2) + " references via parents " + parent + " that must be unloaded");
        }
    }

    public ClassLoaderTreeChecker(@NotNull IdeaPluginDescriptorImpl unloadedMainDescriptor, @NotNull WeakList<PluginClassLoader> classLoaders) {
        Intrinsics.checkNotNullParameter((Object)unloadedMainDescriptor, (String)"unloadedMainDescriptor");
        Intrinsics.checkNotNullParameter(classLoaders, (String)"classLoaders");
        this.unloadedMainDescriptor = unloadedMainDescriptor;
        this.classLoaders = classLoaders;
    }
}

